from pumpia.file_handling.dicom_tags import Tag, TagLink

class XRAYTags():
    """Class containing X-ray DICOM Tags as class attributes."""
    InventoriedStudiesSequence = Tag('Inventoried Studies Sequence', "InventoriedStudiesSequence", 0x0008, 0x0423)
    InventoriedSeriesSequence = Tag('Inventoried Series Sequence', "InventoriedSeriesSequence", 0x0008, 0x0424, [TagLink(InventoriedStudiesSequence),])
    InventoriedInstancesSequence = Tag('Inventoried Instances Sequence', "InventoriedInstancesSequence", 0x0008, 0x0425, [TagLink(InventoriedSeriesSequence),])
    ScopeOfInventorySequence = Tag('Scope of Inventory Sequence', "ScopeOfInventorySequence", 0x0008, 0x0400)
    SpecificCharacterSet = Tag('Specific Character Set', "SpecificCharacterSet", 0x0008, 0x0005, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),TagLink(ScopeOfInventorySequence),])
    AlternateContentDescriptionSequence = Tag('Alternate Content Description Sequence', "AlternateContentDescriptionSequence", 0x0070, 0x0087)
    LanguageCodeSequence = Tag('Language Code Sequence', "LanguageCodeSequence", 0x0008, 0x0006, [TagLink(AlternateContentDescriptionSequence),])
    ImageType = Tag('Image Type', "ImageType", 0x0008, 0x0008)
    InstanceCreationDate = Tag('Instance Creation Date', "InstanceCreationDate", 0x0008, 0x0012)
    InstanceCreationTime = Tag('Instance Creation Time', "InstanceCreationTime", 0x0008, 0x0013)
    InstanceCreatorUID = Tag('Instance Creator UID', "InstanceCreatorUID", 0x0008, 0x0014)
    InstanceCoercionDateTime = Tag('Instance Coercion DateTime', "InstanceCoercionDateTime", 0x0008, 0x0015)
    AlternateRepresentationSequence = Tag('Alternate Representation Sequence', "AlternateRepresentationSequence", 0x0008, 0x3001, [TagLink(InventoriedInstancesSequence),])
    SOPClassUID = Tag('SOP Class UID', "SOPClassUID", 0x0008, 0x0016, [TagLink(InventoriedInstancesSequence),TagLink(AlternateRepresentationSequence),])
    AcquisitionUID = Tag('Acquisition UID', "AcquisitionUID", 0x0008, 0x0017)
    SOPInstanceUID = Tag('SOP Instance UID', "SOPInstanceUID", 0x0008, 0x0018, [TagLink(InventoriedInstancesSequence),TagLink(AlternateRepresentationSequence),])
    RelatedGeneralSOPClassUID = Tag('Related General SOP Class UID', "RelatedGeneralSOPClassUID", 0x0008, 0x001A, [TagLink(InventoriedInstancesSequence),])
    OriginalSpecializedSOPClassUID = Tag('Original Specialized SOP Class UID', "OriginalSpecializedSOPClassUID", 0x0008, 0x001B)
    SyntheticData = Tag('Synthetic Data', "SyntheticData", 0x0008, 0x001C)
    StudyDate = Tag('Study Date', "StudyDate", 0x0008, 0x0020, [TagLink(InventoriedStudiesSequence),])
    SourceSeriesInformationSequence = Tag('Source Series Information Sequence', "SourceSeriesInformationSequence", 0x3006, 0x004C)
    SeriesDate = Tag('Series Date', "SeriesDate", 0x0008, 0x0021, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionDate = Tag('Acquisition Date', "AcquisitionDate", 0x0008, 0x0022)
    ContentDate = Tag('Content Date', "ContentDate", 0x0008, 0x0023, [TagLink(InventoriedInstancesSequence),])
    ContributingSourcesSequence = Tag('Contributing Sources Sequence', "ContributingSourcesSequence", 0x0018, 0x9506)
    AcquisitionDateTime = Tag('Acquisition DateTime', "AcquisitionDateTime", 0x0008, 0x002A, [TagLink(ContributingSourcesSequence),])
    StudyTime = Tag('Study Time', "StudyTime", 0x0008, 0x0030, [TagLink(InventoriedStudiesSequence),])
    SeriesTime = Tag('Series Time', "SeriesTime", 0x0008, 0x0031, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionTime = Tag('Acquisition Time', "AcquisitionTime", 0x0008, 0x0032)
    ContentTime = Tag('Content Time', "ContentTime", 0x0008, 0x0033, [TagLink(InventoriedInstancesSequence),])
    RequestAttributesSequence = Tag('Request Attributes Sequence', "RequestAttributesSequence", 0x0040, 0x0275, [TagLink(InventoriedSeriesSequence),])
    ReferencedRequestSequence = Tag('Referenced Request Sequence', "ReferencedRequestSequence", 0x0040, 0xA370, [TagLink(InventoriedInstancesSequence),])
    AccessionNumber = Tag('Accession Number', "AccessionNumber", 0x0008, 0x0050, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(InventoriedStudiesSequence),])
    IssuerOfAccessionNumberSequence = Tag('Issuer of Accession Number Sequence', "IssuerOfAccessionNumberSequence", 0x0008, 0x0051, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(InventoriedStudiesSequence),])
    QueryRetrieveView = Tag('Query/Retrieve View', "QueryRetrieveView", 0x0008, 0x0053)
    ReferencedPatientPhotoSequence = Tag('Referenced Patient Photo Sequence', "ReferencedPatientPhotoSequence", 0x0010, 0x1100)
    DICOMRetrievalSequence = Tag('DICOM Retrieval Sequence', "DICOMRetrievalSequence", 0x0040, 0xE021, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveAETitle = Tag('Retrieve AE Title', "RetrieveAETitle", 0x0008, 0x0054, [TagLink(DICOMRetrievalSequence),TagLink(InventoriedStudiesSequence),])
    AssessmentRequesterSequence = Tag('Assessment Requester Sequence', "AssessmentRequesterSequence", 0x0082, 0x0017)
    AuthorIdentificationSequence = Tag('Author Identification Sequence', "AuthorIdentificationSequence", 0x3010, 0x0019)
    TreatmentSessionBeamSequence = Tag('Treatment Session Beam Sequence', "TreatmentSessionBeamSequence", 0x3008, 0x0020)
    ControlPointDeliverySequence = Tag('Control Point Delivery Sequence', "ControlPointDeliverySequence", 0x3008, 0x0040, [TagLink(TreatmentSessionBeamSequence),])
    TreatmentSessionApplicationSetupSequence = Tag('Treatment Session Application Setup Sequence', "TreatmentSessionApplicationSetupSequence", 0x3008, 0x0110)
    RecordedChannelSequence = Tag('Recorded Channel Sequence', "RecordedChannelSequence", 0x3008, 0x0130, [TagLink(TreatmentSessionApplicationSetupSequence),])
    BrachyControlPointDeliveredSequence = Tag('Brachy Control Point Delivered Sequence', "BrachyControlPointDeliveredSequence", 0x3008, 0x0160, [TagLink(RecordedChannelSequence),])
    PulseSpecificBrachyControlPointDeliveredSequence = Tag('Pulse Specific Brachy Control Point Delivered Sequence', "PulseSpecificBrachyControlPointDeliveredSequence", 0x3008, 0x0171, [TagLink(RecordedChannelSequence),])
    BrachyPulseControlPointDeliveredSequence = Tag('Brachy Pulse Control Point Delivered Sequence', "BrachyPulseControlPointDeliveredSequence", 0x3008, 0x0173, [TagLink(PulseSpecificBrachyControlPointDeliveredSequence),])
    TreatmentSessionIonBeamSequence = Tag('Treatment Session Ion Beam Sequence', "TreatmentSessionIonBeamSequence", 0x3008, 0x0021)
    IonControlPointDeliverySequence = Tag('Ion Control Point Delivery Sequence', "IonControlPointDeliverySequence", 0x3008, 0x0041, [TagLink(TreatmentSessionIonBeamSequence),])
    TreatmentToleranceViolationSequence = Tag('Treatment Tolerance Violation Sequence', "TreatmentToleranceViolationSequence", 0x300A, 0x0731)
    OverrideSequence = Tag('Override Sequence', "OverrideSequence", 0x3008, 0x0060, [TagLink(ControlPointDeliverySequence),TagLink(BrachyControlPointDeliveredSequence),TagLink(BrachyPulseControlPointDeliveredSequence),TagLink(IonControlPointDeliverySequence),TagLink(TreatmentToleranceViolationSequence),])
    ContributingEquipmentSequence = Tag('Contributing Equipment Sequence', "ContributingEquipmentSequence", 0x0018, 0xA001)
    OperatorIdentificationSequence = Tag('Operator Identification Sequence', "OperatorIdentificationSequence", 0x0008, 0x1072, [TagLink(OverrideSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),])
    ApprovalSequence = Tag('Approval Sequence', "ApprovalSequence", 0x0044, 0x0100)
    ConfirmationSequence = Tag('Confirmation Sequence', "ConfirmationSequence", 0x300A, 0x073F)
    OmittedRadiationSequence = Tag('Omitted Radiation Sequence', "OmittedRadiationSequence", 0x300A, 0x0787)
    AsserterIdentificationSequence = Tag('Asserter Identification Sequence', "AsserterIdentificationSequence", 0x0044, 0x0103, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),TagLink(OmittedRadiationSequence),])
    HangingProtocolDefinitionSequence = Tag('Hanging Protocol Definition Sequence', "HangingProtocolDefinitionSequence", 0x0072, 0x000C)
    Modality = Tag('Modality', "Modality", 0x0008, 0x0060, [TagLink(SourceSeriesInformationSequence),TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedSeriesSequence),])
    AnatomicRegionsInStudyCodeSequence = Tag('Anatomic Regions in Study Code Sequence', "AnatomicRegionsInStudyCodeSequence", 0x0008, 0x0063, [TagLink(InventoriedStudiesSequence),])
    PresentationIntentType = Tag('Presentation Intent Type', "PresentationIntentType", 0x0008, 0x0068)
    DeviceSequence = Tag('Device Sequence', "DeviceSequence", 0x0050, 0x0010)
    ContainerComponentSequence = Tag('Container Component Sequence', "ContainerComponentSequence", 0x0040, 0x0520)
    PerFrameFunctionalGroupsSequence = Tag('Per-Frame Functional Groups Sequence', "PerFrameFunctionalGroupsSequence", 0x5200, 0x9230)
    RTImageFrameContextSequence = Tag('RT Image Frame Context Sequence', "RTImageFrameContextSequence", 0x3002, 0x0103, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageScopeSequence = Tag('RT Image Scope Sequence', "RTImageScopeSequence", 0x3002, 0x0104, [TagLink(RTImageFrameContextSequence),])
    RTPatientPositionScopeSequence = Tag('RT Patient Position Scope Sequence', "RTPatientPositionScopeSequence", 0x300A, 0x0784)
    AcquisitionTaskSequence = Tag('Acquisition Task Sequence', "AcquisitionTaskSequence", 0x3002, 0x0118)
    AcquisitionTaskApplicabilitySequence = Tag('Acquisition Task Applicability Sequence', "AcquisitionTaskApplicabilitySequence", 0x3002, 0x0124, [TagLink(AcquisitionTaskSequence),])
    ReferencedRTPlanSequence = Tag('Referenced RT Plan Sequence', "ReferencedRTPlanSequence", 0x300C, 0x0002, [TagLink(RTImageScopeSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    BeamSequence = Tag('Beam Sequence', "BeamSequence", 0x300A, 0x00B0, [TagLink(ReferencedRTPlanSequence),])
    TreatmentMachineSequence = Tag('Treatment Machine Sequence', "TreatmentMachineSequence", 0x300A, 0x0206)
    IonBeamSequence = Tag('Ion Beam Sequence', "IonBeamSequence", 0x300A, 0x03A2)
    ModelSpecificationSequence = Tag('Model Specification Sequence', "ModelSpecificationSequence", 0x0018, 0x9912)
    PatientSupportDevicesSequence = Tag('Patient Support Devices Sequence', "PatientSupportDevicesSequence", 0x300A, 0x0686)
    WedgeDefinitionSequence = Tag('Wedge Definition Sequence', "WedgeDefinitionSequence", 0x300A, 0x0651)
    CompensatorDefinitionSequence = Tag('Compensator Definition Sequence', "CompensatorDefinitionSequence", 0x300A, 0x0662)
    BlockDefinitionSequence = Tag('Block Definition Sequence', "BlockDefinitionSequence", 0x300A, 0x066A)
    RTAccessoryHolderDefinitionSequence = Tag('RT Accessory Holder Definition Sequence', "RTAccessoryHolderDefinitionSequence", 0x300A, 0x0614)
    GeneralAccessoryDefinitionSequence = Tag('General Accessory Definition Sequence', "GeneralAccessoryDefinitionSequence", 0x300A, 0x0671)
    BolusDefinitionSequence = Tag('Bolus Definition Sequence', "BolusDefinitionSequence", 0x300A, 0x0673)
    AcquisitionDeviceSequence = Tag('Acquisition Device Sequence', "AcquisitionDeviceSequence", 0x3002, 0x0117)
    PatientSetupSequence = Tag('Patient Setup Sequence', "PatientSetupSequence", 0x300A, 0x0180)
    PatientTreatmentPreparationSequence = Tag('Patient Treatment Preparation Sequence', "PatientTreatmentPreparationSequence", 0x300A, 0x079F, [TagLink(PatientSetupSequence),])
    PatientTreatmentPreparationProcedureSequence = Tag('Patient Treatment Preparation Procedure Sequence', "PatientTreatmentPreparationProcedureSequence", 0x300A, 0x0790, [TagLink(PatientTreatmentPreparationSequence),])
    PatientTreatmentPreparationDeviceSequence = Tag('Patient Treatment Preparation Device Sequence', "PatientTreatmentPreparationDeviceSequence", 0x300A, 0x078F, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    RTSegmentAnnotationSequence = Tag('RT Segment Annotation Sequence', "RTSegmentAnnotationSequence", 0x3010, 0x002A)
    SegmentedRTAccessoryDeviceSequence = Tag('Segmented RT Accessory Device Sequence', "SegmentedRTAccessoryDeviceSequence", 0x3010, 0x0026, [TagLink(RTSegmentAnnotationSequence),])
    TreatmentDeviceIdentificationSequence = Tag('Treatment Device Identification Sequence', "TreatmentDeviceIdentificationSequence", 0x300A, 0x063A)
    Manufacturer = Tag('Manufacturer', "Manufacturer", 0x0008, 0x0070, [TagLink(DeviceSequence),TagLink(ContainerComponentSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    SegmentSequence = Tag('Segment Sequence', "SegmentSequence", 0x0062, 0x0002)
    ContentCreatorIdentificationCodeSequence = Tag("Content Creator's Identification Code Sequence", "ContentCreatorIdentificationCodeSequence", 0x0070, 0x0086, [TagLink(SegmentSequence),])
    ReferringPhysicianIdentificationSequence = Tag('Referring Physician Identification Sequence', "ReferringPhysicianIdentificationSequence", 0x0008, 0x0096, [TagLink(InventoriedStudiesSequence),])
    ConsultingPhysicianIdentificationSequence = Tag('Consulting Physician Identification Sequence', "ConsultingPhysicianIdentificationSequence", 0x0008, 0x009D, [TagLink(InventoriedStudiesSequence),])
    PhysiciansOfRecordIdentificationSequence = Tag('Physician(s) of Record Identification Sequence', "PhysiciansOfRecordIdentificationSequence", 0x0008, 0x1049, [TagLink(InventoriedStudiesSequence),])
    PhysiciansReadingStudyIdentificationSequence = Tag('Physician(s) Reading Study Identification Sequence', "PhysiciansReadingStudyIdentificationSequence", 0x0008, 0x1062, [TagLink(InventoriedStudiesSequence),])
    PerformingPhysicianIdentificationSequence = Tag('Performing Physician Identification Sequence', "PerformingPhysicianIdentificationSequence", 0x0008, 0x1052)
    CustodialOrganizationSequence = Tag('Custodial Organization Sequence', "CustodialOrganizationSequence", 0x0040, 0xA07C)
    InterlockSequence = Tag('Interlock Sequence', "InterlockSequence", 0x300A, 0x0740, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionIonBeamSequence),])
    InterlockResolutionUserSequence = Tag('Interlock Resolution User Sequence', "InterlockResolutionUserSequence", 0x300A, 0x0746, [TagLink(InterlockSequence),])
    InstitutionName = Tag('Institution Name', "InstitutionName", 0x0008, 0x0080, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(CustodialOrganizationSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    InstitutionAddress = Tag('Institution Address', "InstitutionAddress", 0x0008, 0x0081, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(InterlockResolutionUserSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    InstitutionCodeSequence = Tag('Institution Code Sequence', "InstitutionCodeSequence", 0x0008, 0x0082, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(CustodialOrganizationSequence),TagLink(AssessmentRequesterSequence),TagLink(ApprovalSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ReferringPhysicianName = Tag("Referring Physician's Name", "ReferringPhysicianName", 0x0008, 0x0090, [TagLink(InventoriedStudiesSequence),])
    ConsultingPhysicianName = Tag("Consulting Physician's Name", "ConsultingPhysicianName", 0x0008, 0x009C, [TagLink(InventoriedStudiesSequence),])
    PersonIdentificationCodeSequence = Tag('Person Identification Code Sequence', "PersonIdentificationCodeSequence", 0x0040, 0x1101, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    InstitutionalDepartmentTypeCodeSequence = Tag('Institutional Department Type Code Sequence', "InstitutionalDepartmentTypeCodeSequence", 0x0008, 0x1041, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ScheduledProtocolCodeSequence = Tag('Scheduled Protocol Code Sequence', "ScheduledProtocolCodeSequence", 0x0040, 0x0008, [TagLink(RequestAttributesSequence),])
    PerformedProtocolCodeSequence = Tag('Performed Protocol Code Sequence', "PerformedProtocolCodeSequence", 0x0040, 0x0260, [TagLink(ContributingSourcesSequence),])
    ProtocolContextSequence = Tag('Protocol Context Sequence', "ProtocolContextSequence", 0x0040, 0x0440, [TagLink(ScheduledProtocolCodeSequence),TagLink(PerformedProtocolCodeSequence),])
    AcquisitionContextSequence = Tag('Acquisition Context Sequence', "AcquisitionContextSequence", 0x0040, 0x0555)
    ReferencedImageRealWorldValueMappingSequence = Tag('Referenced Image Real World Value Mapping Sequence', "ReferencedImageRealWorldValueMappingSequence", 0x0040, 0x9094)
    RealWorldValueMappingSequence = Tag('Real World Value Mapping Sequence', "RealWorldValueMappingSequence", 0x0040, 0x9096, [TagLink(ReferencedImageRealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    QuantityDefinitionSequence = Tag('Quantity Definition Sequence', "QuantityDefinitionSequence", 0x0040, 0x9220, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    MultienergyCTCharacteristicsSequence = Tag('Multi-energy CT Characteristics Sequence', "MultienergyCTCharacteristicsSequence", 0x0018, 0x9364, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PerformedProcessingParametersSequence = Tag('Performed Processing Parameters Sequence', "PerformedProcessingParametersSequence", 0x0074, 0x1212, [TagLink(MultienergyCTCharacteristicsSequence),])
    PatientTreatmentPreparationProcedureParameterSequence = Tag('Patient Treatment Preparation Procedure Parameter Sequence', "PatientTreatmentPreparationProcedureParameterSequence", 0x300A, 0x0793, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    SegmentCharacteristicsSequence = Tag('Segment Characteristics Sequence', "SegmentCharacteristicsSequence", 0x3010, 0x0027, [TagLink(RTSegmentAnnotationSequence),])
    ContentItemModifierSequence = Tag('Content Item Modifier Sequence', "ContentItemModifierSequence", 0x0040, 0x0441, [TagLink(ProtocolContextSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(PerformedProcessingParametersSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(SegmentCharacteristicsSequence),])
    RTRadiationTaskSequence = Tag('RT Radiation Task Sequence', "RTRadiationTaskSequence", 0x300A, 0x0797)
    RTDeliveryStartPatientPositionSequence = Tag('RT Delivery Start Patient Position Sequence', "RTDeliveryStartPatientPositionSequence", 0x300A, 0x0789, [TagLink(RTRadiationTaskSequence),])
    RTTreatmentPreparationPatientPositionSequence = Tag('RT Treatment Preparation Patient Position Sequence', "RTTreatmentPreparationPatientPositionSequence", 0x300A, 0x078A)
    RTAcquisitionPatientPositionSequence = Tag('RT Acquisition Patient Position Sequence', "RTAcquisitionPatientPositionSequence", 0x3002, 0x0108, [TagLink(AcquisitionTaskSequence),])
    RTPatientPositionDisplacementSequence = Tag('RT Patient Position Displacement Sequence', "RTPatientPositionDisplacementSequence", 0x300A, 0x0798, [TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientSupportDisplacementSequence = Tag('Patient Support Displacement Sequence', "PatientSupportDisplacementSequence", 0x300A, 0x079C, [TagLink(RTPatientPositionDisplacementSequence),])
    PatientSupportPositionDeviceParameterSequence = Tag('Patient Support Position Device Parameter Sequence', "PatientSupportPositionDeviceParameterSequence", 0x300A, 0x065D, [TagLink(PatientSupportDisplacementSequence),])
    PatientToEquipmentRelationshipSequence = Tag('Patient to Equipment Relationship Sequence', "PatientToEquipmentRelationshipSequence", 0x300A, 0x07A0)
    PatientSupportPositionParameterSequence = Tag('Patient Support Position Parameter Sequence', "PatientSupportPositionParameterSequence", 0x300A, 0x065B, [TagLink(PatientSupportPositionDeviceParameterSequence),TagLink(PatientToEquipmentRelationshipSequence),])
    SpecimenDescriptionSequence = Tag('Specimen Description Sequence', "SpecimenDescriptionSequence", 0x0040, 0x0560, [TagLink(InventoriedInstancesSequence),])
    SpecimenPreparationSequence = Tag('Specimen Preparation Sequence', "SpecimenPreparationSequence", 0x0040, 0x0610, [TagLink(SpecimenDescriptionSequence),])
    SpecimenPreparationStepContentItemSequence = Tag('Specimen Preparation Step Content Item Sequence', "SpecimenPreparationStepContentItemSequence", 0x0040, 0x0612, [TagLink(SpecimenPreparationSequence),])
    SpecimenLocalizationContentItemSequence = Tag('Specimen Localization Content Item Sequence', "SpecimenLocalizationContentItemSequence", 0x0040, 0x0620, [TagLink(SpecimenDescriptionSequence),])
    ReferencedFractionGroupSequence = Tag('Referenced Fraction Group Sequence', "ReferencedFractionGroupSequence", 0x300C, 0x0020, [TagLink(ReferencedRTPlanSequence),])
    ReferencedTreatmentRecordSequence = Tag('Referenced Treatment Record Sequence', "ReferencedTreatmentRecordSequence", 0x3008, 0x0030)
    FractionGroupSequence = Tag('Fraction Group Sequence', "FractionGroupSequence", 0x300A, 0x0070)
    ReferencedBeamSequence = Tag('Referenced Beam Sequence', "ReferencedBeamSequence", 0x300C, 0x0004, [TagLink(ReferencedFractionGroupSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(FractionGroupSequence),TagLink(ReferencedRTPlanSequence),])
    RTImageFrameRadiationAcquisitionSequence = Tag('RT Image Frame Radiation Acquisition Sequence', "RTImageFrameRadiationAcquisitionSequence", 0x3002, 0x010C, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageFrameMVRadiationAcquisitionSequence = Tag('RT Image Frame MV Radiation Acquisition Sequence', "RTImageFrameMVRadiationAcquisitionSequence", 0x3002, 0x010B, [TagLink(RTImageFrameRadiationAcquisitionSequence),])
    AcquisitionSubtaskSequence = Tag('Acquisition Subtask Sequence', "AcquisitionSubtaskSequence", 0x3002, 0x011A, [TagLink(AcquisitionTaskSequence),])
    MVImagingGenerationParametersSequence = Tag('MV Imaging Generation Parameters Sequence', "MVImagingGenerationParametersSequence", 0x3002, 0x0128, [TagLink(AcquisitionSubtaskSequence),])
    RadiationGenerationModeSequence = Tag('Radiation Generation Mode Sequence', "RadiationGenerationModeSequence", 0x300A, 0x067B, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationDeviceConfigurationAndCommissioningKeySequence = Tag('Radiation Device Configuration and Commissioning Key Sequence', "RadiationDeviceConfigurationAndCommissioningKeySequence", 0x300A, 0x065A, [TagLink(ReferencedBeamSequence),TagLink(TreatmentSessionBeamSequence),TagLink(RadiationGenerationModeSequence),])
    WideFieldOphthalmicPhotographyQualityRatingSequence = Tag('Wide Field Ophthalmic Photography Quality Rating Sequence', "WideFieldOphthalmicPhotographyQualityRatingSequence", 0x0022, 0x1525)
    OphthalmicEnFaceImageQualityRatingSequence = Tag('Ophthalmic En Face Image Quality Rating Sequence', "OphthalmicEnFaceImageQualityRatingSequence", 0x0022, 0x1628)
    LensConstantSequence = Tag('Lens Constant Sequence', "LensConstantSequence", 0x0022, 0x1092)
    VisualFieldGlobalResultsIndexSequence = Tag('Visual Field Global Results Index Sequence', "VisualFieldGlobalResultsIndexSequence", 0x0024, 0x0320)
    DataObservationSequence = Tag('Data Observation Sequence', "DataObservationSequence", 0x0024, 0x0325, [TagLink(VisualFieldGlobalResultsIndexSequence),])
    OphthalmicThicknessMapQualityRatingSequence = Tag('Ophthalmic Thickness Map Quality Rating Sequence', "OphthalmicThicknessMapQualityRatingSequence", 0x0022, 0x1470)
    TrackSetSequence = Tag('Track Set Sequence', "TrackSetSequence", 0x0066, 0x0101)
    AnnotationGroupSequence = Tag('Annotation Group Sequence', "AnnotationGroupSequence", 0x006A, 0x0002)
    MeasurementsSequence = Tag('Measurements Sequence', "MeasurementsSequence", 0x0066, 0x0121, [TagLink(TrackSetSequence),TagLink(AnnotationGroupSequence),])
    TrackStatisticsSequence = Tag('Track Statistics Sequence', "TrackStatisticsSequence", 0x0066, 0x0130, [TagLink(TrackSetSequence),])
    WaveformAnnotationSequence = Tag('Waveform Annotation Sequence', "WaveformAnnotationSequence", 0x0040, 0xB020)
    ContentSequence = Tag('Content Sequence', "ContentSequence", 0x0040, 0xA730)
    TabulatedValuesSequence = Tag('Tabulated Values Sequence', "TabulatedValuesSequence", 0x0040, 0xA801, [TagLink(ContentSequence),])
    TableRowDefinitionSequence = Tag('Table Row Definition Sequence', "TableRowDefinitionSequence", 0x0040, 0xA806, [TagLink(TabulatedValuesSequence),])
    TableColumnDefinitionSequence = Tag('Table Column Definition Sequence', "TableColumnDefinitionSequence", 0x0040, 0xA807, [TagLink(TabulatedValuesSequence),])
    DosimetricObjectiveSequence = Tag('Dosimetric Objective Sequence', "DosimetricObjectiveSequence", 0x3010, 0x006C)
    DosimetricObjectiveParameterSequence = Tag('Dosimetric Objective Parameter Sequence', "DosimetricObjectiveParameterSequence", 0x3010, 0x0070, [TagLink(DosimetricObjectiveSequence),])
    PatientSupportPositionDeviceToleranceSequence = Tag('Patient Support Position Device Tolerance Sequence', "PatientSupportPositionDeviceToleranceSequence", 0x300A, 0x0660)
    PatientSupportPositionToleranceSequence = Tag('Patient Support Position Tolerance Sequence', "PatientSupportPositionToleranceSequence", 0x300A, 0x062D, [TagLink(PatientSupportPositionDeviceToleranceSequence),])
    CTImagingAcquisitionParameterSequence = Tag('CT Imaging Acquisition Parameter Sequence', "CTImagingAcquisitionParameterSequence", 0x3002, 0x0126, [TagLink(AcquisitionSubtaskSequence),])
    ScanStartPositionSequence = Tag('Scan Start Position Sequence', "ScanStartPositionSequence", 0x3002, 0x012B, [TagLink(CTImagingAcquisitionParameterSequence),])
    ScanStopPositionSequence = Tag('Scan Stop Position Sequence', "ScanStopPositionSequence", 0x3002, 0x012C, [TagLink(CTImagingAcquisitionParameterSequence),])
    RTImageFrameImagingDevicePositionSequence = Tag('RT Image Frame Imaging Device Position Sequence', "RTImageFrameImagingDevicePositionSequence", 0x3002, 0x0109, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImagingSourcePositionSequence = Tag('Imaging Source Position Sequence', "ImagingSourcePositionSequence", 0x3002, 0x010D, [TagLink(ScanStartPositionSequence),TagLink(ScanStopPositionSequence),TagLink(RTImageFrameImagingDevicePositionSequence),])
    ImageReceptorPositionSequence = Tag('Image Receptor Position Sequence', "ImageReceptorPositionSequence", 0x3002, 0x010E, [TagLink(ScanStartPositionSequence),TagLink(ScanStopPositionSequence),TagLink(RTImageFrameImagingDevicePositionSequence),])
    ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence = Tag('Imaging Equipment to Treatment Delivery Device Relationship Sequence', "ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence", 0x300A, 0x07A1)
    DevicePositionParameterSequence = Tag('Device Position Parameter Sequence', "DevicePositionParameterSequence", 0x3002, 0x0110, [TagLink(ImagingSourcePositionSequence),TagLink(ImageReceptorPositionSequence),TagLink(ImagingEquipmentToTreatmentDeliveryDeviceRelationshipSequence),])
    RTPrescriptionSequence = Tag('RT Prescription Sequence', "RTPrescriptionSequence", 0x3010, 0x006B)
    PrescriptionNotesSequence = Tag('Prescription Notes Sequence', "PrescriptionNotesSequence", 0x3010, 0x0081, [TagLink(RTPrescriptionSequence),])
    AlternateValueSequence = Tag('Alternate Value Sequence', "AlternateValueSequence", 0x300A, 0x073E, [TagLink(OverrideSequence),])
    AcquisitionInitiationSequence = Tag('Acquisition Initiation Sequence', "AcquisitionInitiationSequence", 0x3002, 0x0135, [TagLink(AcquisitionSubtaskSequence),])
    AdditionalRTAccessoryDeviceSequence = Tag('Additional RT Accessory Device Sequence', "AdditionalRTAccessoryDeviceSequence", 0x3002, 0x0130, [TagLink(AcquisitionSubtaskSequence),])
    DeviceSpecificAcquisitionParameterSequence = Tag('Device-Specific Acquisition Parameter Sequence', "DeviceSpecificAcquisitionParameterSequence", 0x3002, 0x0131, [TagLink(AcquisitionSubtaskSequence),TagLink(AdditionalRTAccessoryDeviceSequence),])
    ConceptNameCodeSequence = Tag('Concept Name Code Sequence', "ConceptNameCodeSequence", 0x0040, 0xA043, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(AlternateContentDescriptionSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(LensConstantSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(MeasurementsSequence),TagLink(TrackStatisticsSequence),TagLink(WaveformAnnotationSequence),TagLink(ContentSequence),TagLink(TableRowDefinitionSequence),TagLink(TableColumnDefinitionSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(InventoriedInstancesSequence),])
    CellValuesSequence = Tag('Cell Values Sequence', "CellValuesSequence", 0x0040, 0xA808, [TagLink(TabulatedValuesSequence),])
    ConceptCodeSequence = Tag('Concept Code Sequence', "ConceptCodeSequence", 0x0040, 0xA168, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(WaveformAnnotationSequence),TagLink(CellValuesSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    MeasuredValueSequence = Tag('Measured Value Sequence', "MeasuredValueSequence", 0x0040, 0xA300, [TagLink(ContentSequence),])
    AssessmentObservationsSequence = Tag('Assessment Observations Sequence', "AssessmentObservationsSequence", 0x0082, 0x0007)
    StructuredConstraintObservationSequence = Tag('Structured Constraint Observation Sequence', "StructuredConstraintObservationSequence", 0x0082, 0x000C, [TagLink(AssessmentObservationsSequence),])
    PatientSpecificationSequence = Tag('Patient Specification Sequence', "PatientSpecificationSequence", 0x0018, 0x9911)
    AcquisitionProtocolElementSpecificationSequence = Tag('Acquisition Protocol Element Specification Sequence', "AcquisitionProtocolElementSpecificationSequence", 0x0018, 0x991F)
    ReconstructionProtocolElementSpecificationSequence = Tag('Reconstruction Protocol Element Specification Sequence', "ReconstructionProtocolElementSpecificationSequence", 0x0018, 0x9933)
    StorageProtocolElementSpecificationSequence = Tag('Storage Protocol Element Specification Sequence', "StorageProtocolElementSpecificationSequence", 0x0018, 0x9935)
    ParametersSpecificationSequence = Tag('Parameters Specification Sequence', "ParametersSpecificationSequence", 0x0018, 0x9913, [TagLink(AcquisitionProtocolElementSpecificationSequence),TagLink(ReconstructionProtocolElementSpecificationSequence),TagLink(StorageProtocolElementSpecificationSequence),TagLink(CTImagingAcquisitionParameterSequence),])
    MeasurementUnitsCodeSequence = Tag('Measurement Units Code Sequence', "MeasurementUnitsCodeSequence", 0x0040, 0x08EA, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RealWorldValueMappingSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(MeasurementsSequence),TagLink(TrackStatisticsSequence),TagLink(WaveformAnnotationSequence),TagLink(MeasuredValueSequence),TagLink(TableRowDefinitionSequence),TagLink(TableColumnDefinitionSequence),TagLink(CellValuesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAnatomySequence = Tag('Frame Anatomy Sequence', "FrameAnatomySequence", 0x0020, 0x9071, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTROIObservationsSequence = Tag('RT ROI Observations Sequence', "RTROIObservationsSequence", 0x3006, 0x0080)
    MRArterialSpinLabelingSequence = Tag('MR Arterial Spin Labeling Sequence', "MRArterialSpinLabelingSequence", 0x0018, 0x9251, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ASLSlabSequence = Tag('ASL Slab Sequence', "ASLSlabSequence", 0x0018, 0x9260, [TagLink(MRArterialSpinLabelingSequence),])
    ImplantTargetAnatomySequence = Tag('Implant Target Anatomy Sequence', "ImplantTargetAnatomySequence", 0x0068, 0x6230)
    ImplantAssemblyTemplateTargetAnatomySequence = Tag('Implant Assembly Template Target Anatomy Sequence', "ImplantAssemblyTemplateTargetAnatomySequence", 0x0076, 0x0010)
    ImplantTemplateGroupTargetAnatomySequence = Tag('Implant Template Group Target Anatomy Sequence', "ImplantTemplateGroupTargetAnatomySequence", 0x0078, 0x0028)
    AnatomicRegionSequence = Tag('Anatomic Region Sequence', "AnatomicRegionSequence", 0x0008, 0x2218, [TagLink(FrameAnatomySequence),TagLink(RTROIObservationsSequence),TagLink(ASLSlabSequence),TagLink(SegmentSequence),TagLink(HangingProtocolDefinitionSequence),TagLink(ImplantTargetAnatomySequence),TagLink(ImplantAssemblyTemplateTargetAnatomySequence),TagLink(ImplantTemplateGroupTargetAnatomySequence),TagLink(AnnotationGroupSequence),])
    AnatomicRegionModifierSequence = Tag('Anatomic Region Modifier Sequence', "AnatomicRegionModifierSequence", 0x0008, 0x2220, [TagLink(AnatomicRegionSequence),])
    PrimaryAnatomicStructureSequence = Tag('Primary Anatomic Structure Sequence', "PrimaryAnatomicStructureSequence", 0x0008, 0x2228, [TagLink(FrameAnatomySequence),TagLink(SpecimenDescriptionSequence),TagLink(RTROIObservationsSequence),TagLink(ASLSlabSequence),TagLink(SegmentSequence),TagLink(AnnotationGroupSequence),])
    PrimaryAnatomicStructureModifierSequence = Tag('Primary Anatomic Structure Modifier Sequence', "PrimaryAnatomicStructureModifierSequence", 0x0008, 0x2230, [TagLink(PrimaryAnatomicStructureSequence),])
    RequestedProcedureCodeSequence = Tag('Requested Procedure Code Sequence', "RequestedProcedureCodeSequence", 0x0032, 0x1064, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    ReasonForRequestedProcedureCodeSequence = Tag('Reason for Requested Procedure Code Sequence', "ReasonForRequestedProcedureCodeSequence", 0x0040, 0x100A, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(HangingProtocolDefinitionSequence),])
    PatientTreatmentOrientationSequence = Tag('Patient Treatment Orientation Sequence', "PatientTreatmentOrientationSequence", 0x3010, 0x0032, [TagLink(RTPrescriptionSequence),])
    PatientOrientationCodeSequence = Tag('Patient Orientation Code Sequence', "PatientOrientationCodeSequence", 0x0054, 0x0410, [TagLink(PatientTreatmentOrientationSequence),TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientOrientationModifierCodeSequence = Tag('Patient Orientation Modifier Code Sequence', "PatientOrientationModifierCodeSequence", 0x0054, 0x0412, [TagLink(PatientOrientationCodeSequence),])
    PatientGantryRelationshipCodeSequence = Tag('Patient Gantry Relationship Code Sequence', "PatientGantryRelationshipCodeSequence", 0x0054, 0x0414)
    PatientEquipmentRelationshipCodeSequence = Tag('Patient Equipment Relationship Code Sequence', "PatientEquipmentRelationshipCodeSequence", 0x3010, 0x0030, [TagLink(PatientTreatmentOrientationSequence),TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    OtherPatientIDsSequence = Tag('Other Patient IDs Sequence', "OtherPatientIDsSequence", 0x0010, 0x1002, [TagLink(InventoriedStudiesSequence),])
    SourcePatientGroupIdentificationSequence = Tag('Source Patient Group Identification Sequence', "SourcePatientGroupIdentificationSequence", 0x0010, 0x0026)
    GroupOfPatientsIdentificationSequence = Tag('Group of Patients Identification Sequence', "GroupOfPatientsIdentificationSequence", 0x0010, 0x0027)
    IssuerOfPatientIDQualifiersSequence = Tag('Issuer of Patient ID Qualifiers Sequence', "IssuerOfPatientIDQualifiersSequence", 0x0010, 0x0024, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    AssigningJurisdictionCodeSequence = Tag('Assigning Jurisdiction Code Sequence', "AssigningJurisdictionCodeSequence", 0x0040, 0x0039, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    AssigningAgencyOrDepartmentCodeSequence = Tag('Assigning Agency or Department Code Sequence', "AssigningAgencyOrDepartmentCodeSequence", 0x0040, 0x003A, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    StructureSetROISequence = Tag('Structure Set ROI Sequence', "StructureSetROISequence", 0x3006, 0x0020)
    ConceptualVolumeIdentificationSequence = Tag('Conceptual Volume Identification Sequence', "ConceptualVolumeIdentificationSequence", 0x3010, 0x00A0, [TagLink(StructureSetROISequence),])
    RTAnatomicPrescriptionSequence = Tag('RT Anatomic Prescription Sequence', "RTAnatomicPrescriptionSequence", 0x3010, 0x0060, [TagLink(RTPrescriptionSequence),])
    RadiationDoseIdentificationSequence = Tag('Radiation Dose Identification Sequence', "RadiationDoseIdentificationSequence", 0x300A, 0x0618)
    ConceptualVolumeSequence = Tag('Conceptual Volume Sequence', "ConceptualVolumeSequence", 0x3010, 0x0025, [TagLink(PatientSupportDevicesSequence),TagLink(BolusDefinitionSequence),TagLink(RTPatientPositionDisplacementSequence),TagLink(RTAnatomicPrescriptionSequence),TagLink(RadiationDoseIdentificationSequence),])
    SegmentReferenceSequence = Tag('Segment Reference Sequence', "SegmentReferenceSequence", 0x3010, 0x0021)
    DirectSegmentReferenceSequence = Tag('Direct Segment Reference Sequence', "DirectSegmentReferenceSequence", 0x3010, 0x0023, [TagLink(SegmentReferenceSequence),])
    CombinationSegmentReferenceSequence = Tag('Combination Segment Reference Sequence', "CombinationSegmentReferenceSequence", 0x3010, 0x0024, [TagLink(SegmentReferenceSequence),])
    DerivationConceptualVolumeSequence = Tag('Derivation Conceptual Volume Sequence', "DerivationConceptualVolumeSequence", 0x3010, 0x0014, [TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    ConceptualVolumeDerivationAlgorithmSequence = Tag('Conceptual Volume Derivation Algorithm Sequence', "ConceptualVolumeDerivationAlgorithmSequence", 0x3010, 0x0016, [TagLink(DerivationConceptualVolumeSequence),])
    ROIDerivationAlgorithmIdentificationSequence = Tag('ROI Derivation Algorithm Identification Sequence', "ROIDerivationAlgorithmIdentificationSequence", 0x3006, 0x0037, [TagLink(StructureSetROISequence),])
    DerivationAlgorithmSequence = Tag('Derivation Algorithm Sequence', "DerivationAlgorithmSequence", 0x0022, 0x1612, [TagLink(MultienergyCTCharacteristicsSequence),])
    MultienergyCTProcessingSequence = Tag('Multi-energy CT Processing Sequence', "MultienergyCTProcessingSequence", 0x0018, 0x9363, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DecompositionAlgorithmIdentificationSequence = Tag('Decomposition Algorithm Identification Sequence', "DecompositionAlgorithmIdentificationSequence", 0x0018, 0x9380, [TagLink(MultienergyCTProcessingSequence),])
    TransformationAlgorithmSequence = Tag('Transformation Algorithm Sequence', "TransformationAlgorithmSequence", 0x0022, 0x1513)
    AcquisitionMethodAlgorithmSequence = Tag('Acquisition Method Algorithm Sequence', "AcquisitionMethodAlgorithmSequence", 0x0022, 0x1423)
    SegmentationAlgorithmIdentificationSequence = Tag('Segmentation Algorithm Identification Sequence', "SegmentationAlgorithmIdentificationSequence", 0x0062, 0x0007, [TagLink(SegmentSequence),])
    ReferencedSurfaceSequence = Tag('Referenced Surface Sequence', "ReferencedSurfaceSequence", 0x0066, 0x002B, [TagLink(SegmentSequence),])
    SegmentSurfaceGenerationAlgorithmIdentificationSequence = Tag('Segment Surface Generation Algorithm Identification Sequence', "SegmentSurfaceGenerationAlgorithmIdentificationSequence", 0x0066, 0x002D, [TagLink(ReferencedSurfaceSequence),])
    IndexProbabilitySequence = Tag('Index Probability Sequence', "IndexProbabilitySequence", 0x0024, 0x0344, [TagLink(VisualFieldGlobalResultsIndexSequence),])
    AgeCorrectedSensitivityDeviationAlgorithmSequence = Tag('Age Corrected Sensitivity Deviation Algorithm Sequence', "AgeCorrectedSensitivityDeviationAlgorithmSequence", 0x0024, 0x0065)
    GeneralizedDefectSensitivityDeviationAlgorithmSequence = Tag('Generalized Defect Sensitivity Deviation Algorithm Sequence', "GeneralizedDefectSensitivityDeviationAlgorithmSequence", 0x0024, 0x0067)
    ResultsNormalsSequence = Tag('Results Normals Sequence', "ResultsNormalsSequence", 0x0024, 0x0064)
    GlobalDeviationProbabilitySequence = Tag('Global Deviation Probability Sequence', "GlobalDeviationProbabilitySequence", 0x0024, 0x0083, [TagLink(ResultsNormalsSequence),])
    LocalizedDeviationProbabilitySequence = Tag('Localized Deviation Probability Sequence', "LocalizedDeviationProbabilitySequence", 0x0024, 0x0085, [TagLink(ResultsNormalsSequence),])
    OphthalmicThicknessMapQualityThresholdSequence = Tag('Ophthalmic Thickness Map Quality Threshold Sequence', "OphthalmicThicknessMapQualityThresholdSequence", 0x0022, 0x1458, [TagLink(OphthalmicThicknessMapQualityRatingSequence),])
    TrackingAlgorithmIdentificationSequence = Tag('Tracking Algorithm Identification Sequence', "TrackingAlgorithmIdentificationSequence", 0x0066, 0x0104, [TagLink(TrackSetSequence),])
    ReconstructionProtocolElementSequence = Tag('Reconstruction Protocol Element Sequence', "ReconstructionProtocolElementSequence", 0x0018, 0x9934)
    ReconstructionAlgorithmSequence = Tag('Reconstruction Algorithm Sequence', "ReconstructionAlgorithmSequence", 0x0018, 0x993D, [TagLink(ReconstructionProtocolElementSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    SurfaceSequence = Tag('Surface Sequence', "SurfaceSequence", 0x0066, 0x0002)
    SurfaceProcessingAlgorithmIdentificationSequence = Tag('Surface Processing Algorithm Identification Sequence', "SurfaceProcessingAlgorithmIdentificationSequence", 0x0066, 0x0035, [TagLink(SurfaceSequence),])
    AnnotationGroupAlgorithmIdentificationSequence = Tag('Annotation Group Algorithm Identification Sequence', "AnnotationGroupAlgorithmIdentificationSequence", 0x006A, 0x0008, [TagLink(AnnotationGroupSequence),])
    AlgorithmFamilyCodeSequence = Tag('Algorithm Family Code Sequence', "AlgorithmFamilyCodeSequence", 0x0066, 0x002F, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    AlgorithmNameCodeSequence = Tag('Algorithm Name Code Sequence', "AlgorithmNameCodeSequence", 0x0066, 0x0030, [TagLink(ConceptualVolumeDerivationAlgorithmSequence),TagLink(ROIDerivationAlgorithmIdentificationSequence),TagLink(DerivationAlgorithmSequence),TagLink(DecompositionAlgorithmIdentificationSequence),TagLink(TransformationAlgorithmSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(AcquisitionMethodAlgorithmSequence),TagLink(SegmentationAlgorithmIdentificationSequence),TagLink(SegmentSurfaceGenerationAlgorithmIdentificationSequence),TagLink(IndexProbabilitySequence),TagLink(AgeCorrectedSensitivityDeviationAlgorithmSequence),TagLink(GeneralizedDefectSensitivityDeviationAlgorithmSequence),TagLink(GlobalDeviationProbabilitySequence),TagLink(LocalizedDeviationProbabilitySequence),TagLink(OphthalmicThicknessMapQualityThresholdSequence),TagLink(TrackingAlgorithmIdentificationSequence),TagLink(ReconstructionAlgorithmSequence),TagLink(SurfaceProcessingAlgorithmIdentificationSequence),TagLink(AnnotationGroupAlgorithmIdentificationSequence),])
    DetectorInformationSequence = Tag('Detector Information Sequence', "DetectorInformationSequence", 0x0054, 0x0022)
    ViewCodeSequence = Tag('View Code Sequence', "ViewCodeSequence", 0x0054, 0x0220, [TagLink(DetectorInformationSequence),])
    ViewModifierCodeSequence = Tag('View Modifier Code Sequence', "ViewModifierCodeSequence", 0x0054, 0x0222, [TagLink(ViewCodeSequence),])
    BeamTaskSequence = Tag('Beam Task Sequence', "BeamTaskSequence", 0x0074, 0x1020)
    DeviceMotionControlSequence = Tag('Device Motion Control Sequence', "DeviceMotionControlSequence", 0x300A, 0x0450, [TagLink(BeamTaskSequence),TagLink(RTRadiationTaskSequence),])
    DeviceMotionParameterCodeSequence = Tag('Device Motion Parameter Code Sequence', "DeviceMotionParameterCodeSequence", 0x300A, 0x0453, [TagLink(DeviceMotionControlSequence),])
    AssessedAttributeValueSequence = Tag('Assessed Attribute Value Sequence', "AssessedAttributeValueSequence", 0x0082, 0x0010, [TagLink(StructuredConstraintObservationSequence),])
    SelectorCodeSequenceValue = Tag('Selector Code Sequence Value', "SelectorCodeSequenceValue", 0x0072, 0x0080, [TagLink(AssessedAttributeValueSequence),])
    PositioningLandmarkSequence = Tag('Positioning Landmark Sequence', "PositioningLandmarkSequence", 0x0018, 0x991D)
    AcquisitionProtocolElementSequence = Tag('Acquisition Protocol Element Sequence', "AcquisitionProtocolElementSequence", 0x0018, 0x9920)
    AcquisitionStartLocationSequence = Tag('Acquisition Start Location Sequence', "AcquisitionStartLocationSequence", 0x0018, 0x9931, [TagLink(AcquisitionProtocolElementSequence),])
    AcquisitionEndLocationSequence = Tag('Acquisition End Location Sequence', "AcquisitionEndLocationSequence", 0x0018, 0x9932, [TagLink(AcquisitionProtocolElementSequence),])
    ReconstructionStartLocationSequence = Tag('Reconstruction Start Location Sequence', "ReconstructionStartLocationSequence", 0x0018, 0x993B, [TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionEndLocationSequence = Tag('Reconstruction End Location Sequence', "ReconstructionEndLocationSequence", 0x0018, 0x993C, [TagLink(ReconstructionProtocolElementSequence),])
    ReconstructionTargetCenterLocationSequence = Tag('Reconstruction Target Center Location Sequence', "ReconstructionTargetCenterLocationSequence", 0x0018, 0x993E, [TagLink(ReconstructionProtocolElementSequence),])
    ReferenceBasisCodeSequence = Tag('Reference Basis Code Sequence', "ReferenceBasisCodeSequence", 0x0018, 0x9902, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    ReferenceGeometryCodeSequence = Tag('Reference Geometry Code Sequence', "ReferenceGeometryCodeSequence", 0x0018, 0x9903, [TagLink(PositioningLandmarkSequence),TagLink(AcquisitionStartLocationSequence),TagLink(AcquisitionEndLocationSequence),TagLink(ReconstructionStartLocationSequence),TagLink(ReconstructionEndLocationSequence),TagLink(ReconstructionTargetCenterLocationSequence),])
    AssertionCodeSequence = Tag('Assertion Code Sequence', "AssertionCodeSequence", 0x0044, 0x0101, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    TransducerIdentificationSequence = Tag('Transducer Identification Sequence', "TransducerIdentificationSequence", 0x0018, 0x5011)
    GatingBeamHoldTransitionSequence = Tag('Gating Beam Hold Transition Sequence', "GatingBeamHoldTransitionSequence", 0x300C, 0x0125, [TagLink(TreatmentSessionBeamSequence),])
    BeamHoldOriginatingDeviceSequence = Tag('Beam Hold Originating Device Sequence', "BeamHoldOriginatingDeviceSequence", 0x300C, 0x0128, [TagLink(GatingBeamHoldTransitionSequence),])
    InterlockOriginatingDeviceSequence = Tag('Interlock Originating Device Sequence', "InterlockOriginatingDeviceSequence", 0x300A, 0x0743, [TagLink(InterlockSequence),])
    RTImageFramekVRadiationAcquisitionSequence = Tag('RT Image Frame kV Radiation Acquisition Sequence', "RTImageFramekVRadiationAcquisitionSequence", 0x3002, 0x010A, [TagLink(RTImageFrameRadiationAcquisitionSequence),])
    KVImagingGenerationParametersSequence = Tag('KV Imaging Generation Parameters Sequence', "KVImagingGenerationParametersSequence", 0x3002, 0x0127, [TagLink(AcquisitionSubtaskSequence),])
    XRayFilterSequence = Tag('X-Ray Filter Sequence', "XRayFilterSequence", 0x0018, 0x9556, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DeviceTypeCodeSequence = Tag('Device Type Code Sequence', "DeviceTypeCodeSequence", 0x3010, 0x002E, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    RelatedSeriesSequence = Tag('Related Series Sequence', "RelatedSeriesSequence", 0x0008, 0x1250)
    ContributingSOPInstancesReferenceSequence = Tag('Contributing SOP Instances Reference Sequence', "ContributingSOPInstancesReferenceSequence", 0x0020, 0x9529, [TagLink(ContributingSourcesSequence),])
    RTPhysicianIntentSequence = Tag('RT Physician Intent Sequence', "RTPhysicianIntentSequence", 0x3010, 0x0057)
    RTPhysicianIntentInputInstanceSequence = Tag('RT Physician Intent Input Instance Sequence', "RTPhysicianIntentInputInstanceSequence", 0x3010, 0x005F, [TagLink(RTPhysicianIntentSequence),])
    PlanningInputInformationSequence = Tag('Planning Input Information Sequence', "PlanningInputInformationSequence", 0x3010, 0x0076, [TagLink(RTPrescriptionSequence),])
    ReferencedPositionReferenceInstanceSequence = Tag('Referenced Position Reference Instance Sequence', "ReferencedPositionReferenceInstanceSequence", 0x3002, 0x0132, [TagLink(AcquisitionSubtaskSequence),])
    ReferencedStudySequence = Tag('Referenced Study Sequence', "ReferencedStudySequence", 0x0008, 0x1110, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),TagLink(RTPhysicianIntentInputInstanceSequence),TagLink(PlanningInputInformationSequence),TagLink(ReferencedPositionReferenceInstanceSequence),])
    BlendingSequence = Tag('Blending Sequence', "BlendingSequence", 0x0070, 0x0402)
    StudiesContainingOtherReferencedInstancesSequence = Tag('Studies Containing Other Referenced Instances Sequence', "StudiesContainingOtherReferencedInstancesSequence", 0x0008, 0x1200)
    CurrentRequestedProcedureEvidenceSequence = Tag('Current Requested Procedure Evidence Sequence', "CurrentRequestedProcedureEvidenceSequence", 0x0040, 0xA375)
    IdenticalDocumentsSequence = Tag('Identical Documents Sequence', "IdenticalDocumentsSequence", 0x0040, 0xA525)
    PredecessorDocumentsSequence = Tag('Predecessor Documents Sequence', "PredecessorDocumentsSequence", 0x0040, 0xA360)
    ReferencedSeriesSequence = Tag('Referenced Series Sequence', "ReferencedSeriesSequence", 0x0008, 0x1115, [TagLink(ContributingSOPInstancesReferenceSequence),TagLink(ReferencedStudySequence),TagLink(BlendingSequence),TagLink(StudiesContainingOtherReferencedInstancesSequence),TagLink(CurrentRequestedProcedureEvidenceSequence),TagLink(IdenticalDocumentsSequence),TagLink(PredecessorDocumentsSequence),])
    PlanOverviewSequence = Tag('Plan Overview Sequence', "PlanOverviewSequence", 0x300C, 0x0116)
    SoundSpeedCorrectionMechanismCodeSequence = Tag('Sound Speed Correction Mechanism Code Sequence', "SoundSpeedCorrectionMechanismCodeSequence", 0x0018, 0x9832)
    DisplayedAreaSelectionSequence = Tag('Displayed Area Selection Sequence', "DisplayedAreaSelectionSequence", 0x0070, 0x005A)
    GraphicAnnotationSequence = Tag('Graphic Annotation Sequence', "GraphicAnnotationSequence", 0x0070, 0x0001)
    AdvancedBlendingSequence = Tag('Advanced Blending Sequence', "AdvancedBlendingSequence", 0x0070, 0x1B01)
    SoftcopyVOILUTSequence = Tag('Softcopy VOI LUT Sequence', "SoftcopyVOILUTSequence", 0x0028, 0x3110, [TagLink(BlendingSequence),TagLink(AdvancedBlendingSequence),])
    StructuredDisplayImageBoxSequence = Tag('Structured Display Image Box Sequence', "StructuredDisplayImageBoxSequence", 0x0072, 0x0422)
    MaskSubtractionSequence = Tag('Mask Subtraction Sequence', "MaskSubtractionSequence", 0x0028, 0x6100)
    FrameDisplayShutterSequence = Tag('Frame Display Shutter Sequence', "FrameDisplayShutterSequence", 0x0018, 0x9472, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MultiFramePresentationSequence = Tag('Multi-frame Presentation Sequence', "MultiFramePresentationSequence", 0x0028, 0x9505)
    VolumetricPresentationInputSetSequence = Tag('Volumetric Presentation Input Set Sequence', "VolumetricPresentationInputSetSequence", 0x0070, 0x120A)
    VolumeCroppingSequence = Tag('Volume Cropping Sequence', "VolumeCroppingSequence", 0x0070, 0x1301)
    VariableModalityLUTSequence = Tag('Variable Modality LUT Sequence', "VariableModalityLUTSequence", 0x0028, 0x3001)
    RegistrationSequence = Tag('Registration Sequence', "RegistrationSequence", 0x0070, 0x0308)
    DeformableRegistrationSequence = Tag('Deformable Registration Sequence', "DeformableRegistrationSequence", 0x0064, 0x0002)
    FiducialSetSequence = Tag('Fiducial Set Sequence', "FiducialSetSequence", 0x0070, 0x031C)
    FiducialSequence = Tag('Fiducial Sequence', "FiducialSequence", 0x0070, 0x031E, [TagLink(FiducialSetSequence),])
    GraphicCoordinatesDataSequence = Tag('Graphic Coordinates Data Sequence', "GraphicCoordinatesDataSequence", 0x0070, 0x0318, [TagLink(FiducialSequence),])
    ReferencedImageSequence = Tag('Referenced Image Sequence', "ReferencedImageSequence", 0x0008, 0x1140, [TagLink(ReferencedSeriesSequence),TagLink(PlanOverviewSequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(DisplayedAreaSelectionSequence),TagLink(GraphicAnnotationSequence),TagLink(SoftcopyVOILUTSequence),TagLink(StructuredDisplayImageBoxSequence),TagLink(MaskSubtractionSequence),TagLink(FrameDisplayShutterSequence),TagLink(MultiFramePresentationSequence),TagLink(VolumetricPresentationInputSetSequence),TagLink(VolumeCroppingSequence),TagLink(AdvancedBlendingSequence),TagLink(VariableModalityLUTSequence),TagLink(RegistrationSequence),TagLink(DeformableRegistrationSequence),TagLink(FiducialSetSequence),TagLink(GraphicCoordinatesDataSequence),TagLink(ReferencedImageRealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DerivationImageSequence = Tag('Derivation Image Sequence', "DerivationImageSequence", 0x0008, 0x9124, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRay3DAcquisitionSequence = Tag('X-Ray 3D Acquisition Sequence', "XRay3DAcquisitionSequence", 0x0018, 0x9507)
    SourceImageSequence = Tag('Source Image Sequence', "SourceImageSequence", 0x0008, 0x2112, [TagLink(DerivationImageSequence),TagLink(XRay3DAcquisitionSequence),])
    ReferencedInstanceSequence = Tag('Referenced Instance Sequence', "ReferencedInstanceSequence", 0x0008, 0x114A, [TagLink(ReferencedSeriesSequence),TagLink(StructuredDisplayImageBoxSequence),])
    OphthalmicFrameLocationSequence = Tag('Ophthalmic Frame Location Sequence', "OphthalmicFrameLocationSequence", 0x0022, 0x0031, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SourceInstanceSequence = Tag('Source Instance Sequence', "SourceInstanceSequence", 0x0042, 0x0013)
    CornealSizeSequence = Tag('Corneal Size Sequence', "CornealSizeSequence", 0x0046, 0x0047)
    LensThicknessSequence = Tag('Lens Thickness Sequence', "LensThicknessSequence", 0x0022, 0x1127)
    AnteriorChamberDepthSequence = Tag('Anterior Chamber Depth Sequence', "AnteriorChamberDepthSequence", 0x0022, 0x1128)
    RefractiveStateSequence = Tag('Refractive State Sequence', "RefractiveStateSequence", 0x0022, 0x001B)
    SourceOfRefractiveMeasurementsSequence = Tag('Source of Refractive Measurements Sequence', "SourceOfRefractiveMeasurementsSequence", 0x0022, 0x1134, [TagLink(RefractiveStateSequence),])
    CorneaMeasurementsSequence = Tag('Cornea Measurements Sequence', "CorneaMeasurementsSequence", 0x0046, 0x0110)
    OphthalmicAxialLengthSequence = Tag('Ophthalmic Axial Length Sequence', "OphthalmicAxialLengthSequence", 0x0022, 0x1012)
    ReferencedSOPSequence = Tag('Referenced SOP Sequence', "ReferencedSOPSequence", 0x0008, 0x1199, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(ReferencedPatientPhotoSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(CornealSizeSequence),TagLink(LensThicknessSequence),TagLink(AnteriorChamberDepthSequence),TagLink(SourceOfRefractiveMeasurementsSequence),TagLink(CorneaMeasurementsSequence),TagLink(OphthalmicAxialLengthSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(DirectSegmentReferenceSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    PurposeOfReferenceCodeSequence = Tag('Purpose of Reference Code Sequence', "PurposeOfReferenceCodeSequence", 0x0040, 0xA170, [TagLink(RelatedSeriesSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ContributingEquipmentSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedSOPSequence),TagLink(RTPhysicianIntentInputInstanceSequence),TagLink(PlanningInputInformationSequence),TagLink(ReferencedPositionReferenceInstanceSequence),TagLink(AlternateRepresentationSequence),])
    TreatmentPositionSequence = Tag('Treatment Position Sequence', "TreatmentPositionSequence", 0x300A, 0x063F)
    RTPatientPositionSequence = Tag('RT Patient Position Sequence', "RTPatientPositionSequence", 0x300A, 0x0799, [TagLink(RTDeliveryStartPatientPositionSequence),TagLink(RTTreatmentPreparationPatientPositionSequence),TagLink(RTAcquisitionPatientPositionSequence),])
    PatientLocationCoordinatesSequence = Tag('Patient Location Coordinates Sequence', "PatientLocationCoordinatesSequence", 0x3006, 0x00C9, [TagLink(TreatmentPositionSequence),TagLink(RTPatientPositionSequence),])
    PatientLocationCoordinatesCodeSequence = Tag('Patient Location Coordinates Code Sequence', "PatientLocationCoordinatesCodeSequence", 0x3006, 0x00CA, [TagLink(PatientLocationCoordinatesSequence),])
    EthnicGroupCodeSequence = Tag('Ethnic Group Code Sequence', "EthnicGroupCodeSequence", 0x0010, 0x2161)
    PatientSpeciesCodeSequence = Tag('Patient Species Code Sequence', "PatientSpeciesCodeSequence", 0x0010, 0x2202)
    PatientBreedCodeSequence = Tag('Patient Breed Code Sequence', "PatientBreedCodeSequence", 0x0010, 0x2293)
    BreedRegistrationSequence = Tag('Breed Registration Sequence', "BreedRegistrationSequence", 0x0010, 0x2294)
    BreedRegistryCodeSequence = Tag('Breed Registry Code Sequence', "BreedRegistryCodeSequence", 0x0010, 0x2296, [TagLink(BreedRegistrationSequence),])
    StrainCodeSequence = Tag('Strain Code Sequence', "StrainCodeSequence", 0x0010, 0x0219)
    StrainStockSequence = Tag('Strain Stock Sequence', "StrainStockSequence", 0x0010, 0x0216)
    StrainSourceRegistryCodeSequence = Tag('Strain Source Registry Code Sequence', "StrainSourceRegistryCodeSequence", 0x0010, 0x0215, [TagLink(StrainStockSequence),])
    GeneticModificationsSequence = Tag('Genetic Modifications Sequence', "GeneticModificationsSequence", 0x0010, 0x0221)
    GeneticModificationsCodeSequence = Tag('Genetic Modifications Code Sequence', "GeneticModificationsCodeSequence", 0x0010, 0x0229, [TagLink(GeneticModificationsSequence),])
    DeidentificationMethodCodeSequence = Tag('De-identification Method Code Sequence', "DeidentificationMethodCodeSequence", 0x0012, 0x0064)
    RequestingServiceCodeSequence = Tag('Requesting Service Code Sequence', "RequestingServiceCodeSequence", 0x0032, 0x1034)
    ProcedureCodeSequence = Tag('Procedure Code Sequence', "ProcedureCodeSequence", 0x0008, 0x1032, [TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedStudiesSequence),])
    ReasonForPerformedProcedureCodeSequence = Tag('Reason For Performed Procedure Code Sequence', "ReasonForPerformedProcedureCodeSequence", 0x0040, 0x1012)
    AdmittingDiagnosesCodeSequence = Tag('Admitting Diagnoses Code Sequence', "AdmittingDiagnosesCodeSequence", 0x0008, 0x1084)
    PrincipalDiagnosisCodeSequence = Tag('Principal Diagnosis Code Sequence', "PrincipalDiagnosisCodeSequence", 0x0008, 0x1301)
    PrimaryDiagnosisCodeSequence = Tag('Primary Diagnosis Code Sequence', "PrimaryDiagnosisCodeSequence", 0x0008, 0x1302)
    SecondaryDiagnosesCodeSequence = Tag('Secondary Diagnoses Code Sequence', "SecondaryDiagnosesCodeSequence", 0x0008, 0x1303)
    HistologicalDiagnosesCodeSequence = Tag('Histological Diagnoses Code Sequence', "HistologicalDiagnosesCodeSequence", 0x0008, 0x1304)
    PatientSizeCodeSequence = Tag("Patient's Size Code Sequence", "PatientSizeCodeSequence", 0x0010, 0x1021)
    ReasonForVisitCodeSequence = Tag('Reason for Visit Code Sequence', "ReasonForVisitCodeSequence", 0x0032, 0x1067)
    ClinicalTrialTimePointTypeCodeSequence = Tag('Clinical Trial Time Point Type Code Sequence', "ClinicalTrialTimePointTypeCodeSequence", 0x0012, 0x0054)
    SeriesDescriptionCodeSequence = Tag('Series Description Code Sequence', "SeriesDescriptionCodeSequence", 0x0008, 0x103F)
    ContrastBolusAgentSequence = Tag('Contrast/Bolus Agent Sequence', "ContrastBolusAgentSequence", 0x0018, 0x0012, [TagLink(XRay3DAcquisitionSequence),])
    ContrastBolusAdministrationRouteSequence = Tag('Contrast/Bolus Administration Route Sequence', "ContrastBolusAdministrationRouteSequence", 0x0018, 0x0014, [TagLink(ContrastBolusAgentSequence),])
    AdditionalDrugSequence = Tag('Additional Drug Sequence', "AdditionalDrugSequence", 0x0018, 0x002A, [TagLink(ContrastBolusAdministrationRouteSequence),])
    ContrastBolusIngredientCodeSequence = Tag('Contrast/Bolus Ingredient Code Sequence', "ContrastBolusIngredientCodeSequence", 0x0018, 0x9338, [TagLink(ContrastBolusAgentSequence),])
    MultiplexedAudioChannelsDescriptionCodeSequence = Tag('Multiplexed Audio Channels Description Code Sequence', "MultiplexedAudioChannelsDescriptionCodeSequence", 0x003A, 0x0300)
    WaveformSequence = Tag('Waveform Sequence', "WaveformSequence", 0x5400, 0x0100)
    ChannelDefinitionSequence = Tag('Channel Definition Sequence', "ChannelDefinitionSequence", 0x003A, 0x0200, [TagLink(WaveformSequence),])
    ContributingChannelSourcesSequence = Tag('Contributing Channel Sources Sequence', "ContributingChannelSourcesSequence", 0x0040, 0xB041)
    ChannelSourceSequence = Tag('Channel Source Sequence', "ChannelSourceSequence", 0x003A, 0x0208, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),TagLink(ChannelDefinitionSequence),TagLink(ContributingChannelSourcesSequence),])
    InterventionSequence = Tag('Intervention Sequence', "InterventionSequence", 0x0018, 0x0036)
    InterventionDrugInformationSequence = Tag('Intervention Drug Information Sequence', "InterventionDrugInformationSequence", 0x0018, 0x0026)
    InterventionDrugCodeSequence = Tag('Intervention Drug Code Sequence', "InterventionDrugCodeSequence", 0x0018, 0x0029, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    RadiopharmaceuticalInformationSequence = Tag('Radiopharmaceutical Information Sequence', "RadiopharmaceuticalInformationSequence", 0x0054, 0x0016)
    AdministrationRouteCodeSequence = Tag('Administration Route Code Sequence', "AdministrationRouteCodeSequence", 0x0054, 0x0302, [TagLink(InterventionSequence),TagLink(RadiopharmaceuticalInformationSequence),TagLink(InterventionDrugInformationSequence),])
    XAXRFFrameCharacteristicsSequence = Tag('XA/XRF Frame Characteristics Sequence', "XAXRFFrameCharacteristicsSequence", 0x0018, 0x9412, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DerivationCodeSequence = Tag('Derivation Code Sequence', "DerivationCodeSequence", 0x0008, 0x9215, [TagLink(DerivationImageSequence),TagLink(StructureSetROISequence),TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ReconstructionProtocolElementSequence),])
    PatientPhysiologicalStateSequence = Tag('Patient Physiological State Sequence', "PatientPhysiologicalStateSequence", 0x0018, 0x9771, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PatientPhysiologicalStateCodeSequence = Tag('Patient Physiological State Code Sequence', "PatientPhysiologicalStateCodeSequence", 0x0018, 0x9772, [TagLink(PatientPhysiologicalStateSequence),])
    ContainerTypeCodeSequence = Tag('Container Type Code Sequence', "ContainerTypeCodeSequence", 0x0040, 0x0518)
    ContainerComponentTypeCodeSequence = Tag('Container Component Type Code Sequence', "ContainerComponentTypeCodeSequence", 0x0050, 0x0012, [TagLink(ContainerComponentSequence),])
    SpecimenTypeCodeSequence = Tag('Specimen Type Code Sequence', "SpecimenTypeCodeSequence", 0x0040, 0x059A, [TagLink(SpecimenDescriptionSequence),])
    CTExposureSequence = Tag('CT Exposure Sequence', "CTExposureSequence", 0x0018, 0x9321, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CTDIPhantomTypeCodeSequence = Tag('CTDI Phantom Type Code Sequence', "CTDIPhantomTypeCodeSequence", 0x0018, 0x9346, [TagLink(CTExposureSequence),TagLink(AcquisitionProtocolElementSequence),])
    WaterEquivalentDiameterCalculationMethodCodeSequence = Tag('Water Equivalent Diameter Calculation Method Code Sequence', "WaterEquivalentDiameterCalculationMethodCodeSequence", 0x0018, 0x1272, [TagLink(CTExposureSequence),])
    RadionuclideCodeSequence = Tag('Radionuclide Code Sequence', "RadionuclideCodeSequence", 0x0054, 0x0300, [TagLink(RadiopharmaceuticalInformationSequence),])
    RadiopharmaceuticalCodeSequence = Tag('Radiopharmaceutical Code Sequence', "RadiopharmaceuticalCodeSequence", 0x0054, 0x0304, [TagLink(RadiopharmaceuticalInformationSequence),])
    SequenceOfUltrasoundRegions = Tag('Sequence of Ultrasound Regions', "SequenceOfUltrasoundRegions", 0x0018, 0x6011)
    PixelValueMappingToCodedConceptSequence = Tag('Pixel Value Mapping to Coded Concept Sequence', "PixelValueMappingToCodedConceptSequence", 0x0022, 0x1450)
    PixelValueMappingCodeSequence = Tag('Pixel Value Mapping Code Sequence', "PixelValueMappingCodeSequence", 0x0040, 0x9098, [TagLink(SequenceOfUltrasoundRegions),TagLink(PixelValueMappingToCodedConceptSequence),])
    StageCodeSequence = Tag('Stage Code Sequence', "StageCodeSequence", 0x0040, 0x000A)
    DocumentClassCodeSequence = Tag('Document Class Code Sequence', "DocumentClassCodeSequence", 0x0040, 0xE008)
    TreatmentSiteCodeSequence = Tag('Treatment Site Code Sequence', "TreatmentSiteCodeSequence", 0x3010, 0x0078, [TagLink(PlanOverviewSequence),TagLink(RTPhysicianIntentSequence),])
    TreatmentSiteModifierCodeSequence = Tag('Treatment Site Modifier Code Sequence', "TreatmentSiteModifierCodeSequence", 0x3010, 0x0089, [TagLink(TreatmentSiteCodeSequence),])
    RTProtocolCodeSequence = Tag('RT Protocol Code Sequence', "RTProtocolCodeSequence", 0x3010, 0x005B, [TagLink(StructureSetROISequence),TagLink(RTPhysicianIntentSequence),])
    ROIObservationContextCodeSequence = Tag('ROI Observation Context Code Sequence', "ROIObservationContextCodeSequence", 0x3006, 0x004F, [TagLink(RTROIObservationsSequence),])
    SurfacePointsSequence = Tag('Surface Points Sequence', "SurfacePointsSequence", 0x0066, 0x0011, [TagLink(SurfaceSequence),])
    SegmentedPropertyCategoryCodeSequence = Tag('Segmented Property Category Code Sequence', "SegmentedPropertyCategoryCodeSequence", 0x0062, 0x0003, [TagLink(RTROIObservationsSequence),TagLink(SegmentSequence),TagLink(SurfaceSequence),TagLink(SurfacePointsSequence),TagLink(CombinationSegmentReferenceSequence),])
    RTROIIdentificationCodeSequence = Tag('RT ROI Identification Code Sequence', "RTROIIdentificationCodeSequence", 0x3006, 0x0086, [TagLink(RTROIObservationsSequence),])
    OphthalmicEnFaceVolumeDescriptorSequence = Tag('Ophthalmic En Face Volume Descriptor Sequence', "OphthalmicEnFaceVolumeDescriptorSequence", 0x0022, 0x1627)
    ReferencedSegmentationSequence = Tag('Referenced Segmentation Sequence', "ReferencedSegmentationSequence", 0x0008, 0x114C, [TagLink(OphthalmicEnFaceVolumeDescriptorSequence),])
    SegmentedPropertyTypeCodeSequence = Tag('Segmented Property Type Code Sequence', "SegmentedPropertyTypeCodeSequence", 0x0062, 0x000F, [TagLink(ReferencedSegmentationSequence),TagLink(SegmentSequence),TagLink(SurfaceSequence),TagLink(SurfacePointsSequence),TagLink(CombinationSegmentReferenceSequence),])
    SegmentedPropertyTypeModifierCodeSequence = Tag('Segmented Property Type Modifier Code Sequence', "SegmentedPropertyTypeModifierCodeSequence", 0x0062, 0x0011, [TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),])
    TherapeuticRoleCategoryCodeSequence = Tag('Therapeutic Role Category Code Sequence', "TherapeuticRoleCategoryCodeSequence", 0x3010, 0x0064, [TagLink(RTROIObservationsSequence),TagLink(RTAnatomicPrescriptionSequence),])
    TherapeuticRoleTypeCodeSequence = Tag('Therapeutic Role Type Code Sequence', "TherapeuticRoleTypeCodeSequence", 0x3010, 0x0065, [TagLink(RTROIObservationsSequence),TagLink(RTAnatomicPrescriptionSequence),])
    RTTreatmentTechniqueCodeSequence = Tag('RT Treatment Technique Code Sequence', "RTTreatmentTechniqueCodeSequence", 0x3010, 0x0080, [TagLink(BeamSequence),TagLink(RTPrescriptionSequence),])
    RTTreatmentTerminationReasonCodeSequence = Tag('RT Treatment Termination Reason Code Sequence', "RTTreatmentTerminationReasonCodeSequence", 0x300A, 0x0715, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    MachineSpecificTreatmentTerminationCodeSequence = Tag('Machine-Specific Treatment Termination Code Sequence', "MachineSpecificTreatmentTerminationCodeSequence", 0x300A, 0x0716, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    ProjectionEponymousNameCodeSequence = Tag('Projection Eponymous Name Code Sequence', "ProjectionEponymousNameCodeSequence", 0x0018, 0x5104)
    PartialViewCodeSequence = Tag('Partial View Code Sequence', "PartialViewCodeSequence", 0x0028, 0x1352)
    OpticalPathSequence = Tag('Optical Path Sequence', "OpticalPathSequence", 0x0048, 0x0105)
    ChannelDescriptionCodeSequence = Tag('Channel Description Code Sequence', "ChannelDescriptionCodeSequence", 0x0022, 0x001A, [TagLink(OpticalPathSequence),])
    IlluminatorTypeCodeSequence = Tag('Illuminator Type Code Sequence', "IlluminatorTypeCodeSequence", 0x0048, 0x0100, [TagLink(OpticalPathSequence),])
    IlluminationColorCodeSequence = Tag('Illumination Color Code Sequence', "IlluminationColorCodeSequence", 0x0048, 0x0108, [TagLink(OpticalPathSequence),])
    IlluminationTypeCodeSequence = Tag('Illumination Type Code Sequence', "IlluminationTypeCodeSequence", 0x0022, 0x0016, [TagLink(OpticalPathSequence),])
    LightPathFilterTypeStackCodeSequence = Tag('Light Path Filter Type Stack Code Sequence', "LightPathFilterTypeStackCodeSequence", 0x0022, 0x0017, [TagLink(OpticalPathSequence),])
    ImagePathFilterTypeStackCodeSequence = Tag('Image Path Filter Type Stack Code Sequence', "ImagePathFilterTypeStackCodeSequence", 0x0022, 0x0018, [TagLink(OpticalPathSequence),])
    LensesCodeSequence = Tag('Lenses Code Sequence', "LensesCodeSequence", 0x0022, 0x0019, [TagLink(OpticalPathSequence),])
    MRMetaboliteMapSequence = Tag('MR Metabolite Map Sequence', "MRMetaboliteMapSequence", 0x0018, 0x9152, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MetaboliteMapCodeSequence = Tag('Metabolite Map Code Sequence', "MetaboliteMapCodeSequence", 0x0018, 0x9083, [TagLink(MRMetaboliteMapSequence),])
    DecompositionMaterialSequence = Tag('Decomposition Material Sequence', "DecompositionMaterialSequence", 0x0018, 0x9381, [TagLink(MultienergyCTProcessingSequence),])
    MaterialCodeSequence = Tag('Material Code Sequence', "MaterialCodeSequence", 0x0018, 0x937D, [TagLink(DecompositionMaterialSequence),])
    AcquisitionDeviceTypeCodeSequence = Tag('Acquisition Device Type Code Sequence', "AcquisitionDeviceTypeCodeSequence", 0x0022, 0x0015)
    PatientEyeMovementCommandCodeSequence = Tag('Patient Eye Movement Command Code Sequence', "PatientEyeMovementCommandCodeSequence", 0x0022, 0x0006)
    RelativeImagePositionCodeSequence = Tag('Relative Image Position Code Sequence', "RelativeImagePositionCodeSequence", 0x0022, 0x001D)
    MydriaticAgentSequence = Tag('Mydriatic Agent Sequence', "MydriaticAgentSequence", 0x0022, 0x0058)
    MydriaticAgentCodeSequence = Tag('Mydriatic Agent Code Sequence', "MydriaticAgentCodeSequence", 0x0022, 0x001C, [TagLink(MydriaticAgentSequence),])
    MydriaticAgentConcentrationUnitsSequence = Tag('Mydriatic Agent Concentration Units Sequence', "MydriaticAgentConcentrationUnitsSequence", 0x0022, 0x0042, [TagLink(MydriaticAgentSequence),])
    OCTBscanAnalysisAcquisitionParametersSequence = Tag('OCT B-scan Analysis Acquisition Parameters Sequence', "OCTBscanAnalysisAcquisitionParametersSequence", 0x0022, 0x1640)
    ScanPatternTypeCodeSequence = Tag('Scan Pattern Type Code Sequence', "ScanPatternTypeCodeSequence", 0x0022, 0x1618, [TagLink(OCTBscanAnalysisAcquisitionParametersSequence),])
    TransformationMethodCodeSequence = Tag('Transformation Method Code Sequence', "TransformationMethodCodeSequence", 0x0022, 0x1512)
    OphthalmicImageTypeCodeSequence = Tag('Ophthalmic Image Type Code Sequence', "OphthalmicImageTypeCodeSequence", 0x0022, 0x1615)
    EventTimerSequence = Tag('Event Timer Sequence', "EventTimerSequence", 0x0008, 0x2133)
    EventCodeSequence = Tag('Event Code Sequence', "EventCodeSequence", 0x0008, 0x2135, [TagLink(EventTimerSequence),])
    TransducerScanPatternCodeSequence = Tag('Transducer Scan Pattern Code Sequence', "TransducerScanPatternCodeSequence", 0x0018, 0x9809)
    TransducerGeometryCodeSequence = Tag('Transducer Geometry Code Sequence', "TransducerGeometryCodeSequence", 0x0018, 0x980D)
    TransducerBeamSteeringCodeSequence = Tag('Transducer Beam Steering Code Sequence', "TransducerBeamSteeringCodeSequence", 0x0018, 0x980E)
    TransducerApplicationCodeSequence = Tag('Transducer Application Code Sequence', "TransducerApplicationCodeSequence", 0x0018, 0x980F)
    VisualAcuityTypeCodeSequence = Tag('Visual Acuity Type Code Sequence', "VisualAcuityTypeCodeSequence", 0x0046, 0x0121)
    OphthalmicUltrasoundMethodCodeSequence = Tag('Ophthalmic Ultrasound Method Code Sequence', "OphthalmicUltrasoundMethodCodeSequence", 0x0022, 0x1044, [TagLink(OphthalmicAxialLengthSequence),])
    AnteriorChamberDepthDefinitionCodeSequence = Tag('Anterior Chamber Depth Definition Code Sequence', "AnteriorChamberDepthDefinitionCodeSequence", 0x0022, 0x1125)
    LensStatusCodeSequence = Tag('Lens Status Code Sequence', "LensStatusCodeSequence", 0x0022, 0x1024)
    VitreousStatusCodeSequence = Tag('Vitreous Status Code Sequence', "VitreousStatusCodeSequence", 0x0022, 0x1025)
    UltrasoundSelectedOphthalmicAxialLengthSequence = Tag('Ultrasound Selected Ophthalmic Axial Length Sequence', "UltrasoundSelectedOphthalmicAxialLengthSequence", 0x0022, 0x1230)
    OpticalSelectedOphthalmicAxialLengthSequence = Tag('Optical Selected Ophthalmic Axial Length Sequence', "OpticalSelectedOphthalmicAxialLengthSequence", 0x0022, 0x1255)
    SelectedSegmentalOphthalmicAxialLengthSequence = Tag('Selected Segmental Ophthalmic Axial Length Sequence', "SelectedSegmentalOphthalmicAxialLengthSequence", 0x0022, 0x1257, [TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(OpticalSelectedOphthalmicAxialLengthSequence),])
    OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence = Tag('Ophthalmic Axial Length Measurements Segment Name Code Sequence', "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence", 0x0022, 0x1101, [TagLink(SelectedSegmentalOphthalmicAxialLengthSequence),])
    UltrasoundOphthalmicAxialLengthMeasurementsSequence = Tag('Ultrasound Ophthalmic Axial Length Measurements Sequence', "UltrasoundOphthalmicAxialLengthMeasurementsSequence", 0x0022, 0x1220)
    OpticalOphthalmicAxialLengthMeasurementsSequence = Tag('Optical Ophthalmic Axial Length Measurements Sequence', "OpticalOphthalmicAxialLengthMeasurementsSequence", 0x0022, 0x1225)
    OphthalmicAxialLengthDataSourceCodeSequence = Tag('Ophthalmic Axial Length Data Source Code Sequence', "OphthalmicAxialLengthDataSourceCodeSequence", 0x0022, 0x1150, [TagLink(UltrasoundOphthalmicAxialLengthMeasurementsSequence),TagLink(OpticalOphthalmicAxialLengthMeasurementsSequence),])
    OphthalmicAxialLengthSelectionMethodCodeSequence = Tag('Ophthalmic Axial Length Selection Method Code Sequence', "OphthalmicAxialLengthSelectionMethodCodeSequence", 0x0022, 0x1250, [TagLink(UltrasoundSelectedOphthalmicAxialLengthSequence),TagLink(OphthalmicAxialLengthSequence),])
    RefractiveSurgeryTypeCodeSequence = Tag('Refractive Surgery Type Code Sequence', "RefractiveSurgeryTypeCodeSequence", 0x0022, 0x1040)
    RefractiveErrorBeforeRefractiveSurgeryCodeSequence = Tag('Refractive Error Before Refractive Surgery Code Sequence', "RefractiveErrorBeforeRefractiveSurgeryCodeSequence", 0x0022, 0x1103)
    SourceOfCornealSizeDataCodeSequence = Tag('Source of Corneal Size Data Code Sequence', "SourceOfCornealSizeDataCodeSequence", 0x0022, 0x1036, [TagLink(CornealSizeSequence),])
    SourceOfLensThicknessDataCodeSequence = Tag('Source of Lens Thickness Data Code Sequence', "SourceOfLensThicknessDataCodeSequence", 0x0022, 0x1132, [TagLink(LensThicknessSequence),])
    SourceOfAnteriorChamberDepthDataCodeSequence = Tag('Source of Anterior Chamber Depth Data Code Sequence', "SourceOfAnteriorChamberDepthDataCodeSequence", 0x0022, 0x1133, [TagLink(AnteriorChamberDepthSequence),])
    SourceOfRefractiveMeasurementsCodeSequence = Tag('Source of Refractive Measurements Code Sequence', "SourceOfRefractiveMeasurementsCodeSequence", 0x0022, 0x1135, [TagLink(SourceOfRefractiveMeasurementsSequence),])
    SourceOfCorneaMeasurementDataCodeSequence = Tag('Source of Cornea Measurement Data Code Sequence', "SourceOfCorneaMeasurementDataCodeSequence", 0x0046, 0x0111, [TagLink(CorneaMeasurementsSequence),])
    IOLFormulaCodeSequence = Tag('IOL Formula Code Sequence', "IOLFormulaCodeSequence", 0x0022, 0x1028)
    KeratometryMeasurementTypeCodeSequence = Tag('Keratometry Measurement Type Code Sequence', "KeratometryMeasurementTypeCodeSequence", 0x0022, 0x1096)
    SourceOfOphthalmicAxialLengthCodeSequence = Tag('Source of Ophthalmic Axial Length Code Sequence', "SourceOfOphthalmicAxialLengthCodeSequence", 0x0022, 0x1035, [TagLink(OphthalmicAxialLengthSequence),])
    CorneaMeasurementMethodCodeSequence = Tag('Cornea Measurement Method Code Sequence', "CorneaMeasurementMethodCodeSequence", 0x0046, 0x0116)
    ScreeningTestModeCodeSequence = Tag('Screening Test Mode Code Sequence', "ScreeningTestModeCodeSequence", 0x0024, 0x0016)
    StimulusColorCodeSequence = Tag('Stimulus Color Code Sequence', "StimulusColorCodeSequence", 0x0024, 0x0021)
    BackgroundIlluminationColorCodeSequence = Tag('Background Illumination Color Code Sequence', "BackgroundIlluminationColorCodeSequence", 0x0024, 0x0024)
    FixationSequence = Tag('Fixation Sequence', "FixationSequence", 0x0024, 0x0032)
    FixationMonitoringCodeSequence = Tag('Fixation Monitoring Code Sequence', "FixationMonitoringCodeSequence", 0x0024, 0x0033, [TagLink(FixationSequence),])
    ModeOfPercutaneousAccessSequence = Tag('Mode of Percutaneous Access Sequence', "ModeOfPercutaneousAccessSequence", 0x0052, 0x0016)
    AcquisitionMethodCodeSequence = Tag('Acquisition Method Code Sequence', "AcquisitionMethodCodeSequence", 0x0022, 0x1420)
    OphthalmicThicknessMapTypeCodeSequence = Tag('Ophthalmic Thickness Map Type Code Sequence', "OphthalmicThicknessMapTypeCodeSequence", 0x0022, 0x1436)
    RetinalThicknessDefinitionCodeSequence = Tag('Retinal Thickness Definition Code Sequence', "RetinalThicknessDefinitionCodeSequence", 0x0022, 0x1445)
    SurfaceScanAcquisitionTypeCodeSequence = Tag('Surface Scan Acquisition Type Code Sequence', "SurfaceScanAcquisitionTypeCodeSequence", 0x0080, 0x0001)
    SurfaceScanModeCodeSequence = Tag('Surface Scan Mode Code Sequence', "SurfaceScanModeCodeSequence", 0x0080, 0x0002)
    RegistrationMethodCodeSequence = Tag('Registration Method Code Sequence', "RegistrationMethodCodeSequence", 0x0080, 0x0003)
    CornealTopographyMapTypeCodeSequence = Tag('Corneal Topography Map Type Code Sequence', "CornealTopographyMapTypeCodeSequence", 0x0046, 0x0207)
    TrackSetAnatomicalTypeCodeSequence = Tag('Track Set Anatomical Type Code Sequence', "TrackSetAnatomicalTypeCodeSequence", 0x0066, 0x0108, [TagLink(TrackSetSequence),])
    ModifierCodeSequence = Tag('Modifier Code Sequence', "ModifierCodeSequence", 0x0040, 0xA195, [TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(TrackStatisticsSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),])
    DiffusionAcquisitionCodeSequence = Tag('Diffusion Acquisition Code Sequence', "DiffusionAcquisitionCodeSequence", 0x0066, 0x0133, [TagLink(TrackSetSequence),])
    DiffusionModelCodeSequence = Tag('Diffusion Model Code Sequence', "DiffusionModelCodeSequence", 0x0066, 0x0134, [TagLink(TrackSetSequence),])
    AcousticCouplingMediumCodeSequence = Tag('Acoustic Coupling Medium Code Sequence', "AcousticCouplingMediumCodeSequence", 0x0018, 0x982A)
    TransducerTechnologySequence = Tag('Transducer Technology Sequence', "TransducerTechnologySequence", 0x0018, 0x9831)
    ImageDataTypeSequence = Tag('Image Data Type Sequence', "ImageDataTypeSequence", 0x0018, 0x9807, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageDataTypeCodeSequence = Tag('Image Data Type Code Sequence', "ImageDataTypeCodeSequence", 0x0018, 0x9836, [TagLink(ImageDataTypeSequence),])
    ChannelSourceModifiersSequence = Tag('Channel Source Modifiers Sequence', "ChannelSourceModifiersSequence", 0x003A, 0x0209, [TagLink(ChannelDefinitionSequence),])
    ChannelSensitivityUnitsSequence = Tag('Channel Sensitivity Units Sequence', "ChannelSensitivityUnitsSequence", 0x003A, 0x0211, [TagLink(ChannelDefinitionSequence),])
    FilterLowFrequencyCharacteristicsSequence = Tag('Filter Low Frequency Characteristics Sequence', "FilterLowFrequencyCharacteristicsSequence", 0x003A, 0x0318, [TagLink(ChannelDefinitionSequence),])
    FilterHighFrequencyCharacteristicsSequence = Tag('Filter High Frequency Characteristics Sequence', "FilterHighFrequencyCharacteristicsSequence", 0x003A, 0x0319, [TagLink(ChannelDefinitionSequence),])
    NotchFilterCharacteristicsSequence = Tag('Notch Filter Characteristics Sequence', "NotchFilterCharacteristicsSequence", 0x003A, 0x0321, [TagLink(ChannelDefinitionSequence),])
    AnalogFilterCharacteristicsSequence = Tag('Analog Filter Characteristics Sequence', "AnalogFilterCharacteristicsSequence", 0x003A, 0x0323, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    AnalogFilterTypeCodeSequence = Tag('Analog Filter Type Code Sequence', "AnalogFilterTypeCodeSequence", 0x003A, 0x0325, [TagLink(AnalogFilterCharacteristicsSequence),])
    DigitalFilterCharacteristicsSequence = Tag('Digital Filter Characteristics Sequence', "DigitalFilterCharacteristicsSequence", 0x003A, 0x0326, [TagLink(FilterLowFrequencyCharacteristicsSequence),TagLink(FilterHighFrequencyCharacteristicsSequence),TagLink(NotchFilterCharacteristicsSequence),])
    DigitalFilterTypeCodeSequence = Tag('Digital Filter Type Code Sequence', "DigitalFilterTypeCodeSequence", 0x003A, 0x0328, [TagLink(DigitalFilterCharacteristicsSequence),])
    FrequencyEncodingCodeSequence = Tag('Frequency Encoding Code Sequence', "FrequencyEncodingCodeSequence", 0x003A, 0x032C)
    MagnitudeEncodingCodeSequence = Tag('Magnitude Encoding Code Sequence', "MagnitudeEncodingCodeSequence", 0x003A, 0x032D)
    DigitalSignaturesSequence = Tag('Digital Signatures Sequence', "DigitalSignaturesSequence", 0xFFFA, 0xFFFA)
    DigitalSignaturePurposeCodeSequence = Tag('Digital Signature Purpose Code Sequence', "DigitalSignaturePurposeCodeSequence", 0x0400, 0x0401, [TagLink(DigitalSignaturesSequence),])
    VerifyingObserverSequence = Tag('Verifying Observer Sequence', "VerifyingObserverSequence", 0x0040, 0xA073)
    VerifyingObserverIdentificationCodeSequence = Tag('Verifying Observer Identification Code Sequence', "VerifyingObserverIdentificationCodeSequence", 0x0040, 0xA088, [TagLink(VerifyingObserverSequence),])
    ResponsibleGroupCodeSequence = Tag('Responsible Group Code Sequence', "ResponsibleGroupCodeSequence", 0x0008, 0x0220, [TagLink(CustodialOrganizationSequence),])
    PerformedProcedureCodeSequence = Tag('Performed Procedure Code Sequence', "PerformedProcedureCodeSequence", 0x0040, 0xA372)
    OrganizationalRoleCodeSequence = Tag('Organizational Role Code Sequence', "OrganizationalRoleCodeSequence", 0x0044, 0x010A, [TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    NumericValueQualifierCodeSequence = Tag('Numeric Value Qualifier Code Sequence', "NumericValueQualifierCodeSequence", 0x0040, 0xA301, [TagLink(CellValuesSequence),TagLink(ContentSequence),])
    MatrixRegistrationSequence = Tag('Matrix Registration Sequence', "MatrixRegistrationSequence", 0x0070, 0x0309, [TagLink(RegistrationSequence),])
    RegistrationTypeCodeSequence = Tag('Registration Type Code Sequence', "RegistrationTypeCodeSequence", 0x0070, 0x030D, [TagLink(MatrixRegistrationSequence),TagLink(DeformableRegistrationSequence),])
    FiducialsPropertyCategoryCodeSequence = Tag('Fiducials Property Category Code Sequence', "FiducialsPropertyCategoryCodeSequence", 0x0070, 0x031F, [TagLink(FiducialSequence),])
    FiducialIdentifierCodeSequence = Tag('Fiducial Identifier Code Sequence', "FiducialIdentifierCodeSequence", 0x0070, 0x0311, [TagLink(FiducialSequence),])
    ImageSetsSequence = Tag('Image Sets Sequence', "ImageSetsSequence", 0x0072, 0x0020)
    TimeBasedImageSetsSequence = Tag('Time Based Image Sets Sequence', "TimeBasedImageSetsSequence", 0x0072, 0x0030, [TagLink(ImageSetsSequence),])
    AbstractPriorCodeSequence = Tag('Abstract Prior Code Sequence', "AbstractPriorCodeSequence", 0x0072, 0x003E, [TagLink(TimeBasedImageSetsSequence),])
    HangingProtocolUserIdentificationCodeSequence = Tag('Hanging Protocol User Identification Code Sequence', "HangingProtocolUserIdentificationCodeSequence", 0x0072, 0x000E)
    ImplantRegulatoryDisapprovalCodeSequence = Tag('Implant Regulatory Disapproval Code Sequence', "ImplantRegulatoryDisapprovalCodeSequence", 0x0068, 0x62A0)
    MaterialsCodeSequence = Tag('Materials Code Sequence', "MaterialsCodeSequence", 0x0068, 0x63A0)
    CoatingMaterialsCodeSequence = Tag('Coating Materials Code Sequence', "CoatingMaterialsCodeSequence", 0x0068, 0x63A4)
    ImplantTypeCodeSequence = Tag('Implant Type Code Sequence', "ImplantTypeCodeSequence", 0x0068, 0x63A8)
    FixationMethodCodeSequence = Tag('Fixation Method Code Sequence', "FixationMethodCodeSequence", 0x0068, 0x63AC)
    HPGLDocumentSequence = Tag('HPGL Document Sequence', "HPGLDocumentSequence", 0x0068, 0x62C0)
    ViewOrientationCodeSequence = Tag('View Orientation Code Sequence', "ViewOrientationCodeSequence", 0x0068, 0x62E0, [TagLink(HPGLDocumentSequence),])
    ViewOrientationModifierCodeSequence = Tag('View Orientation Modifier Code Sequence', "ViewOrientationModifierCodeSequence", 0x0068, 0x62F0, [TagLink(HPGLDocumentSequence),])
    PlanningLandmarkPointSequence = Tag('Planning Landmark Point Sequence', "PlanningLandmarkPointSequence", 0x0068, 0x6500)
    PlanningLandmarkLineSequence = Tag('Planning Landmark Line Sequence', "PlanningLandmarkLineSequence", 0x0068, 0x6510)
    PlanningLandmarkPlaneSequence = Tag('Planning Landmark Plane Sequence', "PlanningLandmarkPlaneSequence", 0x0068, 0x6520)
    PlanningLandmarkIdentificationCodeSequence = Tag('Planning Landmark Identification Code Sequence', "PlanningLandmarkIdentificationCodeSequence", 0x0068, 0x6545, [TagLink(PlanningLandmarkPointSequence),TagLink(PlanningLandmarkLineSequence),TagLink(PlanningLandmarkPlaneSequence),])
    ProcedureTypeCodeSequence = Tag('Procedure Type Code Sequence', "ProcedureTypeCodeSequence", 0x0076, 0x0020)
    ComponentTypesSequence = Tag('Component Types Sequence', "ComponentTypesSequence", 0x0076, 0x0032)
    ComponentTypeCodeSequence = Tag('Component Type Code Sequence', "ComponentTypeCodeSequence", 0x0076, 0x0034, [TagLink(ComponentTypesSequence),])
    AssessmentTypeCodeSequence = Tag('Assessment Type Code Sequence', "AssessmentTypeCodeSequence", 0x0082, 0x0021)
    ObservationBasisCodeSequence = Tag('Observation Basis Code Sequence', "ObservationBasisCodeSequence", 0x0082, 0x0022, [TagLink(AssessmentObservationsSequence),])
    PotentialScheduledProtocolCodeSequence = Tag('Potential Scheduled Protocol Code Sequence', "PotentialScheduledProtocolCodeSequence", 0x0018, 0x9906)
    PotentialRequestedProcedureCodeSequence = Tag('Potential Requested Procedure Code Sequence', "PotentialRequestedProcedureCodeSequence", 0x0018, 0x9907)
    PotentialReasonsForProcedureCodeSequence = Tag('Potential Reasons for Procedure Code Sequence', "PotentialReasonsForProcedureCodeSequence", 0x0018, 0x9909)
    ContraindicationsCodeSequence = Tag('Contraindications Code Sequence', "ContraindicationsCodeSequence", 0x0018, 0x990B)
    PositioningMethodCodeSequence = Tag('Positioning Method Code Sequence', "PositioningMethodCodeSequence", 0x0018, 0x991C)
    RequestedSeriesDescriptionCodeSequence = Tag('Requested Series Description Code Sequence', "RequestedSeriesDescriptionCodeSequence", 0x0018, 0x11C1, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ModelUsageCodeSequence = Tag('Model Usage Code Sequence', "ModelUsageCodeSequence", 0x0068, 0x7003)
    DosimetricObjectiveTypeCodeSequence = Tag('Dosimetric Objective Type Code Sequence', "DosimetricObjectiveTypeCodeSequence", 0x3010, 0x006D, [TagLink(DosimetricObjectiveSequence),])
    RadiationDoseSequence = Tag('Radiation Dose Sequence', "RadiationDoseSequence", 0x300A, 0x0617)
    RadiationDoseValuesParametersSequence = Tag('Radiation Dose Values Parameters Sequence', "RadiationDoseValuesParametersSequence", 0x300A, 0x061F, [TagLink(RadiationDoseSequence),])
    DoseValuesSequence = Tag('Dose Values Sequence', "DoseValuesSequence", 0x300A, 0x061C, [TagLink(RadiationDoseValuesParametersSequence),])
    EffectiveDoseCalculationMethodCategoryCodeSequence = Tag('Effective Dose Calculation Method Category Code Sequence', "EffectiveDoseCalculationMethodCategoryCodeSequence", 0x3010, 0x0003, [TagLink(DoseValuesSequence),TagLink(RadiationDoseValuesParametersSequence),])
    EffectiveDoseCalculationMethodCodeSequence = Tag('Effective Dose Calculation Method Code Sequence', "EffectiveDoseCalculationMethodCodeSequence", 0x3010, 0x0004, [TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),])
    TreatmentMachineSpecialModeCodeSequence = Tag('Treatment Machine Special Mode Code Sequence', "TreatmentMachineSpecialModeCodeSequence", 0x300A, 0x0635)
    CArmPhotonElectronControlPointSequence = Tag('C-Arm Photon-Electron Control Point Sequence', "CArmPhotonElectronControlPointSequence", 0x300A, 0x062F)
    TomotherapeuticControlPointSequence = Tag('Tomotherapeutic Control Point Sequence', "TomotherapeuticControlPointSequence", 0x3010, 0x0098)
    RoboticPathControlPointSequence = Tag('Robotic Path Control Point Sequence', "RoboticPathControlPointSequence", 0x3010, 0x0097)
    DeliveryRateUnitSequence = Tag('Delivery Rate Unit Sequence', "DeliveryRateUnitSequence", 0x300A, 0x063E, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(CArmPhotonElectronControlPointSequence),TagLink(TomotherapeuticControlPointSequence),TagLink(RoboticPathControlPointSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationGenerationModeMachineCodeSequence = Tag('Radiation Generation Mode Machine Code Sequence', "RadiationGenerationModeMachineCodeSequence", 0x300A, 0x067E, [TagLink(RadiationGenerationModeSequence),])
    RadiationTypeCodeSequence = Tag('Radiation Type Code Sequence', "RadiationTypeCodeSequence", 0x300A, 0x067F, [TagLink(RadiationGenerationModeSequence),])
    EnergyUnitCodeSequence = Tag('Energy Unit Code Sequence', "EnergyUnitCodeSequence", 0x300A, 0x0684, [TagLink(RadiationGenerationModeSequence),])
    RadiationFluenceModifierCodeSequence = Tag('Radiation Fluence Modifier Code Sequence', "RadiationFluenceModifierCodeSequence", 0x300A, 0x0683, [TagLink(RadiationGenerationModeSequence),])
    CompensatorShapeSequence = Tag('Compensator Shape Sequence', "CompensatorShapeSequence", 0x300A, 0x0668, [TagLink(CompensatorDefinitionSequence),])
    CompensatorShapeFabricationCodeSequence = Tag('Compensator Shape Fabrication Code Sequence', "CompensatorShapeFabricationCodeSequence", 0x300A, 0x0667, [TagLink(CompensatorShapeSequence),])
    InterlockCodeSequence = Tag('Interlock Code Sequence', "InterlockCodeSequence", 0x300A, 0x0744, [TagLink(InterlockSequence),])
    InterlockResolutionCodeSequence = Tag('Interlock Resolution Code Sequence', "InterlockResolutionCodeSequence", 0x300A, 0x0745, [TagLink(InterlockSequence),])
    ParallelRTBeamDelimiterDeviceSequence = Tag('Parallel RT Beam Delimiter Device Sequence', "ParallelRTBeamDelimiterDeviceSequence", 0x300A, 0x0647)
    ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence = Tag('Parallel RT Beam Delimiter Device Orientation Label Code Sequence', "ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence", 0x300A, 0x0644, [TagLink(ParallelRTBeamDelimiterDeviceSequence),])
    DisplacementReferenceLocationCodeSequence = Tag('Displacement Reference Location Code Sequence', "DisplacementReferenceLocationCodeSequence", 0x300A, 0x079D, [TagLink(RTPatientPositionDisplacementSequence),])
    PatientTreatmentPreparationMethodCodeSequence = Tag('Patient Treatment Preparation Method Code Sequence', "PatientTreatmentPreparationMethodCodeSequence", 0x300A, 0x078D, [TagLink(PatientTreatmentPreparationSequence),])
    PatientTreatmentPreparationProcedureCodeSequence = Tag('Patient Treatment Preparation Procedure Code Sequence', "PatientTreatmentPreparationProcedureCodeSequence", 0x300A, 0x0791, [TagLink(PatientTreatmentPreparationProcedureSequence),])
    EnergyDerivationCodeSequence = Tag('Energy Derivation Code Sequence', "EnergyDerivationCodeSequence", 0x3002, 0x0133, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),TagLink(MVImagingGenerationParametersSequence),])
    RadiationDosimeterUnitSequence = Tag('Radiation Dosimeter Unit Sequence', "RadiationDosimeterUnitSequence", 0x300A, 0x0658, [TagLink(RTImageFrameMVRadiationAcquisitionSequence),TagLink(MVImagingGenerationParametersSequence),])
    RTDiagnosisCodeSequence = Tag('RT Diagnosis Code Sequence', "RTDiagnosisCodeSequence", 0x3010, 0x005D, [TagLink(RTPhysicianIntentSequence),])
    ConceptualVolumeCategoryCodeSequence = Tag('Conceptual Volume Category Code Sequence', "ConceptualVolumeCategoryCodeSequence", 0x3010, 0x0067, [TagLink(RTAnatomicPrescriptionSequence),])
    ConceptualVolumeTypeCodeSequence = Tag('Conceptual Volume Type Code Sequence', "ConceptualVolumeTypeCodeSequence", 0x3010, 0x0069, [TagLink(RTAnatomicPrescriptionSequence),])
    ConceptualVolumeTypeModifierCodeSequence = Tag('Conceptual Volume Type Modifier Code Sequence', "ConceptualVolumeTypeModifierCodeSequence", 0x3010, 0x006A, [TagLink(RTAnatomicPrescriptionSequence),])
    DeliveryTimeStructureCodeSequence = Tag('Delivery Time Structure Code Sequence', "DeliveryTimeStructureCodeSequence", 0x3010, 0x0088, [TagLink(RTPrescriptionSequence),])
    SegmentAnnotationCategoryCodeSequence = Tag('Segment Annotation Category Code Sequence', "SegmentAnnotationCategoryCodeSequence", 0x3010, 0x002B, [TagLink(RTSegmentAnnotationSequence),])
    SegmentAnnotationTypeCodeSequence = Tag('Segment Annotation Type Code Sequence', "SegmentAnnotationTypeCodeSequence", 0x3010, 0x002C, [TagLink(RTSegmentAnnotationSequence),])
    SegmentAnnotationTypeModifierCodeSequence = Tag('Segment Annotation Type Modifier Code Sequence', "SegmentAnnotationTypeModifierCodeSequence", 0x3010, 0x002F, [TagLink(SegmentAnnotationTypeCodeSequence),])
    RTDeviceDistanceReferenceLocationCodeSequence = Tag('RT Device Distance Reference Location Code Sequence', "RTDeviceDistanceReferenceLocationCodeSequence", 0x300A, 0x0659, [TagLink(AcquisitionSubtaskSequence),])
    EquipmentReferencePointCoordinatesSequence = Tag('Equipment Reference Point Coordinates Sequence', "EquipmentReferencePointCoordinatesSequence", 0x300A, 0x0677)
    EquipmentReferencePointCodeSequence = Tag('Equipment Reference Point Code Sequence', "EquipmentReferencePointCodeSequence", 0x300A, 0x0678, [TagLink(EquipmentReferencePointCoordinatesSequence),])
    RoboticPathNodeSetCodeSequence = Tag('Robotic Path Node Set Code Sequence', "RoboticPathNodeSetCodeSequence", 0x3010, 0x0091)
    MeasuredMetersetToDoseMappingSequence = Tag('Measured Meterset to Dose Mapping Sequence', "MeasuredMetersetToDoseMappingSequence", 0x300A, 0x0772, [TagLink(RadiationDoseSequence),])
    DoseMeasurementDeviceCodeSequence = Tag('Dose Measurement Device Code Sequence', "DoseMeasurementDeviceCodeSequence", 0x300A, 0x0774, [TagLink(MeasuredMetersetToDoseMappingSequence),])
    TreatmentToleranceViolationTypeCodeSequence = Tag('Treatment Tolerance Violation Type Code Sequence', "TreatmentToleranceViolationTypeCodeSequence", 0x300A, 0x0761, [TagLink(TreatmentToleranceViolationSequence),])
    TreatmentToleranceViolationCauseCodeSequence = Tag('Treatment Tolerance Violation Cause Code Sequence', "TreatmentToleranceViolationCauseCodeSequence", 0x300A, 0x0762, [TagLink(TreatmentToleranceViolationSequence),])
    ReasonForOmissionCodeSequence = Tag('Reason for Omission Code Sequence', "ReasonForOmissionCodeSequence", 0x300A, 0x0788, [TagLink(OmittedRadiationSequence),])
    AcquisitionTaskWorkitemCodeSequence = Tag('Acquisition Task Workitem Code Sequence', "AcquisitionTaskWorkitemCodeSequence", 0x3002, 0x0119, [TagLink(AcquisitionTaskSequence),])
    SubtaskWorkitemCodeSequence = Tag('Subtask Workitem Code Sequence', "SubtaskWorkitemCodeSequence", 0x3002, 0x011B, [TagLink(AcquisitionSubtaskSequence),])
    PositionAcquisitionTemplateIdentificationSequence = Tag('Position Acquisition Template Identification Sequence', "PositionAcquisitionTemplateIdentificationSequence", 0x3002, 0x011F, [TagLink(AcquisitionSubtaskSequence),])
    PositionAcquisitionTemplateCodeSequence = Tag('Position Acquisition Template Code Sequence', "PositionAcquisitionTemplateCodeSequence", 0x3002, 0x0122, [TagLink(PositionAcquisitionTemplateIdentificationSequence),])
    AnnotationPropertyCategoryCodeSequence = Tag('Annotation Property Category Code Sequence', "AnnotationPropertyCategoryCodeSequence", 0x006A, 0x0009, [TagLink(AnnotationGroupSequence),])
    AnnotationPropertyTypeCodeSequence = Tag('Annotation Property Type Code Sequence', "AnnotationPropertyTypeCodeSequence", 0x006A, 0x000A, [TagLink(AnnotationGroupSequence),])
    AnnotationPropertyTypeModifierCodeSequence = Tag('Annotation Property Type Modifier Code Sequence', "AnnotationPropertyTypeModifierCodeSequence", 0x006A, 0x000B, [TagLink(AnnotationPropertyTypeCodeSequence),])
    ReasonForRemovalCodeSequence = Tag('Reason for Removal Code Sequence', "ReasonForRemovalCodeSequence", 0x0008, 0x0406, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    MontageChannelSourceCodeSequence = Tag('Montage Channel Source Code Sequence', "MontageChannelSourceCodeSequence", 0x0040, 0xB040)
    EquivalentCodeSequence = Tag('Equivalent Code Sequence', "EquivalentCodeSequence", 0x0008, 0x0121, [TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodeValue = Tag('Code Value', "CodeValue", 0x0008, 0x0100, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeIdentificationSequence = Tag('Coding Scheme Identification Sequence', "CodingSchemeIdentificationSequence", 0x0008, 0x0110)
    CodingSchemeDesignator = Tag('Coding Scheme Designator', "CodingSchemeDesignator", 0x0008, 0x0102, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(CodingSchemeIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeVersion = Tag('Coding Scheme Version', "CodingSchemeVersion", 0x0008, 0x0103, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(CodingSchemeIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodeMeaning = Tag('Code Meaning', "CodeMeaning", 0x0008, 0x0104, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupIdentificationSequence = Tag('Context Group Identification Sequence', "ContextGroupIdentificationSequence", 0x0008, 0x0123)
    MappingResourceIdentificationSequence = Tag('Mapping Resource Identification Sequence', "MappingResourceIdentificationSequence", 0x0008, 0x0124)
    ContentTemplateSequence = Tag('Content Template Sequence', "ContentTemplateSequence", 0x0040, 0xA504, [TagLink(ContentSequence),TagLink(InventoriedInstancesSequence),])
    MappingResource = Tag('Mapping Resource', "MappingResource", 0x0008, 0x0105, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(ContentTemplateSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupVersion = Tag('Context Group Version', "ContextGroupVersion", 0x0008, 0x0106, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    ContextGroupLocalVersion = Tag('Context Group Local Version', "ContextGroupLocalVersion", 0x0008, 0x0107, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeResourcesSequence = Tag('Coding Scheme Resources Sequence', "CodingSchemeResourcesSequence", 0x0008, 0x0109, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeURLType = Tag('Coding Scheme URL Type', "CodingSchemeURLType", 0x0008, 0x010A, [TagLink(CodingSchemeResourcesSequence),])
    ContextGroupExtensionFlag = Tag('Context Group Extension Flag', "ContextGroupExtensionFlag", 0x0008, 0x010B, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeUID = Tag('Coding Scheme UID', "CodingSchemeUID", 0x0008, 0x010C, [TagLink(CodingSchemeIdentificationSequence),])
    ContextGroupExtensionCreatorUID = Tag('Context Group Extension Creator UID', "ContextGroupExtensionCreatorUID", 0x0008, 0x010D, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeURL = Tag('Coding Scheme URL', "CodingSchemeURL", 0x0008, 0x010E, [TagLink(CodingSchemeResourcesSequence),])
    ContextIdentifier = Tag('Context Identifier', "ContextIdentifier", 0x0008, 0x010F, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    CodingSchemeRegistry = Tag('Coding Scheme Registry', "CodingSchemeRegistry", 0x0008, 0x0112, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeExternalID = Tag('Coding Scheme External ID', "CodingSchemeExternalID", 0x0008, 0x0114, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeName = Tag('Coding Scheme Name', "CodingSchemeName", 0x0008, 0x0115, [TagLink(CodingSchemeIdentificationSequence),])
    CodingSchemeResponsibleOrganization = Tag('Coding Scheme Responsible Organization', "CodingSchemeResponsibleOrganization", 0x0008, 0x0116, [TagLink(CodingSchemeIdentificationSequence),])
    ContextUID = Tag('Context UID', "ContextUID", 0x0008, 0x0117, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(ContextGroupIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    MappingResourceUID = Tag('Mapping Resource UID', "MappingResourceUID", 0x0008, 0x0118, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(ContentTemplateSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    LongCodeValue = Tag('Long Code Value', "LongCodeValue", 0x0008, 0x0119, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    URNCodeValue = Tag('URN Code Value', "URNCodeValue", 0x0008, 0x0120, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    MappingResourceName = Tag('Mapping Resource Name', "MappingResourceName", 0x0008, 0x0122, [TagLink(EquivalentCodeSequence),TagLink(PersonIdentificationCodeSequence),TagLink(InstitutionCodeSequence),TagLink(InstitutionalDepartmentTypeCodeSequence),TagLink(ConceptNameCodeSequence),TagLink(ConceptCodeSequence),TagLink(MeasurementUnitsCodeSequence),TagLink(AnatomicRegionSequence),TagLink(AnatomicRegionModifierSequence),TagLink(PrimaryAnatomicStructureSequence),TagLink(PrimaryAnatomicStructureModifierSequence),TagLink(RequestedProcedureCodeSequence),TagLink(ReasonForRequestedProcedureCodeSequence),TagLink(ScheduledProtocolCodeSequence),TagLink(LanguageCodeSequence),TagLink(PerformedProtocolCodeSequence),TagLink(PatientOrientationCodeSequence),TagLink(PatientOrientationModifierCodeSequence),TagLink(PatientGantryRelationshipCodeSequence),TagLink(PatientEquipmentRelationshipCodeSequence),TagLink(AssigningJurisdictionCodeSequence),TagLink(AssigningAgencyOrDepartmentCodeSequence),TagLink(AlgorithmFamilyCodeSequence),TagLink(AlgorithmNameCodeSequence),TagLink(ViewCodeSequence),TagLink(ViewModifierCodeSequence),TagLink(DeviceMotionParameterCodeSequence),TagLink(SelectorCodeSequenceValue),TagLink(ReferenceBasisCodeSequence),TagLink(ReferenceGeometryCodeSequence),TagLink(AssertionCodeSequence),TagLink(DeviceTypeCodeSequence),TagLink(PurposeOfReferenceCodeSequence),TagLink(PatientLocationCoordinatesCodeSequence),TagLink(EthnicGroupCodeSequence),TagLink(PatientSpeciesCodeSequence),TagLink(PatientBreedCodeSequence),TagLink(BreedRegistryCodeSequence),TagLink(StrainCodeSequence),TagLink(StrainSourceRegistryCodeSequence),TagLink(GeneticModificationsCodeSequence),TagLink(DeidentificationMethodCodeSequence),TagLink(RequestingServiceCodeSequence),TagLink(ProcedureCodeSequence),TagLink(ReasonForPerformedProcedureCodeSequence),TagLink(AdmittingDiagnosesCodeSequence),TagLink(PrincipalDiagnosisCodeSequence),TagLink(PrimaryDiagnosisCodeSequence),TagLink(SecondaryDiagnosesCodeSequence),TagLink(HistologicalDiagnosesCodeSequence),TagLink(PatientSizeCodeSequence),TagLink(ReasonForVisitCodeSequence),TagLink(ClinicalTrialTimePointTypeCodeSequence),TagLink(SeriesDescriptionCodeSequence),TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusAdministrationRouteSequence),TagLink(AdditionalDrugSequence),TagLink(ContrastBolusIngredientCodeSequence),TagLink(ChannelSourceSequence),TagLink(DeviceSequence),TagLink(InterventionSequence),TagLink(InterventionDrugCodeSequence),TagLink(AdministrationRouteCodeSequence),TagLink(DerivationCodeSequence),TagLink(PatientPhysiologicalStateCodeSequence),TagLink(ContainerTypeCodeSequence),TagLink(ContainerComponentTypeCodeSequence),TagLink(SpecimenTypeCodeSequence),TagLink(CTDIPhantomTypeCodeSequence),TagLink(WaterEquivalentDiameterCalculationMethodCodeSequence),TagLink(RadionuclideCodeSequence),TagLink(RadiopharmaceuticalCodeSequence),TagLink(PixelValueMappingCodeSequence),TagLink(StageCodeSequence),TagLink(DocumentClassCodeSequence),TagLink(TreatmentSiteCodeSequence),TagLink(TreatmentSiteModifierCodeSequence),TagLink(RTProtocolCodeSequence),TagLink(ROIObservationContextCodeSequence),TagLink(SegmentedPropertyCategoryCodeSequence),TagLink(RTROIIdentificationCodeSequence),TagLink(SegmentedPropertyTypeModifierCodeSequence),TagLink(TherapeuticRoleCategoryCodeSequence),TagLink(TherapeuticRoleTypeCodeSequence),TagLink(RTTreatmentTechniqueCodeSequence),TagLink(RTTreatmentTerminationReasonCodeSequence),TagLink(MachineSpecificTreatmentTerminationCodeSequence),TagLink(ProjectionEponymousNameCodeSequence),TagLink(PartialViewCodeSequence),TagLink(ChannelDescriptionCodeSequence),TagLink(IlluminatorTypeCodeSequence),TagLink(IlluminationColorCodeSequence),TagLink(IlluminationTypeCodeSequence),TagLink(LightPathFilterTypeStackCodeSequence),TagLink(ImagePathFilterTypeStackCodeSequence),TagLink(LensesCodeSequence),TagLink(MetaboliteMapCodeSequence),TagLink(MaterialCodeSequence),TagLink(AcquisitionDeviceTypeCodeSequence),TagLink(PatientEyeMovementCommandCodeSequence),TagLink(RelativeImagePositionCodeSequence),TagLink(MydriaticAgentCodeSequence),TagLink(MydriaticAgentConcentrationUnitsSequence),TagLink(ScanPatternTypeCodeSequence),TagLink(TransformationMethodCodeSequence),TagLink(OphthalmicImageTypeCodeSequence),TagLink(SegmentedPropertyTypeCodeSequence),TagLink(EventCodeSequence),TagLink(TransducerScanPatternCodeSequence),TagLink(TransducerGeometryCodeSequence),TagLink(TransducerBeamSteeringCodeSequence),TagLink(TransducerApplicationCodeSequence),TagLink(VisualAcuityTypeCodeSequence),TagLink(OphthalmicUltrasoundMethodCodeSequence),TagLink(AnteriorChamberDepthDefinitionCodeSequence),TagLink(LensStatusCodeSequence),TagLink(VitreousStatusCodeSequence),TagLink(OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence),TagLink(OphthalmicAxialLengthDataSourceCodeSequence),TagLink(OphthalmicAxialLengthSelectionMethodCodeSequence),TagLink(RefractiveSurgeryTypeCodeSequence),TagLink(RefractiveErrorBeforeRefractiveSurgeryCodeSequence),TagLink(SourceOfCornealSizeDataCodeSequence),TagLink(SourceOfLensThicknessDataCodeSequence),TagLink(SourceOfAnteriorChamberDepthDataCodeSequence),TagLink(SourceOfRefractiveMeasurementsCodeSequence),TagLink(SourceOfCorneaMeasurementDataCodeSequence),TagLink(IOLFormulaCodeSequence),TagLink(KeratometryMeasurementTypeCodeSequence),TagLink(SourceOfOphthalmicAxialLengthCodeSequence),TagLink(CorneaMeasurementMethodCodeSequence),TagLink(ScreeningTestModeCodeSequence),TagLink(StimulusColorCodeSequence),TagLink(BackgroundIlluminationColorCodeSequence),TagLink(FixationMonitoringCodeSequence),TagLink(ModeOfPercutaneousAccessSequence),TagLink(AcquisitionMethodCodeSequence),TagLink(OphthalmicThicknessMapTypeCodeSequence),TagLink(RetinalThicknessDefinitionCodeSequence),TagLink(SurfaceScanAcquisitionTypeCodeSequence),TagLink(SurfaceScanModeCodeSequence),TagLink(RegistrationMethodCodeSequence),TagLink(CornealTopographyMapTypeCodeSequence),TagLink(TrackSetAnatomicalTypeCodeSequence),TagLink(ModifierCodeSequence),TagLink(DiffusionAcquisitionCodeSequence),TagLink(DiffusionModelCodeSequence),TagLink(AcousticCouplingMediumCodeSequence),TagLink(TransducerTechnologySequence),TagLink(SoundSpeedCorrectionMechanismCodeSequence),TagLink(ImageDataTypeCodeSequence),TagLink(ChannelSourceModifiersSequence),TagLink(ChannelSensitivityUnitsSequence),TagLink(AnalogFilterTypeCodeSequence),TagLink(DigitalFilterTypeCodeSequence),TagLink(FrequencyEncodingCodeSequence),TagLink(MagnitudeEncodingCodeSequence),TagLink(MappingResourceIdentificationSequence),TagLink(DigitalSignaturePurposeCodeSequence),TagLink(VerifyingObserverIdentificationCodeSequence),TagLink(ResponsibleGroupCodeSequence),TagLink(PerformedProcedureCodeSequence),TagLink(OrganizationalRoleCodeSequence),TagLink(NumericValueQualifierCodeSequence),TagLink(RegistrationTypeCodeSequence),TagLink(FiducialsPropertyCategoryCodeSequence),TagLink(FiducialIdentifierCodeSequence),TagLink(AbstractPriorCodeSequence),TagLink(HangingProtocolUserIdentificationCodeSequence),TagLink(ImplantRegulatoryDisapprovalCodeSequence),TagLink(MaterialsCodeSequence),TagLink(CoatingMaterialsCodeSequence),TagLink(ImplantTypeCodeSequence),TagLink(FixationMethodCodeSequence),TagLink(ViewOrientationCodeSequence),TagLink(ViewOrientationModifierCodeSequence),TagLink(PlanningLandmarkIdentificationCodeSequence),TagLink(ProcedureTypeCodeSequence),TagLink(ComponentTypeCodeSequence),TagLink(AssessmentTypeCodeSequence),TagLink(ObservationBasisCodeSequence),TagLink(PotentialScheduledProtocolCodeSequence),TagLink(PotentialRequestedProcedureCodeSequence),TagLink(PotentialReasonsForProcedureCodeSequence),TagLink(ContraindicationsCodeSequence),TagLink(PositioningMethodCodeSequence),TagLink(RequestedSeriesDescriptionCodeSequence),TagLink(ModelUsageCodeSequence),TagLink(DosimetricObjectiveTypeCodeSequence),TagLink(EffectiveDoseCalculationMethodCategoryCodeSequence),TagLink(EffectiveDoseCalculationMethodCodeSequence),TagLink(TreatmentMachineSpecialModeCodeSequence),TagLink(DeliveryRateUnitSequence),TagLink(RadiationGenerationModeMachineCodeSequence),TagLink(RadiationTypeCodeSequence),TagLink(EnergyUnitCodeSequence),TagLink(RadiationFluenceModifierCodeSequence),TagLink(CompensatorShapeFabricationCodeSequence),TagLink(InterlockCodeSequence),TagLink(InterlockResolutionCodeSequence),TagLink(ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence),TagLink(DisplacementReferenceLocationCodeSequence),TagLink(PatientTreatmentPreparationMethodCodeSequence),TagLink(PatientTreatmentPreparationProcedureCodeSequence),TagLink(EnergyDerivationCodeSequence),TagLink(RadiationDosimeterUnitSequence),TagLink(RTDiagnosisCodeSequence),TagLink(ConceptualVolumeCategoryCodeSequence),TagLink(ConceptualVolumeTypeCodeSequence),TagLink(ConceptualVolumeTypeModifierCodeSequence),TagLink(DeliveryTimeStructureCodeSequence),TagLink(SegmentAnnotationCategoryCodeSequence),TagLink(SegmentAnnotationTypeCodeSequence),TagLink(SegmentAnnotationTypeModifierCodeSequence),TagLink(RTDeviceDistanceReferenceLocationCodeSequence),TagLink(EquipmentReferencePointCodeSequence),TagLink(RoboticPathNodeSetCodeSequence),TagLink(DoseMeasurementDeviceCodeSequence),TagLink(TreatmentToleranceViolationTypeCodeSequence),TagLink(TreatmentToleranceViolationCauseCodeSequence),TagLink(ReasonForOmissionCodeSequence),TagLink(AcquisitionTaskWorkitemCodeSequence),TagLink(SubtaskWorkitemCodeSequence),TagLink(PositionAcquisitionTemplateCodeSequence),TagLink(AnnotationPropertyCategoryCodeSequence),TagLink(AnnotationPropertyTypeCodeSequence),TagLink(AnnotationPropertyTypeModifierCodeSequence),TagLink(ReasonForRemovalCodeSequence),TagLink(AnatomicRegionsInStudyCodeSequence),TagLink(MontageChannelSourceCodeSequence),])
    TimezoneOffsetFromUTC = Tag('Timezone Offset From UTC', "TimezoneOffsetFromUTC", 0x0008, 0x0201, [TagLink(InventoriedInstancesSequence),TagLink(ScopeOfInventorySequence),])
    PrivateDataElementCharacteristicsSequence = Tag('Private Data Element Characteristics Sequence', "PrivateDataElementCharacteristicsSequence", 0x0008, 0x0300)
    PrivateGroupReference = Tag('Private Group Reference', "PrivateGroupReference", 0x0008, 0x0301, [TagLink(PrivateDataElementCharacteristicsSequence),])
    PrivateCreatorReference = Tag('Private Creator Reference', "PrivateCreatorReference", 0x0008, 0x0302, [TagLink(PrivateDataElementCharacteristicsSequence),])
    BlockIdentifyingInformationStatus = Tag('Block Identifying Information Status', "BlockIdentifyingInformationStatus", 0x0008, 0x0303, [TagLink(PrivateDataElementCharacteristicsSequence),])
    NonidentifyingPrivateElements = Tag('Nonidentifying Private Elements', "NonidentifyingPrivateElements", 0x0008, 0x0304, [TagLink(PrivateDataElementCharacteristicsSequence),])
    DeidentificationActionSequence = Tag('Deidentification Action Sequence', "DeidentificationActionSequence", 0x0008, 0x0305, [TagLink(PrivateDataElementCharacteristicsSequence),])
    IdentifyingPrivateElements = Tag('Identifying Private Elements', "IdentifyingPrivateElements", 0x0008, 0x0306, [TagLink(DeidentificationActionSequence),])
    DeidentificationAction = Tag('Deidentification Action', "DeidentificationAction", 0x0008, 0x0307, [TagLink(DeidentificationActionSequence),])
    PrivateDataElementDefinitionSequence = Tag('Private Data Element Definition Sequence', "PrivateDataElementDefinitionSequence", 0x0008, 0x0310, [TagLink(PrivateDataElementCharacteristicsSequence),])
    PrivateDataElement = Tag('Private Data Element', "PrivateDataElement", 0x0008, 0x0308, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementValueMultiplicity = Tag('Private Data Element Value Multiplicity', "PrivateDataElementValueMultiplicity", 0x0008, 0x0309, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementValueRepresentation = Tag('Private Data Element Value Representation', "PrivateDataElementValueRepresentation", 0x0008, 0x030A, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementNumberOfItems = Tag('Private Data Element Number of Items', "PrivateDataElementNumberOfItems", 0x0008, 0x030B, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementName = Tag('Private Data Element Name', "PrivateDataElementName", 0x0008, 0x030C, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementKeyword = Tag('Private Data Element Keyword', "PrivateDataElementKeyword", 0x0008, 0x030D, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementDescription = Tag('Private Data Element Description', "PrivateDataElementDescription", 0x0008, 0x030E, [TagLink(PrivateDataElementDefinitionSequence),])
    PrivateDataElementEncoding = Tag('Private Data Element Encoding', "PrivateDataElementEncoding", 0x0008, 0x030F, [TagLink(PrivateDataElementDefinitionSequence),])
    IncorporatedInventoryInstanceSequence = Tag('Incorporated Inventory Instance Sequence', "IncorporatedInventoryInstanceSequence", 0x0008, 0x0422)
    StationName = Tag('Station Name', "StationName", 0x0008, 0x1010, [TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    StudyDescription = Tag('Study Description', "StudyDescription", 0x0008, 0x1030, [TagLink(InventoriedStudiesSequence),])
    SeriesDescription = Tag('Series Description', "SeriesDescription", 0x0008, 0x103E, [TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    InstitutionalDepartmentName = Tag('Institutional Department Name', "InstitutionalDepartmentName", 0x0008, 0x1040, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(InterlockResolutionUserSequence),TagLink(AuthorIdentificationSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    PhysiciansOfRecord = Tag('Physician(s) of Record', "PhysiciansOfRecord", 0x0008, 0x1048, [TagLink(InventoriedStudiesSequence),])
    PerformingPhysicianName = Tag("Performing Physician's Name", "PerformingPhysicianName", 0x0008, 0x1050)
    NameOfPhysiciansReadingStudy = Tag('Name of Physician(s) Reading Study', "NameOfPhysiciansReadingStudy", 0x0008, 0x1060, [TagLink(InventoriedStudiesSequence),])
    OperatorsName = Tag("Operators' Name", "OperatorsName", 0x0008, 0x1070, [TagLink(OverrideSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),])
    AdmittingDiagnosesDescription = Tag('Admitting Diagnoses Description', "AdmittingDiagnosesDescription", 0x0008, 0x1080)
    ManufacturerModelName = Tag("Manufacturer's Model Name", "ManufacturerModelName", 0x0008, 0x1090, [TagLink(DeviceSequence),TagLink(ContainerComponentSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ReferencedPerformedProcedureStepSequence = Tag('Referenced Performed Procedure Step Sequence', "ReferencedPerformedProcedureStepSequence", 0x0008, 0x1111)
    ReferencedPatientSequence = Tag('Referenced Patient Sequence', "ReferencedPatientSequence", 0x0008, 0x1120)
    ReferencedStereometricInstanceSequence = Tag('Referenced Stereometric Instance Sequence', "ReferencedStereometricInstanceSequence", 0x0008, 0x1134, [TagLink(StructuredDisplayImageBoxSequence),])
    WaveformTextualAnnotationSequence = Tag('Waveform Textual Annotation Sequence', "WaveformTextualAnnotationSequence", 0x0040, 0xB033)
    DisplayedWaveformSegmentSequence = Tag('Displayed Waveform Segment Sequence', "DisplayedWaveformSegmentSequence", 0x0040, 0xB035)
    ReferencedWaveformSequence = Tag('Referenced Waveform Sequence', "ReferencedWaveformSequence", 0x0008, 0x113A, [TagLink(ReferencedSeriesSequence),TagLink(WaveformTextualAnnotationSequence),TagLink(DisplayedWaveformSegmentSequence),])
    ReferencedRealWorldValueMappingInstanceSequence = Tag('Referenced Real World Value Mapping Instance Sequence', "ReferencedRealWorldValueMappingInstanceSequence", 0x0008, 0x114B, [TagLink(ReferencedSOPSequence),])
    IonRangeCompensatorSequence = Tag('Ion Range Compensator Sequence', "IonRangeCompensatorSequence", 0x300A, 0x02EA, [TagLink(IonBeamSequence),])
    ReferencedSurfaceSegmentationSequence = Tag('Referenced Surface Segmentation Sequence', "ReferencedSurfaceSegmentationSequence", 0x0008, 0x114D, [TagLink(IonRangeCompensatorSequence),])
    PertinentDocumentsSequence = Tag('Pertinent Documents Sequence', "PertinentDocumentsSequence", 0x0038, 0x0100, [TagLink(ApprovalSequence),TagLink(ConfirmationSequence),])
    ConceptualVolumeConstituentSequence = Tag('Conceptual Volume Constituent Sequence', "ConceptualVolumeConstituentSequence", 0x3010, 0x0008, [TagLink(ConceptualVolumeSequence),TagLink(CombinationSegmentReferenceSequence),])
    OriginatingSOPInstanceReferenceSequence = Tag('Originating SOP Instance Reference Sequence', "OriginatingSOPInstanceReferenceSequence", 0x3010, 0x0007, [TagLink(ConceptualVolumeConstituentSequence),TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DosimetricObjectiveSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    EquivalentConceptualVolumesSequence = Tag('Equivalent Conceptual Volumes Sequence', "EquivalentConceptualVolumesSequence", 0x3010, 0x000A, [TagLink(ConceptualVolumeIdentificationSequence),TagLink(ConceptualVolumeSequence),TagLink(DirectSegmentReferenceSequence),TagLink(CombinationSegmentReferenceSequence),])
    EquivalentConceptualVolumeInstanceReferenceSequence = Tag('Equivalent Conceptual Volume Instance Reference Sequence', "EquivalentConceptualVolumeInstanceReferenceSequence", 0x3010, 0x0009, [TagLink(EquivalentConceptualVolumesSequence),])
    SourceConceptualVolumeSequence = Tag('Source Conceptual Volume Sequence', "SourceConceptualVolumeSequence", 0x3010, 0x0018, [TagLink(DerivationConceptualVolumeSequence),])
    ConceptualVolumeConstituentSegmentationReferenceSequence = Tag('Conceptual Volume Constituent Segmentation Reference Sequence', "ConceptualVolumeConstituentSegmentationReferenceSequence", 0x3010, 0x0012, [TagLink(SourceConceptualVolumeSequence),TagLink(ConceptualVolumeConstituentSequence),])
    ConceptualVolumeSegmentationReferenceSequence = Tag('Conceptual Volume Segmentation Reference Sequence', "ConceptualVolumeSegmentationReferenceSequence", 0x3010, 0x0011, [TagLink(ConceptualVolumeSequence),TagLink(CombinationSegmentReferenceSequence),])
    ReferencedDirectSegmentInstanceSequence = Tag('Referenced Direct Segment Instance Sequence', "ReferencedDirectSegmentInstanceSequence", 0x3010, 0x004A, [TagLink(ConceptualVolumeConstituentSegmentationReferenceSequence),TagLink(ConceptualVolumeSegmentationReferenceSequence),])
    ReferencedDefinedProtocolSequence = Tag('Referenced Defined Protocol Sequence', "ReferencedDefinedProtocolSequence", 0x0018, 0x990C, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ReferencedPerformedProtocolSequence = Tag('Referenced Performed Protocol Sequence', "ReferencedPerformedProtocolSequence", 0x0018, 0x990D, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    ConversionSourceAttributesSequence = Tag('Conversion Source Attributes Sequence', "ConversionSourceAttributesSequence", 0x0020, 0x9172, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReferencedSpatialRegistrationSequence = Tag('Referenced Spatial Registration Sequence', "ReferencedSpatialRegistrationSequence", 0x0070, 0x0404, [TagLink(VolumetricPresentationInputSetSequence),TagLink(AdvancedBlendingSequence),])
    ReferencedStructureSetSequence = Tag('Referenced Structure Set Sequence', "ReferencedStructureSetSequence", 0x300C, 0x0060, [TagLink(PlanOverviewSequence),])
    ReferencedFrameOfReferenceSequence = Tag('Referenced Frame of Reference Sequence', "ReferencedFrameOfReferenceSequence", 0x3006, 0x0010)
    RTReferencedStudySequence = Tag('RT Referenced Study Sequence', "RTReferencedStudySequence", 0x3006, 0x0012, [TagLink(ReferencedFrameOfReferenceSequence),])
    RTReferencedSeriesSequence = Tag('RT Referenced Series Sequence', "RTReferencedSeriesSequence", 0x3006, 0x0014, [TagLink(RTReferencedStudySequence),])
    ROIContourSequence = Tag('ROI Contour Sequence', "ROIContourSequence", 0x3006, 0x0039)
    ContourSequence = Tag('Contour Sequence', "ContourSequence", 0x3006, 0x0040, [TagLink(ROIContourSequence),])
    ContourImageSequence = Tag('Contour Image Sequence', "ContourImageSequence", 0x3006, 0x0016, [TagLink(RTReferencedSeriesSequence),TagLink(ContourSequence),])
    DefinitionSourceSequence = Tag('Definition Source Sequence', "DefinitionSourceSequence", 0x0008, 0x1156, [TagLink(StructureSetROISequence),TagLink(FractionGroupSequence),TagLink(BeamSequence),TagLink(TreatmentSessionBeamSequence),TagLink(SegmentSequence),TagLink(FiducialSequence),])
    PredecessorStructureSetSequence = Tag('Predecessor Structure Set Sequence', "PredecessorStructureSetSequence", 0x3006, 0x0018)
    ControlPointSequence = Tag('Control Point Sequence', "ControlPointSequence", 0x300A, 0x0111, [TagLink(BeamSequence),])
    ReferencedDoseSequence = Tag('Referenced Dose Sequence', "ReferencedDoseSequence", 0x300C, 0x0080, [TagLink(FractionGroupSequence),TagLink(BeamSequence),TagLink(ControlPointSequence),TagLink(IonBeamSequence),])
    ReferencedSetupImageSequence = Tag('Referenced Setup Image Sequence', "ReferencedSetupImageSequence", 0x300A, 0x0401, [TagLink(PatientSetupSequence),])
    ApplicationSetupSequence = Tag('Application Setup Sequence', "ApplicationSetupSequence", 0x300A, 0x0230)
    ReferencedReferenceImageSequence = Tag('Referenced Reference Image Sequence', "ReferencedReferenceImageSequence", 0x300C, 0x0042, [TagLink(BeamSequence),TagLink(ApplicationSetupSequence),TagLink(IonBeamSequence),])
    ReferencedVerificationImageSequence = Tag('Referenced Verification Image Sequence', "ReferencedVerificationImageSequence", 0x300C, 0x0040, [TagLink(TreatmentSessionBeamSequence),TagLink(TreatmentSessionApplicationSetupSequence),TagLink(TreatmentSessionIonBeamSequence),])
    DeliveryVerificationImageSequence = Tag('Delivery Verification Image Sequence', "DeliveryVerificationImageSequence", 0x0074, 0x1030, [TagLink(BeamTaskSequence),])
    RelatedReferenceRTImageSequence = Tag('Related Reference RT Image Sequence', "RelatedReferenceRTImageSequence", 0x0074, 0x1040, [TagLink(DeliveryVerificationImageSequence),])
    StereoPairsSequence = Tag('Stereo Pairs Sequence', "StereoPairsSequence", 0x0022, 0x0020)
    LeftImageSequence = Tag('Left Image Sequence', "LeftImageSequence", 0x0022, 0x0021, [TagLink(StereoPairsSequence),])
    RightImageSequence = Tag('Right Image Sequence', "RightImageSequence", 0x0022, 0x0022, [TagLink(StereoPairsSequence),])
    ReferencedOtherPlaneSequence = Tag('Referenced Other Plane Sequence', "ReferencedOtherPlaneSequence", 0x0008, 0x9410)
    SegmentSurfaceSourceInstanceSequence = Tag('Segment Surface Source Instance Sequence', "SegmentSurfaceSourceInstanceSequence", 0x0066, 0x002E, [TagLink(ReferencedSurfaceSequence),])
    ReferencedRefractiveMeasurementsSequence = Tag('Referenced Refractive Measurements Sequence', "ReferencedRefractiveMeasurementsSequence", 0x0046, 0x0145)
    ReferencedSurfaceDataSequence = Tag('Referenced Surface Data Sequence', "ReferencedSurfaceDataSequence", 0x0080, 0x0013)
    SourceWaveformSequence = Tag('Source Waveform Sequence', "SourceWaveformSequence", 0x003A, 0x020A, [TagLink(ChannelDefinitionSequence),TagLink(ContributingChannelSourcesSequence),])
    ReferencedFirstFrameSequence = Tag('Referenced First Frame Sequence', "ReferencedFirstFrameSequence", 0x0072, 0x0427, [TagLink(StructuredDisplayImageBoxSequence),])
    ReferencedPresentationStateSequence = Tag('Referenced Presentation State Sequence', "ReferencedPresentationStateSequence", 0x0008, 0x9237, [TagLink(ReferencedImageSequence),TagLink(StructuredDisplayImageBoxSequence),])
    RenderedImageReferenceSequence = Tag('Rendered Image Reference Sequence', "RenderedImageReferenceSequence", 0x0070, 0x1104)
    VolumetricAnnotationSequence = Tag('Volumetric Annotation Sequence', "VolumetricAnnotationSequence", 0x0070, 0x1901)
    VolumetricPresentationInputAnnotationSequence = Tag('Volumetric Presentation Input Annotation Sequence', "VolumetricPresentationInputAnnotationSequence", 0x0070, 0x1905)
    ReferencedStructuredContextSequence = Tag('Referenced Structured Context Sequence', "ReferencedStructuredContextSequence", 0x0070, 0x1903, [TagLink(VolumetricAnnotationSequence),TagLink(VolumetricPresentationInputAnnotationSequence),])
    HL7StructuredDocumentReferenceSequence = Tag('HL7 Structured Document Reference Sequence', "HL7StructuredDocumentReferenceSequence", 0x0040, 0xA390)
    UsedFiducialsSequence = Tag('Used Fiducials Sequence', "UsedFiducialsSequence", 0x0070, 0x0314, [TagLink(RegistrationSequence),TagLink(DeformableRegistrationSequence),])
    UsedSegmentsSequence = Tag('Used Segments Sequence', "UsedSegmentsSequence", 0x0062, 0x0012, [TagLink(RegistrationSequence),])
    UsedRTStructureSetROISequence = Tag('Used RT Structure Set ROI Sequence', "UsedRTStructureSetROISequence", 0x0070, 0x0315, [TagLink(RegistrationSequence),])
    SourceHangingProtocolSequence = Tag('Source Hanging Protocol Sequence', "SourceHangingProtocolSequence", 0x0072, 0x0012)
    DisplaySetsSequence = Tag('Display Sets Sequence', "DisplaySetsSequence", 0x0072, 0x0200)
    PseudoColorPaletteInstanceReferenceSequence = Tag('Pseudo-Color Palette Instance Reference Sequence', "PseudoColorPaletteInstanceReferenceSequence", 0x0072, 0x0705, [TagLink(DisplaySetsSequence),])
    UVMappingSequence = Tag('UV Mapping Sequence', "UVMappingSequence", 0x0080, 0x0008)
    ReferencedTextureSequence = Tag('Referenced Texture Sequence', "ReferencedTextureSequence", 0x0080, 0x0012, [TagLink(UVMappingSequence),])
    ReplacedImplantTemplateSequence = Tag('Replaced Implant Template Sequence', "ReplacedImplantTemplateSequence", 0x0068, 0x6222)
    OriginalImplantTemplateSequence = Tag('Original Implant Template Sequence', "OriginalImplantTemplateSequence", 0x0068, 0x6225)
    DerivationImplantTemplateSequence = Tag('Derivation Implant Template Sequence', "DerivationImplantTemplateSequence", 0x0068, 0x6224)
    ReplacedImplantAssemblyTemplateSequence = Tag('Replaced Implant Assembly Template Sequence', "ReplacedImplantAssemblyTemplateSequence", 0x0076, 0x0008)
    OriginalImplantAssemblyTemplateSequence = Tag('Original Implant Assembly Template Sequence', "OriginalImplantAssemblyTemplateSequence", 0x0076, 0x000C)
    DerivationImplantAssemblyTemplateSequence = Tag('Derivation Implant Assembly Template Sequence', "DerivationImplantAssemblyTemplateSequence", 0x0076, 0x000E)
    ComponentSequence = Tag('Component Sequence', "ComponentSequence", 0x0076, 0x0040, [TagLink(ComponentTypesSequence),])
    ReplacedImplantTemplateGroupSequence = Tag('Replaced Implant Template Group Sequence', "ReplacedImplantTemplateGroupSequence", 0x0078, 0x0026)
    ImplantTemplateGroupMembersSequence = Tag('Implant Template Group Members Sequence', "ImplantTemplateGroupMembersSequence", 0x0078, 0x002A)
    AssessedSOPInstanceSequence = Tag('Assessed SOP Instance Sequence', "AssessedSOPInstanceSequence", 0x0082, 0x0004)
    ReferencedComparisonSOPInstanceSequence = Tag('Referenced Comparison SOP Instance Sequence', "ReferencedComparisonSOPInstanceSequence", 0x0082, 0x0005, [TagLink(AssessedSOPInstanceSequence),])
    PredecessorProtocolSequence = Tag('Predecessor Protocol Sequence', "PredecessorProtocolSequence", 0x0018, 0x990E)
    StorageProtocolElementSequence = Tag('Storage Protocol Element Sequence', "StorageProtocolElementSequence", 0x0018, 0x9936)
    OutputInformationSequence = Tag('Output Information Sequence', "OutputInformationSequence", 0x0040, 0x4033, [TagLink(StorageProtocolElementSequence),])
    ApprovalSubjectSequence = Tag('Approval Subject Sequence', "ApprovalSubjectSequence", 0x0044, 0x0109)
    ReferencedRTRadiationSetSequence = Tag('Referenced RT Radiation Set Sequence', "ReferencedRTRadiationSetSequence", 0x300A, 0x0702, [TagLink(RTImageScopeSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    TreatmentPositionGroupSequence = Tag('Treatment Position Group Sequence', "TreatmentPositionGroupSequence", 0x300A, 0x060A, [TagLink(ReferencedRTRadiationSetSequence),])
    ReferencedRTRadiationSequence = Tag('Referenced RT Radiation Sequence', "ReferencedRTRadiationSequence", 0x300A, 0x0630, [TagLink(ReferencedRTRadiationSetSequence),TagLink(RTImageScopeSequence),TagLink(TreatmentPositionGroupSequence),TagLink(RadiationDoseSequence),TagLink(RTRadiationTaskSequence),TagLink(OmittedRadiationSequence),TagLink(RTPatientPositionScopeSequence),TagLink(AcquisitionTaskApplicabilitySequence),])
    ReferencedPatientSetupPhotoSequence = Tag('Referenced Patient Setup Photo Sequence', "ReferencedPatientSetupPhotoSequence", 0x300A, 0x078C, [TagLink(PatientTreatmentPreparationSequence),])
    InstanceLevelReferencedPerformedProcedureStepSequence = Tag('Instance-Level Referenced Performed Procedure Step Sequence', "InstanceLevelReferencedPerformedProcedureStepSequence", 0x3010, 0x0044)
    RTPhysicianIntentPredecessorSequence = Tag('RT Physician Intent Predecessor Sequence', "RTPhysicianIntentPredecessorSequence", 0x3010, 0x0055, [TagLink(RTPhysicianIntentSequence),])
    PriorTreatmentReferenceSequence = Tag('Prior Treatment Reference Sequence', "PriorTreatmentReferenceSequence", 0x3010, 0x0062, [TagLink(RTPrescriptionSequence),])
    ReferencedRTPhysicianIntentSequence = Tag('Referenced RT Physician Intent Sequence', "ReferencedRTPhysicianIntentSequence", 0x300A, 0x063B)
    RTRadiationSequence = Tag('RT Radiation Sequence', "RTRadiationSequence", 0x300A, 0x0616)
    ReferencedRTRadiationRecordSequence = Tag('Referenced RT Radiation Record Sequence', "ReferencedRTRadiationRecordSequence", 0x300A, 0x0703, [TagLink(RadiationDoseSequence),])
    ReferencedRTInstanceSequence = Tag('Referenced RT Instance Sequence', "ReferencedRTInstanceSequence", 0x300A, 0x0631)
    AdditionalParameterRecordingInstanceSequence = Tag('Additional Parameter Recording Instance Sequence', "AdditionalParameterRecordingInstanceSequence", 0x300A, 0x0780)
    ReferencedRTTreatmentPreparationSequence = Tag('Referenced RT Treatment Preparation Sequence', "ReferencedRTTreatmentPreparationSequence", 0x300A, 0x078B, [TagLink(RTRadiationTaskSequence),])
    ReferencedBaselineParametersRTRadiationInstanceSequence = Tag('Referenced Baseline Parameters RT Radiation Instance Sequence', "ReferencedBaselineParametersRTRadiationInstanceSequence", 0x3002, 0x011E, [TagLink(AcquisitionSubtaskSequence),])
    StructuredWaveformAnnotationSequence = Tag('Structured Waveform Annotation Sequence', "StructuredWaveformAnnotationSequence", 0x0040, 0xB030)
    ReferencedSOPClassUID = Tag('Referenced SOP Class UID', "ReferencedSOPClassUID", 0x0008, 0x1150, [TagLink(ReferencedSOPSequence),TagLink(ReferencedInstanceSequence),TagLink(PertinentDocumentsSequence),TagLink(OriginatingSOPInstanceReferenceSequence),TagLink(EquivalentConceptualVolumeInstanceReferenceSequence),TagLink(ReferencedDirectSegmentInstanceSequence),TagLink(ReferencedImageSequence),TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReferencedPatientSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPerformedProcedureStepSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ReferencedRTPlanSequence),TagLink(ReferencedSpatialRegistrationSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(ReferencedStructureSetSequence),TagLink(RTReferencedStudySequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(PredecessorStructureSetSequence),TagLink(ReferencedDoseSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedReferenceImageSequence),TagLink(ReferencedVerificationImageSequence),TagLink(ReferencedSurfaceSegmentationSequence),TagLink(RelatedReferenceRTImageSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedRefractiveMeasurementsSequence),TagLink(ReferencedSurfaceDataSequence),TagLink(SourceWaveformSequence),TagLink(ReferencedFirstFrameSequence),TagLink(ReferencedPresentationStateSequence),TagLink(ReferencedStereometricInstanceSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedStructuredContextSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedRealWorldValueMappingInstanceSequence),TagLink(UsedFiducialsSequence),TagLink(UsedSegmentsSequence),TagLink(UsedRTStructureSetROISequence),TagLink(SourceHangingProtocolSequence),TagLink(PseudoColorPaletteInstanceReferenceSequence),TagLink(ReferencedTextureSequence),TagLink(ReplacedImplantTemplateSequence),TagLink(OriginalImplantTemplateSequence),TagLink(DerivationImplantTemplateSequence),TagLink(ReplacedImplantAssemblyTemplateSequence),TagLink(OriginalImplantAssemblyTemplateSequence),TagLink(DerivationImplantAssemblyTemplateSequence),TagLink(ComponentSequence),TagLink(ReplacedImplantTemplateGroupSequence),TagLink(ImplantTemplateGroupMembersSequence),TagLink(AssessedSOPInstanceSequence),TagLink(ReferencedComparisonSOPInstanceSequence),TagLink(PredecessorProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),TagLink(OutputInformationSequence),TagLink(ApprovalSubjectSequence),TagLink(ReferencedRTRadiationSequence),TagLink(ReferencedRTRadiationSetSequence),TagLink(ReferencedPatientSetupPhotoSequence),TagLink(InstanceLevelReferencedPerformedProcedureStepSequence),TagLink(RTPhysicianIntentPredecessorSequence),TagLink(PriorTreatmentReferenceSequence),TagLink(ReferencedRTPhysicianIntentSequence),TagLink(RTRadiationSequence),TagLink(ReferencedRTRadiationRecordSequence),TagLink(ReferencedRTInstanceSequence),TagLink(AdditionalParameterRecordingInstanceSequence),TagLink(ReferencedRTTreatmentPreparationSequence),TagLink(ReferencedBaselineParametersRTRadiationInstanceSequence),TagLink(IncorporatedInventoryInstanceSequence),TagLink(ReferencedWaveformSequence),TagLink(StructuredWaveformAnnotationSequence),])
    ReferencedSOPInstanceUID = Tag('Referenced SOP Instance UID', "ReferencedSOPInstanceUID", 0x0008, 0x1155, [TagLink(ReferencedSOPSequence),TagLink(ReferencedInstanceSequence),TagLink(PertinentDocumentsSequence),TagLink(OriginatingSOPInstanceReferenceSequence),TagLink(EquivalentConceptualVolumeInstanceReferenceSequence),TagLink(ReferencedDirectSegmentInstanceSequence),TagLink(ReferencedImageSequence),TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReferencedPatientSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPerformedProcedureStepSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ReferencedRTPlanSequence),TagLink(ReferencedSpatialRegistrationSequence),TagLink(ReferencedTreatmentRecordSequence),TagLink(ReferencedStructureSetSequence),TagLink(RTReferencedStudySequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(PredecessorStructureSetSequence),TagLink(ReferencedDoseSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedReferenceImageSequence),TagLink(ReferencedVerificationImageSequence),TagLink(ReferencedSurfaceSegmentationSequence),TagLink(RelatedReferenceRTImageSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedRefractiveMeasurementsSequence),TagLink(ReferencedSurfaceDataSequence),TagLink(SourceWaveformSequence),TagLink(ReferencedFirstFrameSequence),TagLink(ReferencedPresentationStateSequence),TagLink(ReferencedStereometricInstanceSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedStructuredContextSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(SourceInstanceSequence),TagLink(ReferencedRealWorldValueMappingInstanceSequence),TagLink(UsedFiducialsSequence),TagLink(UsedSegmentsSequence),TagLink(UsedRTStructureSetROISequence),TagLink(SourceHangingProtocolSequence),TagLink(PseudoColorPaletteInstanceReferenceSequence),TagLink(ReferencedTextureSequence),TagLink(ReplacedImplantTemplateSequence),TagLink(OriginalImplantTemplateSequence),TagLink(DerivationImplantTemplateSequence),TagLink(ReplacedImplantAssemblyTemplateSequence),TagLink(OriginalImplantAssemblyTemplateSequence),TagLink(DerivationImplantAssemblyTemplateSequence),TagLink(ComponentSequence),TagLink(ReplacedImplantTemplateGroupSequence),TagLink(ImplantTemplateGroupMembersSequence),TagLink(AssessedSOPInstanceSequence),TagLink(ReferencedComparisonSOPInstanceSequence),TagLink(PredecessorProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),TagLink(ApprovalSubjectSequence),TagLink(ReferencedRTRadiationSequence),TagLink(ReferencedRTRadiationSetSequence),TagLink(ReferencedPatientSetupPhotoSequence),TagLink(InstanceLevelReferencedPerformedProcedureStepSequence),TagLink(RTPhysicianIntentPredecessorSequence),TagLink(PriorTreatmentReferenceSequence),TagLink(ReferencedRTPhysicianIntentSequence),TagLink(RTRadiationSequence),TagLink(ReferencedRTRadiationRecordSequence),TagLink(ReferencedRTInstanceSequence),TagLink(AdditionalParameterRecordingInstanceSequence),TagLink(ReferencedRTTreatmentPreparationSequence),TagLink(ReferencedBaselineParametersRTRadiationInstanceSequence),TagLink(IncorporatedInventoryInstanceSequence),TagLink(ReferencedWaveformSequence),TagLink(StructuredWaveformAnnotationSequence),])
    ExposureSequence = Tag('Exposure Sequence', "ExposureSequence", 0x3002, 0x0030)
    TwoDimensionalToThreeDimensionalMapSequence = Tag('Two Dimensional to Three Dimensional Map Sequence', "TwoDimensionalToThreeDimensionalMapSequence", 0x0022, 0x1518)
    ReferencedFrameNumber = Tag('Referenced Frame Number', "ReferencedFrameNumber", 0x0008, 0x1160, [TagLink(ReferencedSOPSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ExposureSequence),TagLink(ContourImageSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(TwoDimensionalToThreeDimensionalMapSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedFirstFrameSequence),TagLink(RenderedImageReferenceSequence),TagLink(ReferencedTextureSequence),])
    FrameExtractionSequence = Tag('Frame Extraction Sequence', "FrameExtractionSequence", 0x0008, 0x1164)
    SimpleFrameList = Tag('Simple Frame List', "SimpleFrameList", 0x0008, 0x1161, [TagLink(FrameExtractionSequence),])
    CalculatedFrameList = Tag('Calculated Frame List', "CalculatedFrameList", 0x0008, 0x1162, [TagLink(FrameExtractionSequence),])
    TimeRange = Tag('Time Range', "TimeRange", 0x0008, 0x1163, [TagLink(FrameExtractionSequence),])
    MultiFrameSourceSOPInstanceUID = Tag('Multi-frame Source SOP Instance UID', "MultiFrameSourceSOPInstanceUID", 0x0008, 0x1167, [TagLink(FrameExtractionSequence),])
    WADORSRetrievalSequence = Tag('WADO-RS Retrieval Sequence', "WADORSRetrievalSequence", 0x0040, 0xE025, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveURL = Tag('Retrieve URL', "RetrieveURL", 0x0008, 0x1190, [TagLink(WADORSRetrievalSequence),TagLink(InventoriedStudiesSequence),])
    DerivationDescription = Tag('Derivation Description', "DerivationDescription", 0x0008, 0x2111, [TagLink(DerivationConceptualVolumeSequence),TagLink(DerivationImageSequence),TagLink(XAXRFFrameCharacteristicsSequence),])
    FrameDisplaySequence = Tag('Frame Display Sequence', "FrameDisplaySequence", 0x0008, 0x9458, [TagLink(MultiFramePresentationSequence),])
    StartTrim = Tag('Start Trim', "StartTrim", 0x0008, 0x2142, [TagLink(FrameDisplaySequence),TagLink(StructuredDisplayImageBoxSequence),])
    StopTrim = Tag('Stop Trim', "StopTrim", 0x0008, 0x2143, [TagLink(FrameDisplaySequence),TagLink(StructuredDisplayImageBoxSequence),])
    ImageBoxesSequence = Tag('Image Boxes Sequence', "ImageBoxesSequence", 0x0072, 0x0300, [TagLink(DisplaySetsSequence),])
    RecommendedDisplayFrameRate = Tag('Recommended Display Frame Rate', "RecommendedDisplayFrameRate", 0x0008, 0x2144, [TagLink(StructuredDisplayImageBoxSequence),TagLink(ImageBoxesSequence),])
    IrradiationEventIdentificationSequence = Tag('Irradiation Event Identification Sequence', "IrradiationEventIdentificationSequence", 0x0018, 0x9477, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SourceIrradiationEventSequence = Tag('Source Irradiation Event Sequence', "SourceIrradiationEventSequence", 0x0008, 0x3011)
    PerProjectionAcquisitionSequence = Tag('Per Projection Acquisition Sequence', "PerProjectionAcquisitionSequence", 0x0018, 0x9538, [TagLink(XRay3DAcquisitionSequence),])
    IrradiationEventUID = Tag('Irradiation Event UID', "IrradiationEventUID", 0x0008, 0x3010, [TagLink(IrradiationEventIdentificationSequence),TagLink(SourceIrradiationEventSequence),TagLink(PerProjectionAcquisitionSequence),])
    WholeSlideMicroscopyImageFrameTypeSequence = Tag('Whole Slide Microscopy Image Frame Type Sequence', "WholeSlideMicroscopyImageFrameTypeSequence", 0x0040, 0x0710, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MRImageFrameTypeSequence = Tag('MR Image Frame Type Sequence', "MRImageFrameTypeSequence", 0x0018, 0x9226, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MRSpectroscopyFrameTypeSequence = Tag('MR Spectroscopy Frame Type Sequence', "MRSpectroscopyFrameTypeSequence", 0x0018, 0x9227, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CTImageFrameTypeSequence = Tag('CT Image Frame Type Sequence', "CTImageFrameTypeSequence", 0x0018, 0x9329, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FramePixelDataPropertiesSequence = Tag('Frame Pixel Data Properties Sequence', "FramePixelDataPropertiesSequence", 0x0028, 0x9443, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRay3DFrameTypeSequence = Tag('X-Ray 3D Frame Type Sequence', "XRay3DFrameTypeSequence", 0x0018, 0x9504, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETFrameTypeSequence = Tag('PET Frame Type Sequence', "PETFrameTypeSequence", 0x0018, 0x9751, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    USImageDescriptionSequence = Tag('US Image Description Sequence', "USImageDescriptionSequence", 0x0018, 0x9806, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IntravascularOCTFrameTypeSequence = Tag('Intravascular OCT Frame Type Sequence', "IntravascularOCTFrameTypeSequence", 0x0052, 0x0025, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ParametricMapFrameTypeSequence = Tag('Parametric Map Frame Type Sequence', "ParametricMapFrameTypeSequence", 0x0040, 0x9092, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PhotoacousticImageFrameTypeSequence = Tag('Photoacoustic Image Frame Type Sequence', "PhotoacousticImageFrameTypeSequence", 0x0018, 0x9835, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ConfocalMicroscopyImageFrameTypeSequence = Tag('Confocal Microscopy Image Frame Type Sequence', "ConfocalMicroscopyImageFrameTypeSequence", 0x0048, 0x0116, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RTImageFrameGeneralContentSequence = Tag('RT Image Frame General Content Sequence', "RTImageFrameGeneralContentSequence", 0x3002, 0x0102, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameType = Tag('Frame Type', "FrameType", 0x0008, 0x9007, [TagLink(WholeSlideMicroscopyImageFrameTypeSequence),TagLink(MRImageFrameTypeSequence),TagLink(MRSpectroscopyFrameTypeSequence),TagLink(CTImageFrameTypeSequence),TagLink(FramePixelDataPropertiesSequence),TagLink(XRay3DFrameTypeSequence),TagLink(PETFrameTypeSequence),TagLink(USImageDescriptionSequence),TagLink(IntravascularOCTFrameTypeSequence),TagLink(ParametricMapFrameTypeSequence),TagLink(PhotoacousticImageFrameTypeSequence),TagLink(ConfocalMicroscopyImageFrameTypeSequence),TagLink(RTImageFrameGeneralContentSequence),])
    ReferencedImageEvidenceSequence = Tag('Referenced Image Evidence Sequence', "ReferencedImageEvidenceSequence", 0x0008, 0x9092)
    SourceImageEvidenceSequence = Tag('Source Image Evidence Sequence', "SourceImageEvidenceSequence", 0x0008, 0x9154)
    RecommendedDisplayFrameRateInFloat = Tag('Recommended Display Frame Rate in Float', "RecommendedDisplayFrameRateInFloat", 0x0008, 0x9459, [TagLink(FrameDisplaySequence),])
    SkipFrameRangeFlag = Tag('Skip Frame Range Flag', "SkipFrameRangeFlag", 0x0008, 0x9460, [TagLink(FrameDisplaySequence),])
    PatientName = Tag("Patient's Name", "PatientName", 0x0010, 0x0010, [TagLink(InventoriedStudiesSequence),])
    PatientID = Tag('Patient ID', "PatientID", 0x0010, 0x0020, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    IssuerOfPatientID = Tag('Issuer of Patient ID', "IssuerOfPatientID", 0x0010, 0x0021, [TagLink(OtherPatientIDsSequence),TagLink(SourcePatientGroupIdentificationSequence),TagLink(GroupOfPatientsIdentificationSequence),TagLink(InventoriedStudiesSequence),])
    TypeOfPatientID = Tag('Type of Patient ID', "TypeOfPatientID", 0x0010, 0x0022, [TagLink(OtherPatientIDsSequence),])
    SubjectRelativePositionInImage = Tag('Subject Relative Position in Image', "SubjectRelativePositionInImage", 0x0010, 0x0028, [TagLink(GroupOfPatientsIdentificationSequence),])
    PatientBirthDate = Tag("Patient's Birth Date", "PatientBirthDate", 0x0010, 0x0030, [TagLink(InventoriedStudiesSequence),])
    PatientBirthTime = Tag("Patient's Birth Time", "PatientBirthTime", 0x0010, 0x0032)
    PatientBirthDateInAlternativeCalendar = Tag("Patient's Birth Date in Alternative Calendar", "PatientBirthDateInAlternativeCalendar", 0x0010, 0x0033)
    PatientDeathDateInAlternativeCalendar = Tag("Patient's Death Date in Alternative Calendar", "PatientDeathDateInAlternativeCalendar", 0x0010, 0x0034)
    PatientAlternativeCalendar = Tag("Patient's Alternative Calendar", "PatientAlternativeCalendar", 0x0010, 0x0035)
    PatientSex = Tag("Patient's Sex", "PatientSex", 0x0010, 0x0040, [TagLink(InventoriedStudiesSequence),])
    QualityControlSubject = Tag('Quality Control Subject', "QualityControlSubject", 0x0010, 0x0200)
    StrainDescription = Tag('Strain Description', "StrainDescription", 0x0010, 0x0212)
    StrainNomenclature = Tag('Strain Nomenclature', "StrainNomenclature", 0x0010, 0x0213)
    StrainStockNumber = Tag('Strain Stock Number', "StrainStockNumber", 0x0010, 0x0214, [TagLink(StrainStockSequence),])
    StrainSource = Tag('Strain Source', "StrainSource", 0x0010, 0x0217, [TagLink(StrainStockSequence),])
    StrainAdditionalInformation = Tag('Strain Additional Information', "StrainAdditionalInformation", 0x0010, 0x0218)
    GeneticModificationsDescription = Tag('Genetic Modifications Description', "GeneticModificationsDescription", 0x0010, 0x0222, [TagLink(GeneticModificationsSequence),])
    GeneticModificationsNomenclature = Tag('Genetic Modifications Nomenclature', "GeneticModificationsNomenclature", 0x0010, 0x0223, [TagLink(GeneticModificationsSequence),])
    OtherPatientNames = Tag('Other Patient Names', "OtherPatientNames", 0x0010, 0x1001, [TagLink(InventoriedStudiesSequence),])
    PatientAge = Tag("Patient's Age", "PatientAge", 0x0010, 0x1010)
    PatientSize = Tag("Patient's Size", "PatientSize", 0x0010, 0x1020)
    PatientBodyMassIndex = Tag("Patient's Body Mass Index", "PatientBodyMassIndex", 0x0010, 0x1022)
    MeasuredAPDimension = Tag('Measured AP Dimension', "MeasuredAPDimension", 0x0010, 0x1023)
    MeasuredLateralDimension = Tag('Measured Lateral Dimension', "MeasuredLateralDimension", 0x0010, 0x1024)
    PatientWeight = Tag("Patient's Weight", "PatientWeight", 0x0010, 0x1030)
    MedicalAlerts = Tag('Medical Alerts', "MedicalAlerts", 0x0010, 0x2000)
    Allergies = Tag('Allergies', "Allergies", 0x0010, 0x2110)
    EthnicGroup = Tag('Ethnic Group', "EthnicGroup", 0x0010, 0x2160)
    Occupation = Tag('Occupation', "Occupation", 0x0010, 0x2180)
    SmokingStatus = Tag('Smoking Status', "SmokingStatus", 0x0010, 0x21A0)
    AdditionalPatientHistory = Tag('Additional Patient History', "AdditionalPatientHistory", 0x0010, 0x21B0)
    PregnancyStatus = Tag('Pregnancy Status', "PregnancyStatus", 0x0010, 0x21C0)
    LastMenstrualDate = Tag('Last Menstrual Date', "LastMenstrualDate", 0x0010, 0x21D0)
    PatientSpeciesDescription = Tag('Patient Species Description', "PatientSpeciesDescription", 0x0010, 0x2201)
    PatientSexNeutered = Tag("Patient's Sex Neutered", "PatientSexNeutered", 0x0010, 0x2203)
    AnatomicalOrientationType = Tag('Anatomical Orientation Type', "AnatomicalOrientationType", 0x0010, 0x2210)
    PatientBreedDescription = Tag('Patient Breed Description', "PatientBreedDescription", 0x0010, 0x2292)
    BreedRegistrationNumber = Tag('Breed Registration Number', "BreedRegistrationNumber", 0x0010, 0x2295, [TagLink(BreedRegistrationSequence),])
    ResponsiblePerson = Tag('Responsible Person', "ResponsiblePerson", 0x0010, 0x2297)
    ResponsiblePersonRole = Tag('Responsible Person Role', "ResponsiblePersonRole", 0x0010, 0x2298)
    ResponsibleOrganization = Tag('Responsible Organization', "ResponsibleOrganization", 0x0010, 0x2299)
    PatientComments = Tag('Patient Comments', "PatientComments", 0x0010, 0x4000)
    ExaminedBodyThickness = Tag('Examined Body Thickness', "ExaminedBodyThickness", 0x0010, 0x9431)
    ClinicalTrialSponsorName = Tag('Clinical Trial Sponsor Name', "ClinicalTrialSponsorName", 0x0012, 0x0010)
    OtherClinicalTrialProtocolIDsSequence = Tag('Other Clinical Trial Protocol IDs Sequence', "OtherClinicalTrialProtocolIDsSequence", 0x0012, 0x0023)
    ConsentForClinicalTrialUseSequence = Tag('Consent for Clinical Trial Use Sequence', "ConsentForClinicalTrialUseSequence", 0x0012, 0x0083)
    ClinicalTrialProtocolID = Tag('Clinical Trial Protocol ID', "ClinicalTrialProtocolID", 0x0012, 0x0020, [TagLink(OtherClinicalTrialProtocolIDsSequence),TagLink(ConsentForClinicalTrialUseSequence),TagLink(ApprovalSequence),])
    ClinicalTrialProtocolName = Tag('Clinical Trial Protocol Name', "ClinicalTrialProtocolName", 0x0012, 0x0021)
    IssuerOfClinicalTrialProtocolID = Tag('Issuer of Clinical Trial Protocol ID', "IssuerOfClinicalTrialProtocolID", 0x0012, 0x0022, [TagLink(OtherClinicalTrialProtocolIDsSequence),TagLink(ConsentForClinicalTrialUseSequence),])
    ClinicalTrialSiteID = Tag('Clinical Trial Site ID', "ClinicalTrialSiteID", 0x0012, 0x0030)
    ClinicalTrialSiteName = Tag('Clinical Trial Site Name', "ClinicalTrialSiteName", 0x0012, 0x0031)
    IssuerOfClinicalTrialSiteID = Tag('Issuer of Clinical Trial Site ID', "IssuerOfClinicalTrialSiteID", 0x0012, 0x0032)
    ClinicalTrialSubjectID = Tag('Clinical Trial Subject ID', "ClinicalTrialSubjectID", 0x0012, 0x0040)
    IssuerOfClinicalTrialSubjectID = Tag('Issuer of Clinical Trial Subject ID', "IssuerOfClinicalTrialSubjectID", 0x0012, 0x0041)
    ClinicalTrialSubjectReadingID = Tag('Clinical Trial Subject Reading ID', "ClinicalTrialSubjectReadingID", 0x0012, 0x0042)
    IssuerOfClinicalTrialSubjectReadingID = Tag('Issuer of Clinical Trial Subject Reading ID', "IssuerOfClinicalTrialSubjectReadingID", 0x0012, 0x0043)
    ClinicalTrialTimePointID = Tag('Clinical Trial Time Point ID', "ClinicalTrialTimePointID", 0x0012, 0x0050)
    ClinicalTrialTimePointDescription = Tag('Clinical Trial Time Point Description', "ClinicalTrialTimePointDescription", 0x0012, 0x0051)
    LongitudinalTemporalOffsetFromEvent = Tag('Longitudinal Temporal Offset from Event', "LongitudinalTemporalOffsetFromEvent", 0x0012, 0x0052)
    LongitudinalTemporalEventType = Tag('Longitudinal Temporal Event Type', "LongitudinalTemporalEventType", 0x0012, 0x0053)
    IssuerOfClinicalTrialTimePointID = Tag('Issuer of Clinical Trial Time Point ID', "IssuerOfClinicalTrialTimePointID", 0x0012, 0x0055)
    ClinicalTrialCoordinatingCenterName = Tag('Clinical Trial Coordinating Center Name', "ClinicalTrialCoordinatingCenterName", 0x0012, 0x0060)
    PatientIdentityRemoved = Tag('Patient Identity Removed', "PatientIdentityRemoved", 0x0012, 0x0062)
    DeidentificationMethod = Tag('De-identification Method', "DeidentificationMethod", 0x0012, 0x0063)
    ClinicalTrialSeriesID = Tag('Clinical Trial Series ID', "ClinicalTrialSeriesID", 0x0012, 0x0071)
    ClinicalTrialSeriesDescription = Tag('Clinical Trial Series Description', "ClinicalTrialSeriesDescription", 0x0012, 0x0072)
    IssuerOfClinicalTrialSeriesID = Tag('Issuer of Clinical Trial Series ID', "IssuerOfClinicalTrialSeriesID", 0x0012, 0x0073)
    ClinicalTrialProtocolEthicsCommitteeName = Tag('Clinical Trial Protocol Ethics Committee Name', "ClinicalTrialProtocolEthicsCommitteeName", 0x0012, 0x0081)
    ClinicalTrialProtocolEthicsCommitteeApprovalNumber = Tag('Clinical Trial Protocol Ethics Committee Approval Number', "ClinicalTrialProtocolEthicsCommitteeApprovalNumber", 0x0012, 0x0082)
    DistributionType = Tag('Distribution Type', "DistributionType", 0x0012, 0x0084, [TagLink(ConsentForClinicalTrialUseSequence),])
    ConsentForDistributionFlag = Tag('Consent for Distribution Flag', "ConsentForDistributionFlag", 0x0012, 0x0085, [TagLink(ConsentForClinicalTrialUseSequence),])
    ContrastBolusAgent = Tag('Contrast/Bolus Agent', "ContrastBolusAgent", 0x0018, 0x0010, [TagLink(XRay3DAcquisitionSequence),])
    ContrastBolusT1Relaxivity = Tag('Contrast/Bolus T1 Relaxivity', "ContrastBolusT1Relaxivity", 0x0018, 0x0013, [TagLink(ContrastBolusAgentSequence),])
    BodyPartExamined = Tag('Body Part Examined', "BodyPartExamined", 0x0018, 0x0015, [TagLink(InventoriedSeriesSequence),])
    ScanOptions = Tag('Scan Options', "ScanOptions", 0x0018, 0x0022, [TagLink(AcquisitionProtocolElementSequence),])
    InterventionDrugStopTime = Tag('Intervention Drug Stop Time', "InterventionDrugStopTime", 0x0018, 0x0027, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    InterventionDrugStartTime = Tag('Intervention Drug Start Time', "InterventionDrugStartTime", 0x0018, 0x0035, [TagLink(InterventionSequence),TagLink(InterventionDrugInformationSequence),])
    InterventionStatus = Tag('Intervention Status', "InterventionStatus", 0x0018, 0x0038, [TagLink(InterventionSequence),])
    InterventionDescription = Tag('Intervention Description', "InterventionDescription", 0x0018, 0x003A, [TagLink(InterventionSequence),])
    CineRate = Tag('Cine Rate', "CineRate", 0x0018, 0x0040)
    PixelMeasuresSequence = Tag('Pixel Measures Sequence', "PixelMeasuresSequence", 0x0028, 0x9110, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SliceThickness = Tag('Slice Thickness', "SliceThickness", 0x0018, 0x0050, [TagLink(PixelMeasuresSequence),TagLink(ReconstructionProtocolElementSequence),])
    CTAdditionalXRaySourceSequence = Tag('CT Additional X-Ray Source Sequence', "CTAdditionalXRaySourceSequence", 0x0018, 0x9360, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    IonControlPointSequence = Tag('Ion Control Point Sequence', "IonControlPointSequence", 0x300A, 0x03A8, [TagLink(IonBeamSequence),])
    CTXRayDetailsSequence = Tag('CT X-Ray Details Sequence', "CTXRayDetailsSequence", 0x0018, 0x9325, [TagLink(AcquisitionProtocolElementSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAcquisitionSequence = Tag('Frame Acquisition Sequence', "FrameAcquisitionSequence", 0x0018, 0x9417, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XAPlaneDetailsSequence = Tag('XA Plane Details Sequence', "XAPlaneDetailsSequence", 0x0018, 0x11BA, [TagLink(AcquisitionProtocolElementSequence),])
    KVP = Tag('KVP', "KVP", 0x0018, 0x0060, [TagLink(CTAdditionalXRaySourceSequence),TagLink(ExposureSequence),TagLink(IonControlPointSequence),TagLink(IonControlPointDeliverySequence),TagLink(CTXRayDetailsSequence),TagLink(FrameAcquisitionSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XAPlaneDetailsSequence),TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    EffectiveDuration = Tag('Effective Duration', "EffectiveDuration", 0x0018, 0x0072)
    SourcePixelPlanesCharacteristicsSequence = Tag('Source Pixel Planes Characteristics Sequence', "SourcePixelPlanesCharacteristicsSequence", 0x3006, 0x004A, [TagLink(ROIContourSequence),])
    SpacingBetweenSlices = Tag('Spacing Between Slices', "SpacingBetweenSlices", 0x0018, 0x0088, [TagLink(PixelMeasuresSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(ReconstructionProtocolElementSequence),])
    CTAcquisitionDetailsSequence = Tag('CT Acquisition Details Sequence', "CTAcquisitionDetailsSequence", 0x0018, 0x9304, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PETFrameAcquisitionSequence = Tag('PET Frame Acquisition Sequence', "PETFrameAcquisitionSequence", 0x0018, 0x9732, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DeviceSerialNumber = Tag('Device Serial Number', "DeviceSerialNumber", 0x0018, 0x1000, [TagLink(DeviceSequence),TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DeviceUID = Tag('Device UID', "DeviceUID", 0x0018, 0x1002, [TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(AuthorIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DeviceID = Tag('Device ID', "DeviceID", 0x0018, 0x1003, [TagLink(DeviceSequence),])
    PlateID = Tag('Plate ID', "PlateID", 0x0018, 0x1004)
    GeneratorID = Tag('Generator ID', "GeneratorID", 0x0018, 0x1005)
    GridID = Tag('Grid ID', "GridID", 0x0018, 0x1006, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    CassetteID = Tag('Cassette ID', "CassetteID", 0x0018, 0x1007)
    GantryID = Tag('Gantry ID', "GantryID", 0x0018, 0x1008)
    UDISequence = Tag('UDI Sequence', "UDISequence", 0x0018, 0x100A, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(ContributingEquipmentSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),])
    UniqueDeviceIdentifier = Tag('Unique Device Identifier', "UniqueDeviceIdentifier", 0x0018, 0x1009, [TagLink(UDISequence),])
    ManufacturerDeviceClassUID = Tag("Manufacturer's Device Class UID", "ManufacturerDeviceClassUID", 0x0018, 0x100B, [TagLink(TreatmentDeviceIdentificationSequence),])
    SoftwareVersions = Tag('Software Versions', "SoftwareVersions", 0x0018, 0x1020, [TagLink(TransducerIdentificationSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    ProtocolName = Tag('Protocol Name', "ProtocolName", 0x0018, 0x1030, [TagLink(ContributingSourcesSequence),])
    ContrastBolusRoute = Tag('Contrast/Bolus Route', "ContrastBolusRoute", 0x0018, 0x1040)
    ContrastAdministrationProfileSequence = Tag('Contrast Administration Profile Sequence', "ContrastAdministrationProfileSequence", 0x0018, 0x9340, [TagLink(ContrastBolusAgentSequence),])
    ContrastBolusVolume = Tag('Contrast/Bolus Volume', "ContrastBolusVolume", 0x0018, 0x1041, [TagLink(ContrastBolusAgentSequence),TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusStartTime = Tag('Contrast/Bolus Start Time', "ContrastBolusStartTime", 0x0018, 0x1042, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusStopTime = Tag('Contrast/Bolus Stop Time', "ContrastBolusStopTime", 0x0018, 0x1043, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusTotalDose = Tag('Contrast/Bolus Total Dose', "ContrastBolusTotalDose", 0x0018, 0x1044)
    ContrastFlowRate = Tag('Contrast Flow Rate', "ContrastFlowRate", 0x0018, 0x1046, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastFlowDuration = Tag('Contrast Flow Duration', "ContrastFlowDuration", 0x0018, 0x1047, [TagLink(ContrastAdministrationProfileSequence),])
    ContrastBolusIngredient = Tag('Contrast/Bolus Ingredient', "ContrastBolusIngredient", 0x0018, 0x1048)
    ContrastBolusIngredientConcentration = Tag('Contrast/Bolus Ingredient Concentration', "ContrastBolusIngredientConcentration", 0x0018, 0x1049, [TagLink(ContrastBolusAgentSequence),])
    SpatialResolution = Tag('Spatial Resolution', "SpatialResolution", 0x0018, 0x1050, [TagLink(ContributingEquipmentSequence),])
    GatedInformationSequence = Tag('Gated Information Sequence', "GatedInformationSequence", 0x0054, 0x0062)
    TriggerSourceOrType = Tag('Trigger Source or Type', "TriggerSourceOrType", 0x0018, 0x1061)
    DataInformationSequence = Tag('Data Information Sequence', "DataInformationSequence", 0x0054, 0x0063, [TagLink(GatedInformationSequence),])
    FrameTime = Tag('Frame Time', "FrameTime", 0x0018, 0x1063, [TagLink(DataInformationSequence),])
    CardiacFramingType = Tag('Cardiac Framing Type', "CardiacFramingType", 0x0018, 0x1064, [TagLink(GatedInformationSequence),TagLink(CTXRayDetailsSequence),])
    FrameTimeVector = Tag('Frame Time Vector', "FrameTimeVector", 0x0018, 0x1065)
    FrameDelay = Tag('Frame Delay', "FrameDelay", 0x0018, 0x1066)
    ImageTriggerDelay = Tag('Image Trigger Delay', "ImageTriggerDelay", 0x0018, 0x1067)
    SynchronizationTrigger = Tag('Synchronization Trigger', "SynchronizationTrigger", 0x0018, 0x106A)
    SynchronizationChannel = Tag('Synchronization Channel', "SynchronizationChannel", 0x0018, 0x106C)
    CardiacSynchronizationSequence = Tag('Cardiac Synchronization Sequence', "CardiacSynchronizationSequence", 0x0018, 0x9118, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    LowRRValue = Tag('Low R-R Value', "LowRRValue", 0x0018, 0x1081, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),TagLink(CTXRayDetailsSequence),])
    HighRRValue = Tag('High R-R Value', "HighRRValue", 0x0018, 0x1082, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),TagLink(CTXRayDetailsSequence),])
    IntervalsAcquired = Tag('Intervals Acquired', "IntervalsAcquired", 0x0018, 0x1083, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),])
    IntervalsRejected = Tag('Intervals Rejected', "IntervalsRejected", 0x0018, 0x1084, [TagLink(CardiacSynchronizationSequence),TagLink(DataInformationSequence),])
    SkipBeats = Tag('Skip Beats', "SkipBeats", 0x0018, 0x1086, [TagLink(CTXRayDetailsSequence),])
    HeartRate = Tag('Heart Rate', "HeartRate", 0x0018, 0x1088, [TagLink(CardiacSynchronizationSequence),])
    RotationInformationSequence = Tag('Rotation Information Sequence', "RotationInformationSequence", 0x0054, 0x0052)
    CTGeometrySequence = Tag('CT Geometry Sequence', "CTGeometrySequence", 0x0018, 0x9312, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    XRayGeometrySequence = Tag('X-Ray Geometry Sequence', "XRayGeometrySequence", 0x0018, 0x9476, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DistanceSourceToDetector = Tag('Distance Source to Detector', "DistanceSourceToDetector", 0x0018, 0x1110, [TagLink(DetectorInformationSequence),TagLink(RotationInformationSequence),TagLink(CTGeometrySequence),TagLink(XRayGeometrySequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    DistanceSourceToPatient = Tag('Distance Source to Patient', "DistanceSourceToPatient", 0x0018, 0x1111, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGeometrySequence),])
    EstimatedRadiographicMagnificationFactor = Tag('Estimated Radiographic Magnification Factor', "EstimatedRadiographicMagnificationFactor", 0x0018, 0x1114, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGeometrySequence),])
    ProjectionPixelCalibrationSequence = Tag('Projection Pixel Calibration Sequence', "ProjectionPixelCalibrationSequence", 0x0018, 0x9401, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TableHeight = Tag('Table Height', "TableHeight", 0x0018, 0x1130, [TagLink(RotationInformationSequence),TagLink(CTAcquisitionDetailsSequence),TagLink(ProjectionPixelCalibrationSequence),TagLink(PETFrameAcquisitionSequence),TagLink(AcquisitionProtocolElementSequence),])
    TableMotion = Tag('Table Motion', "TableMotion", 0x0018, 0x1134)
    TableVerticalIncrement = Tag('Table Vertical Increment', "TableVerticalIncrement", 0x0018, 0x1135)
    TableLateralIncrement = Tag('Table Lateral Increment', "TableLateralIncrement", 0x0018, 0x1136)
    TableLongitudinalIncrement = Tag('Table Longitudinal Increment', "TableLongitudinalIncrement", 0x0018, 0x1137)
    TableAngle = Tag('Table Angle', "TableAngle", 0x0018, 0x1138)
    TableType = Tag('Table Type', "TableType", 0x0018, 0x113A)
    FieldOfViewSequence = Tag('Field of View Sequence', "FieldOfViewSequence", 0x0018, 0x9432, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FieldOfViewShape = Tag('Field of View Shape', "FieldOfViewShape", 0x0018, 0x1147, [TagLink(DetectorInformationSequence),TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewDimensions = Tag('Field of View Dimension(s)', "FieldOfViewDimensions", 0x0018, 0x1149, [TagLink(DetectorInformationSequence),])
    ExposureTime = Tag('Exposure Time', "ExposureTime", 0x0018, 0x1150, [TagLink(ExposureSequence),])
    XRayTubeCurrent = Tag('X-Ray Tube Current', "XRayTubeCurrent", 0x0018, 0x1151, [TagLink(ExposureSequence),])
    Exposure = Tag('Exposure', "Exposure", 0x0018, 0x1152)
    ExposureInuAs = Tag('Exposure in \xb5As', "ExposureInuAs", 0x0018, 0x1153)
    AveragePulseWidth = Tag('Average Pulse Width', "AveragePulseWidth", 0x0018, 0x1154, [TagLink(XAPlaneDetailsSequence),TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    RadiationSetting = Tag('Radiation Setting', "RadiationSetting", 0x0018, 0x1155, [TagLink(AcquisitionProtocolElementSequence),])
    RectificationType = Tag('Rectification Type', "RectificationType", 0x0018, 0x1156)
    RadiationMode = Tag('Radiation Mode', "RadiationMode", 0x0018, 0x115A, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    ImageAndFluoroscopyAreaDoseProduct = Tag('Image and Fluoroscopy Area Dose Product', "ImageAndFluoroscopyAreaDoseProduct", 0x0018, 0x115E, [TagLink(CTExposureSequence),])
    XRayFilterDetailsSequence = Tag('X-Ray Filter Details Sequence', "XRayFilterDetailsSequence", 0x0018, 0x11BC, [TagLink(XAPlaneDetailsSequence),])
    FilterType = Tag('Filter Type', "FilterType", 0x0018, 0x1160, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    TypeOfFilters = Tag('Type of Filters', "TypeOfFilters", 0x0018, 0x1161)
    IntensifierSize = Tag('Intensifier Size', "IntensifierSize", 0x0018, 0x1162)
    ImagerPixelSpacing = Tag('Imager Pixel Spacing', "ImagerPixelSpacing", 0x0018, 0x1164, [TagLink(FramePixelDataPropertiesSequence),TagLink(ContributingSourcesSequence),])
    XRayGridSequence = Tag('X-Ray Grid Sequence', "XRayGridSequence", 0x0018, 0x9555, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    Grid = Tag('Grid', "Grid", 0x0018, 0x1166, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayGridSequence),])
    MultienergyCTXRaySourceSequence = Tag('Multi-energy CT X-Ray Source Sequence', "MultienergyCTXRaySourceSequence", 0x0018, 0x9365)
    GeneratorPower = Tag('Generator Power', "GeneratorPower", 0x0018, 0x1170, [TagLink(MultienergyCTXRaySourceSequence),])
    CollimatorGridName = Tag('Collimator/grid Name', "CollimatorGridName", 0x0018, 0x1180, [TagLink(DetectorInformationSequence),])
    FocalSpots = Tag('Focal Spot(s)', "FocalSpots", 0x0018, 0x1190, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    AnodeTargetMaterial = Tag('Anode Target Material', "AnodeTargetMaterial", 0x0018, 0x1191, [TagLink(XRay3DAcquisitionSequence),])
    BodyPartThickness = Tag('Body Part Thickness', "BodyPartThickness", 0x0018, 0x11A0, [TagLink(XRay3DAcquisitionSequence),])
    CompressionForce = Tag('Compression Force', "CompressionForce", 0x0018, 0x11A2, [TagLink(XRay3DAcquisitionSequence),])
    CompressionPressure = Tag('Compression Pressure', "CompressionPressure", 0x0018, 0x11A3, [TagLink(XRay3DAcquisitionSequence),])
    PaddleDescription = Tag('Paddle Description', "PaddleDescription", 0x0018, 0x11A4, [TagLink(XRay3DAcquisitionSequence),])
    CompressionContactArea = Tag('Compression Contact Area', "CompressionContactArea", 0x0018, 0x11A5, [TagLink(XRay3DAcquisitionSequence),])
    DateOfLastCalibration = Tag('Date of Last Calibration', "DateOfLastCalibration", 0x0018, 0x1200, [TagLink(ContributingEquipmentSequence),])
    TimeOfLastCalibration = Tag('Time of Last Calibration', "TimeOfLastCalibration", 0x0018, 0x1201, [TagLink(ContributingEquipmentSequence),])
    DateOfManufacture = Tag('Date of Manufacture', "DateOfManufacture", 0x0018, 0x1204, [TagLink(DeviceSequence),TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    DateOfInstallation = Tag('Date of Installation', "DateOfInstallation", 0x0018, 0x1205, [TagLink(TransducerIdentificationSequence),TagLink(BeamSequence),TagLink(TreatmentMachineSequence),TagLink(BeamHoldOriginatingDeviceSequence),TagLink(IonBeamSequence),TagLink(ContributingSourcesSequence),TagLink(ContributingEquipmentSequence),TagLink(AssessmentRequesterSequence),TagLink(ModelSpecificationSequence),TagLink(PatientSupportDevicesSequence),TagLink(WedgeDefinitionSequence),TagLink(CompensatorDefinitionSequence),TagLink(BlockDefinitionSequence),TagLink(RTAccessoryHolderDefinitionSequence),TagLink(GeneralAccessoryDefinitionSequence),TagLink(BolusDefinitionSequence),TagLink(InterlockOriginatingDeviceSequence),TagLink(AcquisitionDeviceSequence),TagLink(PatientTreatmentPreparationDeviceSequence),TagLink(XRayFilterSequence),TagLink(AuthorIdentificationSequence),TagLink(SegmentedRTAccessoryDeviceSequence),TagLink(TreatmentDeviceIdentificationSequence),TagLink(OperatorIdentificationSequence),TagLink(AsserterIdentificationSequence),])
    PhaseInformationSequence = Tag('Phase Information Sequence', "PhaseInformationSequence", 0x0054, 0x0032)
    ActualFrameDuration = Tag('Actual Frame Duration', "ActualFrameDuration", 0x0018, 0x1242, [TagLink(RotationInformationSequence),TagLink(PhaseInformationSequence),])
    PreferredPlaybackSequencing = Tag('Preferred Playback Sequencing', "PreferredPlaybackSequencing", 0x0018, 0x1244, [TagLink(StructuredDisplayImageBoxSequence),TagLink(MultiFramePresentationSequence),TagLink(ImageBoxesSequence),])
    PlateType = Tag('Plate Type', "PlateType", 0x0018, 0x1260)
    PhosphorType = Tag('Phosphor Type', "PhosphorType", 0x0018, 0x1261)
    AcquisitionDeviceProcessingDescription = Tag('Acquisition Device Processing Description', "AcquisitionDeviceProcessingDescription", 0x0018, 0x1400, [TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ContributingSourcesSequence),])
    AcquisitionDeviceProcessingCode = Tag('Acquisition Device Processing Code', "AcquisitionDeviceProcessingCode", 0x0018, 0x1401, [TagLink(XAXRFFrameCharacteristicsSequence),TagLink(ContributingSourcesSequence),])
    CassetteOrientation = Tag('Cassette Orientation', "CassetteOrientation", 0x0018, 0x1402)
    CassetteSize = Tag('Cassette Size', "CassetteSize", 0x0018, 0x1403)
    ExposuresOnPlate = Tag('Exposures on Plate', "ExposuresOnPlate", 0x0018, 0x1404)
    XRayAcquisitionDoseSequence = Tag('X-Ray Acquisition Dose Sequence', "XRayAcquisitionDoseSequence", 0x0018, 0x9542, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RelativeXRayExposure = Tag('Relative X-Ray Exposure', "RelativeXRayExposure", 0x0018, 0x1405, [TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    ExposureIndex = Tag('Exposure Index', "ExposureIndex", 0x0018, 0x1411, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    TargetExposureIndex = Tag('Target Exposure Index', "TargetExposureIndex", 0x0018, 0x1412, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    DeviationIndex = Tag('Deviation Index', "DeviationIndex", 0x0018, 0x1413, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),])
    ColumnAngulation = Tag('Column Angulation', "ColumnAngulation", 0x0018, 0x1450)
    TomoLayerHeight = Tag('Tomo Layer Height', "TomoLayerHeight", 0x0018, 0x1460)
    TomoAngle = Tag('Tomo Angle', "TomoAngle", 0x0018, 0x1470)
    TomoTime = Tag('Tomo Time', "TomoTime", 0x0018, 0x1480)
    TomoType = Tag('Tomo Type', "TomoType", 0x0018, 0x1490)
    TomoClass = Tag('Tomo Class', "TomoClass", 0x0018, 0x1491)
    NumberOfTomosynthesisSourceImages = Tag('Number of Tomosynthesis Source Images', "NumberOfTomosynthesisSourceImages", 0x0018, 0x1495)
    PositionerMotion = Tag('Positioner Motion', "PositionerMotion", 0x0018, 0x1500)
    PositionerType = Tag('Positioner Type', "PositionerType", 0x0018, 0x1508)
    PositionerPositionSequence = Tag('Positioner Position Sequence', "PositionerPositionSequence", 0x0018, 0x9405, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PositionerPrimaryAngle = Tag('Positioner Primary Angle', "PositionerPrimaryAngle", 0x0018, 0x1510, [TagLink(PositionerPositionSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerSecondaryAngle = Tag('Positioner Secondary Angle', "PositionerSecondaryAngle", 0x0018, 0x1511, [TagLink(PositionerPositionSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerPrimaryAngleIncrement = Tag('Positioner Primary Angle Increment', "PositionerPrimaryAngleIncrement", 0x0018, 0x1520)
    PositionerSecondaryAngleIncrement = Tag('Positioner Secondary Angle Increment', "PositionerSecondaryAngleIncrement", 0x0018, 0x1521)
    DetectorPositionSequence = Tag('Detector Position Sequence', "DetectorPositionSequence", 0x0018, 0x9541, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DetectorPrimaryAngle = Tag('Detector Primary Angle', "DetectorPrimaryAngle", 0x0018, 0x1530, [TagLink(DetectorPositionSequence),])
    DetectorSecondaryAngle = Tag('Detector Secondary Angle', "DetectorSecondaryAngle", 0x0018, 0x1531, [TagLink(DetectorPositionSequence),])
    ShutterShape = Tag('Shutter Shape', "ShutterShape", 0x0018, 0x1600, [TagLink(FrameDisplayShutterSequence),])
    ShutterLeftVerticalEdge = Tag('Shutter Left Vertical Edge', "ShutterLeftVerticalEdge", 0x0018, 0x1602, [TagLink(FrameDisplayShutterSequence),])
    ShutterRightVerticalEdge = Tag('Shutter Right Vertical Edge', "ShutterRightVerticalEdge", 0x0018, 0x1604, [TagLink(FrameDisplayShutterSequence),])
    ShutterUpperHorizontalEdge = Tag('Shutter Upper Horizontal Edge', "ShutterUpperHorizontalEdge", 0x0018, 0x1606, [TagLink(FrameDisplayShutterSequence),])
    ShutterLowerHorizontalEdge = Tag('Shutter Lower Horizontal Edge', "ShutterLowerHorizontalEdge", 0x0018, 0x1608, [TagLink(FrameDisplayShutterSequence),])
    CenterOfCircularShutter = Tag('Center of Circular Shutter', "CenterOfCircularShutter", 0x0018, 0x1610, [TagLink(FrameDisplayShutterSequence),])
    RadiusOfCircularShutter = Tag('Radius of Circular Shutter', "RadiusOfCircularShutter", 0x0018, 0x1612, [TagLink(FrameDisplayShutterSequence),])
    VerticesOfThePolygonalShutter = Tag('Vertices of the Polygonal Shutter', "VerticesOfThePolygonalShutter", 0x0018, 0x1620, [TagLink(FrameDisplayShutterSequence),])
    ShutterPresentationValue = Tag('Shutter Presentation Value', "ShutterPresentationValue", 0x0018, 0x1622, [TagLink(FrameDisplayShutterSequence),])
    ShutterPresentationColorCIELabValue = Tag('Shutter Presentation Color CIELab Value', "ShutterPresentationColorCIELabValue", 0x0018, 0x1624, [TagLink(FrameDisplayShutterSequence),])
    CollimatorShapeSequence = Tag('Collimator Shape Sequence', "CollimatorShapeSequence", 0x0018, 0x9407, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CollimatorShape = Tag('Collimator Shape', "CollimatorShape", 0x0018, 0x1700, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorLeftVerticalEdge = Tag('Collimator Left Vertical Edge', "CollimatorLeftVerticalEdge", 0x0018, 0x1702, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorRightVerticalEdge = Tag('Collimator Right Vertical Edge', "CollimatorRightVerticalEdge", 0x0018, 0x1704, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorUpperHorizontalEdge = Tag('Collimator Upper Horizontal Edge', "CollimatorUpperHorizontalEdge", 0x0018, 0x1706, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CollimatorLowerHorizontalEdge = Tag('Collimator Lower Horizontal Edge', "CollimatorLowerHorizontalEdge", 0x0018, 0x1708, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    CenterOfCircularCollimator = Tag('Center of Circular Collimator', "CenterOfCircularCollimator", 0x0018, 0x1710, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    RadiusOfCircularCollimator = Tag('Radius of Circular Collimator', "RadiusOfCircularCollimator", 0x0018, 0x1712, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    VerticesOfThePolygonalCollimator = Tag('Vertices of the Polygonal Collimator', "VerticesOfThePolygonalCollimator", 0x0018, 0x1720, [TagLink(CollimatorShapeSequence),TagLink(PerProjectionAcquisitionSequence),])
    AcquisitionTimeSynchronized = Tag('Acquisition Time Synchronized', "AcquisitionTimeSynchronized", 0x0018, 0x1800)
    TimeSource = Tag('Time Source', "TimeSource", 0x0018, 0x1801)
    TimeDistributionProtocol = Tag('Time Distribution Protocol', "TimeDistributionProtocol", 0x0018, 0x1802)
    NTPSourceAddress = Tag('NTP Source Address', "NTPSourceAddress", 0x0018, 0x1803)
    FrameLabelVector = Tag('Frame Label Vector', "FrameLabelVector", 0x0018, 0x2002)
    BiopsyTargetSequence = Tag('Biopsy Target Sequence', "BiopsyTargetSequence", 0x0018, 0x2041, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TargetUID = Tag('Target UID', "TargetUID", 0x0018, 0x2042, [TagLink(BiopsyTargetSequence),])
    LocalizingCursorPosition = Tag('Localizing Cursor Position', "LocalizingCursorPosition", 0x0018, 0x2043, [TagLink(BiopsyTargetSequence),])
    CalculatedTargetPosition = Tag('Calculated Target Position', "CalculatedTargetPosition", 0x0018, 0x2044, [TagLink(BiopsyTargetSequence),])
    TargetLabel = Tag('Target Label', "TargetLabel", 0x0018, 0x2045, [TagLink(BiopsyTargetSequence),])
    DisplayedZValue = Tag('Displayed Z Value', "DisplayedZValue", 0x0018, 0x2046, [TagLink(BiopsyTargetSequence),])
    PatientPosition = Tag('Patient Position', "PatientPosition", 0x0018, 0x5100, [TagLink(GroupOfPatientsIdentificationSequence),TagLink(PatientSetupSequence),])
    ViewPosition = Tag('View Position', "ViewPosition", 0x0018, 0x5101)
    Sensitivity = Tag('Sensitivity', "Sensitivity", 0x0018, 0x6000, [TagLink(XRay3DAcquisitionSequence),])
    DetectorConditionsNominalFlag = Tag('Detector Conditions Nominal Flag', "DetectorConditionsNominalFlag", 0x0018, 0x7000, [TagLink(XRay3DAcquisitionSequence),])
    DetectorTemperature = Tag('Detector Temperature', "DetectorTemperature", 0x0018, 0x7001, [TagLink(XRay3DAcquisitionSequence),])
    DetectorType = Tag('Detector Type', "DetectorType", 0x0018, 0x7004, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DetectorConfiguration = Tag('Detector Configuration', "DetectorConfiguration", 0x0018, 0x7005, [TagLink(XRay3DAcquisitionSequence),])
    DetectorDescription = Tag('Detector Description', "DetectorDescription", 0x0018, 0x7006, [TagLink(XRay3DAcquisitionSequence),])
    DetectorMode = Tag('Detector Mode', "DetectorMode", 0x0018, 0x7008, [TagLink(XRay3DAcquisitionSequence),])
    DetectorID = Tag('Detector ID', "DetectorID", 0x0018, 0x700A, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DateOfLastDetectorCalibration = Tag('Date of Last Detector Calibration', "DateOfLastDetectorCalibration", 0x0018, 0x700C, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    TimeOfLastDetectorCalibration = Tag('Time of Last Detector Calibration', "TimeOfLastDetectorCalibration", 0x0018, 0x700E, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    ExposuresOnDetectorSinceLastCalibration = Tag('Exposures on Detector Since Last Calibration', "ExposuresOnDetectorSinceLastCalibration", 0x0018, 0x7010, [TagLink(XRay3DAcquisitionSequence),])
    ExposuresOnDetectorSinceManufactured = Tag('Exposures on Detector Since Manufactured', "ExposuresOnDetectorSinceManufactured", 0x0018, 0x7011, [TagLink(XRay3DAcquisitionSequence),])
    DetectorTimeSinceLastExposure = Tag('Detector Time Since Last Exposure', "DetectorTimeSinceLastExposure", 0x0018, 0x7012, [TagLink(XRay3DAcquisitionSequence),])
    FrameDetectorParametersSequence = Tag('Frame Detector Parameters Sequence', "FrameDetectorParametersSequence", 0x0018, 0x9451, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DetectorActiveTime = Tag('Detector Active Time', "DetectorActiveTime", 0x0018, 0x7014, [TagLink(FrameDetectorParametersSequence),])
    DetectorActivationOffsetFromExposure = Tag('Detector Activation Offset From Exposure', "DetectorActivationOffsetFromExposure", 0x0018, 0x7016, [TagLink(FrameDetectorParametersSequence),])
    DetectorBinning = Tag('Detector Binning', "DetectorBinning", 0x0018, 0x701A, [TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    DetectorElementPhysicalSize = Tag('Detector Element Physical Size', "DetectorElementPhysicalSize", 0x0018, 0x7020, [TagLink(XRay3DAcquisitionSequence),])
    DetectorElementSpacing = Tag('Detector Element Spacing', "DetectorElementSpacing", 0x0018, 0x7022, [TagLink(ContributingSourcesSequence),TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveShape = Tag('Detector Active Shape', "DetectorActiveShape", 0x0018, 0x7024, [TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveDimensions = Tag('Detector Active Dimension(s)', "DetectorActiveDimensions", 0x0018, 0x7026, [TagLink(XRay3DAcquisitionSequence),])
    DetectorActiveOrigin = Tag('Detector Active Origin', "DetectorActiveOrigin", 0x0018, 0x7028, [TagLink(XRay3DAcquisitionSequence),])
    DetectorManufacturerName = Tag('Detector Manufacturer Name', "DetectorManufacturerName", 0x0018, 0x702A, [TagLink(XRay3DAcquisitionSequence),])
    DetectorManufacturerModelName = Tag("Detector Manufacturer's Model Name", "DetectorManufacturerModelName", 0x0018, 0x702B, [TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewOrigin = Tag('Field of View Origin', "FieldOfViewOrigin", 0x0018, 0x7030, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewRotation = Tag('Field of View Rotation', "FieldOfViewRotation", 0x0018, 0x7032, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewHorizontalFlip = Tag('Field of View Horizontal Flip', "FieldOfViewHorizontalFlip", 0x0018, 0x7034, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),])
    PixelDataAreaOriginRelativeToFOV = Tag('Pixel Data Area Origin Relative To FOV', "PixelDataAreaOriginRelativeToFOV", 0x0018, 0x7036, [TagLink(FramePixelDataPropertiesSequence),])
    PixelDataAreaRotationAngleRelativeToFOV = Tag('Pixel Data Area Rotation Angle Relative To FOV', "PixelDataAreaRotationAngleRelativeToFOV", 0x0018, 0x7038, [TagLink(FramePixelDataPropertiesSequence),])
    GridAbsorbingMaterial = Tag('Grid Absorbing Material', "GridAbsorbingMaterial", 0x0018, 0x7040, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridSpacingMaterial = Tag('Grid Spacing Material', "GridSpacingMaterial", 0x0018, 0x7041, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridThickness = Tag('Grid Thickness', "GridThickness", 0x0018, 0x7042, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridPitch = Tag('Grid Pitch', "GridPitch", 0x0018, 0x7044, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridAspectRatio = Tag('Grid Aspect Ratio', "GridAspectRatio", 0x0018, 0x7046, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridPeriod = Tag('Grid Period', "GridPeriod", 0x0018, 0x7048, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    GridFocalDistance = Tag('Grid Focal Distance', "GridFocalDistance", 0x0018, 0x704C, [TagLink(XRay3DAcquisitionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    FilterMaterial = Tag('Filter Material', "FilterMaterial", 0x0018, 0x7050, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTXRayDetailsSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterThicknessMinimum = Tag('Filter Thickness Minimum', "FilterThicknessMinimum", 0x0018, 0x7052, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterThicknessMaximum = Tag('Filter Thickness Maximum', "FilterThicknessMaximum", 0x0018, 0x7054, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),TagLink(XRayFilterDetailsSequence),])
    FilterBeamPathLengthMinimum = Tag('Filter Beam Path Length Minimum', "FilterBeamPathLengthMinimum", 0x0018, 0x7056, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),])
    FilterBeamPathLengthMaximum = Tag('Filter Beam Path Length Maximum', "FilterBeamPathLengthMaximum", 0x0018, 0x7058, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayFilterSequence),])
    ExposureControlMode = Tag('Exposure Control Mode', "ExposureControlMode", 0x0018, 0x7060, [TagLink(XRay3DAcquisitionSequence),])
    ExposureControlModeDescription = Tag('Exposure Control Mode Description', "ExposureControlModeDescription", 0x0018, 0x7062, [TagLink(XRay3DAcquisitionSequence),])
    ExposureStatus = Tag('Exposure Status', "ExposureStatus", 0x0018, 0x7064)
    PhototimerSetting = Tag('Phototimer Setting', "PhototimerSetting", 0x0018, 0x7065)
    ExposureTimeInuS = Tag('Exposure Time in \xb5S', "ExposureTimeInuS", 0x0018, 0x8150, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    XRayTubeCurrentInuA = Tag('X-Ray Tube Current in \xb5A', "XRayTubeCurrentInuA", 0x0018, 0x8151, [TagLink(RTImageFramekVRadiationAcquisitionSequence),TagLink(KVImagingGenerationParametersSequence),])
    ContentQualification = Tag('Content Qualification', "ContentQualification", 0x0018, 0x9004, [TagLink(AcquisitionProtocolElementSequence),TagLink(ReconstructionProtocolElementSequence),])
    CardiacSynchronizationTechnique = Tag('Cardiac Synchronization Technique', "CardiacSynchronizationTechnique", 0x0018, 0x9037, [TagLink(CTXRayDetailsSequence),])
    CardiacRRIntervalSpecified = Tag('Cardiac R-R Interval Specified', "CardiacRRIntervalSpecified", 0x0018, 0x9070, [TagLink(CTXRayDetailsSequence),])
    AcquisitionDuration = Tag('Acquisition Duration', "AcquisitionDuration", 0x0018, 0x9073)
    FrameContentSequence = Tag('Frame Content Sequence', "FrameContentSequence", 0x0020, 0x9111, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameAcquisitionDateTime = Tag('Frame Acquisition DateTime', "FrameAcquisitionDateTime", 0x0018, 0x9074, [TagLink(FrameContentSequence),])
    CardiacSignalSource = Tag('Cardiac Signal Source', "CardiacSignalSource", 0x0018, 0x9085, [TagLink(CTXRayDetailsSequence),])
    FrameReferenceDateTime = Tag('Frame Reference DateTime', "FrameReferenceDateTime", 0x0018, 0x9151, [TagLink(FrameContentSequence),])
    CardiacBeatRejectionTechnique = Tag('Cardiac Beat Rejection Technique', "CardiacBeatRejectionTechnique", 0x0018, 0x9169, [TagLink(CTXRayDetailsSequence),])
    MotionSynchronizationSequence = Tag('Motion Synchronization Sequence', "MotionSynchronizationSequence", 0x300A, 0x0410, [TagLink(PatientSetupSequence),])
    RespiratoryMotionCompensationTechnique = Tag('Respiratory Motion Compensation Technique', "RespiratoryMotionCompensationTechnique", 0x0018, 0x9170, [TagLink(MotionSynchronizationSequence),TagLink(CTXRayDetailsSequence),])
    RespiratorySignalSource = Tag('Respiratory Signal Source', "RespiratorySignalSource", 0x0018, 0x9171, [TagLink(MotionSynchronizationSequence),TagLink(CTXRayDetailsSequence),])
    RespiratoryCyclePosition = Tag('Respiratory Cycle Position', "RespiratoryCyclePosition", 0x0018, 0x9214, [TagLink(FrameContentSequence),])
    FrameAcquisitionDuration = Tag('Frame Acquisition Duration', "FrameAcquisitionDuration", 0x0018, 0x9220, [TagLink(FrameContentSequence),TagLink(PerProjectionAcquisitionSequence),])
    CardiacCyclePosition = Tag('Cardiac Cycle Position', "CardiacCyclePosition", 0x0018, 0x9236, [TagLink(FrameContentSequence),])
    ExposureTimeInms = Tag('Exposure Time in ms', "ExposureTimeInms", 0x0018, 0x9328, [TagLink(ExposureSequence),TagLink(CTExposureSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    XRayTubeCurrentInmA = Tag('X-Ray Tube Current in mA', "XRayTubeCurrentInmA", 0x0018, 0x9330, [TagLink(CTAdditionalXRaySourceSequence),TagLink(ExposureSequence),TagLink(CTExposureSequence),TagLink(FrameAcquisitionSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    ExposureInmAs = Tag('Exposure in mAs', "ExposureInmAs", 0x0018, 0x9332, [TagLink(CTAdditionalXRaySourceSequence),TagLink(CTExposureSequence),TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),TagLink(CTXRayDetailsSequence),TagLink(XAPlaneDetailsSequence),])
    ContrastBolusUsageSequence = Tag('Contrast/Bolus Usage Sequence', "ContrastBolusUsageSequence", 0x0018, 0x9341, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ContrastBolusAgentNumber = Tag('Contrast/Bolus Agent Number', "ContrastBolusAgentNumber", 0x0018, 0x9337, [TagLink(ContrastBolusAgentSequence),TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentAdministered = Tag('Contrast/Bolus Agent Administered', "ContrastBolusAgentAdministered", 0x0018, 0x9342, [TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentDetected = Tag('Contrast/Bolus Agent Detected', "ContrastBolusAgentDetected", 0x0018, 0x9343, [TagLink(ContrastBolusUsageSequence),])
    ContrastBolusAgentPhase = Tag('Contrast/Bolus Agent Phase', "ContrastBolusAgentPhase", 0x0018, 0x9344, [TagLink(ContrastBolusUsageSequence),])
    DistanceSourceToIsocenter = Tag('Distance Source to Isocenter', "DistanceSourceToIsocenter", 0x0018, 0x9402, [TagLink(XRayGeometrySequence),TagLink(XRay3DAcquisitionSequence),])
    DistanceObjectToTableTop = Tag('Distance Object to Table Top', "DistanceObjectToTableTop", 0x0018, 0x9403, [TagLink(ProjectionPixelCalibrationSequence),])
    ObjectPixelSpacingInCenterOfBeam = Tag('Object Pixel Spacing in Center of Beam', "ObjectPixelSpacingInCenterOfBeam", 0x0018, 0x9404, [TagLink(ProjectionPixelCalibrationSequence),])
    TablePositionSequence = Tag('Table Position Sequence', "TablePositionSequence", 0x0018, 0x9406, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PlanesInAcquisition = Tag('Planes in Acquisition', "PlanesInAcquisition", 0x0018, 0x9410, [TagLink(AcquisitionProtocolElementSequence),])
    XRayReceptorType = Tag('X-Ray Receptor Type', "XRayReceptorType", 0x0018, 0x9420, [TagLink(XRay3DAcquisitionSequence),])
    AcquisitionProtocolName = Tag('Acquisition Protocol Name', "AcquisitionProtocolName", 0x0018, 0x9423, [TagLink(ContributingSourcesSequence),])
    AcquisitionProtocolDescription = Tag('Acquisition Protocol Description', "AcquisitionProtocolDescription", 0x0018, 0x9424)
    ContrastBolusIngredientOpaque = Tag('Contrast/Bolus Ingredient Opaque', "ContrastBolusIngredientOpaque", 0x0018, 0x9425, [TagLink(ContrastBolusAgentSequence),TagLink(AcquisitionProtocolElementSequence),])
    DistanceReceptorPlaneToDetectorHousing = Tag('Distance Receptor Plane to Detector Housing', "DistanceReceptorPlaneToDetectorHousing", 0x0018, 0x9426)
    IntensifierActiveShape = Tag('Intensifier Active Shape', "IntensifierActiveShape", 0x0018, 0x9427)
    IntensifierActiveDimensions = Tag('Intensifier Active Dimension(s)', "IntensifierActiveDimensions", 0x0018, 0x9428)
    PhysicalDetectorSize = Tag('Physical Detector Size', "PhysicalDetectorSize", 0x0018, 0x9429, [TagLink(XRay3DAcquisitionSequence),])
    PositionOfIsocenterProjection = Tag('Position of Isocenter Projection', "PositionOfIsocenterProjection", 0x0018, 0x9430, [TagLink(XRay3DAcquisitionSequence),])
    FieldOfViewDescription = Tag('Field of View Description', "FieldOfViewDescription", 0x0018, 0x9433, [TagLink(FieldOfViewSequence),])
    ExposureControlSensingRegionsSequence = Tag('Exposure Control Sensing Regions Sequence', "ExposureControlSensingRegionsSequence", 0x0018, 0x9434, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ExposureControlSensingRegionShape = Tag('Exposure Control Sensing Region Shape', "ExposureControlSensingRegionShape", 0x0018, 0x9435, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionLeftVerticalEdge = Tag('Exposure Control Sensing Region Left Vertical Edge', "ExposureControlSensingRegionLeftVerticalEdge", 0x0018, 0x9436, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionRightVerticalEdge = Tag('Exposure Control Sensing Region Right Vertical Edge', "ExposureControlSensingRegionRightVerticalEdge", 0x0018, 0x9437, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionUpperHorizontalEdge = Tag('Exposure Control Sensing Region Upper Horizontal Edge', "ExposureControlSensingRegionUpperHorizontalEdge", 0x0018, 0x9438, [TagLink(ExposureControlSensingRegionsSequence),])
    ExposureControlSensingRegionLowerHorizontalEdge = Tag('Exposure Control Sensing Region Lower Horizontal Edge', "ExposureControlSensingRegionLowerHorizontalEdge", 0x0018, 0x9439, [TagLink(ExposureControlSensingRegionsSequence),])
    CenterOfCircularExposureControlSensingRegion = Tag('Center of Circular Exposure Control Sensing Region', "CenterOfCircularExposureControlSensingRegion", 0x0018, 0x9440, [TagLink(ExposureControlSensingRegionsSequence),])
    RadiusOfCircularExposureControlSensingRegion = Tag('Radius of Circular Exposure Control Sensing Region', "RadiusOfCircularExposureControlSensingRegion", 0x0018, 0x9441, [TagLink(ExposureControlSensingRegionsSequence),])
    VerticesOfThePolygonalExposureControlSensingRegion = Tag('Vertices of the Polygonal Exposure Control Sensing Region', "VerticesOfThePolygonalExposureControlSensingRegion", 0x0018, 0x9442, [TagLink(ExposureControlSensingRegionsSequence),])
    ColumnAngulationPatient = Tag('Column Angulation (Patient)', "ColumnAngulationPatient", 0x0018, 0x9447, [TagLink(PositionerPositionSequence),])
    BeamAngle = Tag('Beam Angle', "BeamAngle", 0x0018, 0x9449, [TagLink(ProjectionPixelCalibrationSequence),])
    ObjectThicknessSequence = Tag('Object Thickness Sequence', "ObjectThicknessSequence", 0x0018, 0x9456, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CalculatedAnatomyThickness = Tag('Calculated Anatomy Thickness', "CalculatedAnatomyThickness", 0x0018, 0x9452, [TagLink(ObjectThicknessSequence),])
    CalibrationSequence = Tag('Calibration Sequence', "CalibrationSequence", 0x0018, 0x9455, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PlaneIdentification = Tag('Plane Identification', "PlaneIdentification", 0x0018, 0x9457, [TagLink(ContributingSourcesSequence),TagLink(XAPlaneDetailsSequence),])
    FieldOfViewDimensionsInFloat = Tag('Field of View Dimension(s) in Float', "FieldOfViewDimensionsInFloat", 0x0018, 0x9461, [TagLink(FieldOfViewSequence),TagLink(XRay3DAcquisitionSequence),TagLink(XAPlaneDetailsSequence),])
    IsocenterReferenceSystemSequence = Tag('Isocenter Reference System Sequence', "IsocenterReferenceSystemSequence", 0x0018, 0x9462, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PositionerIsocenterPrimaryAngle = Tag('Positioner Isocenter Primary Angle', "PositionerIsocenterPrimaryAngle", 0x0018, 0x9463, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerIsocenterSecondaryAngle = Tag('Positioner Isocenter Secondary Angle', "PositionerIsocenterSecondaryAngle", 0x0018, 0x9464, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    PositionerIsocenterDetectorRotationAngle = Tag('Positioner Isocenter Detector Rotation Angle', "PositionerIsocenterDetectorRotationAngle", 0x0018, 0x9465, [TagLink(IsocenterReferenceSystemSequence),TagLink(PerProjectionAcquisitionSequence),])
    TableXPositionToIsocenter = Tag('Table X Position to Isocenter', "TableXPositionToIsocenter", 0x0018, 0x9466, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableYPositionToIsocenter = Tag('Table Y Position to Isocenter', "TableYPositionToIsocenter", 0x0018, 0x9467, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableZPositionToIsocenter = Tag('Table Z Position to Isocenter', "TableZPositionToIsocenter", 0x0018, 0x9468, [TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableHorizontalRotationAngle = Tag('Table Horizontal Rotation Angle', "TableHorizontalRotationAngle", 0x0018, 0x9469, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableHeadTiltAngle = Tag('Table Head Tilt Angle', "TableHeadTiltAngle", 0x0018, 0x9470, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    TableCradleTiltAngle = Tag('Table Cradle Tilt Angle', "TableCradleTiltAngle", 0x0018, 0x9471, [TagLink(TablePositionSequence),TagLink(IsocenterReferenceSystemSequence),TagLink(XRay3DAcquisitionSequence),])
    AcquiredImageAreaDoseProduct = Tag('Acquired Image Area Dose Product', "AcquiredImageAreaDoseProduct", 0x0018, 0x9473)
    CArmPositionerTabletopRelationship = Tag('C-arm Positioner Tabletop Relationship', "CArmPositionerTabletopRelationship", 0x0018, 0x9474)
    PositionerPrimaryAngleDirection = Tag('Positioner Primary Angle Direction', "PositionerPrimaryAngleDirection", 0x0018, 0x9559, [TagLink(PerProjectionAcquisitionSequence),TagLink(PositionerPositionSequence),])
    RadiopharmaceuticalUsageSequence = Tag('Radiopharmaceutical Usage Sequence', "RadiopharmaceuticalUsageSequence", 0x0018, 0x9737, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RadiopharmaceuticalAgentNumber = Tag('Radiopharmaceutical Agent Number', "RadiopharmaceuticalAgentNumber", 0x0018, 0x9729, [TagLink(RadiopharmaceuticalUsageSequence),TagLink(RadiopharmaceuticalInformationSequence),])
    DataFrameAssignmentSequence = Tag('Data Frame Assignment Sequence', "DataFrameAssignmentSequence", 0x0028, 0x1401)
    DataType = Tag('Data Type', "DataType", 0x0018, 0x9808, [TagLink(ImageDataTypeSequence),TagLink(DataFrameAssignmentSequence),])
    AliasedDataType = Tag('Aliased Data Type', "AliasedDataType", 0x0018, 0x980B, [TagLink(ImageDataTypeSequence),])
    ZeroVelocityPixelValue = Tag('Zero Velocity Pixel Value', "ZeroVelocityPixelValue", 0x0018, 0x9810, [TagLink(ImageDataTypeSequence),])
    SourceAcquisitionProtocolElementNumber = Tag('Source Acquisition Protocol Element Number', "SourceAcquisitionProtocolElementNumber", 0x0018, 0x9938, [TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(StorageProtocolElementSequence),])
    SourceReconstructionProtocolElementNumber = Tag('Source Reconstruction Protocol Element Number', "SourceReconstructionProtocolElementNumber", 0x0018, 0x993A, [TagLink(ReferencedDefinedProtocolSequence),TagLink(ReferencedPerformedProtocolSequence),TagLink(StorageProtocolElementSequence),])
    ContributionDateTime = Tag('Contribution DateTime', "ContributionDateTime", 0x0018, 0xA002, [TagLink(ContributingEquipmentSequence),])
    ContributionDescription = Tag('Contribution Description', "ContributionDescription", 0x0018, 0xA003, [TagLink(ContributingEquipmentSequence),])
    StudyInstanceUID = Tag('Study Instance UID', "StudyInstanceUID", 0x0020, 0x000D, [TagLink(ContributingSOPInstancesReferenceSequence),TagLink(ReferencedStudySequence),TagLink(ReferencedPatientPhotoSequence),TagLink(RelatedSeriesSequence),TagLink(RequestAttributesSequence),TagLink(BlendingSequence),TagLink(AdvancedBlendingSequence),TagLink(StudiesContainingOtherReferencedInstancesSequence),TagLink(ReferencedRequestSequence),TagLink(CurrentRequestedProcedureEvidenceSequence),TagLink(IdenticalDocumentsSequence),TagLink(PredecessorDocumentsSequence),TagLink(InventoriedStudiesSequence),])
    SourceSeriesSequence = Tag('Source Series Sequence', "SourceSeriesSequence", 0x3006, 0x004B, [TagLink(ROIContourSequence),])
    SeriesInstanceUID = Tag('Series Instance UID', "SeriesInstanceUID", 0x0020, 0x000E, [TagLink(ReferencedSeriesSequence),TagLink(ReferencedPatientPhotoSequence),TagLink(RelatedSeriesSequence),TagLink(RTReferencedSeriesSequence),TagLink(SourceSeriesInformationSequence),TagLink(SourceSeriesSequence),TagLink(AdvancedBlendingSequence),TagLink(InventoriedSeriesSequence),TagLink(AlternateRepresentationSequence),])
    StudyID = Tag('Study ID', "StudyID", 0x0020, 0x0010, [TagLink(InventoriedStudiesSequence),])
    SeriesNumber = Tag('Series Number', "SeriesNumber", 0x0020, 0x0011, [TagLink(ReferencedSeriesSequence),TagLink(SourceSeriesInformationSequence),TagLink(InventoriedSeriesSequence),])
    AcquisitionNumber = Tag('Acquisition Number', "AcquisitionNumber", 0x0020, 0x0012)
    InstanceNumber = Tag('Instance Number', "InstanceNumber", 0x0020, 0x0013, [TagLink(ReferencedInstanceSequence),TagLink(InventoriedInstancesSequence),])
    PatientOrientationInFrameSequence = Tag('Patient Orientation in Frame Sequence', "PatientOrientationInFrameSequence", 0x0020, 0x9450, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PatientOrientation = Tag('Patient Orientation', "PatientOrientation", 0x0020, 0x0020, [TagLink(SourceImageSequence),TagLink(PatientOrientationInFrameSequence),])
    PlanePositionSequence = Tag('Plane Position Sequence', "PlanePositionSequence", 0x0020, 0x9113, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DeformableRegistrationGridSequence = Tag('Deformable Registration Grid Sequence', "DeformableRegistrationGridSequence", 0x0064, 0x0005, [TagLink(DeformableRegistrationSequence),])
    ImagePositionPatient = Tag('Image Position (Patient)', "ImagePositionPatient", 0x0020, 0x0032, [TagLink(PlanePositionSequence),TagLink(DetectorInformationSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(DeformableRegistrationGridSequence),])
    PlaneOrientationSequence = Tag('Plane Orientation Sequence', "PlaneOrientationSequence", 0x0020, 0x9116, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageOrientationPatient = Tag('Image Orientation (Patient)', "ImageOrientationPatient", 0x0020, 0x0037, [TagLink(PlaneOrientationSequence),TagLink(DetectorInformationSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(DeformableRegistrationGridSequence),])
    FrameOfReferenceUID = Tag('Frame of Reference UID', "FrameOfReferenceUID", 0x0020, 0x0052, [TagLink(ReferencedFrameOfReferenceSequence),TagLink(RegistrationSequence),TagLink(FiducialSetSequence),])
    Laterality = Tag('Laterality', "Laterality", 0x0020, 0x0060, [TagLink(HangingProtocolDefinitionSequence),TagLink(InventoriedSeriesSequence),])
    ImageLaterality = Tag('Image Laterality', "ImageLaterality", 0x0020, 0x0062)
    SynchronizationFrameOfReferenceUID = Tag('Synchronization Frame of Reference UID', "SynchronizationFrameOfReferenceUID", 0x0020, 0x0200)
    SOPInstanceUIDOfConcatenationSource = Tag('SOP Instance UID of Concatenation Source', "SOPInstanceUIDOfConcatenationSource", 0x0020, 0x0242)
    ImagesInAcquisition = Tag('Images in Acquisition', "ImagesInAcquisition", 0x0020, 0x1002)
    PositionReferenceIndicator = Tag('Position Reference Indicator', "PositionReferenceIndicator", 0x0020, 0x1040)
    ImageComments = Tag('Image Comments', "ImageComments", 0x0020, 0x4000)
    StackID = Tag('Stack ID', "StackID", 0x0020, 0x9056, [TagLink(FrameContentSequence),])
    InStackPositionNumber = Tag('In-Stack Position Number', "InStackPositionNumber", 0x0020, 0x9057, [TagLink(FrameContentSequence),])
    FrameLaterality = Tag('Frame Laterality', "FrameLaterality", 0x0020, 0x9072, [TagLink(FrameAnatomySequence),])
    TemporalPositionIndex = Tag('Temporal Position Index', "TemporalPositionIndex", 0x0020, 0x9128, [TagLink(FrameContentSequence),])
    NominalCardiacTriggerDelayTime = Tag('Nominal Cardiac Trigger Delay Time', "NominalCardiacTriggerDelayTime", 0x0020, 0x9153, [TagLink(CardiacSynchronizationSequence),])
    NominalCardiacTriggerTimePriorToRPeak = Tag('Nominal Cardiac Trigger Time Prior To R-Peak', "NominalCardiacTriggerTimePriorToRPeak", 0x0020, 0x9154, [TagLink(CardiacSynchronizationSequence),])
    ActualCardiacTriggerTimePriorToRPeak = Tag('Actual Cardiac Trigger Time Prior To R-Peak', "ActualCardiacTriggerTimePriorToRPeak", 0x0020, 0x9155, [TagLink(CardiacSynchronizationSequence),])
    FrameAcquisitionNumber = Tag('Frame Acquisition Number', "FrameAcquisitionNumber", 0x0020, 0x9156, [TagLink(FrameContentSequence),])
    DimensionIndexValues = Tag('Dimension Index Values', "DimensionIndexValues", 0x0020, 0x9157, [TagLink(FrameContentSequence),])
    FrameComments = Tag('Frame Comments', "FrameComments", 0x0020, 0x9158, [TagLink(FrameContentSequence),])
    ConcatenationUID = Tag('Concatenation UID', "ConcatenationUID", 0x0020, 0x9161)
    InConcatenationNumber = Tag('In-concatenation Number', "InConcatenationNumber", 0x0020, 0x9162)
    InConcatenationTotalNumber = Tag('In-concatenation Total Number', "InConcatenationTotalNumber", 0x0020, 0x9163)
    DimensionOrganizationSequence = Tag('Dimension Organization Sequence', "DimensionOrganizationSequence", 0x0020, 0x9221)
    DimensionIndexSequence = Tag('Dimension Index Sequence', "DimensionIndexSequence", 0x0020, 0x9222)
    DimensionOrganizationUID = Tag('Dimension Organization UID', "DimensionOrganizationUID", 0x0020, 0x9164, [TagLink(DimensionOrganizationSequence),TagLink(DimensionIndexSequence),])
    DimensionIndexPointer = Tag('Dimension Index Pointer', "DimensionIndexPointer", 0x0020, 0x9165, [TagLink(DimensionIndexSequence),])
    FunctionalGroupPointer = Tag('Functional Group Pointer', "FunctionalGroupPointer", 0x0020, 0x9167, [TagLink(DimensionIndexSequence),])
    UnassignedSharedConvertedAttributesSequence = Tag('Unassigned Shared Converted Attributes Sequence', "UnassignedSharedConvertedAttributesSequence", 0x0020, 0x9170, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    UnassignedPerFrameConvertedAttributesSequence = Tag('Unassigned Per-Frame Converted Attributes Sequence', "UnassignedPerFrameConvertedAttributesSequence", 0x0020, 0x9171, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    DimensionIndexPrivateCreator = Tag('Dimension Index Private Creator', "DimensionIndexPrivateCreator", 0x0020, 0x9213, [TagLink(DimensionIndexSequence),])
    ConcatenationFrameOffsetNumber = Tag('Concatenation Frame Offset Number', "ConcatenationFrameOffsetNumber", 0x0020, 0x9228)
    FunctionalGroupPrivateCreator = Tag('Functional Group Private Creator', "FunctionalGroupPrivateCreator", 0x0020, 0x9238, [TagLink(DimensionIndexSequence),])
    NominalPercentageOfCardiacPhase = Tag('Nominal Percentage of Cardiac Phase', "NominalPercentageOfCardiacPhase", 0x0020, 0x9241, [TagLink(CardiacSynchronizationSequence),])
    RespiratorySynchronizationSequence = Tag('Respiratory Synchronization Sequence', "RespiratorySynchronizationSequence", 0x0020, 0x9253, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    NominalPercentageOfRespiratoryPhase = Tag('Nominal Percentage of Respiratory Phase', "NominalPercentageOfRespiratoryPhase", 0x0020, 0x9245, [TagLink(RespiratorySynchronizationSequence),])
    StartingRespiratoryAmplitude = Tag('Starting Respiratory Amplitude', "StartingRespiratoryAmplitude", 0x0020, 0x9246, [TagLink(RespiratorySynchronizationSequence),])
    StartingRespiratoryPhase = Tag('Starting Respiratory Phase', "StartingRespiratoryPhase", 0x0020, 0x9247, [TagLink(RespiratorySynchronizationSequence),])
    EndingRespiratoryAmplitude = Tag('Ending Respiratory Amplitude', "EndingRespiratoryAmplitude", 0x0020, 0x9248, [TagLink(RespiratorySynchronizationSequence),])
    EndingRespiratoryPhase = Tag('Ending Respiratory Phase', "EndingRespiratoryPhase", 0x0020, 0x9249, [TagLink(RespiratorySynchronizationSequence),])
    RespiratoryTriggerType = Tag('Respiratory Trigger Type', "RespiratoryTriggerType", 0x0020, 0x9250, [TagLink(CTXRayDetailsSequence),])
    RRIntervalTimeNominal = Tag('R-R Interval Time Nominal', "RRIntervalTimeNominal", 0x0020, 0x9251, [TagLink(CardiacSynchronizationSequence),])
    ActualCardiacTriggerDelayTime = Tag('Actual Cardiac Trigger Delay Time', "ActualCardiacTriggerDelayTime", 0x0020, 0x9252, [TagLink(CardiacSynchronizationSequence),])
    RespiratoryIntervalTime = Tag('Respiratory Interval Time', "RespiratoryIntervalTime", 0x0020, 0x9254, [TagLink(RespiratorySynchronizationSequence),])
    NominalRespiratoryTriggerDelayTime = Tag('Nominal Respiratory Trigger Delay Time', "NominalRespiratoryTriggerDelayTime", 0x0020, 0x9255, [TagLink(RespiratorySynchronizationSequence),])
    RespiratoryTriggerDelayThreshold = Tag('Respiratory Trigger Delay Threshold', "RespiratoryTriggerDelayThreshold", 0x0020, 0x9256, [TagLink(CTXRayDetailsSequence),])
    ActualRespiratoryTriggerDelayTime = Tag('Actual Respiratory Trigger Delay Time', "ActualRespiratoryTriggerDelayTime", 0x0020, 0x9257, [TagLink(RespiratorySynchronizationSequence),])
    PlanePositionVolumeSequence = Tag('Plane Position (Volume) Sequence', "PlanePositionVolumeSequence", 0x0020, 0x930E, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImagePositionVolume = Tag('Image Position (Volume)', "ImagePositionVolume", 0x0020, 0x9301, [TagLink(PlanePositionVolumeSequence),])
    PlaneOrientationVolumeSequence = Tag('Plane Orientation (Volume) Sequence', "PlaneOrientationVolumeSequence", 0x0020, 0x930F, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ImageOrientationVolume = Tag('Image Orientation (Volume)', "ImageOrientationVolume", 0x0020, 0x9302, [TagLink(PlaneOrientationVolumeSequence),])
    TemporalPositionSequence = Tag('Temporal Position Sequence', "TemporalPositionSequence", 0x0020, 0x9310, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    TemporalPositionTimeOffset = Tag('Temporal Position Time Offset', "TemporalPositionTimeOffset", 0x0020, 0x930D, [TagLink(TemporalPositionSequence),])
    DimensionOrganizationType = Tag('Dimension Organization Type', "DimensionOrganizationType", 0x0020, 0x9311)
    DimensionDescriptionLabel = Tag('Dimension Description Label', "DimensionDescriptionLabel", 0x0020, 0x9421, [TagLink(DimensionIndexSequence),])
    FrameLabel = Tag('Frame Label', "FrameLabel", 0x0020, 0x9453, [TagLink(FrameContentSequence),])
    StereoPairsPresent = Tag('Stereo Pairs Present', "StereoPairsPresent", 0x0022, 0x0028)
    IconImageSequence = Tag('Icon Image Sequence', "IconImageSequence", 0x0088, 0x0200, [TagLink(ReferencedSOPSequence),])
    SamplesPerPixel = Tag('Samples per Pixel', "SamplesPerPixel", 0x0028, 0x0002, [TagLink(IconImageSequence),])
    PhotometricInterpretation = Tag('Photometric Interpretation', "PhotometricInterpretation", 0x0028, 0x0004, [TagLink(IconImageSequence),])
    PlanarConfiguration = Tag('Planar Configuration', "PlanarConfiguration", 0x0028, 0x0006, [TagLink(IconImageSequence),])
    NumberOfFrames = Tag('Number of Frames', "NumberOfFrames", 0x0028, 0x0008, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(InventoriedInstancesSequence),])
    FrameIncrementPointer = Tag('Frame Increment Pointer', "FrameIncrementPointer", 0x0028, 0x0009)
    FrameDimensionPointer = Tag('Frame Dimension Pointer', "FrameDimensionPointer", 0x0028, 0x000A)
    Rows = Tag('Rows', "Rows", 0x0028, 0x0010, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(XAPlaneDetailsSequence),TagLink(InventoriedInstancesSequence),])
    Columns = Tag('Columns', "Columns", 0x0028, 0x0011, [TagLink(SourcePixelPlanesCharacteristicsSequence),TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(ReconstructionProtocolElementSequence),TagLink(XAPlaneDetailsSequence),TagLink(InventoriedInstancesSequence),])
    PixelSpacing = Tag('Pixel Spacing', "PixelSpacing", 0x0028, 0x0030, [TagLink(PixelMeasuresSequence),TagLink(SourcePixelPlanesCharacteristicsSequence),])
    PixelAspectRatio = Tag('Pixel Aspect Ratio', "PixelAspectRatio", 0x0028, 0x0034, [TagLink(IconImageSequence),])
    BitsAllocated = Tag('Bits Allocated', "BitsAllocated", 0x0028, 0x0100, [TagLink(IconImageSequence),TagLink(InventoriedInstancesSequence),])
    BitsStored = Tag('Bits Stored', "BitsStored", 0x0028, 0x0101, [TagLink(IconImageSequence),TagLink(ContributingSourcesSequence),TagLink(XAPlaneDetailsSequence),])
    HighBit = Tag('High Bit', "HighBit", 0x0028, 0x0102, [TagLink(IconImageSequence),])
    PixelRepresentation = Tag('Pixel Representation', "PixelRepresentation", 0x0028, 0x0103, [TagLink(IconImageSequence),])
    SmallestImagePixelValue = Tag('Smallest Image Pixel Value', "SmallestImagePixelValue", 0x0028, 0x0106, [TagLink(IconImageSequence),])
    LargestImagePixelValue = Tag('Largest Image Pixel Value', "LargestImagePixelValue", 0x0028, 0x0107, [TagLink(IconImageSequence),])
    SmallestPixelValueInSeries = Tag('Smallest Pixel Value in Series', "SmallestPixelValueInSeries", 0x0028, 0x0108)
    LargestPixelValueInSeries = Tag('Largest Pixel Value in Series', "LargestPixelValueInSeries", 0x0028, 0x0109)
    PixelPaddingValue = Tag('Pixel Padding Value', "PixelPaddingValue", 0x0028, 0x0120)
    PixelPaddingRangeLimit = Tag('Pixel Padding Range Limit', "PixelPaddingRangeLimit", 0x0028, 0x0121)
    QualityControlImage = Tag('Quality Control Image', "QualityControlImage", 0x0028, 0x0300)
    BurnedInAnnotation = Tag('Burned In Annotation', "BurnedInAnnotation", 0x0028, 0x0301)
    RecognizableVisualFeatures = Tag('Recognizable Visual Features', "RecognizableVisualFeatures", 0x0028, 0x0302)
    LongitudinalTemporalInformationModified = Tag('Longitudinal Temporal Information Modified', "LongitudinalTemporalInformationModified", 0x0028, 0x0303)
    PixelSpacingCalibrationType = Tag('Pixel Spacing Calibration Type', "PixelSpacingCalibrationType", 0x0028, 0x0A02)
    PixelSpacingCalibrationDescription = Tag('Pixel Spacing Calibration Description', "PixelSpacingCalibrationDescription", 0x0028, 0x0A04)
    PixelIntensityRelationship = Tag('Pixel Intensity Relationship', "PixelIntensityRelationship", 0x0028, 0x1040, [TagLink(FramePixelDataPropertiesSequence),])
    PixelIntensityRelationshipSign = Tag('Pixel Intensity Relationship Sign', "PixelIntensityRelationshipSign", 0x0028, 0x1041, [TagLink(FramePixelDataPropertiesSequence),])
    FrameVOILUTSequence = Tag('Frame VOI LUT Sequence', "FrameVOILUTSequence", 0x0028, 0x9132, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    VolumetricPresentationStateInputSequence = Tag('Volumetric Presentation State Input Sequence', "VolumetricPresentationStateInputSequence", 0x0070, 0x1201)
    WindowCenter = Tag('Window Center', "WindowCenter", 0x0028, 0x1050, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),TagLink(ReconstructionProtocolElementSequence),])
    WindowWidth = Tag('Window Width', "WindowWidth", 0x0028, 0x1051, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),TagLink(ReconstructionProtocolElementSequence),])
    PixelValueTransformationSequence = Tag('Pixel Value Transformation Sequence', "PixelValueTransformationSequence", 0x0028, 0x9145, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    RescaleIntercept = Tag('Rescale Intercept', "RescaleIntercept", 0x0028, 0x1052, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    RescaleSlope = Tag('Rescale Slope', "RescaleSlope", 0x0028, 0x1053, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    RescaleType = Tag('Rescale Type', "RescaleType", 0x0028, 0x1054, [TagLink(PixelValueTransformationSequence),TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    WindowCenterWidthExplanation = Tag('Window Center & Width Explanation', "WindowCenterWidthExplanation", 0x0028, 0x1055, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    VOILUTFunction = Tag('VOI LUT Function', "VOILUTFunction", 0x0028, 0x1056, [TagLink(FrameVOILUTSequence),TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    RecommendedViewingMode = Tag('Recommended Viewing Mode', "RecommendedViewingMode", 0x0028, 0x1090, [TagLink(FrameDisplaySequence),])
    EnhancedPaletteColorLookupTableSequence = Tag('Enhanced Palette Color Lookup Table Sequence', "EnhancedPaletteColorLookupTableSequence", 0x0028, 0x140B)
    PaletteColorLookupTableSequence = Tag('Palette Color Lookup Table Sequence', "PaletteColorLookupTableSequence", 0x0048, 0x0120, [TagLink(OpticalPathSequence),TagLink(AdvancedBlendingSequence),])
    VolumeStreamSequence = Tag('Volume Stream Sequence', "VolumeStreamSequence", 0x0070, 0x1A08)
    PresentationStateClassificationComponentSequence = Tag('Presentation State Classification Component Sequence', "PresentationStateClassificationComponentSequence", 0x0070, 0x1801, [TagLink(VolumeStreamSequence),])
    RedPaletteColorLookupTableDescriptor = Tag('Red Palette Color Lookup Table Descriptor', "RedPaletteColorLookupTableDescriptor", 0x0028, 0x1101, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    GreenPaletteColorLookupTableDescriptor = Tag('Green Palette Color Lookup Table Descriptor', "GreenPaletteColorLookupTableDescriptor", 0x0028, 0x1102, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    BluePaletteColorLookupTableDescriptor = Tag('Blue Palette Color Lookup Table Descriptor', "BluePaletteColorLookupTableDescriptor", 0x0028, 0x1103, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    RedPaletteColorLookupTableData = Tag('Red Palette Color Lookup Table Data', "RedPaletteColorLookupTableData", 0x0028, 0x1201, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    GreenPaletteColorLookupTableData = Tag('Green Palette Color Lookup Table Data', "GreenPaletteColorLookupTableData", 0x0028, 0x1202, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    BluePaletteColorLookupTableData = Tag('Blue Palette Color Lookup Table Data', "BluePaletteColorLookupTableData", 0x0028, 0x1203, [TagLink(EnhancedPaletteColorLookupTableSequence),TagLink(PaletteColorLookupTableSequence),TagLink(IconImageSequence),TagLink(PresentationStateClassificationComponentSequence),])
    StoredValueColorRangeSequence = Tag('Stored Value Color Range Sequence', "StoredValueColorRangeSequence", 0x0028, 0x1230, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    MinimumStoredValueMapped = Tag('Minimum Stored Value Mapped', "MinimumStoredValueMapped", 0x0028, 0x1231, [TagLink(StoredValueColorRangeSequence),])
    MaximumStoredValueMapped = Tag('Maximum Stored Value Mapped', "MaximumStoredValueMapped", 0x0028, 0x1232, [TagLink(StoredValueColorRangeSequence),])
    BreastImplantPresent = Tag('Breast Implant Present', "BreastImplantPresent", 0x0028, 0x1300)
    PartialView = Tag('Partial View', "PartialView", 0x0028, 0x1350)
    PartialViewDescription = Tag('Partial View Description', "PartialViewDescription", 0x0028, 0x1351)
    SpatialLocationsPreserved = Tag('Spatial Locations Preserved', "SpatialLocationsPreserved", 0x0028, 0x135A, [TagLink(SourceImageSequence),])
    ICCProfile = Tag('ICC Profile', "ICCProfile", 0x0028, 0x2000, [TagLink(OpticalPathSequence),TagLink(IconImageSequence),])
    ColorSpace = Tag('Color Space', "ColorSpace", 0x0028, 0x2002, [TagLink(OpticalPathSequence),TagLink(IconImageSequence),])
    LossyImageCompression = Tag('Lossy Image Compression', "LossyImageCompression", 0x0028, 0x2110, [TagLink(ContributingSourcesSequence),])
    LossyImageCompressionRatio = Tag('Lossy Image Compression Ratio', "LossyImageCompressionRatio", 0x0028, 0x2112, [TagLink(ContributingSourcesSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    LossyImageCompressionMethod = Tag('Lossy Image Compression Method', "LossyImageCompressionMethod", 0x0028, 0x2114, [TagLink(ContributingSourcesSequence),])
    ModalityLUTSequence = Tag('Modality LUT Sequence', "ModalityLUTSequence", 0x0028, 0x3000, [TagLink(BlendingSequence),TagLink(VariableModalityLUTSequence),])
    PixelIntensityRelationshipLUTSequence = Tag('Pixel Intensity Relationship LUT Sequence', "PixelIntensityRelationshipLUTSequence", 0x0028, 0x9422, [TagLink(MaskSubtractionSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    VOILUTSequence = Tag('VOI LUT Sequence', "VOILUTSequence", 0x0028, 0x3010, [TagLink(SoftcopyVOILUTSequence),TagLink(VolumetricPresentationStateInputSequence),])
    PresentationLUTSequence = Tag('Presentation LUT Sequence', "PresentationLUTSequence", 0x2050, 0x0010)
    PresentationStateCompositorComponentSequence = Tag('Presentation State Compositor Component Sequence', "PresentationStateCompositorComponentSequence", 0x0070, 0x1805)
    WeightingTransferFunctionSequence = Tag('Weighting Transfer Function Sequence', "WeightingTransferFunctionSequence", 0x0070, 0x1806, [TagLink(PresentationStateCompositorComponentSequence),])
    LUTDescriptor = Tag('LUT Descriptor', "LUTDescriptor", 0x0028, 0x3002, [TagLink(PixelIntensityRelationshipLUTSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(WeightingTransferFunctionSequence),])
    LUTExplanation = Tag('LUT Explanation', "LUTExplanation", 0x0028, 0x3003, [TagLink(RealWorldValueMappingSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    ModalityLUTType = Tag('Modality LUT Type', "ModalityLUTType", 0x0028, 0x3004, [TagLink(ModalityLUTSequence),])
    LUTData = Tag('LUT Data', "LUTData", 0x0028, 0x3006, [TagLink(PixelIntensityRelationshipLUTSequence),TagLink(VOILUTSequence),TagLink(ModalityLUTSequence),TagLink(PresentationLUTSequence),TagLink(WeightingTransferFunctionSequence),])
    RepresentativeFrameNumber = Tag('Representative Frame Number', "RepresentativeFrameNumber", 0x0028, 0x6010)
    FrameNumbersOfInterest = Tag('Frame Numbers of Interest (FOI)', "FrameNumbersOfInterest", 0x0028, 0x6020)
    FrameOfInterestDescription = Tag('Frame of Interest Description', "FrameOfInterestDescription", 0x0028, 0x6022)
    FrameOfInterestType = Tag('Frame of Interest Type', "FrameOfInterestType", 0x0028, 0x6023)
    RWavePointer = Tag('R Wave Pointer', "RWavePointer", 0x0028, 0x6040)
    MaskOperation = Tag('Mask Operation', "MaskOperation", 0x0028, 0x6101, [TagLink(MaskSubtractionSequence),])
    ApplicableFrameRange = Tag('Applicable Frame Range', "ApplicableFrameRange", 0x0028, 0x6102, [TagLink(MaskSubtractionSequence),])
    MaskFrameNumbers = Tag('Mask Frame Numbers', "MaskFrameNumbers", 0x0028, 0x6110, [TagLink(MaskSubtractionSequence),])
    ContrastFrameAveraging = Tag('Contrast Frame Averaging', "ContrastFrameAveraging", 0x0028, 0x6112, [TagLink(MaskSubtractionSequence),])
    FramePixelShiftSequence = Tag('Frame Pixel Shift Sequence', "FramePixelShiftSequence", 0x0028, 0x9415, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    PixelShiftSequence = Tag('Pixel Shift Sequence', "PixelShiftSequence", 0x0028, 0x9501, [TagLink(MaskSubtractionSequence),])
    RegionPixelShiftSequence = Tag('Region Pixel Shift Sequence', "RegionPixelShiftSequence", 0x0028, 0x9502, [TagLink(PixelShiftSequence),])
    MaskSubPixelShift = Tag('Mask Sub-pixel Shift', "MaskSubPixelShift", 0x0028, 0x6114, [TagLink(MaskSubtractionSequence),TagLink(FramePixelShiftSequence),TagLink(RegionPixelShiftSequence),])
    TIDOffset = Tag('TID Offset', "TIDOffset", 0x0028, 0x6120, [TagLink(MaskSubtractionSequence),])
    MaskOperationExplanation = Tag('Mask Operation Explanation', "MaskOperationExplanation", 0x0028, 0x6190, [TagLink(MaskSubtractionSequence),])
    PixelDataProviderURL = Tag('Pixel Data Provider URL', "PixelDataProviderURL", 0x0028, 0x7FE0)
    DisplayFilterPercentage = Tag('Display Filter Percentage', "DisplayFilterPercentage", 0x0028, 0x9411, [TagLink(FrameDisplaySequence),])
    SubtractionItemID = Tag('Subtraction Item ID', "SubtractionItemID", 0x0028, 0x9416, [TagLink(MaskSubtractionSequence),TagLink(FramePixelShiftSequence),])
    GeometricalProperties = Tag('Geometrical Properties', "GeometricalProperties", 0x0028, 0x9444, [TagLink(FramePixelDataPropertiesSequence),])
    GeometricMaximumDistortion = Tag('Geometric Maximum Distortion', "GeometricMaximumDistortion", 0x0028, 0x9445, [TagLink(FramePixelDataPropertiesSequence),])
    ImageProcessingApplied = Tag('Image Processing Applied', "ImageProcessingApplied", 0x0028, 0x9446, [TagLink(FramePixelDataPropertiesSequence),])
    MaskSelectionMode = Tag('Mask Selection Mode', "MaskSelectionMode", 0x0028, 0x9454, [TagLink(MaskSubtractionSequence),])
    LUTFunction = Tag('LUT Function', "LUTFunction", 0x0028, 0x9474, [TagLink(PixelIntensityRelationshipLUTSequence),])
    MaskVisibilityPercentage = Tag('Mask Visibility Percentage', "MaskVisibilityPercentage", 0x0028, 0x9478, [TagLink(FrameDisplaySequence),TagLink(ReconstructionProtocolElementSequence),])
    RequestingService = Tag('Requesting Service', "RequestingService", 0x0032, 0x1033)
    RequestedProcedureDescription = Tag('Requested Procedure Description', "RequestedProcedureDescription", 0x0032, 0x1060, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    ReasonForVisit = Tag('Reason for Visit', "ReasonForVisit", 0x0032, 0x1066)
    TimeOfFrameGroupSequence = Tag('Time of Frame Group Sequence', "TimeOfFrameGroupSequence", 0x0034, 0x000D, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    FrameOriginTimestamp = Tag('Frame Origin Timestamp', "FrameOriginTimestamp", 0x0034, 0x0007, [TagLink(TimeOfFrameGroupSequence),])
    FrameUsefulnessGroupSequence = Tag('Frame Usefulness Group Sequence', "FrameUsefulnessGroupSequence", 0x0034, 0x0009, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    CameraPositionGroupSequence = Tag('Camera Position Group Sequence', "CameraPositionGroupSequence", 0x0034, 0x000B, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    AdmissionID = Tag('Admission ID', "AdmissionID", 0x0038, 0x0010)
    IssuerOfAdmissionIDSequence = Tag('Issuer of Admission ID Sequence', "IssuerOfAdmissionIDSequence", 0x0038, 0x0014)
    ServiceEpisodeID = Tag('Service Episode ID', "ServiceEpisodeID", 0x0038, 0x0060)
    ServiceEpisodeDescription = Tag('Service Episode Description', "ServiceEpisodeDescription", 0x0038, 0x0062)
    IssuerOfServiceEpisodeIDSequence = Tag('Issuer of Service Episode ID Sequence', "IssuerOfServiceEpisodeIDSequence", 0x0038, 0x0064)
    PertinentResourcesSequence = Tag('Pertinent Resources Sequence', "PertinentResourcesSequence", 0x0038, 0x0101)
    PatientState = Tag('Patient State', "PatientState", 0x0038, 0x0500)
    WaveformMontageSequence = Tag('Waveform Montage Sequence', "WaveformMontageSequence", 0x0040, 0xB039)
    WaveformPresentationGroupSequence = Tag('Waveform Presentation Group Sequence', "WaveformPresentationGroupSequence", 0x003A, 0x0240, [TagLink(WaveformMontageSequence),])
    ChannelDisplaySequence = Tag('Channel Display Sequence', "ChannelDisplaySequence", 0x003A, 0x0242, [TagLink(WaveformPresentationGroupSequence),])
    ChannelIdentificationCode = Tag('Channel Identification Code', "ChannelIdentificationCode", 0x003A, 0x0301, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),])
    ChannelMode = Tag('Channel Mode', "ChannelMode", 0x003A, 0x0302, [TagLink(MultiplexedAudioChannelsDescriptionCodeSequence),])
    ScheduledProcedureStepDescription = Tag('Scheduled Procedure Step Description', "ScheduledProcedureStepDescription", 0x0040, 0x0007, [TagLink(RequestAttributesSequence),])
    ScheduledProcedureStepID = Tag('Scheduled Procedure Step ID', "ScheduledProcedureStepID", 0x0040, 0x0009, [TagLink(RequestAttributesSequence),])
    OrderPlacerIdentifierSequence = Tag('Order Placer Identifier Sequence', "OrderPlacerIdentifierSequence", 0x0040, 0x0026, [TagLink(ReferencedRequestSequence),])
    OrderFillerIdentifierSequence = Tag('Order Filler Identifier Sequence', "OrderFillerIdentifierSequence", 0x0040, 0x0027, [TagLink(ReferencedRequestSequence),])
    AssigningFacilitySequence = Tag('Assigning Facility Sequence', "AssigningFacilitySequence", 0x0040, 0x0036, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    AlternateContainerIdentifierSequence = Tag('Alternate Container Identifier Sequence', "AlternateContainerIdentifierSequence", 0x0040, 0x0515)
    IssuerOfTheContainerIdentifierSequence = Tag('Issuer of the Container Identifier Sequence', "IssuerOfTheContainerIdentifierSequence", 0x0040, 0x0513, [TagLink(AlternateContainerIdentifierSequence),])
    IssuerOfTheSpecimenIdentifierSequence = Tag('Issuer of the Specimen Identifier Sequence', "IssuerOfTheSpecimenIdentifierSequence", 0x0040, 0x0562, [TagLink(SpecimenDescriptionSequence),])
    LocalNamespaceEntityID = Tag('Local Namespace Entity ID', "LocalNamespaceEntityID", 0x0040, 0x0031, [TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    UniversalEntityID = Tag('Universal Entity ID', "UniversalEntityID", 0x0040, 0x0032, [TagLink(IssuerOfPatientIDQualifiersSequence),TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    UniversalEntityIDType = Tag('Universal Entity ID Type', "UniversalEntityIDType", 0x0040, 0x0033, [TagLink(IssuerOfPatientIDQualifiersSequence),TagLink(AssigningFacilitySequence),TagLink(IssuerOfAccessionNumberSequence),TagLink(IssuerOfAdmissionIDSequence),TagLink(IssuerOfServiceEpisodeIDSequence),TagLink(IssuerOfTheContainerIdentifierSequence),TagLink(IssuerOfTheSpecimenIdentifierSequence),TagLink(OrderPlacerIdentifierSequence),TagLink(OrderFillerIdentifierSequence),])
    IdentifierTypeCode = Tag('Identifier Type Code', "IdentifierTypeCode", 0x0040, 0x0035, [TagLink(IssuerOfPatientIDQualifiersSequence),])
    PerformedProcedureStepStartDate = Tag('Performed Procedure Step Start Date', "PerformedProcedureStepStartDate", 0x0040, 0x0244)
    PerformedProcedureStepStartTime = Tag('Performed Procedure Step Start Time', "PerformedProcedureStepStartTime", 0x0040, 0x0245)
    PerformedProcedureStepEndDate = Tag('Performed Procedure Step End Date', "PerformedProcedureStepEndDate", 0x0040, 0x0250)
    PerformedProcedureStepEndTime = Tag('Performed Procedure Step End Time', "PerformedProcedureStepEndTime", 0x0040, 0x0251)
    PerformedProcedureStepID = Tag('Performed Procedure Step ID', "PerformedProcedureStepID", 0x0040, 0x0253)
    PerformedProcedureStepDescription = Tag('Performed Procedure Step Description', "PerformedProcedureStepDescription", 0x0040, 0x0254)
    CommentsOnThePerformedProcedureStep = Tag('Comments on the Performed Procedure Step', "CommentsOnThePerformedProcedureStep", 0x0040, 0x0280)
    EntranceDose = Tag('Entrance Dose', "EntranceDose", 0x0040, 0x0302)
    ExposedArea = Tag('Exposed Area', "ExposedArea", 0x0040, 0x0303)
    DistanceSourceToEntrance = Tag('Distance Source to Entrance', "DistanceSourceToEntrance", 0x0040, 0x0306, [TagLink(XRayGeometrySequence),])
    CommentsOnRadiationDose = Tag('Comments on Radiation Dose', "CommentsOnRadiationDose", 0x0040, 0x0310)
    XRayOutput = Tag('X-Ray Output', "XRayOutput", 0x0040, 0x0312)
    HalfValueLayer = Tag('Half Value Layer', "HalfValueLayer", 0x0040, 0x0314, [TagLink(XRay3DAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    OrganDose = Tag('Organ Dose', "OrganDose", 0x0040, 0x0316, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    OrganExposed = Tag('Organ Exposed', "OrganExposed", 0x0040, 0x0318)
    ContainerIdentifier = Tag('Container Identifier', "ContainerIdentifier", 0x0040, 0x0512, [TagLink(AlternateContainerIdentifierSequence),TagLink(InventoriedInstancesSequence),])
    ContainerDescription = Tag('Container Description', "ContainerDescription", 0x0040, 0x051A)
    SpecimenIdentifier = Tag('Specimen Identifier', "SpecimenIdentifier", 0x0040, 0x0551, [TagLink(SpecimenDescriptionSequence),])
    SpecimenReferenceSequence = Tag('Specimen Reference Sequence', "SpecimenReferenceSequence", 0x0048, 0x0110, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    SpecimenUID = Tag('Specimen UID', "SpecimenUID", 0x0040, 0x0554, [TagLink(SpecimenDescriptionSequence),TagLink(SpecimenReferenceSequence),])
    AcquisitionContextDescription = Tag('Acquisition Context Description', "AcquisitionContextDescription", 0x0040, 0x0556)
    SpecimenShortDescription = Tag('Specimen Short Description', "SpecimenShortDescription", 0x0040, 0x0600, [TagLink(SpecimenDescriptionSequence),])
    SpecimenDetailedDescription = Tag('Specimen Detailed Description', "SpecimenDetailedDescription", 0x0040, 0x0602, [TagLink(SpecimenDescriptionSequence),])
    RequestedProcedureID = Tag('Requested Procedure ID', "RequestedProcedureID", 0x0040, 0x1001, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    ReasonForTheRequestedProcedure = Tag('Reason for the Requested Procedure', "ReasonForTheRequestedProcedure", 0x0040, 0x1002, [TagLink(RequestAttributesSequence),TagLink(ReferencedRequestSequence),])
    PersonAddress = Tag("Person's Address", "PersonAddress", 0x0040, 0x1102, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    PersonTelephoneNumbers = Tag("Person's Telephone Numbers", "PersonTelephoneNumbers", 0x0040, 0x1103, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    PersonTelecomInformation = Tag("Person's Telecom Information", "PersonTelecomInformation", 0x0040, 0x1104, [TagLink(ContentCreatorIdentificationCodeSequence),TagLink(OperatorIdentificationSequence),TagLink(ReferringPhysicianIdentificationSequence),TagLink(ConsultingPhysicianIdentificationSequence),TagLink(PhysiciansOfRecordIdentificationSequence),TagLink(PhysiciansReadingStudyIdentificationSequence),TagLink(PerformingPhysicianIdentificationSequence),TagLink(InterlockResolutionUserSequence),])
    XDSStorageSequence = Tag('XDS Storage Sequence', "XDSStorageSequence", 0x0040, 0x4074, [TagLink(OutputInformationSequence),])
    EntranceDoseInmGy = Tag('Entrance Dose in mGy', "EntranceDoseInmGy", 0x0040, 0x8302, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    EntranceDoseDerivation = Tag('Entrance Dose Derivation', "EntranceDoseDerivation", 0x0040, 0x8303, [TagLink(XRay3DAcquisitionSequence),TagLink(PerProjectionAcquisitionSequence),TagLink(XRayAcquisitionDoseSequence),])
    LUTLabel = Tag('LUT Label', "LUTLabel", 0x0040, 0x9210, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueLastValueMapped = Tag('Real World Value Last Value Mapped', "RealWorldValueLastValueMapped", 0x0040, 0x9211, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueLUTData = Tag('Real World Value LUT Data', "RealWorldValueLUTData", 0x0040, 0x9212, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DoubleFloatRealWorldValueLastValueMapped = Tag('Double Float Real World Value Last Value Mapped', "DoubleFloatRealWorldValueLastValueMapped", 0x0040, 0x9213, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    DoubleFloatRealWorldValueFirstValueMapped = Tag('Double Float Real World Value First Value Mapped', "DoubleFloatRealWorldValueFirstValueMapped", 0x0040, 0x9214, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueFirstValueMapped = Tag('Real World Value First Value Mapped', "RealWorldValueFirstValueMapped", 0x0040, 0x9216, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueIntercept = Tag('Real World Value Intercept', "RealWorldValueIntercept", 0x0040, 0x9224, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    RealWorldValueSlope = Tag('Real World Value Slope', "RealWorldValueSlope", 0x0040, 0x9225, [TagLink(RealWorldValueMappingSequence),TagLink(PerFrameFunctionalGroupsSequence, True),])
    ObservationDateTime = Tag('Observation DateTime', "ObservationDateTime", 0x0040, 0xA032, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),TagLink(InventoriedInstancesSequence),])
    ObservationStartDateTime = Tag('Observation Start DateTime', "ObservationStartDateTime", 0x0040, 0xA033, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ValueType = Tag('Value Type', "ValueType", 0x0040, 0xA040, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    ReferencedWaveformChannels = Tag('Referenced Waveform Channels', "ReferencedWaveformChannels", 0x0040, 0xA0B0, [TagLink(ReferencedSOPSequence),TagLink(SourceWaveformSequence),TagLink(ChannelDisplaySequence),TagLink(WaveformAnnotationSequence),TagLink(ReferencedWaveformSequence),])
    DateTime = Tag('DateTime', "DateTime", 0x0040, 0xA120, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    Date = Tag('Date', "Date", 0x0040, 0xA121, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    Time = Tag('Time', "Time", 0x0040, 0xA122, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    PersonName = Tag('Person Name', "PersonName", 0x0040, 0xA123, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(AssessmentRequesterSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(AuthorIdentificationSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(OperatorIdentificationSequence),TagLink(AlternateValueSequence),TagLink(AsserterIdentificationSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    UID = Tag('UID', "UID", 0x0040, 0xA124, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    TextValue = Tag('Text Value', "TextValue", 0x0040, 0xA160, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(ContentSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    FloatingPointValue = Tag('Floating Point Value', "FloatingPointValue", 0x0040, 0xA161, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    RationalNumeratorValue = Tag('Rational Numerator Value', "RationalNumeratorValue", 0x0040, 0xA162, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    RationalDenominatorValue = Tag('Rational Denominator Value', "RationalDenominatorValue", 0x0040, 0xA163, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(DataObservationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    NumericValue = Tag('Numeric Value', "NumericValue", 0x0040, 0xA30A, [TagLink(ContentItemModifierSequence),TagLink(ProtocolContextSequence),TagLink(PatientSupportPositionParameterSequence),TagLink(AcquisitionContextSequence),TagLink(QuantityDefinitionSequence),TagLink(SpecimenPreparationStepContentItemSequence),TagLink(SpecimenLocalizationContentItemSequence),TagLink(RadiationDeviceConfigurationAndCommissioningKeySequence),TagLink(PerformedProcessingParametersSequence),TagLink(WideFieldOphthalmicPhotographyQualityRatingSequence),TagLink(OphthalmicEnFaceImageQualityRatingSequence),TagLink(LensConstantSequence),TagLink(DataObservationSequence),TagLink(OphthalmicThicknessMapQualityRatingSequence),TagLink(WaveformAnnotationSequence),TagLink(MeasuredValueSequence),TagLink(DosimetricObjectiveParameterSequence),TagLink(PatientSupportPositionToleranceSequence),TagLink(PatientTreatmentPreparationProcedureParameterSequence),TagLink(DevicePositionParameterSequence),TagLink(PrescriptionNotesSequence),TagLink(SegmentCharacteristicsSequence),TagLink(AlternateValueSequence),TagLink(AcquisitionInitiationSequence),TagLink(DeviceSpecificAcquisitionParameterSequence),])
    HL7InstanceIdentifier = Tag('HL7 Instance Identifier', "HL7InstanceIdentifier", 0x0040, 0xE001, [TagLink(ReferencedSOPSequence),TagLink(PertinentDocumentsSequence),TagLink(HL7StructuredDocumentReferenceSequence),])
    WADORetrievalSequence = Tag('WADO Retrieval Sequence', "WADORetrievalSequence", 0x0040, 0xE023, [TagLink(ReferencedPatientPhotoSequence),])
    RetrieveURI = Tag('Retrieve URI', "RetrieveURI", 0x0040, 0xE010, [TagLink(WADORetrievalSequence),TagLink(PertinentDocumentsSequence),TagLink(HL7StructuredDocumentReferenceSequence),TagLink(PrivateDataElementDefinitionSequence),TagLink(PertinentResourcesSequence),])
    RetrieveLocationUID = Tag('Retrieve Location UID', "RetrieveLocationUID", 0x0040, 0xE011)
    TypeOfInstances = Tag('Type of Instances', "TypeOfInstances", 0x0040, 0xE020, [TagLink(ReferencedPatientPhotoSequence),])
    DICOMMediaRetrievalSequence = Tag('DICOM Media Retrieval Sequence', "DICOMMediaRetrievalSequence", 0x0040, 0xE022, [TagLink(ReferencedPatientPhotoSequence),])
    XDSRetrievalSequence = Tag('XDS Retrieval Sequence', "XDSRetrievalSequence", 0x0040, 0xE024, [TagLink(ReferencedPatientPhotoSequence),])
    RepositoryUniqueID = Tag('Repository Unique ID', "RepositoryUniqueID", 0x0040, 0xE030, [TagLink(XDSRetrievalSequence),TagLink(XDSStorageSequence),])
    HomeCommunityID = Tag('Home Community ID', "HomeCommunityID", 0x0040, 0xE031, [TagLink(XDSRetrievalSequence),TagLink(XDSStorageSequence),])
    CalibrationImage = Tag('Calibration Image', "CalibrationImage", 0x0050, 0x0004, [TagLink(CalibrationSequence),])
    ContainerComponentThickness = Tag('Container Component Thickness', "ContainerComponentThickness", 0x0050, 0x0013, [TagLink(ContainerComponentSequence),])
    DeviceLength = Tag('Device Length', "DeviceLength", 0x0050, 0x0014, [TagLink(DeviceSequence),])
    ContainerComponentWidth = Tag('Container Component Width', "ContainerComponentWidth", 0x0050, 0x0015, [TagLink(ContainerComponentSequence),])
    DeviceDiameter = Tag('Device Diameter', "DeviceDiameter", 0x0050, 0x0016, [TagLink(DeviceSequence),])
    DeviceDiameterUnits = Tag('Device Diameter Units', "DeviceDiameterUnits", 0x0050, 0x0017, [TagLink(DeviceSequence),])
    DeviceVolume = Tag('Device Volume', "DeviceVolume", 0x0050, 0x0018, [TagLink(DeviceSequence),])
    InterMarkerDistance = Tag('Inter-Marker Distance', "InterMarkerDistance", 0x0050, 0x0019, [TagLink(DeviceSequence),])
    ContainerComponentMaterial = Tag('Container Component Material', "ContainerComponentMaterial", 0x0050, 0x001A, [TagLink(ContainerComponentSequence),])
    ContainerComponentID = Tag('Container Component ID', "ContainerComponentID", 0x0050, 0x001B, [TagLink(ContainerComponentSequence),])
    ContainerComponentLength = Tag('Container Component Length', "ContainerComponentLength", 0x0050, 0x001C, [TagLink(ContainerComponentSequence),])
    ContainerComponentDiameter = Tag('Container Component Diameter', "ContainerComponentDiameter", 0x0050, 0x001D, [TagLink(ContainerComponentSequence),])
    ContainerComponentDescription = Tag('Container Component Description', "ContainerComponentDescription", 0x0050, 0x001E, [TagLink(ContainerComponentSequence),])
    DeviceDescription = Tag('Device Description', "DeviceDescription", 0x0050, 0x0020, [TagLink(UDISequence),TagLink(DeviceSequence),])
    ContrastBolusIngredientPercentByVolume = Tag('Contrast/Bolus Ingredient Percent by Volume', "ContrastBolusIngredientPercentByVolume", 0x0052, 0x0001, [TagLink(ContrastBolusAgentSequence),])
    SegmentIdentificationSequence = Tag('Segment Identification Sequence', "SegmentIdentificationSequence", 0x0062, 0x000A, [TagLink(PerFrameFunctionalGroupsSequence, True),])
    ReferencedSegmentNumber = Tag('Referenced Segment Number', "ReferencedSegmentNumber", 0x0062, 0x000B, [TagLink(ReferencedSOPSequence),TagLink(ReferencedImageSequence),TagLink(SourceImageSequence),TagLink(ConversionSourceAttributesSequence),TagLink(ContourImageSequence),TagLink(DefinitionSourceSequence),TagLink(ReferencedSetupImageSequence),TagLink(ReferencedInstanceSequence),TagLink(OphthalmicFrameLocationSequence),TagLink(ReferencedSegmentationSequence),TagLink(LeftImageSequence),TagLink(RightImageSequence),TagLink(ReferencedOtherPlaneSequence),TagLink(SegmentIdentificationSequence),TagLink(SegmentSurfaceSourceInstanceSequence),TagLink(ReferencedFirstFrameSequence),TagLink(RenderedImageReferenceSequence),TagLink(UsedSegmentsSequence),TagLink(ReferencedTextureSequence),TagLink(DirectSegmentReferenceSequence),])
    RenderProjection = Tag('Render Projection', "RenderProjection", 0x0070, 0x1602, [TagLink(CameraPositionGroupSequence),])
    ViewpointPosition = Tag('Viewpoint Position', "ViewpointPosition", 0x0070, 0x1603, [TagLink(CameraPositionGroupSequence),])
    ViewpointLookAtPoint = Tag('Viewpoint LookAt Point', "ViewpointLookAtPoint", 0x0070, 0x1604, [TagLink(CameraPositionGroupSequence),])
    ViewpointUpDirection = Tag('Viewpoint Up Direction', "ViewpointUpDirection", 0x0070, 0x1605, [TagLink(CameraPositionGroupSequence),])
    RenderFieldOfView = Tag('Render Field of View', "RenderFieldOfView", 0x0070, 0x1606, [TagLink(CameraPositionGroupSequence),])
    ImageSetSelectorSequence = Tag('Image Set Selector Sequence', "ImageSetSelectorSequence", 0x0072, 0x0022, [TagLink(ImageSetsSequence),])
    FilterOperationsSequence = Tag('Filter Operations Sequence', "FilterOperationsSequence", 0x0072, 0x0400, [TagLink(DisplaySetsSequence),])
    OriginalAttributesSequence = Tag('Original Attributes Sequence', "OriginalAttributesSequence", 0x0400, 0x0561, [TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    NonconformingModifiedAttributesSequence = Tag('Nonconforming Modified Attributes Sequence', "NonconformingModifiedAttributesSequence", 0x0400, 0x0551, [TagLink(OriginalAttributesSequence),])
    SortingOperationsSequence = Tag('Sorting Operations Sequence', "SortingOperationsSequence", 0x0072, 0x0600, [TagLink(DisplaySetsSequence),])
    AttributeToleranceValuesSequence = Tag('Attribute Tolerance Values Sequence', "AttributeToleranceValuesSequence", 0x300A, 0x062B)
    TreatmentToleranceViolationAttributeSequence = Tag('Treatment Tolerance Violation Attribute Sequence', "TreatmentToleranceViolationAttributeSequence", 0x300A, 0x0733, [TagLink(TreatmentToleranceViolationSequence),])
    SelectorAttribute = Tag('Selector Attribute', "SelectorAttribute", 0x0072, 0x0026, [TagLink(NonconformingModifiedAttributesSequence),TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),TagLink(SortingOperationsSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorValueNumber = Tag('Selector Value Number', "SelectorValueNumber", 0x0072, 0x0028, [TagLink(NonconformingModifiedAttributesSequence),TagLink(ImageSetSelectorSequence),TagLink(FilterOperationsSequence),TagLink(SortingOperationsSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorSequencePointer = Tag('Selector Sequence Pointer', "SelectorSequencePointer", 0x0072, 0x0052, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorSequencePointerPrivateCreator = Tag('Selector Sequence Pointer Private Creator', "SelectorSequencePointerPrivateCreator", 0x0072, 0x0054, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorAttributePrivateCreator = Tag('Selector Attribute Private Creator', "SelectorAttributePrivateCreator", 0x0072, 0x0056, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    SelectorSequencePointerItems = Tag('Selector Sequence Pointer Items', "SelectorSequencePointerItems", 0x0074, 0x1057, [TagLink(NonconformingModifiedAttributesSequence),TagLink(StructuredConstraintObservationSequence),TagLink(PatientSpecificationSequence),TagLink(ParametersSpecificationSequence),TagLink(AttributeToleranceValuesSequence),TagLink(TreatmentToleranceViolationAttributeSequence),])
    StorageMediaFileSetID = Tag('Storage Media File-set ID', "StorageMediaFileSetID", 0x0088, 0x0130, [TagLink(DICOMMediaRetrievalSequence),TagLink(InventoriedStudiesSequence),TagLink(InventoriedSeriesSequence),TagLink(InventoriedInstancesSequence),])
    StorageMediaFileSetUID = Tag('Storage Media File-set UID', "StorageMediaFileSetUID", 0x0088, 0x0140, [TagLink(DICOMMediaRetrievalSequence),])
    SOPInstanceStatus = Tag('SOP Instance Status', "SOPInstanceStatus", 0x0100, 0x0410)
    SOPAuthorizationDateTime = Tag('SOP Authorization DateTime', "SOPAuthorizationDateTime", 0x0100, 0x0420)
    SOPAuthorizationComment = Tag('SOP Authorization Comment', "SOPAuthorizationComment", 0x0100, 0x0424)
    AuthorizationEquipmentCertificationNumber = Tag('Authorization Equipment Certification Number', "AuthorizationEquipmentCertificationNumber", 0x0100, 0x0426)
    MACParametersSequence = Tag('MAC Parameters Sequence', "MACParametersSequence", 0x4FFE, 0x0001)
    MACIDNumber = Tag('MAC ID Number', "MACIDNumber", 0x0400, 0x0005, [TagLink(MACParametersSequence),TagLink(DigitalSignaturesSequence),])
    ReferencedSOPInstanceMACSequence = Tag('Referenced SOP Instance MAC Sequence', "ReferencedSOPInstanceMACSequence", 0x0400, 0x0403, [TagLink(ReferencedSOPSequence),])
    MACCalculationTransferSyntaxUID = Tag('MAC Calculation Transfer Syntax UID', "MACCalculationTransferSyntaxUID", 0x0400, 0x0010, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),])
    MACAlgorithm = Tag('MAC Algorithm', "MACAlgorithm", 0x0400, 0x0015, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    DataElementsSigned = Tag('Data Elements Signed', "DataElementsSigned", 0x0400, 0x0020, [TagLink(MACParametersSequence),TagLink(ReferencedSOPInstanceMACSequence),])
    ReferencedDigitalSignatureSequence = Tag('Referenced Digital Signature Sequence', "ReferencedDigitalSignatureSequence", 0x0400, 0x0402, [TagLink(ReferencedSOPSequence),])
    DigitalSignatureUID = Tag('Digital Signature UID', "DigitalSignatureUID", 0x0400, 0x0100, [TagLink(DigitalSignaturesSequence),TagLink(ReferencedDigitalSignatureSequence),])
    DigitalSignatureDateTime = Tag('Digital Signature DateTime', "DigitalSignatureDateTime", 0x0400, 0x0105, [TagLink(DigitalSignaturesSequence),])
    CertificateType = Tag('Certificate Type', "CertificateType", 0x0400, 0x0110, [TagLink(DigitalSignaturesSequence),])
    CertificateOfSigner = Tag('Certificate of Signer', "CertificateOfSigner", 0x0400, 0x0115, [TagLink(DigitalSignaturesSequence),])
    Signature = Tag('Signature', "Signature", 0x0400, 0x0120, [TagLink(DigitalSignaturesSequence),TagLink(ReferencedDigitalSignatureSequence),])
    CertifiedTimestampType = Tag('Certified Timestamp Type', "CertifiedTimestampType", 0x0400, 0x0305, [TagLink(DigitalSignaturesSequence),])
    CertifiedTimestamp = Tag('Certified Timestamp', "CertifiedTimestamp", 0x0400, 0x0310, [TagLink(DigitalSignaturesSequence),])
    MAC = Tag('MAC', "MAC", 0x0400, 0x0404, [TagLink(ReferencedSOPInstanceMACSequence),TagLink(IncorporatedInventoryInstanceSequence),])
    EncryptedAttributesSequence = Tag('Encrypted Attributes Sequence', "EncryptedAttributesSequence", 0x0400, 0x0500)
    EncryptedContentTransferSyntaxUID = Tag('Encrypted Content Transfer Syntax UID', "EncryptedContentTransferSyntaxUID", 0x0400, 0x0510, [TagLink(EncryptedAttributesSequence),])
    EncryptedContent = Tag('Encrypted Content', "EncryptedContent", 0x0400, 0x0520, [TagLink(EncryptedAttributesSequence),])
    ModifiedAttributesSequence = Tag('Modified Attributes Sequence', "ModifiedAttributesSequence", 0x0400, 0x0550, [TagLink(OriginalAttributesSequence),])
    NonconformingDataElementValue = Tag('Nonconforming Data Element Value', "NonconformingDataElementValue", 0x0400, 0x0552, [TagLink(NonconformingModifiedAttributesSequence),])
    AttributeModificationDateTime = Tag('Attribute Modification DateTime', "AttributeModificationDateTime", 0x0400, 0x0562, [TagLink(OriginalAttributesSequence),])
    ModifyingSystem = Tag('Modifying System', "ModifyingSystem", 0x0400, 0x0563, [TagLink(OriginalAttributesSequence),])
    SourceOfPreviousValues = Tag('Source of Previous Values', "SourceOfPreviousValues", 0x0400, 0x0564, [TagLink(OriginalAttributesSequence),])
    ReasonForTheAttributeModification = Tag('Reason for the Attribute Modification', "ReasonForTheAttributeModification", 0x0400, 0x0565, [TagLink(OriginalAttributesSequence),])
    InstanceOriginStatus = Tag('Instance Origin Status', "InstanceOriginStatus", 0x0400, 0x0600)
    PresentationLUTShape = Tag('Presentation LUT Shape', "PresentationLUTShape", 0x2050, 0x0020)
    BarcodeValue = Tag('Barcode Value', "BarcodeValue", 0x2200, 0x0005)
    TableTopVerticalPosition = Tag('Table Top Vertical Position', "TableTopVerticalPosition", 0x300A, 0x0128, [TagLink(ExposureSequence),TagLink(ControlPointSequence),TagLink(ControlPointDeliverySequence),TagLink(IonControlPointSequence),TagLink(IonControlPointDeliverySequence),TagLink(TablePositionSequence),])
    TableTopLongitudinalPosition = Tag('Table Top Longitudinal Position', "TableTopLongitudinalPosition", 0x300A, 0x0129, [TagLink(ExposureSequence),TagLink(ControlPointSequence),TagLink(ControlPointDeliverySequence),TagLink(IonControlPointSequence),TagLink(IonControlPointDeliverySequence),TagLink(TablePositionSequence),])
    TableTopLateralPosition = Tag('Table Top Lateral Position', "TableTopLateralPosition", 0x300A, 0x012A, [TagLink(ExposureSequence),TagLink(ControlPointSequence),TagLink(ControlPointDeliverySequence),TagLink(IonControlPointSequence),TagLink(IonControlPointDeliverySequence),TagLink(TablePositionSequence),])
    TreatmentSessionUID = Tag('Treatment Session UID', "TreatmentSessionUID", 0x300A, 0x0700)
    SharedFunctionalGroupsSequence = Tag('Shared Functional Groups Sequence', "SharedFunctionalGroupsSequence", 0x5200, 0x9229)
    OverlayRows = Tag('Overlay Rows', "OverlayRows", 0x6000, 0x0010, [], [(0x6002, 0x0010),(0x6004, 0x0010),(0x6006, 0x0010),(0x6008, 0x0010),(0x600A, 0x0010),(0x600C, 0x0010),(0x600E, 0x0010),(0x6010, 0x0010),(0x6012, 0x0010),(0x6014, 0x0010),(0x6016, 0x0010),(0x6018, 0x0010),(0x601A, 0x0010),(0x601C, 0x0010),(0x601E, 0x0010),(0x6020, 0x0010),(0x6022, 0x0010),(0x6024, 0x0010),(0x6026, 0x0010),(0x6028, 0x0010),(0x602A, 0x0010),(0x602C, 0x0010),(0x602E, 0x0010),(0x6030, 0x0010),(0x6032, 0x0010),(0x6034, 0x0010),(0x6036, 0x0010),(0x6038, 0x0010),(0x603A, 0x0010),(0x603C, 0x0010),(0x603E, 0x0010),(0x6040, 0x0010),(0x6042, 0x0010),(0x6044, 0x0010),(0x6046, 0x0010),(0x6048, 0x0010),(0x604A, 0x0010),(0x604C, 0x0010),(0x604E, 0x0010),(0x6050, 0x0010),(0x6052, 0x0010),(0x6054, 0x0010),(0x6056, 0x0010),(0x6058, 0x0010),(0x605A, 0x0010),(0x605C, 0x0010),(0x605E, 0x0010),(0x6060, 0x0010),(0x6062, 0x0010),(0x6064, 0x0010),(0x6066, 0x0010),(0x6068, 0x0010),(0x606A, 0x0010),(0x606C, 0x0010),(0x606E, 0x0010),(0x6070, 0x0010),(0x6072, 0x0010),(0x6074, 0x0010),(0x6076, 0x0010),(0x6078, 0x0010),(0x607A, 0x0010),(0x607C, 0x0010),(0x607E, 0x0010),(0x6080, 0x0010),(0x6082, 0x0010),(0x6084, 0x0010),(0x6086, 0x0010),(0x6088, 0x0010),(0x608A, 0x0010),(0x608C, 0x0010),(0x608E, 0x0010),(0x6090, 0x0010),(0x6092, 0x0010),(0x6094, 0x0010),(0x6096, 0x0010),(0x6098, 0x0010),(0x609A, 0x0010),(0x609C, 0x0010),(0x609E, 0x0010),(0x60A0, 0x0010),(0x60A2, 0x0010),(0x60A4, 0x0010),(0x60A6, 0x0010),(0x60A8, 0x0010),(0x60AA, 0x0010),(0x60AC, 0x0010),(0x60AE, 0x0010),(0x60B0, 0x0010),(0x60B2, 0x0010),(0x60B4, 0x0010),(0x60B6, 0x0010),(0x60B8, 0x0010),(0x60BA, 0x0010),(0x60BC, 0x0010),(0x60BE, 0x0010),(0x60C0, 0x0010),(0x60C2, 0x0010),(0x60C4, 0x0010),(0x60C6, 0x0010),(0x60C8, 0x0010),(0x60CA, 0x0010),(0x60CC, 0x0010),(0x60CE, 0x0010),(0x60D0, 0x0010),(0x60D2, 0x0010),(0x60D4, 0x0010),(0x60D6, 0x0010),(0x60D8, 0x0010),(0x60DA, 0x0010),(0x60DC, 0x0010),(0x60DE, 0x0010),(0x60E0, 0x0010),(0x60E2, 0x0010),(0x60E4, 0x0010),(0x60E6, 0x0010),(0x60E8, 0x0010),(0x60EA, 0x0010),(0x60EC, 0x0010),(0x60EE, 0x0010),(0x60F0, 0x0010),(0x60F2, 0x0010),(0x60F4, 0x0010),(0x60F6, 0x0010),(0x60F8, 0x0010),(0x60FA, 0x0010),(0x60FC, 0x0010),(0x60FE, 0x0010),])
    OverlayColumns = Tag('Overlay Columns', "OverlayColumns", 0x6000, 0x0011, [], [(0x6002, 0x0011),(0x6004, 0x0011),(0x6006, 0x0011),(0x6008, 0x0011),(0x600A, 0x0011),(0x600C, 0x0011),(0x600E, 0x0011),(0x6010, 0x0011),(0x6012, 0x0011),(0x6014, 0x0011),(0x6016, 0x0011),(0x6018, 0x0011),(0x601A, 0x0011),(0x601C, 0x0011),(0x601E, 0x0011),(0x6020, 0x0011),(0x6022, 0x0011),(0x6024, 0x0011),(0x6026, 0x0011),(0x6028, 0x0011),(0x602A, 0x0011),(0x602C, 0x0011),(0x602E, 0x0011),(0x6030, 0x0011),(0x6032, 0x0011),(0x6034, 0x0011),(0x6036, 0x0011),(0x6038, 0x0011),(0x603A, 0x0011),(0x603C, 0x0011),(0x603E, 0x0011),(0x6040, 0x0011),(0x6042, 0x0011),(0x6044, 0x0011),(0x6046, 0x0011),(0x6048, 0x0011),(0x604A, 0x0011),(0x604C, 0x0011),(0x604E, 0x0011),(0x6050, 0x0011),(0x6052, 0x0011),(0x6054, 0x0011),(0x6056, 0x0011),(0x6058, 0x0011),(0x605A, 0x0011),(0x605C, 0x0011),(0x605E, 0x0011),(0x6060, 0x0011),(0x6062, 0x0011),(0x6064, 0x0011),(0x6066, 0x0011),(0x6068, 0x0011),(0x606A, 0x0011),(0x606C, 0x0011),(0x606E, 0x0011),(0x6070, 0x0011),(0x6072, 0x0011),(0x6074, 0x0011),(0x6076, 0x0011),(0x6078, 0x0011),(0x607A, 0x0011),(0x607C, 0x0011),(0x607E, 0x0011),(0x6080, 0x0011),(0x6082, 0x0011),(0x6084, 0x0011),(0x6086, 0x0011),(0x6088, 0x0011),(0x608A, 0x0011),(0x608C, 0x0011),(0x608E, 0x0011),(0x6090, 0x0011),(0x6092, 0x0011),(0x6094, 0x0011),(0x6096, 0x0011),(0x6098, 0x0011),(0x609A, 0x0011),(0x609C, 0x0011),(0x609E, 0x0011),(0x60A0, 0x0011),(0x60A2, 0x0011),(0x60A4, 0x0011),(0x60A6, 0x0011),(0x60A8, 0x0011),(0x60AA, 0x0011),(0x60AC, 0x0011),(0x60AE, 0x0011),(0x60B0, 0x0011),(0x60B2, 0x0011),(0x60B4, 0x0011),(0x60B6, 0x0011),(0x60B8, 0x0011),(0x60BA, 0x0011),(0x60BC, 0x0011),(0x60BE, 0x0011),(0x60C0, 0x0011),(0x60C2, 0x0011),(0x60C4, 0x0011),(0x60C6, 0x0011),(0x60C8, 0x0011),(0x60CA, 0x0011),(0x60CC, 0x0011),(0x60CE, 0x0011),(0x60D0, 0x0011),(0x60D2, 0x0011),(0x60D4, 0x0011),(0x60D6, 0x0011),(0x60D8, 0x0011),(0x60DA, 0x0011),(0x60DC, 0x0011),(0x60DE, 0x0011),(0x60E0, 0x0011),(0x60E2, 0x0011),(0x60E4, 0x0011),(0x60E6, 0x0011),(0x60E8, 0x0011),(0x60EA, 0x0011),(0x60EC, 0x0011),(0x60EE, 0x0011),(0x60F0, 0x0011),(0x60F2, 0x0011),(0x60F4, 0x0011),(0x60F6, 0x0011),(0x60F8, 0x0011),(0x60FA, 0x0011),(0x60FC, 0x0011),(0x60FE, 0x0011),])
    NumberOfFramesInOverlay = Tag('Number of Frames in Overlay', "NumberOfFramesInOverlay", 0x6000, 0x0015, [], [(0x6002, 0x0015),(0x6004, 0x0015),(0x6006, 0x0015),(0x6008, 0x0015),(0x600A, 0x0015),(0x600C, 0x0015),(0x600E, 0x0015),(0x6010, 0x0015),(0x6012, 0x0015),(0x6014, 0x0015),(0x6016, 0x0015),(0x6018, 0x0015),(0x601A, 0x0015),(0x601C, 0x0015),(0x601E, 0x0015),(0x6020, 0x0015),(0x6022, 0x0015),(0x6024, 0x0015),(0x6026, 0x0015),(0x6028, 0x0015),(0x602A, 0x0015),(0x602C, 0x0015),(0x602E, 0x0015),(0x6030, 0x0015),(0x6032, 0x0015),(0x6034, 0x0015),(0x6036, 0x0015),(0x6038, 0x0015),(0x603A, 0x0015),(0x603C, 0x0015),(0x603E, 0x0015),(0x6040, 0x0015),(0x6042, 0x0015),(0x6044, 0x0015),(0x6046, 0x0015),(0x6048, 0x0015),(0x604A, 0x0015),(0x604C, 0x0015),(0x604E, 0x0015),(0x6050, 0x0015),(0x6052, 0x0015),(0x6054, 0x0015),(0x6056, 0x0015),(0x6058, 0x0015),(0x605A, 0x0015),(0x605C, 0x0015),(0x605E, 0x0015),(0x6060, 0x0015),(0x6062, 0x0015),(0x6064, 0x0015),(0x6066, 0x0015),(0x6068, 0x0015),(0x606A, 0x0015),(0x606C, 0x0015),(0x606E, 0x0015),(0x6070, 0x0015),(0x6072, 0x0015),(0x6074, 0x0015),(0x6076, 0x0015),(0x6078, 0x0015),(0x607A, 0x0015),(0x607C, 0x0015),(0x607E, 0x0015),(0x6080, 0x0015),(0x6082, 0x0015),(0x6084, 0x0015),(0x6086, 0x0015),(0x6088, 0x0015),(0x608A, 0x0015),(0x608C, 0x0015),(0x608E, 0x0015),(0x6090, 0x0015),(0x6092, 0x0015),(0x6094, 0x0015),(0x6096, 0x0015),(0x6098, 0x0015),(0x609A, 0x0015),(0x609C, 0x0015),(0x609E, 0x0015),(0x60A0, 0x0015),(0x60A2, 0x0015),(0x60A4, 0x0015),(0x60A6, 0x0015),(0x60A8, 0x0015),(0x60AA, 0x0015),(0x60AC, 0x0015),(0x60AE, 0x0015),(0x60B0, 0x0015),(0x60B2, 0x0015),(0x60B4, 0x0015),(0x60B6, 0x0015),(0x60B8, 0x0015),(0x60BA, 0x0015),(0x60BC, 0x0015),(0x60BE, 0x0015),(0x60C0, 0x0015),(0x60C2, 0x0015),(0x60C4, 0x0015),(0x60C6, 0x0015),(0x60C8, 0x0015),(0x60CA, 0x0015),(0x60CC, 0x0015),(0x60CE, 0x0015),(0x60D0, 0x0015),(0x60D2, 0x0015),(0x60D4, 0x0015),(0x60D6, 0x0015),(0x60D8, 0x0015),(0x60DA, 0x0015),(0x60DC, 0x0015),(0x60DE, 0x0015),(0x60E0, 0x0015),(0x60E2, 0x0015),(0x60E4, 0x0015),(0x60E6, 0x0015),(0x60E8, 0x0015),(0x60EA, 0x0015),(0x60EC, 0x0015),(0x60EE, 0x0015),(0x60F0, 0x0015),(0x60F2, 0x0015),(0x60F4, 0x0015),(0x60F6, 0x0015),(0x60F8, 0x0015),(0x60FA, 0x0015),(0x60FC, 0x0015),(0x60FE, 0x0015),])
    OverlayDescription = Tag('Overlay Description', "OverlayDescription", 0x6000, 0x0022, [], [(0x6002, 0x0022),(0x6004, 0x0022),(0x6006, 0x0022),(0x6008, 0x0022),(0x600A, 0x0022),(0x600C, 0x0022),(0x600E, 0x0022),(0x6010, 0x0022),(0x6012, 0x0022),(0x6014, 0x0022),(0x6016, 0x0022),(0x6018, 0x0022),(0x601A, 0x0022),(0x601C, 0x0022),(0x601E, 0x0022),(0x6020, 0x0022),(0x6022, 0x0022),(0x6024, 0x0022),(0x6026, 0x0022),(0x6028, 0x0022),(0x602A, 0x0022),(0x602C, 0x0022),(0x602E, 0x0022),(0x6030, 0x0022),(0x6032, 0x0022),(0x6034, 0x0022),(0x6036, 0x0022),(0x6038, 0x0022),(0x603A, 0x0022),(0x603C, 0x0022),(0x603E, 0x0022),(0x6040, 0x0022),(0x6042, 0x0022),(0x6044, 0x0022),(0x6046, 0x0022),(0x6048, 0x0022),(0x604A, 0x0022),(0x604C, 0x0022),(0x604E, 0x0022),(0x6050, 0x0022),(0x6052, 0x0022),(0x6054, 0x0022),(0x6056, 0x0022),(0x6058, 0x0022),(0x605A, 0x0022),(0x605C, 0x0022),(0x605E, 0x0022),(0x6060, 0x0022),(0x6062, 0x0022),(0x6064, 0x0022),(0x6066, 0x0022),(0x6068, 0x0022),(0x606A, 0x0022),(0x606C, 0x0022),(0x606E, 0x0022),(0x6070, 0x0022),(0x6072, 0x0022),(0x6074, 0x0022),(0x6076, 0x0022),(0x6078, 0x0022),(0x607A, 0x0022),(0x607C, 0x0022),(0x607E, 0x0022),(0x6080, 0x0022),(0x6082, 0x0022),(0x6084, 0x0022),(0x6086, 0x0022),(0x6088, 0x0022),(0x608A, 0x0022),(0x608C, 0x0022),(0x608E, 0x0022),(0x6090, 0x0022),(0x6092, 0x0022),(0x6094, 0x0022),(0x6096, 0x0022),(0x6098, 0x0022),(0x609A, 0x0022),(0x609C, 0x0022),(0x609E, 0x0022),(0x60A0, 0x0022),(0x60A2, 0x0022),(0x60A4, 0x0022),(0x60A6, 0x0022),(0x60A8, 0x0022),(0x60AA, 0x0022),(0x60AC, 0x0022),(0x60AE, 0x0022),(0x60B0, 0x0022),(0x60B2, 0x0022),(0x60B4, 0x0022),(0x60B6, 0x0022),(0x60B8, 0x0022),(0x60BA, 0x0022),(0x60BC, 0x0022),(0x60BE, 0x0022),(0x60C0, 0x0022),(0x60C2, 0x0022),(0x60C4, 0x0022),(0x60C6, 0x0022),(0x60C8, 0x0022),(0x60CA, 0x0022),(0x60CC, 0x0022),(0x60CE, 0x0022),(0x60D0, 0x0022),(0x60D2, 0x0022),(0x60D4, 0x0022),(0x60D6, 0x0022),(0x60D8, 0x0022),(0x60DA, 0x0022),(0x60DC, 0x0022),(0x60DE, 0x0022),(0x60E0, 0x0022),(0x60E2, 0x0022),(0x60E4, 0x0022),(0x60E6, 0x0022),(0x60E8, 0x0022),(0x60EA, 0x0022),(0x60EC, 0x0022),(0x60EE, 0x0022),(0x60F0, 0x0022),(0x60F2, 0x0022),(0x60F4, 0x0022),(0x60F6, 0x0022),(0x60F8, 0x0022),(0x60FA, 0x0022),(0x60FC, 0x0022),(0x60FE, 0x0022),])
    OverlayType = Tag('Overlay Type', "OverlayType", 0x6000, 0x0040, [], [(0x6002, 0x0040),(0x6004, 0x0040),(0x6006, 0x0040),(0x6008, 0x0040),(0x600A, 0x0040),(0x600C, 0x0040),(0x600E, 0x0040),(0x6010, 0x0040),(0x6012, 0x0040),(0x6014, 0x0040),(0x6016, 0x0040),(0x6018, 0x0040),(0x601A, 0x0040),(0x601C, 0x0040),(0x601E, 0x0040),(0x6020, 0x0040),(0x6022, 0x0040),(0x6024, 0x0040),(0x6026, 0x0040),(0x6028, 0x0040),(0x602A, 0x0040),(0x602C, 0x0040),(0x602E, 0x0040),(0x6030, 0x0040),(0x6032, 0x0040),(0x6034, 0x0040),(0x6036, 0x0040),(0x6038, 0x0040),(0x603A, 0x0040),(0x603C, 0x0040),(0x603E, 0x0040),(0x6040, 0x0040),(0x6042, 0x0040),(0x6044, 0x0040),(0x6046, 0x0040),(0x6048, 0x0040),(0x604A, 0x0040),(0x604C, 0x0040),(0x604E, 0x0040),(0x6050, 0x0040),(0x6052, 0x0040),(0x6054, 0x0040),(0x6056, 0x0040),(0x6058, 0x0040),(0x605A, 0x0040),(0x605C, 0x0040),(0x605E, 0x0040),(0x6060, 0x0040),(0x6062, 0x0040),(0x6064, 0x0040),(0x6066, 0x0040),(0x6068, 0x0040),(0x606A, 0x0040),(0x606C, 0x0040),(0x606E, 0x0040),(0x6070, 0x0040),(0x6072, 0x0040),(0x6074, 0x0040),(0x6076, 0x0040),(0x6078, 0x0040),(0x607A, 0x0040),(0x607C, 0x0040),(0x607E, 0x0040),(0x6080, 0x0040),(0x6082, 0x0040),(0x6084, 0x0040),(0x6086, 0x0040),(0x6088, 0x0040),(0x608A, 0x0040),(0x608C, 0x0040),(0x608E, 0x0040),(0x6090, 0x0040),(0x6092, 0x0040),(0x6094, 0x0040),(0x6096, 0x0040),(0x6098, 0x0040),(0x609A, 0x0040),(0x609C, 0x0040),(0x609E, 0x0040),(0x60A0, 0x0040),(0x60A2, 0x0040),(0x60A4, 0x0040),(0x60A6, 0x0040),(0x60A8, 0x0040),(0x60AA, 0x0040),(0x60AC, 0x0040),(0x60AE, 0x0040),(0x60B0, 0x0040),(0x60B2, 0x0040),(0x60B4, 0x0040),(0x60B6, 0x0040),(0x60B8, 0x0040),(0x60BA, 0x0040),(0x60BC, 0x0040),(0x60BE, 0x0040),(0x60C0, 0x0040),(0x60C2, 0x0040),(0x60C4, 0x0040),(0x60C6, 0x0040),(0x60C8, 0x0040),(0x60CA, 0x0040),(0x60CC, 0x0040),(0x60CE, 0x0040),(0x60D0, 0x0040),(0x60D2, 0x0040),(0x60D4, 0x0040),(0x60D6, 0x0040),(0x60D8, 0x0040),(0x60DA, 0x0040),(0x60DC, 0x0040),(0x60DE, 0x0040),(0x60E0, 0x0040),(0x60E2, 0x0040),(0x60E4, 0x0040),(0x60E6, 0x0040),(0x60E8, 0x0040),(0x60EA, 0x0040),(0x60EC, 0x0040),(0x60EE, 0x0040),(0x60F0, 0x0040),(0x60F2, 0x0040),(0x60F4, 0x0040),(0x60F6, 0x0040),(0x60F8, 0x0040),(0x60FA, 0x0040),(0x60FC, 0x0040),(0x60FE, 0x0040),])
    OverlaySubtype = Tag('Overlay Subtype', "OverlaySubtype", 0x6000, 0x0045, [], [(0x6002, 0x0045),(0x6004, 0x0045),(0x6006, 0x0045),(0x6008, 0x0045),(0x600A, 0x0045),(0x600C, 0x0045),(0x600E, 0x0045),(0x6010, 0x0045),(0x6012, 0x0045),(0x6014, 0x0045),(0x6016, 0x0045),(0x6018, 0x0045),(0x601A, 0x0045),(0x601C, 0x0045),(0x601E, 0x0045),(0x6020, 0x0045),(0x6022, 0x0045),(0x6024, 0x0045),(0x6026, 0x0045),(0x6028, 0x0045),(0x602A, 0x0045),(0x602C, 0x0045),(0x602E, 0x0045),(0x6030, 0x0045),(0x6032, 0x0045),(0x6034, 0x0045),(0x6036, 0x0045),(0x6038, 0x0045),(0x603A, 0x0045),(0x603C, 0x0045),(0x603E, 0x0045),(0x6040, 0x0045),(0x6042, 0x0045),(0x6044, 0x0045),(0x6046, 0x0045),(0x6048, 0x0045),(0x604A, 0x0045),(0x604C, 0x0045),(0x604E, 0x0045),(0x6050, 0x0045),(0x6052, 0x0045),(0x6054, 0x0045),(0x6056, 0x0045),(0x6058, 0x0045),(0x605A, 0x0045),(0x605C, 0x0045),(0x605E, 0x0045),(0x6060, 0x0045),(0x6062, 0x0045),(0x6064, 0x0045),(0x6066, 0x0045),(0x6068, 0x0045),(0x606A, 0x0045),(0x606C, 0x0045),(0x606E, 0x0045),(0x6070, 0x0045),(0x6072, 0x0045),(0x6074, 0x0045),(0x6076, 0x0045),(0x6078, 0x0045),(0x607A, 0x0045),(0x607C, 0x0045),(0x607E, 0x0045),(0x6080, 0x0045),(0x6082, 0x0045),(0x6084, 0x0045),(0x6086, 0x0045),(0x6088, 0x0045),(0x608A, 0x0045),(0x608C, 0x0045),(0x608E, 0x0045),(0x6090, 0x0045),(0x6092, 0x0045),(0x6094, 0x0045),(0x6096, 0x0045),(0x6098, 0x0045),(0x609A, 0x0045),(0x609C, 0x0045),(0x609E, 0x0045),(0x60A0, 0x0045),(0x60A2, 0x0045),(0x60A4, 0x0045),(0x60A6, 0x0045),(0x60A8, 0x0045),(0x60AA, 0x0045),(0x60AC, 0x0045),(0x60AE, 0x0045),(0x60B0, 0x0045),(0x60B2, 0x0045),(0x60B4, 0x0045),(0x60B6, 0x0045),(0x60B8, 0x0045),(0x60BA, 0x0045),(0x60BC, 0x0045),(0x60BE, 0x0045),(0x60C0, 0x0045),(0x60C2, 0x0045),(0x60C4, 0x0045),(0x60C6, 0x0045),(0x60C8, 0x0045),(0x60CA, 0x0045),(0x60CC, 0x0045),(0x60CE, 0x0045),(0x60D0, 0x0045),(0x60D2, 0x0045),(0x60D4, 0x0045),(0x60D6, 0x0045),(0x60D8, 0x0045),(0x60DA, 0x0045),(0x60DC, 0x0045),(0x60DE, 0x0045),(0x60E0, 0x0045),(0x60E2, 0x0045),(0x60E4, 0x0045),(0x60E6, 0x0045),(0x60E8, 0x0045),(0x60EA, 0x0045),(0x60EC, 0x0045),(0x60EE, 0x0045),(0x60F0, 0x0045),(0x60F2, 0x0045),(0x60F4, 0x0045),(0x60F6, 0x0045),(0x60F8, 0x0045),(0x60FA, 0x0045),(0x60FC, 0x0045),(0x60FE, 0x0045),])
    OverlayOrigin = Tag('Overlay Origin', "OverlayOrigin", 0x6000, 0x0050, [], [(0x6002, 0x0050),(0x6004, 0x0050),(0x6006, 0x0050),(0x6008, 0x0050),(0x600A, 0x0050),(0x600C, 0x0050),(0x600E, 0x0050),(0x6010, 0x0050),(0x6012, 0x0050),(0x6014, 0x0050),(0x6016, 0x0050),(0x6018, 0x0050),(0x601A, 0x0050),(0x601C, 0x0050),(0x601E, 0x0050),(0x6020, 0x0050),(0x6022, 0x0050),(0x6024, 0x0050),(0x6026, 0x0050),(0x6028, 0x0050),(0x602A, 0x0050),(0x602C, 0x0050),(0x602E, 0x0050),(0x6030, 0x0050),(0x6032, 0x0050),(0x6034, 0x0050),(0x6036, 0x0050),(0x6038, 0x0050),(0x603A, 0x0050),(0x603C, 0x0050),(0x603E, 0x0050),(0x6040, 0x0050),(0x6042, 0x0050),(0x6044, 0x0050),(0x6046, 0x0050),(0x6048, 0x0050),(0x604A, 0x0050),(0x604C, 0x0050),(0x604E, 0x0050),(0x6050, 0x0050),(0x6052, 0x0050),(0x6054, 0x0050),(0x6056, 0x0050),(0x6058, 0x0050),(0x605A, 0x0050),(0x605C, 0x0050),(0x605E, 0x0050),(0x6060, 0x0050),(0x6062, 0x0050),(0x6064, 0x0050),(0x6066, 0x0050),(0x6068, 0x0050),(0x606A, 0x0050),(0x606C, 0x0050),(0x606E, 0x0050),(0x6070, 0x0050),(0x6072, 0x0050),(0x6074, 0x0050),(0x6076, 0x0050),(0x6078, 0x0050),(0x607A, 0x0050),(0x607C, 0x0050),(0x607E, 0x0050),(0x6080, 0x0050),(0x6082, 0x0050),(0x6084, 0x0050),(0x6086, 0x0050),(0x6088, 0x0050),(0x608A, 0x0050),(0x608C, 0x0050),(0x608E, 0x0050),(0x6090, 0x0050),(0x6092, 0x0050),(0x6094, 0x0050),(0x6096, 0x0050),(0x6098, 0x0050),(0x609A, 0x0050),(0x609C, 0x0050),(0x609E, 0x0050),(0x60A0, 0x0050),(0x60A2, 0x0050),(0x60A4, 0x0050),(0x60A6, 0x0050),(0x60A8, 0x0050),(0x60AA, 0x0050),(0x60AC, 0x0050),(0x60AE, 0x0050),(0x60B0, 0x0050),(0x60B2, 0x0050),(0x60B4, 0x0050),(0x60B6, 0x0050),(0x60B8, 0x0050),(0x60BA, 0x0050),(0x60BC, 0x0050),(0x60BE, 0x0050),(0x60C0, 0x0050),(0x60C2, 0x0050),(0x60C4, 0x0050),(0x60C6, 0x0050),(0x60C8, 0x0050),(0x60CA, 0x0050),(0x60CC, 0x0050),(0x60CE, 0x0050),(0x60D0, 0x0050),(0x60D2, 0x0050),(0x60D4, 0x0050),(0x60D6, 0x0050),(0x60D8, 0x0050),(0x60DA, 0x0050),(0x60DC, 0x0050),(0x60DE, 0x0050),(0x60E0, 0x0050),(0x60E2, 0x0050),(0x60E4, 0x0050),(0x60E6, 0x0050),(0x60E8, 0x0050),(0x60EA, 0x0050),(0x60EC, 0x0050),(0x60EE, 0x0050),(0x60F0, 0x0050),(0x60F2, 0x0050),(0x60F4, 0x0050),(0x60F6, 0x0050),(0x60F8, 0x0050),(0x60FA, 0x0050),(0x60FC, 0x0050),(0x60FE, 0x0050),])
    ImageFrameOrigin = Tag('Image Frame Origin', "ImageFrameOrigin", 0x6000, 0x0051, [], [(0x6002, 0x0051),(0x6004, 0x0051),(0x6006, 0x0051),(0x6008, 0x0051),(0x600A, 0x0051),(0x600C, 0x0051),(0x600E, 0x0051),(0x6010, 0x0051),(0x6012, 0x0051),(0x6014, 0x0051),(0x6016, 0x0051),(0x6018, 0x0051),(0x601A, 0x0051),(0x601C, 0x0051),(0x601E, 0x0051),(0x6020, 0x0051),(0x6022, 0x0051),(0x6024, 0x0051),(0x6026, 0x0051),(0x6028, 0x0051),(0x602A, 0x0051),(0x602C, 0x0051),(0x602E, 0x0051),(0x6030, 0x0051),(0x6032, 0x0051),(0x6034, 0x0051),(0x6036, 0x0051),(0x6038, 0x0051),(0x603A, 0x0051),(0x603C, 0x0051),(0x603E, 0x0051),(0x6040, 0x0051),(0x6042, 0x0051),(0x6044, 0x0051),(0x6046, 0x0051),(0x6048, 0x0051),(0x604A, 0x0051),(0x604C, 0x0051),(0x604E, 0x0051),(0x6050, 0x0051),(0x6052, 0x0051),(0x6054, 0x0051),(0x6056, 0x0051),(0x6058, 0x0051),(0x605A, 0x0051),(0x605C, 0x0051),(0x605E, 0x0051),(0x6060, 0x0051),(0x6062, 0x0051),(0x6064, 0x0051),(0x6066, 0x0051),(0x6068, 0x0051),(0x606A, 0x0051),(0x606C, 0x0051),(0x606E, 0x0051),(0x6070, 0x0051),(0x6072, 0x0051),(0x6074, 0x0051),(0x6076, 0x0051),(0x6078, 0x0051),(0x607A, 0x0051),(0x607C, 0x0051),(0x607E, 0x0051),(0x6080, 0x0051),(0x6082, 0x0051),(0x6084, 0x0051),(0x6086, 0x0051),(0x6088, 0x0051),(0x608A, 0x0051),(0x608C, 0x0051),(0x608E, 0x0051),(0x6090, 0x0051),(0x6092, 0x0051),(0x6094, 0x0051),(0x6096, 0x0051),(0x6098, 0x0051),(0x609A, 0x0051),(0x609C, 0x0051),(0x609E, 0x0051),(0x60A0, 0x0051),(0x60A2, 0x0051),(0x60A4, 0x0051),(0x60A6, 0x0051),(0x60A8, 0x0051),(0x60AA, 0x0051),(0x60AC, 0x0051),(0x60AE, 0x0051),(0x60B0, 0x0051),(0x60B2, 0x0051),(0x60B4, 0x0051),(0x60B6, 0x0051),(0x60B8, 0x0051),(0x60BA, 0x0051),(0x60BC, 0x0051),(0x60BE, 0x0051),(0x60C0, 0x0051),(0x60C2, 0x0051),(0x60C4, 0x0051),(0x60C6, 0x0051),(0x60C8, 0x0051),(0x60CA, 0x0051),(0x60CC, 0x0051),(0x60CE, 0x0051),(0x60D0, 0x0051),(0x60D2, 0x0051),(0x60D4, 0x0051),(0x60D6, 0x0051),(0x60D8, 0x0051),(0x60DA, 0x0051),(0x60DC, 0x0051),(0x60DE, 0x0051),(0x60E0, 0x0051),(0x60E2, 0x0051),(0x60E4, 0x0051),(0x60E6, 0x0051),(0x60E8, 0x0051),(0x60EA, 0x0051),(0x60EC, 0x0051),(0x60EE, 0x0051),(0x60F0, 0x0051),(0x60F2, 0x0051),(0x60F4, 0x0051),(0x60F6, 0x0051),(0x60F8, 0x0051),(0x60FA, 0x0051),(0x60FC, 0x0051),(0x60FE, 0x0051),])
    OverlayBitsAllocated = Tag('Overlay Bits Allocated', "OverlayBitsAllocated", 0x6000, 0x0100, [], [(0x6002, 0x0100),(0x6004, 0x0100),(0x6006, 0x0100),(0x6008, 0x0100),(0x600A, 0x0100),(0x600C, 0x0100),(0x600E, 0x0100),(0x6010, 0x0100),(0x6012, 0x0100),(0x6014, 0x0100),(0x6016, 0x0100),(0x6018, 0x0100),(0x601A, 0x0100),(0x601C, 0x0100),(0x601E, 0x0100),(0x6020, 0x0100),(0x6022, 0x0100),(0x6024, 0x0100),(0x6026, 0x0100),(0x6028, 0x0100),(0x602A, 0x0100),(0x602C, 0x0100),(0x602E, 0x0100),(0x6030, 0x0100),(0x6032, 0x0100),(0x6034, 0x0100),(0x6036, 0x0100),(0x6038, 0x0100),(0x603A, 0x0100),(0x603C, 0x0100),(0x603E, 0x0100),(0x6040, 0x0100),(0x6042, 0x0100),(0x6044, 0x0100),(0x6046, 0x0100),(0x6048, 0x0100),(0x604A, 0x0100),(0x604C, 0x0100),(0x604E, 0x0100),(0x6050, 0x0100),(0x6052, 0x0100),(0x6054, 0x0100),(0x6056, 0x0100),(0x6058, 0x0100),(0x605A, 0x0100),(0x605C, 0x0100),(0x605E, 0x0100),(0x6060, 0x0100),(0x6062, 0x0100),(0x6064, 0x0100),(0x6066, 0x0100),(0x6068, 0x0100),(0x606A, 0x0100),(0x606C, 0x0100),(0x606E, 0x0100),(0x6070, 0x0100),(0x6072, 0x0100),(0x6074, 0x0100),(0x6076, 0x0100),(0x6078, 0x0100),(0x607A, 0x0100),(0x607C, 0x0100),(0x607E, 0x0100),(0x6080, 0x0100),(0x6082, 0x0100),(0x6084, 0x0100),(0x6086, 0x0100),(0x6088, 0x0100),(0x608A, 0x0100),(0x608C, 0x0100),(0x608E, 0x0100),(0x6090, 0x0100),(0x6092, 0x0100),(0x6094, 0x0100),(0x6096, 0x0100),(0x6098, 0x0100),(0x609A, 0x0100),(0x609C, 0x0100),(0x609E, 0x0100),(0x60A0, 0x0100),(0x60A2, 0x0100),(0x60A4, 0x0100),(0x60A6, 0x0100),(0x60A8, 0x0100),(0x60AA, 0x0100),(0x60AC, 0x0100),(0x60AE, 0x0100),(0x60B0, 0x0100),(0x60B2, 0x0100),(0x60B4, 0x0100),(0x60B6, 0x0100),(0x60B8, 0x0100),(0x60BA, 0x0100),(0x60BC, 0x0100),(0x60BE, 0x0100),(0x60C0, 0x0100),(0x60C2, 0x0100),(0x60C4, 0x0100),(0x60C6, 0x0100),(0x60C8, 0x0100),(0x60CA, 0x0100),(0x60CC, 0x0100),(0x60CE, 0x0100),(0x60D0, 0x0100),(0x60D2, 0x0100),(0x60D4, 0x0100),(0x60D6, 0x0100),(0x60D8, 0x0100),(0x60DA, 0x0100),(0x60DC, 0x0100),(0x60DE, 0x0100),(0x60E0, 0x0100),(0x60E2, 0x0100),(0x60E4, 0x0100),(0x60E6, 0x0100),(0x60E8, 0x0100),(0x60EA, 0x0100),(0x60EC, 0x0100),(0x60EE, 0x0100),(0x60F0, 0x0100),(0x60F2, 0x0100),(0x60F4, 0x0100),(0x60F6, 0x0100),(0x60F8, 0x0100),(0x60FA, 0x0100),(0x60FC, 0x0100),(0x60FE, 0x0100),])
    OverlayBitPosition = Tag('Overlay Bit Position', "OverlayBitPosition", 0x6000, 0x0102, [], [(0x6002, 0x0102),(0x6004, 0x0102),(0x6006, 0x0102),(0x6008, 0x0102),(0x600A, 0x0102),(0x600C, 0x0102),(0x600E, 0x0102),(0x6010, 0x0102),(0x6012, 0x0102),(0x6014, 0x0102),(0x6016, 0x0102),(0x6018, 0x0102),(0x601A, 0x0102),(0x601C, 0x0102),(0x601E, 0x0102),(0x6020, 0x0102),(0x6022, 0x0102),(0x6024, 0x0102),(0x6026, 0x0102),(0x6028, 0x0102),(0x602A, 0x0102),(0x602C, 0x0102),(0x602E, 0x0102),(0x6030, 0x0102),(0x6032, 0x0102),(0x6034, 0x0102),(0x6036, 0x0102),(0x6038, 0x0102),(0x603A, 0x0102),(0x603C, 0x0102),(0x603E, 0x0102),(0x6040, 0x0102),(0x6042, 0x0102),(0x6044, 0x0102),(0x6046, 0x0102),(0x6048, 0x0102),(0x604A, 0x0102),(0x604C, 0x0102),(0x604E, 0x0102),(0x6050, 0x0102),(0x6052, 0x0102),(0x6054, 0x0102),(0x6056, 0x0102),(0x6058, 0x0102),(0x605A, 0x0102),(0x605C, 0x0102),(0x605E, 0x0102),(0x6060, 0x0102),(0x6062, 0x0102),(0x6064, 0x0102),(0x6066, 0x0102),(0x6068, 0x0102),(0x606A, 0x0102),(0x606C, 0x0102),(0x606E, 0x0102),(0x6070, 0x0102),(0x6072, 0x0102),(0x6074, 0x0102),(0x6076, 0x0102),(0x6078, 0x0102),(0x607A, 0x0102),(0x607C, 0x0102),(0x607E, 0x0102),(0x6080, 0x0102),(0x6082, 0x0102),(0x6084, 0x0102),(0x6086, 0x0102),(0x6088, 0x0102),(0x608A, 0x0102),(0x608C, 0x0102),(0x608E, 0x0102),(0x6090, 0x0102),(0x6092, 0x0102),(0x6094, 0x0102),(0x6096, 0x0102),(0x6098, 0x0102),(0x609A, 0x0102),(0x609C, 0x0102),(0x609E, 0x0102),(0x60A0, 0x0102),(0x60A2, 0x0102),(0x60A4, 0x0102),(0x60A6, 0x0102),(0x60A8, 0x0102),(0x60AA, 0x0102),(0x60AC, 0x0102),(0x60AE, 0x0102),(0x60B0, 0x0102),(0x60B2, 0x0102),(0x60B4, 0x0102),(0x60B6, 0x0102),(0x60B8, 0x0102),(0x60BA, 0x0102),(0x60BC, 0x0102),(0x60BE, 0x0102),(0x60C0, 0x0102),(0x60C2, 0x0102),(0x60C4, 0x0102),(0x60C6, 0x0102),(0x60C8, 0x0102),(0x60CA, 0x0102),(0x60CC, 0x0102),(0x60CE, 0x0102),(0x60D0, 0x0102),(0x60D2, 0x0102),(0x60D4, 0x0102),(0x60D6, 0x0102),(0x60D8, 0x0102),(0x60DA, 0x0102),(0x60DC, 0x0102),(0x60DE, 0x0102),(0x60E0, 0x0102),(0x60E2, 0x0102),(0x60E4, 0x0102),(0x60E6, 0x0102),(0x60E8, 0x0102),(0x60EA, 0x0102),(0x60EC, 0x0102),(0x60EE, 0x0102),(0x60F0, 0x0102),(0x60F2, 0x0102),(0x60F4, 0x0102),(0x60F6, 0x0102),(0x60F8, 0x0102),(0x60FA, 0x0102),(0x60FC, 0x0102),(0x60FE, 0x0102),])
    ROIArea = Tag('ROI Area', "ROIArea", 0x6000, 0x1301, [], [(0x6002, 0x1301),(0x6004, 0x1301),(0x6006, 0x1301),(0x6008, 0x1301),(0x600A, 0x1301),(0x600C, 0x1301),(0x600E, 0x1301),(0x6010, 0x1301),(0x6012, 0x1301),(0x6014, 0x1301),(0x6016, 0x1301),(0x6018, 0x1301),(0x601A, 0x1301),(0x601C, 0x1301),(0x601E, 0x1301),(0x6020, 0x1301),(0x6022, 0x1301),(0x6024, 0x1301),(0x6026, 0x1301),(0x6028, 0x1301),(0x602A, 0x1301),(0x602C, 0x1301),(0x602E, 0x1301),(0x6030, 0x1301),(0x6032, 0x1301),(0x6034, 0x1301),(0x6036, 0x1301),(0x6038, 0x1301),(0x603A, 0x1301),(0x603C, 0x1301),(0x603E, 0x1301),(0x6040, 0x1301),(0x6042, 0x1301),(0x6044, 0x1301),(0x6046, 0x1301),(0x6048, 0x1301),(0x604A, 0x1301),(0x604C, 0x1301),(0x604E, 0x1301),(0x6050, 0x1301),(0x6052, 0x1301),(0x6054, 0x1301),(0x6056, 0x1301),(0x6058, 0x1301),(0x605A, 0x1301),(0x605C, 0x1301),(0x605E, 0x1301),(0x6060, 0x1301),(0x6062, 0x1301),(0x6064, 0x1301),(0x6066, 0x1301),(0x6068, 0x1301),(0x606A, 0x1301),(0x606C, 0x1301),(0x606E, 0x1301),(0x6070, 0x1301),(0x6072, 0x1301),(0x6074, 0x1301),(0x6076, 0x1301),(0x6078, 0x1301),(0x607A, 0x1301),(0x607C, 0x1301),(0x607E, 0x1301),(0x6080, 0x1301),(0x6082, 0x1301),(0x6084, 0x1301),(0x6086, 0x1301),(0x6088, 0x1301),(0x608A, 0x1301),(0x608C, 0x1301),(0x608E, 0x1301),(0x6090, 0x1301),(0x6092, 0x1301),(0x6094, 0x1301),(0x6096, 0x1301),(0x6098, 0x1301),(0x609A, 0x1301),(0x609C, 0x1301),(0x609E, 0x1301),(0x60A0, 0x1301),(0x60A2, 0x1301),(0x60A4, 0x1301),(0x60A6, 0x1301),(0x60A8, 0x1301),(0x60AA, 0x1301),(0x60AC, 0x1301),(0x60AE, 0x1301),(0x60B0, 0x1301),(0x60B2, 0x1301),(0x60B4, 0x1301),(0x60B6, 0x1301),(0x60B8, 0x1301),(0x60BA, 0x1301),(0x60BC, 0x1301),(0x60BE, 0x1301),(0x60C0, 0x1301),(0x60C2, 0x1301),(0x60C4, 0x1301),(0x60C6, 0x1301),(0x60C8, 0x1301),(0x60CA, 0x1301),(0x60CC, 0x1301),(0x60CE, 0x1301),(0x60D0, 0x1301),(0x60D2, 0x1301),(0x60D4, 0x1301),(0x60D6, 0x1301),(0x60D8, 0x1301),(0x60DA, 0x1301),(0x60DC, 0x1301),(0x60DE, 0x1301),(0x60E0, 0x1301),(0x60E2, 0x1301),(0x60E4, 0x1301),(0x60E6, 0x1301),(0x60E8, 0x1301),(0x60EA, 0x1301),(0x60EC, 0x1301),(0x60EE, 0x1301),(0x60F0, 0x1301),(0x60F2, 0x1301),(0x60F4, 0x1301),(0x60F6, 0x1301),(0x60F8, 0x1301),(0x60FA, 0x1301),(0x60FC, 0x1301),(0x60FE, 0x1301),])
    ROIMean = Tag('ROI Mean', "ROIMean", 0x6000, 0x1302, [], [(0x6002, 0x1302),(0x6004, 0x1302),(0x6006, 0x1302),(0x6008, 0x1302),(0x600A, 0x1302),(0x600C, 0x1302),(0x600E, 0x1302),(0x6010, 0x1302),(0x6012, 0x1302),(0x6014, 0x1302),(0x6016, 0x1302),(0x6018, 0x1302),(0x601A, 0x1302),(0x601C, 0x1302),(0x601E, 0x1302),(0x6020, 0x1302),(0x6022, 0x1302),(0x6024, 0x1302),(0x6026, 0x1302),(0x6028, 0x1302),(0x602A, 0x1302),(0x602C, 0x1302),(0x602E, 0x1302),(0x6030, 0x1302),(0x6032, 0x1302),(0x6034, 0x1302),(0x6036, 0x1302),(0x6038, 0x1302),(0x603A, 0x1302),(0x603C, 0x1302),(0x603E, 0x1302),(0x6040, 0x1302),(0x6042, 0x1302),(0x6044, 0x1302),(0x6046, 0x1302),(0x6048, 0x1302),(0x604A, 0x1302),(0x604C, 0x1302),(0x604E, 0x1302),(0x6050, 0x1302),(0x6052, 0x1302),(0x6054, 0x1302),(0x6056, 0x1302),(0x6058, 0x1302),(0x605A, 0x1302),(0x605C, 0x1302),(0x605E, 0x1302),(0x6060, 0x1302),(0x6062, 0x1302),(0x6064, 0x1302),(0x6066, 0x1302),(0x6068, 0x1302),(0x606A, 0x1302),(0x606C, 0x1302),(0x606E, 0x1302),(0x6070, 0x1302),(0x6072, 0x1302),(0x6074, 0x1302),(0x6076, 0x1302),(0x6078, 0x1302),(0x607A, 0x1302),(0x607C, 0x1302),(0x607E, 0x1302),(0x6080, 0x1302),(0x6082, 0x1302),(0x6084, 0x1302),(0x6086, 0x1302),(0x6088, 0x1302),(0x608A, 0x1302),(0x608C, 0x1302),(0x608E, 0x1302),(0x6090, 0x1302),(0x6092, 0x1302),(0x6094, 0x1302),(0x6096, 0x1302),(0x6098, 0x1302),(0x609A, 0x1302),(0x609C, 0x1302),(0x609E, 0x1302),(0x60A0, 0x1302),(0x60A2, 0x1302),(0x60A4, 0x1302),(0x60A6, 0x1302),(0x60A8, 0x1302),(0x60AA, 0x1302),(0x60AC, 0x1302),(0x60AE, 0x1302),(0x60B0, 0x1302),(0x60B2, 0x1302),(0x60B4, 0x1302),(0x60B6, 0x1302),(0x60B8, 0x1302),(0x60BA, 0x1302),(0x60BC, 0x1302),(0x60BE, 0x1302),(0x60C0, 0x1302),(0x60C2, 0x1302),(0x60C4, 0x1302),(0x60C6, 0x1302),(0x60C8, 0x1302),(0x60CA, 0x1302),(0x60CC, 0x1302),(0x60CE, 0x1302),(0x60D0, 0x1302),(0x60D2, 0x1302),(0x60D4, 0x1302),(0x60D6, 0x1302),(0x60D8, 0x1302),(0x60DA, 0x1302),(0x60DC, 0x1302),(0x60DE, 0x1302),(0x60E0, 0x1302),(0x60E2, 0x1302),(0x60E4, 0x1302),(0x60E6, 0x1302),(0x60E8, 0x1302),(0x60EA, 0x1302),(0x60EC, 0x1302),(0x60EE, 0x1302),(0x60F0, 0x1302),(0x60F2, 0x1302),(0x60F4, 0x1302),(0x60F6, 0x1302),(0x60F8, 0x1302),(0x60FA, 0x1302),(0x60FC, 0x1302),(0x60FE, 0x1302),])
    ROIStandardDeviation = Tag('ROI Standard Deviation', "ROIStandardDeviation", 0x6000, 0x1303, [], [(0x6002, 0x1303),(0x6004, 0x1303),(0x6006, 0x1303),(0x6008, 0x1303),(0x600A, 0x1303),(0x600C, 0x1303),(0x600E, 0x1303),(0x6010, 0x1303),(0x6012, 0x1303),(0x6014, 0x1303),(0x6016, 0x1303),(0x6018, 0x1303),(0x601A, 0x1303),(0x601C, 0x1303),(0x601E, 0x1303),(0x6020, 0x1303),(0x6022, 0x1303),(0x6024, 0x1303),(0x6026, 0x1303),(0x6028, 0x1303),(0x602A, 0x1303),(0x602C, 0x1303),(0x602E, 0x1303),(0x6030, 0x1303),(0x6032, 0x1303),(0x6034, 0x1303),(0x6036, 0x1303),(0x6038, 0x1303),(0x603A, 0x1303),(0x603C, 0x1303),(0x603E, 0x1303),(0x6040, 0x1303),(0x6042, 0x1303),(0x6044, 0x1303),(0x6046, 0x1303),(0x6048, 0x1303),(0x604A, 0x1303),(0x604C, 0x1303),(0x604E, 0x1303),(0x6050, 0x1303),(0x6052, 0x1303),(0x6054, 0x1303),(0x6056, 0x1303),(0x6058, 0x1303),(0x605A, 0x1303),(0x605C, 0x1303),(0x605E, 0x1303),(0x6060, 0x1303),(0x6062, 0x1303),(0x6064, 0x1303),(0x6066, 0x1303),(0x6068, 0x1303),(0x606A, 0x1303),(0x606C, 0x1303),(0x606E, 0x1303),(0x6070, 0x1303),(0x6072, 0x1303),(0x6074, 0x1303),(0x6076, 0x1303),(0x6078, 0x1303),(0x607A, 0x1303),(0x607C, 0x1303),(0x607E, 0x1303),(0x6080, 0x1303),(0x6082, 0x1303),(0x6084, 0x1303),(0x6086, 0x1303),(0x6088, 0x1303),(0x608A, 0x1303),(0x608C, 0x1303),(0x608E, 0x1303),(0x6090, 0x1303),(0x6092, 0x1303),(0x6094, 0x1303),(0x6096, 0x1303),(0x6098, 0x1303),(0x609A, 0x1303),(0x609C, 0x1303),(0x609E, 0x1303),(0x60A0, 0x1303),(0x60A2, 0x1303),(0x60A4, 0x1303),(0x60A6, 0x1303),(0x60A8, 0x1303),(0x60AA, 0x1303),(0x60AC, 0x1303),(0x60AE, 0x1303),(0x60B0, 0x1303),(0x60B2, 0x1303),(0x60B4, 0x1303),(0x60B6, 0x1303),(0x60B8, 0x1303),(0x60BA, 0x1303),(0x60BC, 0x1303),(0x60BE, 0x1303),(0x60C0, 0x1303),(0x60C2, 0x1303),(0x60C4, 0x1303),(0x60C6, 0x1303),(0x60C8, 0x1303),(0x60CA, 0x1303),(0x60CC, 0x1303),(0x60CE, 0x1303),(0x60D0, 0x1303),(0x60D2, 0x1303),(0x60D4, 0x1303),(0x60D6, 0x1303),(0x60D8, 0x1303),(0x60DA, 0x1303),(0x60DC, 0x1303),(0x60DE, 0x1303),(0x60E0, 0x1303),(0x60E2, 0x1303),(0x60E4, 0x1303),(0x60E6, 0x1303),(0x60E8, 0x1303),(0x60EA, 0x1303),(0x60EC, 0x1303),(0x60EE, 0x1303),(0x60F0, 0x1303),(0x60F2, 0x1303),(0x60F4, 0x1303),(0x60F6, 0x1303),(0x60F8, 0x1303),(0x60FA, 0x1303),(0x60FC, 0x1303),(0x60FE, 0x1303),])
    OverlayLabel = Tag('Overlay Label', "OverlayLabel", 0x6000, 0x1500, [], [(0x6002, 0x1500),(0x6004, 0x1500),(0x6006, 0x1500),(0x6008, 0x1500),(0x600A, 0x1500),(0x600C, 0x1500),(0x600E, 0x1500),(0x6010, 0x1500),(0x6012, 0x1500),(0x6014, 0x1500),(0x6016, 0x1500),(0x6018, 0x1500),(0x601A, 0x1500),(0x601C, 0x1500),(0x601E, 0x1500),(0x6020, 0x1500),(0x6022, 0x1500),(0x6024, 0x1500),(0x6026, 0x1500),(0x6028, 0x1500),(0x602A, 0x1500),(0x602C, 0x1500),(0x602E, 0x1500),(0x6030, 0x1500),(0x6032, 0x1500),(0x6034, 0x1500),(0x6036, 0x1500),(0x6038, 0x1500),(0x603A, 0x1500),(0x603C, 0x1500),(0x603E, 0x1500),(0x6040, 0x1500),(0x6042, 0x1500),(0x6044, 0x1500),(0x6046, 0x1500),(0x6048, 0x1500),(0x604A, 0x1500),(0x604C, 0x1500),(0x604E, 0x1500),(0x6050, 0x1500),(0x6052, 0x1500),(0x6054, 0x1500),(0x6056, 0x1500),(0x6058, 0x1500),(0x605A, 0x1500),(0x605C, 0x1500),(0x605E, 0x1500),(0x6060, 0x1500),(0x6062, 0x1500),(0x6064, 0x1500),(0x6066, 0x1500),(0x6068, 0x1500),(0x606A, 0x1500),(0x606C, 0x1500),(0x606E, 0x1500),(0x6070, 0x1500),(0x6072, 0x1500),(0x6074, 0x1500),(0x6076, 0x1500),(0x6078, 0x1500),(0x607A, 0x1500),(0x607C, 0x1500),(0x607E, 0x1500),(0x6080, 0x1500),(0x6082, 0x1500),(0x6084, 0x1500),(0x6086, 0x1500),(0x6088, 0x1500),(0x608A, 0x1500),(0x608C, 0x1500),(0x608E, 0x1500),(0x6090, 0x1500),(0x6092, 0x1500),(0x6094, 0x1500),(0x6096, 0x1500),(0x6098, 0x1500),(0x609A, 0x1500),(0x609C, 0x1500),(0x609E, 0x1500),(0x60A0, 0x1500),(0x60A2, 0x1500),(0x60A4, 0x1500),(0x60A6, 0x1500),(0x60A8, 0x1500),(0x60AA, 0x1500),(0x60AC, 0x1500),(0x60AE, 0x1500),(0x60B0, 0x1500),(0x60B2, 0x1500),(0x60B4, 0x1500),(0x60B6, 0x1500),(0x60B8, 0x1500),(0x60BA, 0x1500),(0x60BC, 0x1500),(0x60BE, 0x1500),(0x60C0, 0x1500),(0x60C2, 0x1500),(0x60C4, 0x1500),(0x60C6, 0x1500),(0x60C8, 0x1500),(0x60CA, 0x1500),(0x60CC, 0x1500),(0x60CE, 0x1500),(0x60D0, 0x1500),(0x60D2, 0x1500),(0x60D4, 0x1500),(0x60D6, 0x1500),(0x60D8, 0x1500),(0x60DA, 0x1500),(0x60DC, 0x1500),(0x60DE, 0x1500),(0x60E0, 0x1500),(0x60E2, 0x1500),(0x60E4, 0x1500),(0x60E6, 0x1500),(0x60E8, 0x1500),(0x60EA, 0x1500),(0x60EC, 0x1500),(0x60EE, 0x1500),(0x60F0, 0x1500),(0x60F2, 0x1500),(0x60F4, 0x1500),(0x60F6, 0x1500),(0x60F8, 0x1500),(0x60FA, 0x1500),(0x60FC, 0x1500),(0x60FE, 0x1500),])
    OverlayData = Tag('Overlay Data', "OverlayData", 0x6000, 0x3000, [], [(0x6002, 0x3000),(0x6004, 0x3000),(0x6006, 0x3000),(0x6008, 0x3000),(0x600A, 0x3000),(0x600C, 0x3000),(0x600E, 0x3000),(0x6010, 0x3000),(0x6012, 0x3000),(0x6014, 0x3000),(0x6016, 0x3000),(0x6018, 0x3000),(0x601A, 0x3000),(0x601C, 0x3000),(0x601E, 0x3000),(0x6020, 0x3000),(0x6022, 0x3000),(0x6024, 0x3000),(0x6026, 0x3000),(0x6028, 0x3000),(0x602A, 0x3000),(0x602C, 0x3000),(0x602E, 0x3000),(0x6030, 0x3000),(0x6032, 0x3000),(0x6034, 0x3000),(0x6036, 0x3000),(0x6038, 0x3000),(0x603A, 0x3000),(0x603C, 0x3000),(0x603E, 0x3000),(0x6040, 0x3000),(0x6042, 0x3000),(0x6044, 0x3000),(0x6046, 0x3000),(0x6048, 0x3000),(0x604A, 0x3000),(0x604C, 0x3000),(0x604E, 0x3000),(0x6050, 0x3000),(0x6052, 0x3000),(0x6054, 0x3000),(0x6056, 0x3000),(0x6058, 0x3000),(0x605A, 0x3000),(0x605C, 0x3000),(0x605E, 0x3000),(0x6060, 0x3000),(0x6062, 0x3000),(0x6064, 0x3000),(0x6066, 0x3000),(0x6068, 0x3000),(0x606A, 0x3000),(0x606C, 0x3000),(0x606E, 0x3000),(0x6070, 0x3000),(0x6072, 0x3000),(0x6074, 0x3000),(0x6076, 0x3000),(0x6078, 0x3000),(0x607A, 0x3000),(0x607C, 0x3000),(0x607E, 0x3000),(0x6080, 0x3000),(0x6082, 0x3000),(0x6084, 0x3000),(0x6086, 0x3000),(0x6088, 0x3000),(0x608A, 0x3000),(0x608C, 0x3000),(0x608E, 0x3000),(0x6090, 0x3000),(0x6092, 0x3000),(0x6094, 0x3000),(0x6096, 0x3000),(0x6098, 0x3000),(0x609A, 0x3000),(0x609C, 0x3000),(0x609E, 0x3000),(0x60A0, 0x3000),(0x60A2, 0x3000),(0x60A4, 0x3000),(0x60A6, 0x3000),(0x60A8, 0x3000),(0x60AA, 0x3000),(0x60AC, 0x3000),(0x60AE, 0x3000),(0x60B0, 0x3000),(0x60B2, 0x3000),(0x60B4, 0x3000),(0x60B6, 0x3000),(0x60B8, 0x3000),(0x60BA, 0x3000),(0x60BC, 0x3000),(0x60BE, 0x3000),(0x60C0, 0x3000),(0x60C2, 0x3000),(0x60C4, 0x3000),(0x60C6, 0x3000),(0x60C8, 0x3000),(0x60CA, 0x3000),(0x60CC, 0x3000),(0x60CE, 0x3000),(0x60D0, 0x3000),(0x60D2, 0x3000),(0x60D4, 0x3000),(0x60D6, 0x3000),(0x60D8, 0x3000),(0x60DA, 0x3000),(0x60DC, 0x3000),(0x60DE, 0x3000),(0x60E0, 0x3000),(0x60E2, 0x3000),(0x60E4, 0x3000),(0x60E6, 0x3000),(0x60E8, 0x3000),(0x60EA, 0x3000),(0x60EC, 0x3000),(0x60EE, 0x3000),(0x60F0, 0x3000),(0x60F2, 0x3000),(0x60F4, 0x3000),(0x60F6, 0x3000),(0x60F8, 0x3000),(0x60FA, 0x3000),(0x60FC, 0x3000),(0x60FE, 0x3000),])
    ExtendedOffsetTable = Tag('Extended Offset Table', "ExtendedOffsetTable", 0x7FE0, 0x0001)
    ExtendedOffsetTableLengths = Tag('Extended Offset Table Lengths', "ExtendedOffsetTableLengths", 0x7FE0, 0x0002)
    EncapsulatedPixelDataValueTotalLength = Tag('Encapsulated Pixel Data Value Total Length', "EncapsulatedPixelDataValueTotalLength", 0x7FE0, 0x0003)
    PixelData = Tag('Pixel Data', "PixelData", 0x7FE0, 0x0010, [TagLink(IconImageSequence),])
