from enum import Enum
from typing import Union


class OpenMLDatasetID(Enum):
    BIN_ANONYM_ADA = 41156
    BIN_ANONYM_ALBERT = 41147
    BIN_ANONYM_APS_FAILURE = 41138
    BIN_ANONYM_ARCENE = 41157
    BIN_ANONYM_AUSTRALIAN_CREDIT_APPROVAL = 40981
    BIN_ANONYM_AUTOUNIV_AU1 = 1547
    BIN_ANONYM_BIORESPONSE = 4134
    BIN_ANONYM_CHRISTINE = 41142
    BIN_ANONYM_GAMETES = 40650
    BIN_ANONYM_GINA = 41158
    BIN_ANONYM_GUILLERMO = 41159
    BIN_ANONYM_JASMINE = 41143
    BIN_ANONYM_KDDCUP_98_DIRECT_MAIL = 42343
    BIN_ANONYM_KDDCUP_09_APPETENCY = 1111
    BIN_ANONYM_KDDCUP_09_UPSELLING = 43072
    BIN_ANONYM_MADELINE = 41144
    BIN_ANONYM_MADELONE = 1485
    BIN_ANONYM_MAMMOGRAPHY = 310
    BIN_ANONYM_MONKS_PROBLEM_2 = 334
    BIN_ANONYM_NUMERAI_28_6 = 23517
    BIN_ANONYM_OIL_SPILL = 311
    BIN_ANONYM_PHILIPPINE = 41145
    BIN_ANONYM_PORTO_SEGURO = 42742
    BIN_ANONYM_RICARDO = 41161
    BIN_ANONYM_SATELLITE = 40900
    BIN_ANONYM_SYLVINE = 41146
    BIN_ANONYM_TWONORM = 1507
    BIN_ANONYM_XD6 = 40693
    BIN_COMPUTERS_CPU_TOKYO1 = 40705
    BIN_COMPUTERS_IMAGE_BANK_NOTE_AUTHENTICATION = 43466
    BIN_COMPUTERS_IMAGE_SKIN_SEGMENTATION = 1502
    BIN_COMPUTERS_MOZILLA = 1046
    BIN_COMPUTERS_KC1_CODE_DEFECTIONS = 1067
    BIN_COMPUTERS_PC4_CODE_DEFECTIONS = 1049
    BIN_COMPUTERS_PHISHING_URL_WEBSITES = 43622
    BIN_COMPUTERS_PHISHING_WEBSITE_HUDDERSFIELD = 4534
    BIN_CONSUMER_BLASTCHAR_TELCOM_CHURN = 46280
    BIN_CONSUMER_CHURN_TELCO_EUROPA = 44228
    BIN_CONSUMER_CHURN_TELCO_NIGERIA = 44230
    BIN_CONSUMER_CHURN_TELCO_SOUTH_ASIA = 44227
    BIN_CONSUMER_CHURN_TELEPHONY = 40701
    BIN_CONSUMER_CLICK_PREDICTION = 42733
    BIN_CONSUMER_DRESS_DALES = 23381
    BIN_CONSUMER_ELECTRICITY_PRICE_TREND = 44156
    BIN_CONSUMER_HOTEL_REVIEW = 43721
    BIN_CONSUMER_INTERNET_ADVERTISEMENTS = 40978
    BIN_CONSUMER_MOBILE_CHURN = 44231
    BIN_CONSUMER_NEWSPAPER_CHURN = 44226
    BIN_CONSUMER_ONLINE_SHOPPERS_PURCHASE_INTENTION = 45560
    BIN_CONSUMER_TOUR_TRAVEL_CHURN = 45545
    BIN_CONSUMER_WHOLESALE_CUSTOMERS_PORTUGAL = 1511
    BIN_FINANCIAL_ACCOUNT_DEBT_SOUTH_AFRICA = 43838
    BIN_FINANCIAL_ADULT_INCOME = 1590
    BIN_FINANCIAL_AUDIT_RISK = 42931
    BIN_FINANCIAL_BANK_ACCOUNT_FRAUD_BAF = 46646
    BIN_FINANCIAL_BANK_CUSTOMER_CHURN_SHRUTIME = 45062
    BIN_FINANCIAL_BANK_MARKETING = 1461
    BIN_FINANCIAL_BANK_PERSONAL_LOAN_MODELING = 43826
    BIN_FINANCIAL_BANKRUPTCY_QUALITATIVE = 1495
    BIN_FINANCIAL_CC_FRAUD = 45955
    BIN_FINANCIAL_CC_FRAUD_TRANSACTION = 46369
    BIN_FINANCIAL_CC_TAIWAN_CREDIT_DEFAULT = 43435
    BIN_FINANCIAL_CREDIT_FICO_HELOC = 45554
    BIN_FINANCIAL_CREDIT_GERMAN = 31
    BIN_FINANCIAL_CREDIT_GIVE_ME_SOME = 45577
    BIN_FINANCIAL_CREDIT_RISK_DEFAULT = 43454
    BIN_FINANCIAL_FRAUD_DETECTION = 46359
    BIN_FINANCIAL_HOME_CREDIT_DEFAULT_RISK = 45567
    BIN_FINANCIAL_HOME_EQUITY_CREDIT = 43337
    BIN_FINANCIAL_LOAN_STATUS_PREDICTION = 43595
    BIN_FINANCIAL_LT_VEHICLE_LOAN = 46430
    BIN_FINANCIAL_TVS_CREDIT_LOAN = 43743
    BIN_GENETICS_MUSK_MOLECULES = 1116
    BIN_GENETICS_OVA_BREAST = 1128
    BIN_GEOGRAPHY_NOMAO_SEARCH_ENGINE = 1486
    BIN_HEALTHCARE_ALZHEIMER_HANDWRITE_DARWIN = 46606
    BIN_HEALTHCARE_BLOOD_TRANSFUSION = 1464
    BIN_HEALTHCARE_BONE_MARROW_TRANSPLANT_CHILDREN = 46610
    BIN_HEALTHCARE_BREAST_CANCER_MAMMOGRAM = 43687
    BIN_HEALTHCARE_BREAST_CANCER_WISCONSIN = 15
    BIN_HEALTHCARE_BREAST_CANCER_YUGOSLAVIA = 13
    BIN_HEALTHCARE_CELLS_WDBC_WISCONSIN_BREAST_CANCER = 1510
    BIN_HEALTHCARE_CARDIOVASCULAR_DISEASE = 45547
    BIN_HEALTHCARE_DIABETES_CDC_DEMOGRAPHICS = 46598
    BIN_HEALTHCARE_DIABETES_EARLY_STAGE = 43643
    BIN_HEALTHCARE_DIABETES_RISK_FACTORS = 46254
    BIN_HEALTHCARE_GLIOMA_BRAIN_TUMOR = 46604
    BIN_HEALTHCARE_HEART_DISEASE = 43672
    BIN_HEALTHCARE_HEART_FAILURE = 45950
    BIN_HEALTHCARE_INSURANCE_LEAD_PREDICTION = 45064
    BIN_HEALTHCARE_KIDNEY_CHRONIC_DISEASE = 42972
    BIN_HEALTHCARE_LIVER_INDIAN_ILPD = 1480
    BIN_HEALTHCARE_LUNG_MALE_ARSENIC = 951
    BIN_HEALTHCARE_MENTAL_HEALTH_TECH = 46719
    BIN_HEALTHCARE_SEPSIS_PHYSIONET = 46677
    BIN_HEALTHCARE_THYROID_CANCER = 46605
    BIN_INDUSTRIAL_CYLINDER_BANDING_PRINTING = 6332
    BIN_NATURE_COLIC_HORSES_SURGICAL_LESION = 25
    BIN_NATURE_DISEASED_TREES_WILT = 40983
    BIN_NATURE_OZONE_LEVEL = 1487
    BIN_NATURE_MUSHROOM_POISONOUS = 24
    BIN_NATURE_PHONEME_SOUNDS = 1489
    BIN_PROFESSIONAL_ACADEMIC_COLLEGE_SCORECARD = 46674
    BIN_PROFESSIONAL_AMAZON_EMPLOYEE_ACCESS = 4135
    BIN_PROFESSIONAL_EMPLOYEE_IBM_ATTRITION = 43893
    BIN_PROFESSIONAL_EMPLOYEE_TURNOVER_TECHCO = 43551
    BIN_PROFESSIONAL_FAKE_JOB_POSTING = 46655
    BIN_PROFESSIONAL_KICKSTARTER_FUNDING = 46668
    BIN_PROFESSIONAL_LICD_LABOR_RIGHTS = 46640
    BIN_SCIENCE_ANTIGEN_AVIDA_HIL6 = 46648
    BIN_SCIENCE_CLIMATE_MODEL_SIMULATION_CRASHES = 40994
    BIN_SCIENCE_EYE_MOVEMENT = 44157
    BIN_SCIENCE_EYE_STATE_EEG = 1471
    BIN_SCIENCE_HIV_QSAR = 1039
    BIN_SCIENCE_MAGIC_TELESCOPE = 44125
    BIN_SCIENCE_PARTICLE_HIGGS = 42769
    BIN_SCIENCE_PARTICLE_MINIBOONE = 41150
    BIN_SCIENCE_QSAR_BIODEG = 1494
    BIN_SCIENCE_SIMULATION_HILL_VALLEY = 1479
    BIN_SCIENCE_WATER_TREATMENT = 940
    BIN_SOCIAL_COMPASS_TWO_YEARS_OFFEND = 45039
    BIN_SOCIAL_EDUCATIONAL_TRANSITIONS_IRISH = 451
    BIN_SOCIAL_IMDB_GENRE_PREDICTION = 46667
    BIN_SOCIAL_GAMING_LEAGUE_OF_LEGENDS_DIAMOND = 43635
    BIN_SOCIAL_HATE_SPEECH_DATASET_DYNAMICALLY_GENERATED = 46683
    BIN_SOCIAL_JIGSAW_TOXICITY = 46654
    BIN_SOCIAL_POLICE_INCIDENTS_SAN_FRANCISCO = 42732
    BIN_SOCIAL_POLITICS_US_CONGRESS_VOTES = 56
    BIN_SOCIAL_SPAM_EMAILS_SPAMBASE = 44
    BIN_SOCIAL_SPEED_DATING = 40536
    BIN_SOCIAL_TIC_TAC_TOE = 50
    BIN_SOCIAL_TWITTER_DISASTER = 43395
    BIN_SPORTS_CHESS_KR_VS_KP = 3
    BIN_SPORTS_NBA_SHOTS = 42806
    BIN_SPORTS_PRO_FOOTBALL_BETS_PROFB = 470
    BIN_SPORTS_RUN_OR_WALK = 40922
    BIN_TRANSPORTATION_AIRLINES_DEPARTURE_DELAY = 1169
    BIN_TRANSPORTATION_CAR_BAD_BUY_KICK = 41162
    BIN_TRANSPORTATION_ESTONIA_DISASTER_PASSENGERS = 43389
    BIN_TRANSPORTATION_ROAD_SAFETY_GENDER = 45038
    BIN_TRANSPORTATION_TITANIC_SURVIVAL = 40945
    MUL_ANONYM_AMAZON_COMMERCE_REVIEWS = 1457
    MUL_ANONYM_CNAE = 1468
    MUL_ANONYM_DILBERT = 41163
    MUL_ANONYM_DNA = 40670
    MUL_ANONYM_FABERT = 41164
    MUL_ANONYM_FIRST_ORDER_THEOREM_PROVING = 1475
    MUL_ANONYM_FOURIER_IMAGE_COEFFICIENT = 14
    MUL_ANONYM_HELENA = 41169
    MUL_ANONYM_ISOLET_LETTER_SPEECH_RECOGNITION = 300
    MUL_ANONYM_JANNIS = 41168
    MUL_ANONYM_LED24 = 40677
    MUL_ANONYM_MFEAT_FACTORS = 12
    MUL_ANONYM_MICRO_MASS = 1515
    MUL_ANONYM_PENDIGITS = 32
    MUL_ANONYM_POL = 201
    MUL_ANONYM_PLANTS_TEXTURE = 1493
    MUL_ANONYM_ROBERT = 41165
    MUL_ANONYM_SPOKEN_ARABIC_DIGIT = 1503
    MUL_ANONYM_SYNTHETIC_CONTROL = 377
    MUL_ANONYM_VOLCANOES_VENUS = 1542
    MUL_ANONYM_VOLKERT = 41166
    MUL_ANONYM_ZERNIKE_MFEAT = 22
    MUL_COMPUTERS_IMAGE_ARTIFICIAL_CHARACTERS = 1459
    MUL_COMPUTERS_IMAGE_CIFAR10 = 40927
    MUL_COMPUTERS_IMAGE_GESTURE_PHASE_SEGMENTATION = 4538
    MUL_COMPUTERS_IMAGE_GTSRB_GERMAN_TRAFFIC_SIGN = 41990
    MUL_COMPUTERS_IMAGE_INDIAN_PINES = 41972
    MUL_COMPUTERS_IMAGE_LETTER_RECOGNITION = 6
    MUL_COMPUTERS_IMAGE_MNIST_DIGITS = 554
    MUL_COMPUTERS_IMAGE_MNIST_FASHION = 40996
    MUL_COMPUTERS_IMAGE_MNIST_JAPANESE_KUZUSHIJI_49 = 41991
    MUL_COMPUTERS_IMAGE_OPT_DIGITS = 28
    MUL_COMPUTERS_IMAGE_SEGMENTATION = 40984
    MUL_COMPUTERS_INTRUSION_DETECTION_KDD = 42746
    MUL_COMPUTERS_META_STREAM_INTERVALS = 279
    MUL_COMPUTERS_PAGE_BLOCK_PARSING = 30
    MUL_COMPUTERS_ROBOT_WALL_NAVIGATION = 1497
    MUL_CONSUMER_ELECTRICITY_TAMILNADU = 40985
    MUL_CONSUMER_INTERNET_USAGE_PROFESSION = 372
    MUL_CONSUMER_PRODUCT_SENTIMENT = 46651
    MUL_CONSUMER_WOMEN_ECOMMERCE_CLOTHING_REVIEW = 46659
    MUL_FINANCIAL_CORPORATE_CREDIT_RATING_CAT = 46372
    MUL_FINANCIAL_CORPORATE_CREDIT_RATING_SYMBOL = 43344
    MUL_FINANCIAL_CREDIT_RISK_CHINA = 46444
    MUL_FINANCIAL_CREDIT_SCORE_HZL = 46441
    MUL_FINANCIAL_LOAN_IBRD = 46467
    MUL_FINANCIAL_P2P_LOAN = 43502
    MUL_FOOD_WINE_QUALITY_CAT = 40498
    MUL_FOOD_WINE_REVIEW = 46653
    MUL_GENETICS_SPLICE_DNA = 46
    MUL_GENETICS_ACP_BREAST_CANCER = 42895
    MUL_HEALTHCARE_APPENDICITIS_REGENSBURG_PEDIATRIC = 46603
    MUL_HEALTHCARE_AUDIOLOGY_DIAGNOSTIC = 7
    MUL_HEALTHCARE_BABY_SLEEP_STATE = 679
    MUL_HEALTHCARE_CANCER_CERVICAL = 46592
    MUL_HEALTHCARE_CMC_CONTRACEPTIVE_WOMEN = 23
    MUL_HEALTHCARE_DIABETES_US130 = 4541
    MUL_HEALTHCARE_EGYPTIAN_SKULLS = 1099
    MUL_HEALTHCARE_HEART_ARRHYTMIA = 5
    MUL_HEALTHCARE_HEART_CARDIOTOCOGRAPHY = 1466
    MUL_HEALTHCARE_HEPATITIS_C_EGYPT = 46607
    MUL_HEALTHCARE_HYPOTHYROID = 57
    MUL_HEALTHCARE_LYMPH_YUGOSLAVIA = 10
    MUL_HEALTHCARE_MENTAL_HEALTH_OCCUPATION = 46721
    MUL_HEALTHCARE_OBESITY_LEVELS = 46597
    MUL_HEALTHCARE_PBCSEQ_BILIARY_CIRRHOSIS = 516
    MUL_HEALTHCARE_TEETH_DMFT_ANALCATDATA = 469
    MUL_HEALTHCARE_WHITE_BLOOD_CELLS_WBC = 46676
    MUL_HOUSES_MELBOURNE_AIRBNB = 46665
    MUL_INDUSTRIAL_STEEL_PLATES_FAULT = 40982
    MUL_NATURE_AIR_QUALITY_POLLUTION = 46762
    MUL_NATURE_CJS_MAPLE_TREES = 23380
    MUL_NATURE_EUCALYPTUS_SEED = 188
    MUL_NATURE_FOREST_COVERTYPE = 1596
    MUL_NATURE_SOLAR_FLARES = 44966
    MUL_NATURE_SOYBEAN_DISEASE = 42
    MUL_NATURE_YEAST_PROTEIN = 181
    MUL_PROFESSIONAL_DATA_SCIENTIST_SALARY = 46664
    MUL_PROFESSIONAL_NURSERY_APPLICATIONS_SLOVENIA = 26
    MUL_PROFESSIONAL_STUDENT_PERFORMANCE_ENTRANCE_EXAM = 46584
    MUL_PROFESSIONAL_TEACHER_ASSISTANT_EVALUATION_TAE = 48
    MUL_SCIENCE_ANNEAL_CHEMICAL = 2
    MUL_SCIENCE_BALANCE_SCALE = 11
    MUL_SCIENCE_BATCH_CHORAL_HARMONY = 4552
    MUL_SCIENCE_DRUG_DIRECTORY_FDA_UNAPPROVED = 43044
    MUL_SCIENCE_MICE_PROTEIN = 40966
    MUL_SCIENCE_MIMIC_ROUTE = 46678
    MUL_SCIENCE_QSAR_BIOCONCENTRATION = 46585
    MUL_SCIENCE_VOWEL_JAPANESE = 375
    MUL_SCIENCE_VOWEL_SPEAKER_RECOGNITION = 307
    MUL_SCIENCE_WAVEFORM_500 = 60
    MUL_SOCIAL_BIAS_FRAMES = 46701
    MUL_SOCIAL_BOOKS_AUTHORSHIP_ANALCATDATA = 458
    MUL_SOCIAL_BROWN_FROWN_CORPORA_COLLINS = 40971
    MUL_SOCIAL_DPBEDIA = 46686
    MUL_SOCIAL_FUNPEDIA = 46692
    MUL_SOCIAL_GOOGLE_QA_TYPE_REASON = 46658
    MUL_SOCIAL_HARRY_POTTER_FAN_FICTION = 43544
    MUL_SOCIAL_HOLISTIC_BIAS = 46684
    MUL_SOCIAL_NEWS_CHANNEL_CATEGORY = 46652
    MUL_SOCIAL_OKCUPID_DATING_JOB_STEM = 42734
    MUL_SOCIAL_SOCC_OPINION_COMMENTS_CORPUS_TOXICITY = 46709
    MUL_SOCIAL_STACKOVERFLOW_POLARITY = 43160
    MUL_SOCIAL_SUPREME_COURT_ANALCATDATA = 504
    MUL_SOCIAL_WIKIPEDIA_TALK_LABELS_ATTACKS = 46708
    MUL_SPORTS_ACTIVITY_LOCALIZED_LDPA = 1483
    MUL_SPORTS_BASEBALL_HALL_OF_FAME = 185
    MUL_SPORTS_CHESS_JUNGLE = 41027
    MUL_SPORTS_CONNECT4_GAME = 40668
    MUL_SPORTS_POKER_HAND = 1567
    MUL_SPORTS_WALKING_ACTIVITY = 1509
    MUL_TRANSPORTATION_AIRLINES_TWITTER_SENTIMENT = 43397
    MUL_TRANSPORTATION_CAR_ACCEPTABILITY = 40975
    MUL_TRANSPORTATION_CAR_ORIGIN_COUNTRY = 455
    MUL_TRANSPORTATION_CAR_STUDENT_INSURANCE_RISK = 43157
    MUL_TRANSPORTATION_SHUTTLE_SPACE = 40685
    MUL_TRANSPORTATION_TRAFFIC_ACCIDENTS_FARS = 40672
    MUL_TRANSPORTATION_TRAFFIC_VIOLATION = 42345
    MUL_TRANSPORTATION_VEHICLE_SILHOUETTE = 54
    REG_ANONYM_ALLSTATE_CLAIM_SEVERITY = 42571
    REG_ANONYM_BANK_32NH = 558
    REG_ANONYM_BUZZ_IN_SOCIAL_MEDIA_TWITTER = 4549
    REG_ANONYM_DIONIS = 41167
    REG_ANONYM_FAT_MEAT_TECATOR = 505
    REG_ANONYM_GEOGRAPHICAL_ORIGIN_OF_MUSIC = 44965
    REG_ANONYM_HOUSE_16H = 574
    REG_ANONYM_MERCEDES_BENZ_GREENER_MANUFACTURING = 42570
    REG_ANONYM_SANTANDER_TRANSACTION_VALUE = 42572
    REG_ANONYM_TOPO = 422
    REG_ANONYM_YOLANDA = 42705
    REG_ANONYM_YPROP = 416
    REG_COMPUTERS_ALGO_RUNTIME_MIP2016 = 43071
    REG_COMPUTERS_ALGO_RUNTIME_SAT11 = 41980
    REG_COMPUTERS_CPU_ACTIVITY = 44978
    REG_COMPUTERS_GAMING_FRAMES_FPS_BENCHMARK = 44992
    REG_COMPUTERS_META_LEVEL_LEARNING = 566
    REG_COMPUTERS_PUMA_ROBOT_ARM = 44981
    REG_COMPUTERS_ROBOT_KIN8NM = 44980
    REG_COMPUTERS_ROBOT_SARCOS = 44976
    REG_COMPUTERS_YOUTUBE_VIDEO_TRANSCODING = 44974
    REG_CONSUMER_AMERICAN_EAGLE_PRICES = 46656
    REG_CONSUMER_AVOCADO_SALES = 41210
    REG_CONSUMER_BLACK_FRIDAY = 41540
    REG_CONSUMER_BOOK_PRICE_PREDICTION = 46663
    REG_CONSUMER_BOOKING_HOTEL_REVIEW = 43712
    REG_CONSUMER_DIAMONDS_PRICES = 42225
    REG_CONSUMER_JC_PENNEY_PRODUCT_PRICE = 46661
    REG_CONSUMER_MEDICAL_CHARGES = 44146
    REG_CONSUMER_MERCARI_ONLINE_MARKETPLACE = 46660
    REG_CONSUMER_ONLINE_NEWS_POPULARITY = 46662
    BIN_CONSUMER_REASONER_RECOMMENDATION = 46681
    REG_FINANCIAL_CC_USER_SEGMENTATION = 43618
    REG_FINANCIAL_INSURANCE_HEALTH_HOURS_WORKED_WIFE = 44993
    REG_FINANCIAL_INSURANCE_PREMIUM_DATA = 43463
    REG_FINANCIAL_STOCK_AEROSPACE = 223
    REG_FOOD_WINE_JUDGEMENT_SENSORY = 546
    REG_HEALTHCARE_BODY_FAT = 560
    REG_HEALTHCARE_DIABETES_SKLEARN = 44223
    REG_HEALTHCARE_POLLUTION_LA_MORTALITY_RMFTSA = 666
    REG_HOUSES_BOSTON_HOUSE = 531
    REG_HOUSES_BOSTON_PRICE_NOMINAL = 42563
    REG_HOUSES_BRAZILIAN_HOUSES = 42688
    REG_HOUSES_CALIFORNIA_HOUSES = 44977
    REG_HOUSES_CALIFORNIA_PRICES_2020 = 46669
    REG_HOUSES_GERMAN_HOUSES = 43342
    REG_HOUSES_HOUSEHOLD_MONTHLY_ELECTRICITY = 43588
    REG_HOUSES_IOWA_HOUSES_PRICES = 42165
    REG_HOUSES_LISBON = 43660
    REG_HOUSES_MIAMI = 44983
    REG_HOUSES_PERTH = 43822
    REG_HOUSES_SEATTLE_KINGS_COUNTY = 42731
    REG_NATURE_ABALONE_FISH_RINGS = 42726
    REG_NATURE_CLIMATE_CHANGE_AGRICULTURE_FINANCIAL = 46726
    REG_NATURE_EL_NINO_KDD = 563
    REG_NATURE_FISH_TOXICITY = 44970
    REG_NATURE_FOREST_FIRES = 44962
    REG_NATURE_MYANMAR_AIR_QUALITY = 43748
    REG_NATURE_NO2_POLLUTION_NORWAY = 547
    REG_NATURE_POLLEN_GRAINS_SYNTH = 529
    REG_NATURE_POLLEN_LUXEMBOURG = 43648
    REG_NATURE_QUAKE_RICHTER = 550
    REG_NATURE_WIND_SPEED_IRELAND = 503
    REG_PROFESSIONAL_CPS88_WAGES = 44984
    REG_PROFESSIONAL_EMPLOYEE_SALARY_MONTGOMERY = 42125
    REG_PROFESSIONAL_STUDENT_PERFORMANCE_PORTUGAL = 44967
    REG_SCIENCE_AIRFOIL_SELF_NOISE = 44957
    REG_SCIENCE_AUCTION_VERIFICATION = 44958
    REG_SCIENCE_CONCRETE_COMPRESSIVE_STRENGTH = 44959
    REG_SCIENCE_ENERGY_EFFICIENCY = 44960
    REG_SCIENCE_GRID_STABILITY = 44973
    REG_SCIENCE_PHYSIOCHEMICAL_PROTEIN = 44963
    REG_SCIENCE_QSAR_TID_11 = 3050
    REG_SCIENCE_QSAR_TID_10980 = 3277
    REG_SCIENCE_SIMULATION_2D_PLANES = 215
    REG_SCIENCE_SIMULATION_FRIED_FORMULA_PREDICT = 564
    REG_SCIENCE_SIMULATION_MV = 344
    REG_SCIENCE_SULFUR = 44145
    REG_SCIENCE_SUPERCONDUCTIVITY = 44964
    REG_SCIENCE_WAVE_ENERGY = 44975
    REG_SOCIAL_COLLEGES_GRANTS = 42727
    REG_SOCIAL_OCCUPATION_MOBILITY_SOCMOB = 541
    REG_SOCIAL_OKCUPID_DATING_PROFILE_AGE = 42164
    REG_SOCIAL_STRIKES_PER_COUNTRY = 549
    REG_SOCIAL_US_CRIME = 42730
    REG_SOCIAL_VOTING_SPACE_GEOGRAPHIC_ANALYSIS = 507
    REG_SPORTS_BASEBALL_HITTER_SALARY = 525
    REG_SPORTS_FIFA20_PLAYERS_VALUE = 43766
    REG_SPORTS_FIFA22_WAGES = 45012
    REG_SPORTS_FIFA_PLAYERS_STATS = 42194
    REG_SPORTS_MONEYBALL = 41021
    REG_SPORTS_NBA_2K20_PLAYERS_RATING = 43420
    REG_SPORTS_NBA_ALL_STAR = 43653
    REG_TRANSPORTATION_CAR_GM_PRICE = 44994
    REG_TRANSPORTATION_FLIGHT_SIMULATION_ELEVATORS = 216
    REG_TRANSPORTATION_NAVAL_PROPULSION_PLANT = 44969
    REG_TRANSPORTATION_NYC_BIKE_TRIP_DURATION = 43573
    REG_TRANSPORTATION_NYC_TAXI_TIP = 42729
    REG_TRANSPORTATION_NYC_TAXI_TRIP_DURATION = 43584
    REG_TRANSPORTATION_SEOUL_BIKE_SHARING_DEMAND = 46328
    REG_TRANSPORTATION_US_AIRPORT_PASSENGERS = 43479
    REG_TRANSPORTATION_US_BIKE_SHARING_DEMAND = 42712
    REG_TRANSPORTATION_ZURICH_PUBLIC_TRANSPORT_DELAY = 40753

class KaggleDatasetID(Enum):
    BIN_SOCIAL_HUMAN_CHOICE_PREDICTION_LM_GAMES = "eilamshapira/human-choice-prediction-in-language-based-games/OPE_train.csv"
    MUL_FOOD_MICHELIN_GUIDE_RESTAURANTS = "ngshiheng/michelin-guide-restaurants-2021/michelin_my_maps.csv"
    MUL_FOOD_YELP_REVIEWS = "omkarsabnis/yelp-reviews-dataset/yelp.csv"
    MUL_SOCIAL_GOT_SCRIPTS = 'albenft/game-of-thrones-script-all-seasons/Game_of_Thrones_Script.csv'
    MUL_SOCIAL_US_ELECTIONS_SPEECHES = "imuhammad/us-2020-presidential-election-speeches/us_2020_election_speeches.csv"
    MUL_TRANSPORTATION_US_ACCIDENTS_MARCH23 = "sobhanmoosavi/us-accidents/US_Accidents_March23.csv"
    REG_CONSUMER_CAR_PRICE_CARDEKHO = "sukritchatterjee/used-cars-dataset-cardekho/cars_details_merges.csv"
    REG_FOOD_ALCOHOL_WIKILIQ_PRICES = "limtis/wikiliq-dataset/spirits_data.csv"
    REG_FOOD_BEER_RATINGS = "ruthgn/beer-profile-and-ratings-data-set/beer_profile_and_ratings.csv"
    REG_FOOD_CHOCOLATE_BAR_RATINGS = "rtatman/chocolate-bar-ratings/flavors_of_cacao.csv"
    REG_FOOD_COFFEE_REVIEW = "hanifalirsyad/coffee-scrap-coffeereview/coffee_clean.csv"
    REG_FOOD_RAMEN_RATINGS_2022 = "ankanhore545/top-ramen-ratings-2022/Top Ramen Ratings .csv"
    REG_FOOD_WHISKY_SCOTCH_REVIEWS = "neilcosgrove/scotch-whiskey-reviews-update-2020/scotch_review2020.csv"
    REG_FOOD_WINE_POLISH_MARKET_PRICES = "skamlo/wine-price-on-polish-market/wine.csv"
    REG_FOOD_WINE_VIVINO_SPAIN = 'joshuakalobbowles/vivino-wine-data/vivino.csv'
    REG_FOOD_ZOMATO_RESTAURANTS = "himanshupoddar/zomato-bangalore-restaurants/zomato.csv"
    REG_PROFESSIONAL_COMPANY_EMPLOYEES_SIZE = "peopledatalabssf/free-7-million-company-dataset/companies_sorted.csv"
    REG_SOCIAL_ANIME_PLANET_RATING = 'hernan4444/animeplanet-recommendation-database-2020/anime.csv'
    REG_SOCIAL_BOOK_READABILITY_CLEAR = "verracodeguacas/clear-corpus/CLEAR.csv"
    REG_SOCIAL_FILMTV_MOVIE_RATING_ITALY = "stefanoleone992/filmtv-movies-dataset/filmtv_movies.csv"
    REG_SOCIAL_KOREAN_DRAMA = "noorrizki/top-korean-drama-list-1500/kdrama_list.csv"
    REG_SOCIAL_MOVIES_DATASET_REVENUE = "rounakbanik/the-movies-dataset/movies_metadata.csv"
    REG_SOCIAL_MUSEUMS_US_REVENUES = "markusschmitz/museums/museums_prep.csv"
    REG_SOCIAL_SPOTIFY_POPULARITY = "maharshipandya/-spotify-tracks-dataset/dataset.csv"
    REG_SOCIAL_VIDEO_GAMES_SALES = "gregorut/videogamesales/vgsales.csv"
    REG_SPORTS_FOOTBALL_MANAGER_IMPORTANT_MATCHES = "ajinkyablaze/football-manager-data/dataset.csv"
    REG_SPORTS_NBA_DRAFT_VALUE_OVER_REPLACEMENT = "mattop/nba-draft-basketball-player-data-19892021/nbaplayersdraft.csv"
    REG_TRANSPORTATION_USED_CAR_MERCEDES_BENZ_ITALY = "bogdansorin/second-hand-mercedes-benz-registered-2000-2023-ita/mercedes-benz.csv"
    REG_TRANSPORTATION_USED_CAR_PAKISTAN = "mustafaimam/used-car-prices-in-pakistan-2021/Used_car_prices_in_Pakistan_cleaned.csv"
    REG_TRANSPORTATION_USED_CAR_SAUDI_ARABIA = "turkibintalib/saudi-arabia-used-cars-dataset/UsedCarsSA_Clean_EN.csv"

class UrlDatasetID(Enum):
    REG_CONSUMER_BABIES_R_US_PRICES = "http://pages.cs.wisc.edu/~anhai/data/784_data/baby_products/csv_files/babies_r_us.csv"
    REG_CONSUMER_BIKE_PRICE_BIKEWALE = "http://pages.cs.wisc.edu/~anhai/data/784_data/bikes/csv_files/bikewale.csv"
    REG_PROFESSIONAL_EMPLOYEE_RENUMERATION_VANCOUBER = "https://opendata.vancouver.ca/api/records/1.0/download/?dataset=employee-remuneration-and-expenses-earning-over-75000&format=csv"
    REG_PROFESSIONAL_ML_DS_AI_JOBS_SALARIES = "https://ai-jobs.net/salaries/download/salaries.csv"
    REG_PROFESSIONAL_SCIMAGOJR_ACADEMIC_IMPACT = "https://www.scimagojr.com/journalrank.php?out=xls"
    REG_SOCIAL_BOOKS_GOODREADS = "http://pages.cs.wisc.edu/~anhai/data/784_data/books2/csv_files/goodreads.csv"
    REG_SOCIAL_MOVIES_ROTTEN_TOMATOES = "http://pages.cs.wisc.edu/~anhai/data/784_data/movies1/csv_files/rotten_tomatoes.csv"


TabularDatasetID = Union[OpenMLDatasetID, KaggleDatasetID, UrlDatasetID]