"""
Collectors are used to collect multiple candidates generated by generators.
This is a task that can be parallelized over the number of generated candidates,
and this is done using parallelization from Ray.
"""
# ruff: noqa: I001, E402

from typing import TypeAlias
from .ABC_collector import CollectorBaseClass
Collector: TypeAlias = CollectorBaseClass

from agox.collectors.replica_exchange import ReplicaExchangeCollector
from agox.collectors.ray_collector import ParallelCollector
from agox.collectors.standard import StandardCollector

__all__ = [
        "CollectorBaseClass",
        "Collector",
        "StandardCollector", 
        "ParallelCollector", 
        "ReplicaExchangeCollector",
        ]
