from math import pi, tan

default_sym_dict = [
    {
        "name": "p6m",
        "system": "hexagonal",
        "number_max": 12,
        "axes": [[1, -1, 0], [1, 1, 0]],
        "rotations": [[[0, 0, 0], 6], [[1 / 2, 1 / 2, 0], 2], [[1 / 3, 1 / 3, 0], 3]],
        "points": [
            [0, 0, 0],
            [1 / 3, 1 / 3, 0],
            [1 / 2, 1 / 2, 0],
            ["x", 0, 0],
            ["x", "x", 0],
        ],
    },
    {
        "name": "p4g",
        "system": ["square"],
        "number_max": 8,
        "axes": [[[1, 1, 0], [1 / 2, 1 / 2, 0]]],
        "rotations": [
            [[1 / 2, 1 / 2, 0], 4],
            [[0, 0, 0], 4],
            [[1 / 2, 0, 0], 2],
            [[0, 1 / 2, 0], 2],
        ],
        "points": [
            [0, 0, 0],
            [1 / 2, 0, 0],
            ["x", "1/2+x", 0],
            ["x", "1/2-x", 0],
            ["x", "x-1/2", 0],
        ],
    },
    {
        "name": "p4m",
        "system": ["square"],
        "number_max": 8,
        "axes": [[1, 0, 0], [1, 1, 0], [0, 1, 0], [1, -1, 0]],
        "rotations": [[[1 / 2, 1 / 2, 0], 4], [[0, 0, 0], 4], [[1 / 2, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            [1 / 2, 1 / 2, 0],
            [1 / 2, 0, 0],
            ["x", "x", 0],
            ["x", 0, 0],
            [1 / 2, "x", 0],
        ],
    },
    {
        "name": "p6",
        "system": "hexagonal",
        "number_max": 6,
        "axes": None,
        "rotations": [
            [[0, 0, 0], 6],
            [[1 / 2, 1 / 2, 0], 2],
            [[1 / 3, 1 / 3, 0], 3],
            [[2 / 3, 2 / 3, 0], 3],
            [[1 / 2, 0, 0], 2],
        ],
        "points": [[0, 0, 0], [1 / 3, 1 / 3, 0], [1 / 2, 1 / 2, 0]],
    },
    {
        "name": "p31m",
        "system": "hexagonal",
        "number_max": 6,
        "axes": [[1, -1, 0]],
        "rotations": [[[1 / 3, 1 / 3, 0], 3], [[0, 0, 0], 3], [[2 / 3, 2 / 3, 0], 3]],
        "points": [[0, 0, 0], [1 / 3, 1 / 3, 0], ["x", 0, 0]],
    },
    {
        "name": "p3m1",
        "system": "hexagonal",
        "number_max": 6,
        "axes": [[1, 1, 0]],
        "rotations": [[[1 / 3, 1 / 3, 0], 3], [[2 / 3, 2 / 3, 0], 3], [[0, 0, 0], 3]],
        "points": [[0, 0, 0], [1 / 3, 1 / 3, 0], [2 / 3, 2 / 3, 0], ["x", "x", 0]],
    },
    {
        "name": "pcmm",
        "system": ["square", "rhombic"],
        "number_max": 4,
        "axes": [[1, -1, 0], [1, 1, 0]],
        "rotations": [[[0, 0, 0], 2], [[1 / 2, 1 / 2, 0], 2], [[1 / 2, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", "1-x", 0],
            ["x", "x", 0],
            [0, 1 / 2, 0],
            [1 / 2, 1 / 2, 0],
        ],
    },
    {
        "name": "pgm",
        "system": ["rectangular"],
        "number_max": 4,
        "axes": [[1, 0, 0]],
        "rotations": [[[1 / 2, 1 / 4, 0], 2]],
        "points": [[1 / 2, 1 / 4, 0], [0, 1 / 4, 0]],
    },
    {
        "name": "pmg",
        "system": ["rectangular"],
        "number_max": 4,
        "axes": [[0, 1, 0]],
        "rotations": [[[1 / 4, 1 / 2, 0], 2]],
        "points": [[1 / 4, 1 / 2, 0], [0, 1 / 2, 0]],
    },
    {
        "name": "p2mm",
        "system": ["rectangular", "square"],
        "number_max": 4,
        "axes": [[1, 0, 0], [0, 1, 0]],
        "rotations": [
            [[1 / 2, 1 / 2, 0], 2],
            [[0, 0, 0], 2],
            [[1 / 2, 0, 0], 2],
            [[0, 1 / 2, 0], 2],
        ],
        "points": [
            [0, 1 / 2, 0],
            [1 / 2, 1 / 2, 0],
            [1 / 2, 0, 0],
            [0, 0, 0],
            ["x", 0, 0],
            [0, "x", 0],
            [1 / 2, "x", 0],
            ["x", 1 / 2, 0],
        ],
    },
    {
        "name": "p4",
        "system": ["square"],
        "number_max": 4,
        "axes": None,
        "rotations": [[[1 / 2, 1 / 2, 0], 4], [[0, 0, 0], 4], [[1 / 2, 0, 0], 2]],
        "points": [[0, 0, 0], [1 / 2, 0, 0], [1 / 2, 1 / 2, 0]],
    },
    {
        "name": "p2gg",
        "system": ["square", "rectangular"],
        "number_max": 4,
        "axes": [[[1, 0, 0], [1 / 2, 0, 0], [1 / 4, 0, 0]]],
        "rotations": [
            [[1 / 2, 1 / 2, 0], 2],
            [[0, 0, 0], 2],
            [[1 / 2, 0, 0], 2],
            [[0, 1 / 2, 0], 2],
        ],
        "points": [[0, 0, 0], [1 / 2, 1 / 2, 0], [1 / 2, 0, 0], [0, 1 / 2, 0]],
    },
    {
        "name": "p3",
        "system": ["hexagonal"],
        "number_max": 3,
        "axes": None,
        "rotations": [[[0, 0, 0], 3], [[1 / 3, 1 / 3, 0], 3], [[2 / 3, 2 / 3, 0], 3]],
        "points": [[0, 0, 0], [1 / 3, 1 / 3, 0], [2 / 3, 2 / 3, 0]],
    },
    {
        "name": "pm",
        "system": ["rectangular"],
        "number_max": 2,
        "axes": [[1, 0, 0]],
        "rotations": None,
        "points": [["x", 1 / 2, 0], ["x", 0, 0]],
    },
    {
        "name": "pg",
        "system": ["rectangular"],
        "number_max": 2,
        "axes": [[[1, 0, 0], [1 / 2, 0, 0]]],
        "rotations": None,
        "points": [["x", 1 / 2, 0]],
    },
    {
        "name": "p2",
        "system": ["square", "rectangular", "rhombic", "oblique", "hexagonal"],
        "number_max": 2,
        "axes": None,
        "rotations": [
            [[1 / 2, 1 / 2, 0], 2],
            [[0, 0, 0], 2],
            [[1 / 2, 0, 0], 2],
            [[0, 1 / 2, 0], 2],
        ],
        "points": [[0, 0, 0], [1 / 2, 0, 0], [0, 1 / 2, 0], [1 / 2, 1 / 2, 0]],
    },
    {
        "name": "p1",
        "system": ["rectangular", "hexagonal", "square", "oblique", "rhombic"],
        "number_max": 1,
        "axes": None,
        "rotations": None,
        "points": None,
    },
]

# NB for clusters special points are relative to the cluster center
cluster_sym_dict = [
    {
        "name": "Ih5",
        "system": "cluster",
        "number_max": 120,
        "rotations": [
            [[1, tan(pi / 5), 1.61803398875], 3],
        ],
        #'rotations2':[[[1,0,1.61803398875],2]],
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 5), 0],
            [1, tan(2 * pi / 5), 0],
            [1, tan(3 * pi / 5), 0],
            [1, tan(4 * pi / 5), 0],
        ],
        "subgroups": ["D5d", "D5h", "Td"],
        "plane": [[-1, -1, -1]],
        "ghost": 12,
        "points": [
            [0, 0, 0],
            [0, 0, "x"],
            ["x", 0, 0],
            ["x", 0, "y"],
            ["x", "x*0.726542", "y"],
            ["x", "y", 0],
            ["x", "0.72654252*x", "1.61803398875*x"],
            ["x", "0.72654252*x", "-1.61803398875*x"],
            [1, 0, "1.61803398875*x"],
        ],
    },
    {
        "name": "Oh4",
        "system": ["cluster", "cubic"],
        "number_max": 48,
        "rotations": [[[-1, -1, 1], 3], [[1, 1, 1], 3], [[0, 1, 1], 2]],
        "axes": [[1, 0, 0], [1, 1, 0], [0, 1, 0], [1, -1, 0]],
        "subgroups": ["Td", "Th", "O", "D4h"],
        "plane": [[1, 1, 1]],
        "ghost": 8,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", "x", 0],
            ["x", 0, "y"],
            ["x", "x", "x"],
            ["x", "x", "y"],
        ],
    },
    {
        "name": "O",
        "system": ["cluster", "cubic"],
        "number_max": 24,
        "rotations": [[[0, 0, 1], 4], [[-1, -1, 1], 3], [[1, 1, 1], 3], [[0, 1, 1], 2]],
        "axes": None,
        "subgroups": ["D4", "T"],
        "plane": None,
        "ghost": 6,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", "x", 0],
            ["x", 0, "y"],
            ["x", "x", "x"],
            ["x", "x", "y"],
        ],
    },
    {
        "name": "Td",
        "system": ["cluster", "cubic"],
        "number_max": 24,
        "rotations": [
            [[1, -1, 1], 3],
            [[1, 1, 1], 3],
            [[1, 1, -1], 3],
            [[0, 0, 1], 2],
            [[1, 0, 0], 2],
            [[0, 1, 0], 2],
        ],
        "axes": [[1, 1, 0], [-1, 1, 0]],
        "points": [
            [0, 0, 0],
            ["x", "-x", "x"],
            [0, 0, "x"],
            ["x", "x", "y"],
            ["x", "x", "x"],
            ["x", 0, "y"],
            ["x", 0, 0],
        ],
        "subgroups": ["D2d_2", "T", "S4"],
        "plane": None,
        "ghost": 4,
    },
    {
        "name": "Th",
        "system": ["cluster", "cubic"],
        "number_max": 24,
        "rotations": [
            [[-1, -1, 1], 3],
            [[1, 1, 1], 3],
            [[1, 1, -1], 3],
            [[0, 0, 1], 2],
            [[1, 0, 0], 2],
        ],
        "axes": None,
        "points": [
            [0, 0, 0],
            [0, "x", 0],
            ["x", "y", "y"],
            ["x", "x", 0],
            ["x", "x", "x"],
            [0, "x", "x"],
            [0, "x", 0],
            ["x", 0, 0],
            ["x", 0, "y"],
        ],
        "subgroups": ["D2h", "T", "S6"],
        "plane": [[-1, -1, -1]],
        "ghost": 6,
    },
    {
        "name": "T",
        "system": ["cluster", "cubic"],
        "number_max": 12,
        "rotations": [[[-1, -1, 1], 3], [[1, 1, 1], 3], [[1, 0, 0], 2], [[0, 0, 1], 2]],
        "axes": None,
        "points": [
            [0, 0, 0],
            ["x", "x", "y"],
            ["x", "-x", "y"],
            ["x", "x", "x"],
            ["x", 0, "y"],
            ["x", 0, 0],
        ],
        "subgroups": ["D2"],
        "plane": None,
        "ghost": 4,
    },
    {
        "name": "D7d",
        "system": "cluster",
        "number_max": 28,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 7), 0],
            [1, tan(2 * pi / 7), 0],
            [1, tan(3 * pi / 7), 0],
            [1, tan(4 * pi / 7), 0],
            [1, tan(5 * pi / 7), 0],
            [1, tan(6 * pi / 7), 0],
        ],
        "subgroups": ["D7", "S14"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            [0, 0, "x"],
            ["x", 0, 0],
            ["x", "y", 0],
            ["x", 0, "y"],
            ["x", "x*0.4815746188", "y"],
            ["x", "x*0.4815746", 0],
            ["x", "x", "y"],
            ["x", "x", 0],
        ],
        "plane": [[-1, -1, -1]],
        "ghost": 14,
    },
    {
        "name": "D6d",
        "system": "cluster",
        "number_max": 24,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 6), 0],
            [1, tan(2 * pi / 6), 0],
            [0, 1, 0],
            [1, tan(4 * pi / 6), 0],
            [1, tan(5 * pi / 6), 0],
        ],
        "subgroups": ["D2d", "D6", "C6v", "D3d", "S12"],
        "rotations": [[[1, 1, 0], 2]],
        "points": [
            [0, 0, 0],
            [0, 0, "x"],
            ["x", 0, 0],
            ["x", "y", 0],
            ["x", 0, "y"],
            ["x", "x*0.577350", "y"],
            ["x", "x*0.577350", 0],
            ["x", "x", "y"],
            ["x", "x", 0],
        ],
        "plane": None,
        "ghost": 12,
    },
    {
        "name": "D5d",
        "system": "cluster",
        "number_max": 20,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 5), 0],
            [1, tan(2 * pi / 5), 0],
            [1, tan(3 * pi / 5), 0],
            [1, tan(4 * pi / 5), 0],
        ],
        "subgroups": ["C5v", "D5", "S10"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", "x*0.726542", 0],
            ["x", "y", 0],
            ["x", "x*0.726542", "y"],
            ["x", 0, "y"],
            [0, 0, "x"],
        ],
        "plane": [[-1, -1, -1]],
        "ghost": 10,
    },
    {
        "name": "D4d",
        "system": "cluster",
        "number_max": 16,
        "subgroups": ["C4v", "D4", "D2d", "S8"],
        "rotations": [[[1, 0.41421356, 0], 2]],
        "axes": [[1, 0, 0], [1, 1, 0], [0, 1, 0], [1, -1, 0]],
        "points": [
            [0, 0, 0],
            ["x", 0, "y"],
            ["x", "x*0.41421356", "y"],
            ["x", "x*0.41421356", 0],
            ["x", "x", "y"],
            ["x", "y", 0],
            ["x", 0, 0],
            ["x", "x", 0],
        ],
        "plane": None,
        "ghost": 8,
    },
    {
        "name": "D3d",
        "system": ["cluster", "hexagonal"],
        "number_max": 12,
        "axes": [[1, 0, 0], [1, tan(pi / 3), 0], [1, tan(2 * pi / 3), 0]],
        "subgroups": ["C3v", "D3"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", "1.7320*x", "y"],
            ["x", 0, "y"],
            ["x", "y", 0],
            [0, 0, "x"],
        ],
        "plane": [[-1, -1, -1]],
        "ghost": 6,
    },
    {
        "name": "D2d",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 8,
        "axes": [[1, 0, 0], [0, 1, 0]],
        "subgroups": ["C2v", "D2", "S4"],
        "rotations": [[[1, 1, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", 0, "y"],
            [0, "x", "y"],
            ["x", "x", "y"],
            ["x", "x", 0],
            [0, 0, "x"],
        ],
        "plane": None,
        "ghost": 4,
    },
    {
        "name": "D2d_2",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 8,
        "axes": [[1, 1, 0], [-1, 1, 0]],
        "subgroups": ["C2v", "D2", "S4"],
        "rotations": [[[1, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", "x", 0],
            ["x", "x", "y"],
            [0, "x", "y"],
            ["x", "y", 0],
            [0, 0, "x"],
            ["x", 0, 0],
            ["x", 0, "y"],
        ],
        "plane": None,
        "ghost": 4,
    },
    {
        "name": "D6h",
        "system": ["cluster", "hexagonal"],
        "number_max": 24,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 6), 0],
            [1, tan(2 * pi / 6), 0],
            [0, 1, 0],
            [1, tan(4 * pi / 6), 0],
            [1, tan(5 * pi / 6), 0],
        ],
        "subgroups": ["D3h", "D3d", "D6", "C6v", "S6"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            [0, 0, "x"],
            ["x", "y", 0],
            ["x", 0, 0],
            ["x", "y", 0],
            ["x", 0, "y"],
            ["x", "x*0.577350", "y"],
            ["x", "x*0.577350", 0],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 6,
    },
    {
        "name": "D5h",
        "system": "cluster",
        "number_max": 20,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 5), 0],
            [1, tan(2 * pi / 5), 0],
            [1, tan(3 * pi / 5), 0],
            [1, tan(4 * pi / 5), 0],
        ],
        "subgroups": ["C5v", "D5"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", "x*0.726542", 0],
            ["x", "x*0.726542", "y"],
            ["x", 0, "y"],
            ["x", "y", 0],
            [0, 0, "x"],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 5,
    },
    {
        "name": "D4h",
        "system": ["cluster", "cubic", "tetragonal", "orthorombic"],
        "number_max": 16,
        "subgroups": ["C4v", "D4", "D2d", "D2h", "D2d_2"],
        "rotations": None,
        "axes": [[1, 0, 0], [1, 1, 0], [0, 1, 0], [1, -1, 0]],
        "points": [
            [0, 0, 0],
            ["x", 0, "y"],
            ["x", "x", "y"],
            ["x", "y", 0],
            ["x", "x", 0],
            ["x", 0, 0],
            [0, 0, "x"],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 4,
    },
    {
        "name": "D3h",
        "system": ["cluster", "hexagonal"],
        "number_max": 12,
        "axes": [[1, 0, 0], [1, tan(pi / 3), 0], [1, tan(2 * pi / 3), 0]],
        "subgroups": ["C3v", "D3"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            ["x", 0, "y"],
            ["x", "y", 0],
            ["x", "1.7320*x", "y"],
            ["x", "1.7320*x", 0],
            [0, 0, "x"],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 3,
    },
    {
        "name": "D2h",
        "system": ["cluster", "cubic", "tetragonal", "orthorombic"],
        "number_max": 8,
        "axes": [[1, 0, 0], [0, 1, 0]],
        "subgroups": ["C2v", "D2"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", 0, 0],
            [0, "x", 0],
            ["x", 0, "y"],
            [0, "x", "y"],
            ["x", "y", 0],
            [0, 0, "x"],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 2,
    },
    {
        "name": "D2h_2",
        "system": ["cluster", "cubic", "tetragonal", "orthorombic"],
        "number_max": 8,
        "axes": [[1, 1, 0], [-1, 1, 0]],
        "subgroups": ["C2v", "D2"],
        "rotations": None,
        "points": [
            [0, 0, 0],
            ["x", "x", 0],
            [0, "x", 0],
            ["x", 0, "y"],
            ["x", "x", "y"],
            [0, "x", "y"],
            ["x", "y", 0],
            [0, 0, "x"],
        ],
        "plane": [[1, 1, 1]],
        "ghost": 2,
    },
    {
        "name": "D7",
        "system": "cluster",
        "number_max": 14,
        "axes": None,
        "rotations": [[[0, 0, 1], 7], [[1, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", "y", 0],
            ["x", 0, 0],
            ["x", "x*0.4815746", 0],
            [0, "x", 0],
            [0, 0, "x"],
        ],
        "plane": None,
        "ghost": 7,
        "subgroups": ["C1"],
    },
    {
        "name": "D6",
        "system": ["cluster", "hexagonal"],
        "number_max": 12,
        "axes": None,
        "rotations": [[[0, 0, 1], 6], [[1, 0, 0], 2], [[0, 1, 0], 2]],
        "points": [
            [0, 0, 0],
            [0, "x", 0],
            ["x", "x*0.577350", 0],
            ["x", "y", 0],
            ["x", 0, 0],
            [0, 0, "x"],
        ],
        "plane": None,
        "ghost": 6,
        "subgroups": ["C6", "D3", "D2"],
    },
    {
        "name": "D5",
        "system": "cluster",
        "number_max": 10,
        "axes": None,
        "rotations": [[[0, 0, 1], 5], [[1, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", "y", 0],
            ["x", 0, 0],
            ["x", "x*0.726542", 0],
            [0, "x", 0],
            [0, 0, "x"],
        ],
        "plane": None,
        "ghost": 5,
        "subgroups": ["C5", "C1"],
    },
    {
        "name": "D4",
        "system": ["cluster", "cubic", "tetragonal"],
        "number_max": 8,
        "axes": None,
        "rotations": [[[0, 0, 1], 4], [[1, 0, 0], 2]],
        "points": [[0, 0, 0], ["x", "y", 0], ["x", "x", 0], ["x", 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 4,
        "subgroups": ["C4", "D2"],
    },
    {
        "name": "D3",
        "system": ["cluster", "hexagonal"],
        "number_max": 6,
        "axes": None,
        "rotations": [[[0, 0, 1], 3], [[1, 0, 0], 2]],
        "points": [
            [0, 0, 0],
            ["x", "1.7320*x", "y"],
            ["x", "y", 0],
            ["x", 0, 0],
            [0, 0, "x"],
        ],
        "plane": None,
        "ghost": 3,
        "subgroups": ["C3", "C1"],
    },
    {
        "name": "D2",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 4,
        "axes": None,
        "rotations": [[[0, 0, 1], 2], [[1, 0, 0], 2]],
        "points": [[0, 0, 0], ["x", "y", 0], ["x", 0, 0], [0, "x", 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 2,
        "subgroups": ["C2", "C1"],
    },
    {
        "name": "C6v",
        "system": ["cluster", "hexagonal"],
        "number_max": 12,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 6), 0],
            [1, tan(2 * pi / 6), 0],
            [0, 1, 0],
            [1, tan(4 * pi / 6), 0],
            [1, tan(5 * pi / 6), 0],
        ],
        "rotations": None,
        "points": [[0, 0, 0], ["x", "x*0.577350", "y"], ["x", 0, "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 6,
        "subgroups": ["C6", "C1"],
    },
    {
        "name": "C5v",
        "system": "cluster",
        "number_max": 10,
        "axes": [
            [1, 0, 0],
            [1, tan(pi / 5), 0],
            [1, tan(2 * pi / 5), 0],
            [1, tan(3 * pi / 5), 0],
            [1, tan(4 * pi / 5), 0],
        ],
        "rotations": None,
        "points": [[0, 0, 0], ["x", "x*0.726542", "y"], ["x", 0, "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 5,
        "subgroups": ["C5", "C1"],
    },
    {
        "name": "C4v",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 8,
        "axes": [[1, 0, 0], [1, 1, 0], [0, 1, 0], [1, -1, 0]],
        "rotations": None,
        "points": [[0, 0, 0], ["x", 0, "y"], ["x", "x", "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 4,
        "subgroups": ["C4", "C1"],
    },
    {
        "name": "C3v",
        "system": "cluster",
        "number_max": 6,
        "axes": [[1, 0, 0], [1, tan(pi / 3), 0], [1, tan(2 * pi / 3), 0]],
        "rotations": None,
        "points": [[0, 0, 0], ["x", 0, "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 3,
        "subgroups": ["C3", "C1"],
    },
    {
        "name": "C2v",
        "system": ["cluster", "cubic", "tetragonal"],
        "number_max": 4,
        "axes": [[1, 0, 0], [0, 1, 0]],
        "rotations": None,
        "points": [[0, 0, 0], ["x", 0, "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 2,
        "subgroups": ["C2", "C1"],
    },
    {
        "name": "C2v_2",
        "system": ["cluster", "cubic", "tetragonal"],
        "number_max": 4,
        "axes": [[1, 1, 0], [1, -1, 0]],
        "rotations": None,
        "points": [[0, 0, 0], ["x", "x", "y"], [0, 0, "x"]],
        "plane": None,
        "ghost": 2,
        "subgroups": ["C2", "C1"],
    },
    {
        "name": "S14",
        "system": "cluster",
        "number_max": 14,
        "axes": None,
        "rotations": [[[0, 0, 1], 7]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[-1, -1, -1]],
        "ghost": 14,
        "subgroups": ["C1"],
    },
    {
        "name": "S12",
        "system": "cluster",
        "number_max": 12,
        "axes": None,
        "rotations": [[[0, 0, 1], 6]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[1, -1, -1]],
        "ghost": 12,
        "subgroups": ["C1", "C6", "S4"],
    },
    {
        "name": "S10",
        "system": "cluster",
        "number_max": 10,
        "axes": None,
        "rotations": [[[0, 0, 1], 5]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[-1, -1, -1]],
        "ghost": 10,
        "subgroups": ["C1", "C5"],
    },
    {
        "name": "S8",
        "system": "cluster",
        "number_max": 8,
        "axes": None,
        "rotations": [[[0, 0, 1], 4]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[1, -1, -1]],
        "ghost": 8,
        "subgroups": ["C1", "C4"],
    },
    {
        "name": "S6",
        "system": ["cluster", "hexagonal"],
        "number_max": 6,
        "axes": None,
        "rotations": [[[0, 0, 1], 3]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[-1, -1, -1]],
        "ghost": 6,
        "subgroups": ["C1", "C3"],
    },
    {
        "name": "S4",
        "system": ["cluster", "cubic", "tetragonal"],
        "number_max": 4,
        "axes": None,
        "rotations": [[[0, 0, 1], 2]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": [[1, -1, -1]],
        "ghost": 4,
        "subgroups": ["C1", "C2"],
    },
    {
        "name": "C6",
        "system": ["cluster", "hexagonal"],
        "number_max": 6,
        "axes": None,
        "rotations": [[[0, 0, 1], 6]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 6,
        "subgroups": ["C1", "C3"],
    },
    {
        "name": "C5",
        "system": "cluster",
        "number_max": 5,
        "axes": None,
        "rotations": [[[0, 0, 1], 5]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 5,
        "subgroups": ["C1"],
    },
    {
        "name": "C4",
        "system": ["cluster", "cubic", "tetragonal"],
        "number_max": 4,
        "axes": None,
        "rotations": [[[0, 0, 1], 4]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 4,
        "subgroups": ["C1"],
    },
    {
        "name": "C3",
        "system": ["cluster", "hexagonal"],
        "number_max": 3,
        "axes": None,
        "rotations": [[[0, 0, 1], 3]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 3,
        "subgroups": ["C1"],
    },
    {
        "name": "C2",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 2,
        "axes": None,
        "rotations": [[[0, 0, 1], 2]],
        "points": [[0, 0, 0], [0, 0, "x"]],
        "plane": None,
        "ghost": 2,
        "subgroups": ["C1"],
    },
    {
        "name": "C1",
        "system": ["cluster", "hexagonal", "cubic", "tetragonal"],
        "number_max": 1,
        "axes": None,
        "rotations": None,
        "points": None,
        "plane": None,
        "ghost": 0,
        "subgroups": ["C1"],
    },
]
