"""
Many algorithms use generators that are seeded by previous candidates, e.g. in
Basin-Hopping the next candidate is generated by a small random perturbation of
the previous candidate.

Samplers are responsible for keeping track of which candidates to use as seeds
for the next generation of candidates.
"""
# ruff: noqa: I001, E402
from typing import TypeAlias
from .ABC_sampler import SamplerBaseClass
Sampler: TypeAlias = SamplerBaseClass

from .concurrent_tempering import ConcurrentTemperingSampler
from .fixed_sampler import FixedSampler
from .genetic import DistanceComparator, GeneticSampler
from .kernel_similarity import KernelSimSampler
from .kmeans import KMeansSampler
from .metropolis import MetropolisSampler
from .replica_exchange import ReplicaExchangeSampler
from .spectral_graph import SpectralGraphSampler


__all__ = [
    "SamplerBaseClass",
    "SpectralGraphSampler",
    "KMeansSampler",
    "MetropolisSampler",
    "ConcurrentTemperingSampler",
    "ReplicaExchangeSampler", 
    "GeneticSampler",
    "DistanceComparator",
    "KernelSimSampler",
    "FixedSampler",
    "Sampler"
]
