from ..results import AnyResult, ErrorResult
from .cert import RADKitClientCertificate, RADKitEndpointCertificate, RADKitServiceCertificate
from .models import AuthenticationResult, OIDCAuthenticationResult, UserAgent
from collections.abc import AsyncGenerator
from dataclasses import dataclass
from datetime import datetime
from pydantic import HttpUrl
from radkit_common.access.auth import ClientOTP, ClientOTPResponse, DomainOAuthProviderInfo, EndpointAuthToken
from radkit_common.access.ca import ClientCertificateResponse, GetCertificateResponse, IssueCertificateRequest
from radkit_common.access.oauth import OAuthConnectResponse, OAuthEnabledTools
from radkit_common.access.types import REVOCATION_REASONS
from radkit_common.domains import AccessAPIEndpoints, Domain
from radkit_common.identities import ClientID, Email, EndpointID, ServiceID
from radkit_common.types import OAuthProvider
from radkit_common.utils.jwks import JWTValidator
from ssl import SSLContext
from typing import Any, TypeVar
from typing_extensions import Self

__all__ = ['RADKitAccessClient']

ResultModel = TypeVar('ResultModel')

@dataclass
class RADKitAccessClient:
    domain: Domain
    token_validator: JWTValidator
    identity: EndpointID | None = ...
    @classmethod
    async def from_domain(cls, domain: Domain, user_agent: UserAgent) -> AsyncGenerator[Self, None]: ...
    @property
    def access_endpoints(self) -> AccessAPIEndpoints: ...
    @property
    def ocsp_proxy_stapler_url(self) -> str | None: ...
    @property
    def ssl_context(self) -> SSLContext: ...
    admin_base_url = ...
    auth_base_url = ...
    ca_base_url = ...
    otp_base_url = ...
    proxy = ...
    logger = ...
    def __post_init__(self) -> None: ...
    @property
    def auth_token(self) -> EndpointAuthToken | None: ...
    @auth_token.setter
    def auth_token(self, token: EndpointAuthToken | None) -> None: ...
    @property
    def authenticated(self) -> bool: ...
    @property
    def endpoint_type(self) -> str | None: ...
    @property
    def is_service(self) -> bool: ...
    @property
    def is_user_client(self) -> bool: ...
    @property
    def is_admin_client(self) -> bool: ...
    @property
    def is_client(self) -> bool: ...
    async def post(self, url: str, model: type[ResultModel], data: dict[str, Any] | None = None, headers: dict[str, Any] | None = None) -> ResultModel | ErrorResult: ...
    async def get(self, url: str, model: type[ResultModel], data: dict[str, Any] | None = None, headers: dict[str, Any] | None = None) -> ResultModel | ErrorResult: ...
    async def put(self, url: str, model: type[ResultModel], data: dict[str, Any] | None = None, headers: dict[str, Any] | None = None) -> ResultModel | ErrorResult: ...
    async def delete(self, url: str, model: type[ResultModel], data: dict[str, Any] | None = None, headers: dict[str, Any] | None = None) -> ResultModel | ErrorResult: ...
    async def get_oauth_provider_info(self, domain: str, provider: OAuthProvider = ..., tool: OAuthEnabledTools | str | None = None) -> DomainOAuthProviderInfo | None: ...
    async def oauth_connect(self, email: Email, provider: OAuthProvider | None = None, admin_level: int = 0, redirect_url: HttpUrl | None = None) -> OAuthConnectResponse | ErrorResult: ...
    async def oauth_login(self, email: Email, provider: OAuthProvider | None = None, open_browser: bool = True, admin_level: int = 0, connect_response: OAuthConnectResponse | None = None, silent: bool = False) -> OIDCAuthenticationResult: ...
    async def logout(self) -> None: ...
    async def auth_refresh(self) -> bool: ...
    async def cert_auth(self, certificate: RADKitEndpointCertificate, admin_level: int = 0) -> AuthenticationResult: ...
    async def basic_auth(self, client_id: ClientID, password: str, admin_level: int = 0) -> AuthenticationResult: ...
    async def access_token_auth(self, token: str, provider: OAuthProvider | None = None, admin_level: int = 0) -> AuthenticationResult: ...
    jwt_auth = access_token_auth
    async def get_request_service_certificate_otp(self, service_id: ServiceID | None = None, service_owner_email: Email | None = None, description: str = '') -> ClientOTPResponse | ErrorResult: ...
    async def get_request_client_certificate_otp(self, client_id: ClientID, client_owner_email: Email, description: str = '') -> ClientOTPResponse | ErrorResult: ...
    async def request_certificate(self, request: IssueCertificateRequest, otp: ClientOTP | str | None = None) -> ClientCertificateResponse | ErrorResult: ...
    async def get_certificate(self, certificate_serial_number: str, otp: ClientOTP | str | None = None) -> GetCertificateResponse | ErrorResult: ...
    async def revoke_certificate(self, certificate_serial_number: str, revocation_reason: REVOCATION_REASONS = 'SUPERSEDED', otp: ClientOTP | str | None = None) -> AnyResult: ...
    async def renew_certificate(self, certificate_serial_number: str) -> RADKitEndpointCertificate | ErrorResult: ...
    async def request_service_certificate(self, service_id: ServiceID | None = None, service_owner_email: Email | None = None, otp: ClientOTPResponse | ClientOTP | str | None = None, description: str = '') -> RADKitServiceCertificate | ErrorResult: ...
    async def request_client_certificate(self, client_id: ClientID | None = None, client_owner_email: Email | None = None, admin: bool = False, otp: ClientOTPResponse | ClientOTP | str | None = None, description: str = '') -> RADKitClientCertificate | ErrorResult: ...
    async def subscribe_auth_token_changes(self) -> AsyncGenerator[EndpointAuthToken | None, None]: ...
    def parse_auth_response(self, response: dict[str, Any]) -> EndpointAuthToken | None: ...
    async def get_now_datetime(self) -> datetime | None: ...
