from anyio.abc import TaskGroup
from collections.abc import AsyncGenerator
from dataclasses import dataclass
from datetime import datetime
from radkit_common.access.client.client import RADKitAccessClient
from typing_extensions import Self

__all__ = ['AuthTokenRefreshLoop']

@dataclass
class AuthTokenRefreshLoop:
    access_client: RADKitAccessClient
    task_group: TaskGroup
    expire_at: datetime | None = ...
    logger = ...
    def __post_init__(self) -> None: ...
    @classmethod
    async def create(cls, access_client: RADKitAccessClient, expire_at: datetime | None = None) -> AsyncGenerator[Self, None]: ...
    @property
    def expired(self) -> bool: ...
    async def wait_loop_tick(self) -> None: ...
    async def wait_exit(self) -> None: ...
    def is_running(self) -> bool: ...
    def restart_loop(self) -> None: ...
    async def loop(self) -> None: ...
