PSILI = SMOOTH = "\u0313"
DASIA = ROUGH = "\u0314"
OXIA = ACUTE = "\u0301"
VARIA = GRAVE = "\u0300"
PERISPOMENI = CIRCUMFLEX = "\u0342"
YPOGEGRAMMENI = IOTA_SUBSCRIPT = "\u0345"
DIAERESIS = "\u0308"

ANTEPENULTIMATE = 'antepenultimate'
PENULTIMATE = 'penultimate'
ULTIMATE = 'ultimate'
INCORRECT_ACCENT = 'incorrect_accent'

vowels_dict = {'ά': 'α', 'έ': 'ε', 'ί': 'ι', 'ύ': 'υ', 'ό': 'ο', 'ώ': 'ω', 'ή': 'η', 'ΐ': 'ϊ', 'ΰ': 'ϋ'}

vowels_accented = ['ά', 'έ', 'ί', 'ύ', 'ό', 'ώ', 'ή', 'ΐ', 'ΰ']

vowels_unaccented = ['α', 'ε', 'ι', 'υ', 'ο', 'ω', 'η', 'ϊ', 'ϋ']

vowels = ['ά', 'Ά', 'α', 'έ', 'ε', 'ί', 'ι', 'ύ', 'υ', 'ό', 'ο', 'ώ', 'ω', 'ή', 'η', 'ΐ', 'ϊ', 'ΰ', 'ϋ', 'Ά', 'Α', 'Έ',
          'Ε', 'Ί', 'Ι', 'Ύ', 'Υ', 'Ό', 'Ο', 'Ώ', 'Ω', 'Ή', 'Η', 'Ϊ́', 'Ϊ', 'Ϋ́', 'Ϋ']

un_single_i = ['ι', 'η', 'υ', 'ϊ']

un_digraph_i = ['οι', 'ει', 'υι', 'Υι', 'Οι', 'Ει', 'ΟΙ', 'ΕΙ', 'ΥΙ']

valid_cons_cluster = ['στ', 'χρ', 'μπ', 'ντ', 'χτ', 'χθ', 'γδ']

diphtongs_dict = {'αύ': 'αυ', 'εύ': 'ευ', 'εί': 'ει', 'οί': 'οι', 'υί': 'υι', 'ού': 'ου', 'άη': 'αη', 'όη': 'οη',
                  'άι': 'αϊ', 'όι': 'οϊ', 'αί': 'αι'}

diphtongs = {'αύ',
             'αυ',
             'εύ',
             'ευ',
             'εί',
             'ει',
             'οί',
             'οι',
             'υί',
             'υι',
             'ού',
             'ου',
             'άη',
             'αη',
             'όη',
             'οη',
             'άι',
             'αϊ',
             'όι',
             'οϊ',
             'αί',
             'αι',
             'ΑΎ',
             'ΑΥ',
             'ΕΎ',
             'ΕΥ',
             'ΕΊ',
             'ΕΙ',
             'ΟΊ',
             'ΟΙ',
             'ΥΊ',
             'ΥΙ',
             'ΟΎ',
             'ΟΥ',
             'ΆΗ',
             'ΑΗ',
             'ΌΗ',
             'ΟΗ',
             'ΆΙ',
             'ΑΪ',
             'ΌΙ',
             'ΟΪ',
             'ΑΊ',
             'ΑΙ',
             'Αύ',
             'Αυ',
             'Εύ',
             'Ευ',
             'Εί',
             'Ει',
             'Οί',
             'Οι',
             'Υί',
             'Υι',
             'Ού',
             'Ου',
             'Άη',
             'Αη',
             'Όη',
             'Οη',
             'Άι',
             'Αϊ',
             'Όι',
             'Οϊ',
             'Αί',
             'Αι',
             }

vowels_anc_transcription = {'α': 'a', 'ε': 'e', 'ι': 'i', 'υ': 'u', 'ο': 'o', 'ω': 'o',
                            'η': 'h', 'ϊ': 'i', 'ϋ': 'u'}

vowels_mod_transcription = {'α': 'a', 'ε': 'e', 'ι': 'i', 'υ': 'i', 'ο': 'o', 'ω': 'o', 'η': 'i',
                            'ϊ': 'i', 'ϋ': 'i'}

consonants_anc_transcription = {'β': 'b', 'γ': 'g', 'δ': 'd', 'θ': 'th', 'ζ': 'z', 'λ': 'l', 'κ': 'k',
                                'μ': 'm', 'ν': 'n', 'π': 'p', 'ρ': 'r', 'σ': 's', 'ς': 's', 'τ': 't', 'φ': 'f',
                                'ψ': 'ps', 'ξ': 'ks', 'χ': 'ch'}

consonants_mod_transcription = {'β': 'w', 'γ': 'gh', 'δ': 'dh', 'θ': 'th', 'λ': 'l', 'μ': 'm', 'ν': 'n',
                                'π': 'p', 'ρ': 'r', 'σ': 's', 'ς': 's', 'τ': 't', 'φ': 'f', 'ψ': 'ps', 'ξ': 'ks',
                                'χ': 'ch', 'κ': 'k'}

digraphs_anc_transcirption = {'αυ': 'au', 'ευ': 'eu', 'γγ': 'ng', 'γκ': 'nk', 'γχ': 'nch', 'ου': 'ou'}

digraphs_mod_transciption = {'αυ': 'aw', 'ευ': 'ew', 'γγ': 'ng', 'γκ': 'ng', 'γχ': 'nch',
                             'ου': 'u', 'αι': 'e', 'οι': 'i', 'ει': 'i', 'υι': 'i', 'ηυ': 'iw'}

ancient_tr = {'vowels': vowels_anc_transcription,
              'consonants': consonants_anc_transcription,
              'digraphs': digraphs_anc_transcirption}

modern_tr = {'vowels': vowels_mod_transcription,
             'consonants': consonants_mod_transcription,
             'digraphs': digraphs_mod_transciption}

list_of_def_diphthongs = ['ειευ', 'οιευ', 'ιευ', 'ειαυ', 'οιαυ', 'ιαυ', 'ιου', 'οιου', 'ειου', 'υου', 'οια', 'οιε',
                          'οιοι', 'ειοι', 'οιι', 'οιυ', 'οιο', 'οιω', 'οιη', 'εια', 'ειε', 'ειι', 'ειυ', 'ειο', 'ειω', 'ειη', 'υια',
                          'υιε', 'υιι', 'υιυ', 'υιο', 'υιω', 'υιη', 'ιοι', 'ια', 'ιε', 'ιι', 'ιυ', 'ιο', 'ιω', 'ιη', 'ηα',
                          'ηε', 'ηι', 'ηυ', 'ηο', 'ηω', 'ηη', 'ηϊ', 'ηϋ', 'υα', 'υε', 'υι', 'υυ', 'υο', 'υω', 'υη']

# these prefixes change themselves or stem by esoteric augmentation
# I probably should change this model into key - augmented prefix, value -
# unaugmented, because for one augmented there are sometimes more than one
# unaugmented forms (para: pare, or parh)
dict_of_augmented_prefixes = {'ανα': 'ανε', 'δια': 'διε', 'εκ': 'εξε', 'συν': 'συνε', 'απο': 'απε', 'προ': 'προε',
                              'κατευ': 'κατηυ', 'παρα': 'παρη', 'παρα ': 'παρε', 'προεξ': 'προεξε', 'ενδια': 'ενδιε',
                              'περι': 'περιε', 'υπα': 'υπη', 'εν': 'ενε', 'υπο': 'υπε', 'αμφι': 'αμφε', 'συμ': 'συνε',
                              'επιπαρα ': 'παρεεπε', 'κατα': 'κατε', 'εισ': 'εισε', 'αντι': 'αντε', 'παρεμ': 'περενε',
                              'επι': 'επε', 'μετα': 'μετε', 'προσ': 'προσε', 'ανα ': 'ανη', 'συνα': 'συνη',
                              'απα': 'απη', 'αντικατα': 'αντικατε', 'υποκατα': 'υποκατε', 'αποκατα': 'αποκατε',
                              'περια': 'περιη', 'ενα': 'ενη', 'κατα ': 'κατη', 'εισα': 'ειση', 'επα': 'επη',
                              'επανεγκατα': 'επανεγκατε', 'μετεγκατα': 'μετεγκατε', 'απεγκατα': 'απεγκατε',
                              'ανασυν': 'ανασυνε', 'αντιπαρα': 'αντιπαρε', 'συναπο': 'συναπε',
                              'μετα ': 'μετη', 'παρα': 'παρ', 'επεν': 'επενε',
                              'προσα': 'προση'
                              }

# these prefixes do not merge with verbs at all - there are more, add them in the future
prefixes_detachable = {'πολυ': 'πολυ', 'καλα': 'καλα', 'κουτσο': 'κουτσο', 'ξανα': 'ξανα', 'κρουστο': 'κρουστο', 'αγανο': 'αγανο', 'πρωτο': 'πρωτο', 'xolo': 'χολο',
                        'περνο': 'περνο', 'κακο': 'κακο' }

prefixes_detachable_weak = {'επαναπροσ': 'επαναπροσ', 'διασυμπερι': 'διασυμπερι', 'συμ': 'συν', 'αναπροσ': 'αναπροσ', 'υπερ': "υπερ", 'παρα': 'παρα', 'εξ': 'εξ', 'εκ': 'εξ'}


# for automatic augmentation of regular stems
prefixes_before_augment = {'ανα': 'αν', 'απο' : 'απ', 'επι': 'επ', 'διακατ': 'διακατ', 'αν': 'αν', 'δια': 'δι', 'δι': 'δι', 'εκ': 'εξ',
                           'συλ': 'συν', 'εμπερι': 'εμπερι', 'επανεξ': 'επανεξ', 'επανεκ': 'επανεξ','παραεισ': 'παραεισ',
                           'απο': 'απ', 'κακο': 'κακο', 'καλο': 'καλο', 'αντικατα': 'αντικατ', 'συναπο': 'συναπ', 'επανεισ': 'επανεισ',
                           'απ': 'απ', 'ισαπ': 'ισαπ', 'προ': 'προ', 'κατα': 'κατ', 'κατ': 'κατ', 'παρα': 'παρα', ' παρα': 'παρ',
                           'αναπαρα': 'αναπαρ','περισυν': 'περισυν', 'διεξ': 'διεξ', 'υπεξ': 'υπεξ', 'μετεγ': 'μετεν',
                           'παρ': 'παρ', 'προσ': 'προσ', 'μετα': 'μετ', 'μετ': 'μετ', 'υποκατα': 'υποκατ', 'αποκατα': 'αποκατ',
                           'επανεγκατα': 'επανεγκατ', 'μετεγκατα':'μετεγκατ', 'απεγκατα': 'απεγκατ', 'ανασυν': 'ανασυν',
                           'προεκ': 'προεξ', 'ενδια': 'ενδι', 'ενδι': 'ενδι', 'περι': 'περι', 'υπο': 'υπ','παρεκ':'παρεξ',
                           'υπ': 'υπ', 'αμφι': 'αμφ', 'επ': 'επ', 'εισ': 'εισ', 'συμ': 'συν', 'καταπρο': 'καταπρο',
                           'συγ': 'συν', 'συ': 'συν', 'συν': 'συν', 'ελ': 'εξ', 'πολυ': 'πολυ', 'αντιπαρα': 'αντιπαρ', 'ματ': 'ματ',
                           'επεμ': 'επεν', 'υπερ': 'υπερ', 'προεξ': 'προεξ', 'αυτοκατα': 'αυτοκατ', 'συγκατα': 'συγκατ','υπεκ': 'υπεξ',
                           'επεν': 'επεν', 'επεγ': 'επεν', 'παρεμ': 'παρεν', 'παρεν': 'παρεν', 'παρεγ': 'παρεν', 'ξεδια': 'ξεδια',
                           'εν': 'εν', 'εμ': 'εν', 'εγ': 'εν', 'εγκατα': 'εγκατ', 'υφ': 'υφ', 'επισυμ': 'επισυν', "προεν": 'προεν',
                           'καλα': 'καλα', 'κουτσο': 'κουτσο', 'ξανα': 'ξανα', 'εξ': 'εξ', 'συμμετ': 'συμμετ', 'διασυμ': 'διασυν',
                            'επανα': 'επαν', 'επαν': 'επαν', 'αντι': 'αντ', 'αντ': 'αντ','περιδια':'περιδι','ξαπο': 'ξαπ', 'διεμ': 'διεν',
                           'αποδια': 'αποδι','ανταπο': 'ανταπ', 'συνεφ': 'συνεφ', 'παρεισ': 'παρεισ', 'επαναπο': 'επαναπ',
                           'προκατα': 'προκατ','ανακατα': 'ανακατ','αναδια': 'αναδι', 'πρωτο': 'πρωτο', 'καλ': 'καλ',
                           '': ''}



