"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupBucket = void 0;
const core_1 = require("@aws-cdk/core");
const aws_s3_1 = require("@aws-cdk/aws-s3");
class BackupBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props) {
        const { retentionPeriod = core_1.Duration.days(35), ...rest } = props || {};
        super(scope, id, {
            lifecycleRules: [
                {
                    expiration: retentionPeriod,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            ...rest,
        });
    }
}
exports.BackupBucket = BackupBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9iYWNrdXAtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUFtRTtBQUNuRSw0Q0FLeUI7QUFNekIsTUFBYSxZQUFhLFNBQVEsZUFBTTtJQUN0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLE1BQU0sRUFBRSxlQUFlLEdBQUcsZUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRSxHQUFHLElBQUksRUFBRSxHQUFHLEtBQUssSUFBSSxFQUFFLENBQUM7UUFFckUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixjQUFjLEVBQUU7Z0JBQ2Q7b0JBQ0UsVUFBVSxFQUFFLGVBQWU7aUJBQzVCO2FBQ0Y7WUFDRCxVQUFVLEVBQUUseUJBQWdCLENBQUMsVUFBVTtZQUN2QyxnQkFBZ0IsRUFBRSxLQUFLO1lBQ3ZCLGlCQUFpQixFQUFFLDBCQUFpQixDQUFDLFNBQVM7WUFDOUMsYUFBYSxFQUFFLG9CQUFhLENBQUMsTUFBTTtZQUNuQyxHQUFHLElBQUk7U0FDUixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFqQkQsb0NBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBSZW1vdmFsUG9saWN5LCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHtcbiAgQnVja2V0LFxuICBCdWNrZXRQcm9wcyxcbiAgQnVja2V0RW5jcnlwdGlvbixcbiAgQmxvY2tQdWJsaWNBY2Nlc3MsXG59IGZyb20gJ0Bhd3MtY2RrL2F3cy1zMyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQmFja3VwQnVja2V0UHJvcHMgZXh0ZW5kcyBCdWNrZXRQcm9wcyB7XG4gIHJlYWRvbmx5IHJldGVudGlvblBlcmlvZD86IER1cmF0aW9uO1xufVxuXG5leHBvcnQgY2xhc3MgQmFja3VwQnVja2V0IGV4dGVuZHMgQnVja2V0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM/OiBCYWNrdXBCdWNrZXRQcm9wcykge1xuICAgIGNvbnN0IHsgcmV0ZW50aW9uUGVyaW9kID0gRHVyYXRpb24uZGF5cygzNSksIC4uLnJlc3QgfSA9IHByb3BzIHx8IHt9O1xuXG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBsaWZlY3ljbGVSdWxlczogW1xuICAgICAgICB7XG4gICAgICAgICAgZXhwaXJhdGlvbjogcmV0ZW50aW9uUGVyaW9kLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICAgIGVuY3J5cHRpb246IEJ1Y2tldEVuY3J5cHRpb24uUzNfTUFOQUdFRCxcbiAgICAgIHB1YmxpY1JlYWRBY2Nlc3M6IGZhbHNlLFxuICAgICAgYmxvY2tQdWJsaWNBY2Nlc3M6IEJsb2NrUHVibGljQWNjZXNzLkJMT0NLX0FMTCxcbiAgICAgIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuUkVUQUlOLFxuICAgICAgLi4ucmVzdCxcbiAgICB9KTtcbiAgfVxufVxuIl19