"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/cdk");
const kms = require("../lib");
const app = new cdk.App();
/// !show
/**
 * Stack that defines the key
 */
class KeyStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.key = new kms.Key(this, 'MyKey', { retain: false });
    }
}
/**
 * Stack that uses the key
 */
class UseStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Use the IKey object here.
        props.key.addAlias('alias/foo');
    }
}
const keyStack = new KeyStack(app, 'KeyStack');
new UseStack(app, 'UseStack', { key: keyStack.key });
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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