"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, `aws-cdk-kms-1`);
const key = new lib_1.Key(stack, 'MyKey', { retain: false });
key.addToResourcePolicy(new aws_iam_1.PolicyStatement()
    .addAllResources()
    .addAction('kms:encrypt')
    .addAwsPrincipal(stack.accountId));
key.addAlias('alias/bar');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcua2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQW1EO0FBQ25ELHNDQUEwQztBQUMxQyxnQ0FBNkI7QUFFN0IsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFHLEVBQUUsQ0FBQztBQUV0QixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFFOUMsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFHLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO0FBRXZELEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLHlCQUFlLEVBQUU7S0FDMUMsZUFBZSxFQUFFO0tBQ2pCLFNBQVMsQ0FBQyxhQUFhLENBQUM7S0FDeEIsZUFBZSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0FBRXJDLEdBQUcsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7QUFFMUIsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IEtleSB9IGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBgYXdzLWNkay1rbXMtMWApO1xuXG5jb25zdCBrZXkgPSBuZXcgS2V5KHN0YWNrLCAnTXlLZXknLCB7IHJldGFpbjogZmFsc2UgfSk7XG5cbmtleS5hZGRUb1Jlc291cmNlUG9saWN5KG5ldyBQb2xpY3lTdGF0ZW1lbnQoKVxuICAuYWRkQWxsUmVzb3VyY2VzKClcbiAgLmFkZEFjdGlvbigna21zOmVuY3J5cHQnKVxuICAuYWRkQXdzUHJpbmNpcGFsKHN0YWNrLmFjY291bnRJZCkpO1xuXG5rZXkuYWRkQWxpYXMoJ2FsaWFzL2JhcicpO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==