"use strict";
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const kms = require("../lib");
module.exports = {
    'Via service, any principal'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const statement = new iam.PolicyStatement()
            .addAction('abc:call')
            .addPrincipal(new kms.ViaServicePrincipal('bla.amazonaws.com'))
            .addResource('*');
        // THEN
        test.deepEqual(stack.resolve(statement), {
            Action: 'abc:call',
            Condition: { StringEquals: { 'kms:ViaService': 'bla.amazonaws.com' } },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
    'Via service, principal with conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const statement = new iam.PolicyStatement()
            .addAction('abc:call')
            .addPrincipal(new kms.ViaServicePrincipal('bla.amazonaws.com', new iam.OrganizationPrincipal('o-1234')))
            .addResource('*');
        // THEN
        test.deepEqual(stack.resolve(statement), {
            Action: 'abc:call',
            Condition: {
                StringEquals: {
                    'kms:ViaService': 'bla.amazonaws.com',
                    'aws:PrincipalOrgID': 'o-1234'
                }
            },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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