from lambda_ai_cloud_api_client.api.instances.terminate_instance import sync_detailed as terminate_instance
from lambda_ai_cloud_api_client.cli.client import auth_client
from lambda_ai_cloud_api_client.models import (
    InstanceTerminateRequest,
    TerminateInstanceResponse200,
    TerminateInstanceResponse401,
    TerminateInstanceResponse403,
    TerminateInstanceResponse404,
)
from lambda_ai_cloud_api_client.types import Response


def stop_instances(
    id: tuple[str, ...], base_url: str, token: str | None = None, insecure: bool = False
) -> Response[
    TerminateInstanceResponse200
    | TerminateInstanceResponse401
    | TerminateInstanceResponse403
    | TerminateInstanceResponse404
]:
    client = auth_client(base_url=base_url, token=token, insecure=insecure)
    request = InstanceTerminateRequest(instance_ids=list(id))
    return terminate_instance(client=client, body=request)
