/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.Analysis;
import fpp.compiler.analysis.Component;
import fpp.compiler.analysis.ComponentInstance;
import fpp.compiler.analysis.InitSpecifier;
import fpp.compiler.analysis.Name;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.Symbol$ComponentInstance$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$ComponentKind$Active$;
import fpp.compiler.ast.Ast$ComponentKind$Passive$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.ast.Locations$;
import fpp.compiler.util.Error;
import fpp.compiler.util.File$Path$;
import fpp.compiler.util.Location;
import fpp.compiler.util.SemanticError;
import fpp.compiler.util.SemanticError$InvalidDefComponentInstance$;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.deriving.Mirror;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class ComponentInstance$
implements Mirror.Product,
Serializable {
    public static final ComponentInstance$ MODULE$ = new ComponentInstance$();

    private ComponentInstance$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ComponentInstance$.class);
    }

    public ComponentInstance apply(Tuple3<List<String>, AstNode<Ast.DefComponentInstance>, List<String>> aNode, Name.Qualified qualifiedName, Component component, BigInt baseId, BigInt maxId, Option<String> file, Option<BigInt> queueSize, Option<BigInt> stackSize, Option<BigInt> priority, Option<BigInt> cpu, Map<Object, InitSpecifier> initSpecifierMap) {
        return new ComponentInstance(aNode, qualifiedName, component, baseId, maxId, file, queueSize, stackSize, priority, cpu, initSpecifierMap);
    }

    public ComponentInstance unapply(ComponentInstance x$1) {
        return x$1;
    }

    public String toString() {
        return "ComponentInstance";
    }

    public Map<Object, InitSpecifier> $lessinit$greater$default$11() {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    }

    public Either<Error, ComponentInstance> fromDefComponentInstance(Analysis a, Tuple3<List<String>, AstNode<Ast.DefComponentInstance>, List<String>> aNode) {
        AstNode<Ast.DefComponentInstance> node = aNode._2();
        Ast.DefComponentInstance data = node.data();
        return a.getComponent(data.component().id()).flatMap((Function1<Component, Either> & Serializable)component -> package$.MODULE$.Right().apply(component.aNode()._2().data().kind()).flatMap((Function1<Ast.ComponentKind, Either> & Serializable)componentKind -> a.getNonnegativeBigIntValue(data.baseId().id()).flatMap((Function1<BigInt, Either> & Serializable)baseId -> package$.MODULE$.Right().apply(data.file().map((Function1<AstNode, String> & Serializable)node -> this.getFile((AstNode<String>)node))).flatMap((Function1<Option, Either> & Serializable)file -> this.getQueueSize(a, data.name(), Locations$.MODULE$.get(node.id()), (Ast.ComponentKind)componentKind, data.queueSize()).flatMap((Function1<Option, Either> & Serializable)queueSize -> this.getActiveAttribute(data.name(), (Ast.ComponentKind)componentKind, "stack size", (Function1<Option<AstNode<Ast.Expr>>, Either<Error, Option<BigInt>>>)(Function1<Option, Either> & Serializable)nodeOpt -> a.getNonnegativeBigIntValueOpt(nodeOpt), data.stackSize()).flatMap((Function1<Option, Either> & Serializable)stackSize -> this.getActiveAttribute(data.name(), (Ast.ComponentKind)componentKind, "priority", (Function1<Option<AstNode<Ast.Expr>>, Either<Error, Option<BigInt>>>)(Function1<Option, Either> & Serializable)node -> package$.MODULE$.Right().apply(a.getBigIntValueOpt(node)), data.priority()).flatMap((Function1<Option, Either> & Serializable)priority -> this.getActiveAttribute(data.name(), (Ast.ComponentKind)componentKind, "CPU affinity", (Function1<Option<AstNode<Ast.Expr>>, Either<Error, Option<BigInt>>>)(Function1<Option, Either> & Serializable)node -> package$.MODULE$.Right().apply(a.getBigIntValueOpt(node)), data.cpu()).map((Function1<Option, ComponentInstance> & Serializable)cpu -> {
            BigInt maxId = baseId.$plus(component.getMaxId());
            Symbol.ComponentInstance symbol = Symbol$ComponentInstance$.MODULE$.apply(aNode);
            Name.Qualified qualifiedName = a.getQualifiedName().apply(symbol);
            return this.apply(aNode, qualifiedName, (Component)component, (BigInt)baseId, maxId, (Option<String>)file, (Option<BigInt>)queueSize, (Option<BigInt>)stackSize, (Option<BigInt>)priority, (Option<BigInt>)cpu, this.$lessinit$greater$default$11());
        }))))))));
    }

    private Left<SemanticError.InvalidDefComponentInstance, Nothing$> invalid(String name, Location loc, String msg) {
        return package$.MODULE$.Left().apply(SemanticError$InvalidDefComponentInstance$.MODULE$.apply(name, loc, msg));
    }

    private String getFile(AstNode<String> node) {
        Location loc = Locations$.MODULE$.get(node.id());
        Path javaPath = loc.getRelativePath(node.data());
        return File$Path$.MODULE$.apply(javaPath).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Either<Error, Option<BigInt>> getQueueSize(Analysis a, String name, Location loc, Ast.ComponentKind componentKind, Option<AstNode<Ast.Expr>> nodeOpt) {
        Either either;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(componentKind, nodeOpt);
        if (tuple2 != null) {
            Ast.ComponentKind componentKind2 = tuple2._1();
            Option option = tuple2._2();
            if (Ast$ComponentKind$Passive$.MODULE$.equals(componentKind2) && option instanceof Some) {
                AstNode node = (AstNode)((Some)option).value();
                either = this.invalid(name, Locations$.MODULE$.get(node.id()), "passive component may not have queue size");
                return either;
            }
            if (option instanceof Some) {
                either = a.getNonnegativeBigIntValueOpt(nodeOpt);
                return either;
            }
            if (Ast$ComponentKind$Passive$.MODULE$.equals(componentKind2) && None$.MODULE$.equals(option)) {
                either = package$.MODULE$.Right().apply(None$.MODULE$);
                return either;
            }
        }
        either = this.invalid(name, loc, new StringBuilder(31).append(componentKind).append(" component must have queue size").toString());
        return either;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, Option<BigInt>> getActiveAttribute(String name, Ast.ComponentKind componentKind, String kind, Function1<Option<AstNode<Ast.Expr>>, Either<Error, Option<BigInt>>> getValue, Option<AstNode<Ast.Expr>> nodeOpt) {
        Either<Error, Option<BigInt>> either;
        Tuple2<Ast.ComponentKind, Option<AstNode<Ast.Expr>>> tuple2 = Tuple2$.MODULE$.apply(componentKind, nodeOpt);
        if (tuple2 == null) throw new MatchError(tuple2);
        Option<AstNode<Ast.Expr>> option = tuple2._2();
        if (Ast$ComponentKind$Active$.MODULE$.equals(tuple2._1()) && option instanceof Some) {
            either = getValue.apply(nodeOpt);
            return either;
        } else if (option instanceof Some) {
            AstNode node = (AstNode)((Some)option).value();
            either = this.invalid(name, Locations$.MODULE$.get(node.id()), new StringBuilder(24).append(componentKind).append(" component may not have ").append(kind).toString());
            return either;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(tuple2);
            either = package$.MODULE$.Right().apply(None$.MODULE$);
        }
        return either;
    }

    @Override
    public ComponentInstance fromProduct(Product x$0) {
        return new ComponentInstance((Tuple3)x$0.productElement(0), (Name.Qualified)x$0.productElement(1), (Component)x$0.productElement(2), (BigInt)x$0.productElement(3), (BigInt)x$0.productElement(4), (Option)x$0.productElement(5), (Option)x$0.productElement(6), (Option)x$0.productElement(7), (Option)x$0.productElement(8), (Option)x$0.productElement(9), (Map)x$0.productElement(10));
    }
}

