/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Event;
import fpp.compiler.analysis.PortInstance;
import fpp.compiler.analysis.PortInstance$Direction$Input$;
import fpp.compiler.analysis.PortInstance$Direction$Output$;
import fpp.compiler.analysis.PortInstance$Special$;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.Type;
import fpp.compiler.analysis.Type$String$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$SpecPortInstance$CommandRecv$;
import fpp.compiler.ast.Ast$SpecPortInstance$CommandReg$;
import fpp.compiler.ast.Ast$SpecPortInstance$CommandResp$;
import fpp.compiler.ast.Ast$SpecPortInstance$Event$;
import fpp.compiler.ast.Ast$SpecPortInstance$ParamGet$;
import fpp.compiler.ast.Ast$SpecPortInstance$ParamSet$;
import fpp.compiler.ast.Ast$SpecPortInstance$ProductGet$;
import fpp.compiler.ast.Ast$SpecPortInstance$ProductRecv$;
import fpp.compiler.ast.Ast$SpecPortInstance$ProductRequest$;
import fpp.compiler.ast.Ast$SpecPortInstance$ProductSend$;
import fpp.compiler.ast.Ast$SpecPortInstance$Special$;
import fpp.compiler.ast.Ast$SpecPortInstance$Telemetry$;
import fpp.compiler.ast.Ast$SpecPortInstance$TextEvent$;
import fpp.compiler.ast.Ast$SpecPortInstance$TimeGet$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.ComponentCppWriterUtils;
import fpp.compiler.codegen.CppDoc;
import fpp.compiler.codegen.CppDoc$Function$Param$;
import fpp.compiler.codegen.CppDoc$Lines$Both$;
import fpp.compiler.codegen.CppDoc$Type$;
import fpp.compiler.codegen.CppWriterState;
import fpp.compiler.codegen.Line;
import fpp.compiler.codegen.Line$;
import fpp.compiler.codegen.TypeCppWriter$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public abstract class ComponentTestUtils
extends ComponentCppWriterUtils {
    private final CppWriterState s;
    private final String testerBaseClassName;
    private final String gTestClassName;
    private final String testImplClassName;
    private final String historySizeConstantName;
    private final String queueDepthConstantName;
    private final String idConstantName;
    private final boolean hasTypedOutputPorts;
    private final boolean hasHistories;
    private final List inputPorts;
    private final List outputPorts;
    private final List constructorParams;
    private final CppDoc.Function.Param timeTagParam;
    private final List sizeAssertionFunctionParams;
    private final List assertionFunctionParams;

    public ComponentTestUtils(CppWriterState s, Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> aNode) {
        this.s = s;
        super(s, aNode);
        String name = this.componentName();
        this.testerBaseClassName = new StringBuilder(10).append(name).append("TesterBase").toString();
        this.gTestClassName = new StringBuilder(9).append(name).append("GTestBase").toString();
        this.testImplClassName = new StringBuilder(6).append(name).append("Tester").toString();
        this.historySizeConstantName = "MAX_HISTORY_SIZE";
        this.queueDepthConstantName = "TEST_INSTANCE_QUEUE_DEPTH";
        this.idConstantName = "TEST_INSTANCE_ID";
        this.hasTypedOutputPorts = this.typedOutputPorts().nonEmpty();
        this.hasHistories = this.hasTypedOutputPorts() || this.hasCommands() || this.hasParameters() || this.hasEvents() || this.hasCommands() || this.hasDataProducts();
        this.inputPorts = (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{this.specialInputPorts(), this.typedInputPorts(), this.serialInputPorts()}));
        this.outputPorts = (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{this.specialOutputPorts(), this.typedOutputPorts(), this.serialOutputPorts()}));
        this.constructorParams = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const char* const", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "compName", Some$.MODULE$.apply("The component name"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const U32", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "maxHistorySize", Some$.MODULE$.apply("The maximum size of each history"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}));
        this.timeTagParam = CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const Fw::Time&", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "timeTag", Some$.MODULE$.apply("The time"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4());
        List callSiteParams = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const char* const", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "__callSiteFileName", Some$.MODULE$.apply("The name of the file containing the call site"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const U32", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "__callSiteLineNumber", Some$.MODULE$.apply("The line number of the call site"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}));
        this.sizeAssertionFunctionParams = (List)callSiteParams.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const U32", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "size", Some$.MODULE$.apply("The asserted size"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())})));
        this.assertionFunctionParams = (List)callSiteParams.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const U32", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "__index", Some$.MODULE$.apply("The index"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())})));
    }

    public String testerBaseClassName() {
        return this.testerBaseClassName;
    }

    public String gTestClassName() {
        return this.gTestClassName;
    }

    public String testImplClassName() {
        return this.testImplClassName;
    }

    public String historySizeConstantName() {
        return this.historySizeConstantName;
    }

    public String queueDepthConstantName() {
        return this.queueDepthConstantName;
    }

    public String idConstantName() {
        return this.idConstantName;
    }

    public boolean hasTypedOutputPorts() {
        return this.hasTypedOutputPorts;
    }

    public boolean hasHistories() {
        return this.hasHistories;
    }

    public List<PortInstance> inputPorts() {
        return this.inputPorts;
    }

    public List<PortInstance> outputPorts() {
        return this.outputPorts;
    }

    public List<CppDoc.Function.Param> constructorParams() {
        return this.constructorParams;
    }

    public CppDoc.Function.Param timeTagParam() {
        return this.timeTagParam;
    }

    public List<CppDoc.Function.Param> sizeAssertionFunctionParams() {
        return this.sizeAssertionFunctionParams;
    }

    public List<CppDoc.Function.Param> assertionFunctionParams() {
        return this.assertionFunctionParams;
    }

    public List<CppDoc.Class.Member> wrapClassMemberInTextLogGuard(CppDoc.Class.Member member, CppDoc.Lines.Output output) {
        return this.wrapClassMembersInIfDirective("\n#if FW_ENABLE_TEXT_LOGGING", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member[]{member})), output);
    }

    public CppDoc.Lines.Output wrapClassMemberInTextLogGuard$default$2() {
        return CppDoc$Lines$Both$.MODULE$;
    }

    public List<CppDoc.Class.Member> wrapClassMembersInTextLogGuard(List<CppDoc.Class.Member> members, CppDoc.Lines.Output output) {
        return this.wrapClassMembersInIfDirective("\n#if FW_ENABLE_TEXT_LOGGING", (List)members, output);
    }

    public CppDoc.Lines.Output wrapClassMembersInTextLogGuard$default$2() {
        return CppDoc$Lines$Both$.MODULE$;
    }

    public String writeValue(String value, Type t) {
        String string2;
        Type type = t;
        if (type instanceof Type.String) {
            Type.String string3 = Type$String$.MODULE$.unapply((Type.String)type);
            Option<AstNode<Ast.Expr>> option = string3._1();
            string2 = new StringBuilder(9).append(value).append(".toChar()").toString();
        } else {
            string2 = value;
        }
        return string2;
    }

    public String writeAssertEq(Type t) {
        String string2;
        Type type = t;
        if (type instanceof Type.String) {
            Type.String string3 = Type$String$.MODULE$.unapply((Type.String)type);
            Option<AstNode<Ast.Expr>> option = string3._1();
            string2 = "ASSERT_STREQ";
        } else {
            string2 = "ASSERT_EQ";
        }
        return string2;
    }

    public String writeEventValue(String value, String typeName) {
        String string2 = typeName;
        return "Fw::StringBase".equals(string2) ? new StringBuilder(9).append(value).append(".toChar()").toString() : value;
    }

    public String writeEventAssertEq(String typeName) {
        String string2 = typeName;
        return "Fw::StringBase".equals(string2) ? "ASSERT_STREQ" : "ASSERT_EQ";
    }

    public String writeCppType(Type t, Option<String> stringRepOpt) {
        String string2;
        Type type;
        String string3;
        Option<String> option = stringRepOpt;
        if (option instanceof Some) {
            String stringRep = (String)((Some)option).value();
            string3 = TypeCppWriter$.MODULE$.getName(this.s, t, stringRep);
        } else if (None$.MODULE$.equals(option)) {
            string3 = TypeCppWriter$.MODULE$.getName(this.s, t, TypeCppWriter$.MODULE$.getName$default$3());
        } else {
            throw new MatchError(option);
        }
        String typeName = string3;
        Type t2 = type = t;
        if (this.s.isPrimitive(t2, typeName)) {
            string2 = new StringBuilder(6).append("const ").append(typeName).toString();
        } else if (type instanceof Type.String) {
            Option<String> option2 = stringRepOpt;
            if (option2 instanceof Some) {
                String stringRep = (String)((Some)option2).value();
                string2 = new StringBuilder(7).append("const ").append(stringRep).append("&").toString();
            } else {
                string2 = "const char* const";
            }
        } else {
            string2 = new StringBuilder(7).append("const ").append(typeName).append("&").toString();
        }
        return string2;
    }

    public Option<String> writeCppType$default$2() {
        return None$.MODULE$;
    }

    public List<Line> writeMacro(String s) {
        return Line$.MODULE$.addSuffix(this.lines(s), "\\");
    }

    public String inputPortName(String name) {
        return new StringBuilder(5).append("from_").append(name).toString();
    }

    public String outputPortName(String name) {
        return new StringBuilder(3).append("to_").append(name).toString();
    }

    public String testerPortName(PortInstance p) {
        String string2;
        PortInstance.Direction direction = p.getDirection().get();
        if (PortInstance$Direction$Input$.MODULE$.equals(direction)) {
            string2 = this.outputPortName(p.getUnqualifiedName());
        } else if (PortInstance$Direction$Output$.MODULE$.equals(direction)) {
            string2 = this.inputPortName(p.getUnqualifiedName());
        } else {
            throw new MatchError(direction);
        }
        return string2;
    }

    public String testerPortNumGetterName(PortInstance p) {
        return new StringBuilder(7).append("getNum_").append(this.testerPortName(p)).toString();
    }

    public String testerPortVariableName(PortInstance p) {
        return new StringBuilder(2).append("m_").append(this.testerPortName(p)).toString();
    }

    public String toPortIsConnectedName(String name) {
        return new StringBuilder(12).append("isConnected_").append(this.outputPortName(name)).toString();
    }

    public String toPortConnectorName(String name) {
        return new StringBuilder(8).append("connect_").append(this.outputPortName(name)).toString();
    }

    public String toPortInvokerName(String name) {
        return new StringBuilder(7).append("invoke_").append(this.outputPortName(name)).toString();
    }

    public String fromPortGetterName(String name) {
        return new StringBuilder(4).append("get_").append(this.inputPortName(name)).toString();
    }

    public String fromPortHandlerName(String name) {
        return this.inputPortHandlerName(this.inputPortName(name));
    }

    public String fromPortHandlerBaseName(String name) {
        return this.inputPortHandlerBaseName(this.inputPortName(name));
    }

    public String fromPortCallbackName(String name) {
        return new StringBuilder(7).append(this.inputPortName(name)).append("_static").toString();
    }

    public String fromPortPushEntryName(String name) {
        return new StringBuilder(18).append("pushFromPortEntry_").append(name).toString();
    }

    public String fromPortHistorySizeName(String name) {
        return new StringBuilder(20).append("fromPortHistorySize_").append(name).toString();
    }

    public String fromPortHistoryName(String name) {
        return new StringBuilder(16).append("fromPortHistory_").append(name).toString();
    }

    public String fromPortEntryName(String name) {
        return new StringBuilder(14).append("FromPortEntry_").append(name).toString();
    }

    public String fromPortAssertionFuncName(String name) {
        return new StringBuilder(7).append("assert_").append(this.inputPortName(name)).toString();
    }

    public String fromPortSizeAssertionFuncName(String name) {
        return new StringBuilder(5).append(this.fromPortAssertionFuncName(name)).append("_size").toString();
    }

    public String commandSendName(String name) {
        return new StringBuilder(8).append("sendCmd_").append(name).toString();
    }

    public String eventHandlerName(Event event) {
        return new StringBuilder(7).append("logIn_").append(this.writeSeverity(event)).append("_").append(event.getName()).toString();
    }

    public String eventSizeName(String name) {
        return new StringBuilder(11).append("eventsSize_").append(name).toString();
    }

    public String eventHistoryName(String name) {
        return new StringBuilder(13).append("eventHistory_").append(name).toString();
    }

    public String eventEntryName(String name) {
        return new StringBuilder(11).append("EventEntry_").append(name).toString();
    }

    public String eventAssertionFuncName(String name) {
        return new StringBuilder(13).append("assertEvents_").append(name).toString();
    }

    public String eventSizeAssertionFuncName(String name) {
        return new StringBuilder(5).append(this.eventAssertionFuncName(name)).append("_size").toString();
    }

    public String tlmHandlerName(String name) {
        return new StringBuilder(9).append("tlmInput_").append(name).toString();
    }

    public String tlmHistoryName(String name) {
        return new StringBuilder(11).append("tlmHistory_").append(name).toString();
    }

    public String tlmEntryName(String name) {
        return new StringBuilder(9).append("TlmEntry_").append(name).toString();
    }

    public String tlmAssertionFuncName(String name) {
        return new StringBuilder(10).append("assertTlm_").append(name).toString();
    }

    public String tlmSizeAssertionFuncName(String name) {
        return new StringBuilder(5).append(this.tlmAssertionFuncName(name)).append("_size").toString();
    }

    public String paramVariableName(String name) {
        return new StringBuilder(8).append("m_param_").append(name).toString();
    }

    @Override
    public String paramValidityFlagName(String name) {
        return new StringBuilder(14).append("m_param_").append(name).append("_valid").toString();
    }

    public String paramSetName(String name) {
        return new StringBuilder(9).append("paramSet_").append(name).toString();
    }

    public String paramSendName(String name) {
        return new StringBuilder(10).append("paramSend_").append(name).toString();
    }

    public String paramSaveName(String name) {
        return new StringBuilder(10).append("paramSave_").append(name).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean portInstanceIsUsed(PortInstance p) {
        boolean bl;
        Ast.SpecPortInstance.SpecialKind kind;
        PortInstance portInstance = p;
        if (!(portInstance instanceof PortInstance.Special)) return true;
        PortInstance.Special special = PortInstance$Special$.MODULE$.unapply((PortInstance.Special)portInstance);
        Tuple3<List<String>, AstNode<Ast.SpecPortInstance>, List<String>> tuple3 = special._1();
        Ast.SpecPortInstance.Special special2 = special._2();
        Symbol.Port port = special._3();
        Option<BigInt> option = special._4();
        Option<Ast.QueueFull> option2 = special._5();
        Tuple3<List<String>, AstNode<Ast.SpecPortInstance>, List<String>> aNode = tuple3;
        Ast.SpecPortInstance specPortInstance = aNode._2().data();
        if (!(specPortInstance instanceof Ast.SpecPortInstance.Special)) throw new MatchError(specPortInstance);
        Ast.SpecPortInstance.Special special3 = (Ast.SpecPortInstance.Special)specPortInstance;
        Ast.SpecPortInstance.Special special4 = Ast$SpecPortInstance$Special$.MODULE$.unapply(special3);
        Option<Ast.SpecPortInstance.SpecialInputKind> option3 = special4._1();
        Ast.SpecPortInstance.SpecialKind specialKind = special4._2();
        String string2 = special4._3();
        Option<AstNode<Ast.Expr>> option4 = special4._4();
        Option<AstNode<Ast.QueueFull>> option5 = special4._5();
        Ast.SpecPortInstance.SpecialKind kind2 = specialKind;
        Ast.SpecPortInstance.Special spec = special3;
        Tuple2<Ast.SpecPortInstance.Special, Ast.SpecPortInstance.SpecialKind> tuple2 = Tuple2$.MODULE$.apply(spec, kind2);
        Ast.SpecPortInstance.Special spec2 = tuple2._1();
        Ast.SpecPortInstance.SpecialKind specialKind2 = kind = tuple2._2();
        if (Ast$SpecPortInstance$CommandRecv$.MODULE$.equals(specialKind2)) {
            bl = this.hasCommands();
            return bl;
        } else if (Ast$SpecPortInstance$CommandReg$.MODULE$.equals(specialKind2)) {
            bl = this.hasCommands();
            return bl;
        } else if (Ast$SpecPortInstance$CommandResp$.MODULE$.equals(specialKind2)) {
            bl = this.hasCommands();
            return bl;
        } else if (Ast$SpecPortInstance$Event$.MODULE$.equals(specialKind2)) {
            bl = this.hasEvents();
            return bl;
        } else if (Ast$SpecPortInstance$ParamGet$.MODULE$.equals(specialKind2)) {
            bl = this.hasParameters();
            return bl;
        } else if (Ast$SpecPortInstance$ParamSet$.MODULE$.equals(specialKind2)) {
            bl = this.hasParameters();
            return bl;
        } else if (Ast$SpecPortInstance$ProductGet$.MODULE$.equals(specialKind2)) {
            bl = this.component().hasDataProducts();
            return bl;
        } else if (Ast$SpecPortInstance$ProductRecv$.MODULE$.equals(specialKind2)) {
            bl = this.component().hasDataProducts();
            return bl;
        } else if (Ast$SpecPortInstance$ProductRequest$.MODULE$.equals(specialKind2)) {
            bl = this.component().hasDataProducts();
            return bl;
        } else if (Ast$SpecPortInstance$ProductSend$.MODULE$.equals(specialKind2)) {
            bl = this.component().hasDataProducts();
            return bl;
        } else if (Ast$SpecPortInstance$Telemetry$.MODULE$.equals(specialKind2)) {
            bl = this.hasTelemetry();
            return bl;
        } else if (Ast$SpecPortInstance$TextEvent$.MODULE$.equals(specialKind2)) {
            bl = this.hasEvents();
            return bl;
        } else {
            if (!Ast$SpecPortInstance$TimeGet$.MODULE$.equals(specialKind2)) throw new MatchError(specialKind2);
            return true;
        }
    }
}

