/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.StateMachine;
import fpp.compiler.analysis.StateMachine$;
import fpp.compiler.analysis.StateMachine$Kind$Internal$;
import fpp.compiler.analysis.StateMachineAnalysis;
import fpp.compiler.analysis.StateMachineSymbol;
import fpp.compiler.analysis.StateMachineSymbol$Action$;
import fpp.compiler.analysis.StateMachineSymbol$Choice$;
import fpp.compiler.analysis.StateMachineSymbol$Guard$;
import fpp.compiler.analysis.StateMachineSymbol$Signal$;
import fpp.compiler.analysis.StateMachineSymbol$State$;
import fpp.compiler.analysis.StateMachineTypedElement;
import fpp.compiler.analysis.StateMachineTypedElement$Choice$;
import fpp.compiler.analysis.StateOrChoice;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.Symbol$StateMachine$;
import fpp.compiler.analysis.Transition;
import fpp.compiler.analysis.Type;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.AnnotationCppWriter$;
import fpp.compiler.codegen.ComputeCppFiles$FileNames$;
import fpp.compiler.codegen.CppDoc;
import fpp.compiler.codegen.CppDoc$Function$Param$;
import fpp.compiler.codegen.CppDoc$Type$;
import fpp.compiler.codegen.CppWriterState;
import fpp.compiler.codegen.CppWriterState$;
import fpp.compiler.codegen.CppWriterUtils;
import fpp.compiler.codegen.Line;
import fpp.compiler.codegen.Line$;
import fpp.compiler.codegen.LineUtils;
import fpp.compiler.codegen.TypeCppWriter;
import fpp.compiler.codegen.TypeCppWriter$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.AbstractSeq;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class StateMachineCppWriterUtils
implements LineUtils,
CppWriterUtils {
    private String q;
    private int indentIncrement;
    private Function1 addBlankPrefix;
    private Function1 addBlankPostfix;
    private Function1 flattenWithBlankPrefix;
    private List standardSystemHppHeaders;
    private List standardUserHppHeaders;
    private Nil$ standardSystemCppHeaders;
    private List standardUserCppHeaders;
    private final CppWriterState s;
    private final Symbol.StateMachine symbol;
    private final StateMachine stateMachine;
    private final StateMachineAnalysis sma;
    private final String name;
    private final String className;
    private final String fileName;
    private final List namespaceIdentList;
    private final TypeCppWriter typeCppWriter;
    private final String uninitStateName;
    private final String initialTransitionName;
    private final List leafStateSymbols;
    private final List actionSymbols;
    private final List guardSymbols;
    private final String valueParamName;
    private final List signalSymbols;
    private final String signalParamName;
    private final CppDoc.Function.Param signalParam;

    public StateMachineCppWriterUtils(CppWriterState s, Tuple3<List<String>, AstNode<Ast.DefStateMachine>, List<String>> aNode) {
        this.s = s;
        LineUtils.$init$(this);
        CppWriterUtils.$init$(this);
        this.symbol = Symbol$StateMachine$.MODULE$.apply(aNode);
        this.stateMachine = (StateMachine)s.a().stateMachineMap().apply(this.symbol());
        this.sma = this.stateMachine().sma();
        this.name = s.getName(this.symbol());
        this.className = new StringBuilder(16).append(this.name()).append("StateMachineBase").toString();
        this.fileName = ComputeCppFiles$FileNames$.MODULE$.getStateMachine(this.name(), StateMachine$Kind$Internal$.MODULE$);
        this.namespaceIdentList = s.getNamespaceIdentList(this.symbol());
        this.typeCppWriter = TypeCppWriter$.MODULE$.apply(s, TypeCppWriter$.MODULE$.$lessinit$greater$default$2());
        this.uninitStateName = "__FPRIME_AC_UNINITIALIZED";
        this.initialTransitionName = "__FPRIME_AC_INITIAL_TRANSITION";
        this.leafStateSymbols = (List)((IterableOnceOps)StateMachine$.MODULE$.getLeafStates(this.symbol()).map((Function1<Tuple3, StateMachineSymbol.State> & Serializable)_$1 -> StateMachineSymbol$State$.MODULE$.apply((Tuple3<List<String>, AstNode<Ast.DefState>, List<String>>)_$1))).toList().sortBy((Function1<StateMachineSymbol, String> & Serializable)state -> this.writeSmSymbolName((StateMachineSymbol)state), (Ordering)Ordering$String$.MODULE$);
        this.actionSymbols = StateMachine$.MODULE$.getActions(aNode._2().data()).map((Function1<Tuple3, StateMachineSymbol.Action> & Serializable)_$2 -> StateMachineSymbol$Action$.MODULE$.apply((Tuple3<List<String>, AstNode<Ast.DefAction>, List<String>>)_$2));
        this.guardSymbols = StateMachine$.MODULE$.getGuards(aNode._2().data()).map((Function1<Tuple3, StateMachineSymbol.Guard> & Serializable)_$3 -> StateMachineSymbol$Guard$.MODULE$.apply((Tuple3<List<String>, AstNode<Ast.DefGuard>, List<String>>)_$3));
        this.valueParamName = "value";
        this.signalSymbols = StateMachine$.MODULE$.getSignals(aNode._2().data()).map((Function1<Tuple3, StateMachineSymbol.Signal> & Serializable)_$4 -> StateMachineSymbol$Signal$.MODULE$.apply((Tuple3<List<String>, AstNode<Ast.DefSignal>, List<String>>)_$4));
        this.signalParamName = "signal";
        this.signalParam = CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("Signal", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.signalParamName(), Some$.MODULE$.apply("The signal"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4());
        Statics.releaseFence();
    }

    @Override
    public String q() {
        return this.q;
    }

    @Override
    public int indentIncrement() {
        return this.indentIncrement;
    }

    public Function1 addBlankPrefix() {
        return this.addBlankPrefix;
    }

    public Function1 addBlankPostfix() {
        return this.addBlankPostfix;
    }

    public Function1 flattenWithBlankPrefix() {
        return this.flattenWithBlankPrefix;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$q_$eq(String x$0) {
        this.q = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$indentIncrement_$eq(int x$0) {
        this.indentIncrement = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$addBlankPrefix_$eq(Function1 x$0) {
        this.addBlankPrefix = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$addBlankPostfix_$eq(Function1 x$0) {
        this.addBlankPostfix = x$0;
    }

    @Override
    public void fpp$compiler$codegen$LineUtils$_setter_$flattenWithBlankPrefix_$eq(Function1 x$0) {
        this.flattenWithBlankPrefix = x$0;
    }

    public List standardSystemHppHeaders() {
        return this.standardSystemHppHeaders;
    }

    public List standardUserHppHeaders() {
        return this.standardUserHppHeaders;
    }

    @Override
    public Nil$ standardSystemCppHeaders() {
        return this.standardSystemCppHeaders;
    }

    public List standardUserCppHeaders() {
        return this.standardUserCppHeaders;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardSystemHppHeaders_$eq(List x$0) {
        this.standardSystemHppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardUserHppHeaders_$eq(List x$0) {
        this.standardUserHppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardSystemCppHeaders_$eq(Nil$ x$0) {
        this.standardSystemCppHeaders = x$0;
    }

    @Override
    public void fpp$compiler$codegen$CppWriterUtils$_setter_$standardUserCppHeaders_$eq(List x$0) {
        this.standardUserCppHeaders = x$0;
    }

    public Symbol.StateMachine symbol() {
        return this.symbol;
    }

    public StateMachine stateMachine() {
        return this.stateMachine;
    }

    public StateMachineAnalysis sma() {
        return this.sma;
    }

    public String name() {
        return this.name;
    }

    public String className() {
        return this.className;
    }

    public String fileName() {
        return this.fileName;
    }

    public List<String> namespaceIdentList() {
        return this.namespaceIdentList;
    }

    public TypeCppWriter typeCppWriter() {
        return this.typeCppWriter;
    }

    public String uninitStateName() {
        return this.uninitStateName;
    }

    public String initialTransitionName() {
        return this.initialTransitionName;
    }

    public List<StateMachineSymbol.State> leafStateSymbols() {
        return this.leafStateSymbols;
    }

    public List<StateMachineSymbol.Action> actionSymbols() {
        return this.actionSymbols;
    }

    public List<StateMachineSymbol.Guard> guardSymbols() {
        return this.guardSymbols;
    }

    public String valueParamName() {
        return this.valueParamName;
    }

    public String getActionFunctionName(StateMachineSymbol.Action sym) {
        return new StringBuilder(7).append("action_").append(sym.getUnqualifiedName()).toString();
    }

    public String getGuardFunctionName(StateMachineSymbol.Guard sym) {
        return new StringBuilder(6).append("guard_").append(sym.getUnqualifiedName()).toString();
    }

    public String getSendSignalFunctionName(StateMachineSymbol.Signal sym) {
        return new StringBuilder(11).append("sendSignal_").append(sym.getUnqualifiedName()).toString();
    }

    public List<StateMachineSymbol.Signal> signalSymbols() {
        return this.signalSymbols;
    }

    public String signalParamName() {
        return this.signalParamName;
    }

    public CppDoc.Function.Param signalParam() {
        return this.signalParam;
    }

    public List<Tuple2<List<Line>, String>> commentedLeafStateNames() {
        return (List)((AbstractSeq)this.leafStateSymbols().toList().map((Function1<StateMachineSymbol.State, Tuple2> & Serializable)state -> Tuple2$.MODULE$.apply(AnnotationCppWriter$.MODULE$.writePreComment(state.node()), this.writeSmSymbolName((StateMachineSymbol)state)))).sortBy((Function1<Tuple2, String> & Serializable)_$5 -> (String)_$5._2(), (Ordering)Ordering$String$.MODULE$);
    }

    public List<Tuple2<List<Line>, String>> commentedSignalNames() {
        return (List)((AbstractSeq)this.signalSymbols().map((Function1<StateMachineSymbol.Signal, Tuple2> & Serializable)symbol -> Tuple2$.MODULE$.apply(AnnotationCppWriter$.MODULE$.writePreComment(symbol.node()), this.writeSmSymbolName((StateMachineSymbol)symbol)))).sortBy((Function1<Tuple2, String> & Serializable)_$6 -> (String)_$6._2(), (Ordering)Ordering$String$.MODULE$);
    }

    public List<CppDoc.Function.Param> getActionFunctionParams(StateMachineSymbol.Action sym) {
        return this.getParamsWithTypeNameOpt(sym.node()._2().data().typeName());
    }

    public String getEnterFunctionName(StateMachineSymbol symbol) {
        return new StringBuilder(6).append("enter_").append(this.writeSmSymbolName(symbol)).toString();
    }

    public List<CppDoc.Function.Param> getGuardFunctionParams(StateMachineSymbol.Guard sym) {
        return this.getParamsWithTypeNameOpt(sym.node()._2().data().typeName());
    }

    public List<CppDoc.Function.Param> getParamsWithTypeNameOpt(Option<AstNode<Ast.TypeName>> typeNameOpt) {
        return this.getParamsWithTypeOpt(typeNameOpt.map((Function1<AstNode, Type> & Serializable)tn -> (Type)this.s.a().typeMap().apply(BoxesRunTime.boxToInteger(tn.id()))));
    }

    public List<CppDoc.Function.Param> getParamsWithTypeOpt(Option<Type> typeOpt) {
        return this.getValueParamsWithTypeOpt(typeOpt).$colon$colon(this.signalParam());
    }

    public CppDoc.Type getValueParamType(Type t) {
        String typeName = this.typeCppWriter().write(t);
        String paramTypeName = t.isPrimitive() ? typeName : new StringBuilder(7).append("const ").append(typeName).append("&").toString();
        return CppDoc$Type$.MODULE$.apply(paramTypeName, CppDoc$Type$.MODULE$.$lessinit$greater$default$2());
    }

    public List<CppDoc.Function.Param> getValueParamsWithTypeNameOpt(Option<AstNode<Ast.TypeName>> typeNameOpt) {
        return this.getValueParamsWithTypeOpt(typeNameOpt.map((Function1<AstNode, Type> & Serializable)tn -> (Type)this.s.a().typeMap().apply(BoxesRunTime.boxToInteger(tn.id()))));
    }

    public List<CppDoc.Function.Param> getValueParamsWithTypeOpt(Option<Type> typeOpt) {
        List list;
        Option<Type> option = typeOpt;
        if (option instanceof Some) {
            Type t = (Type)((Some)option).value();
            list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(this.getValueParamType(t), this.valueParamName(), Some$.MODULE$.apply("The value"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}));
        } else if (None$.MODULE$.equals(option)) {
            list = package$.MODULE$.Nil();
        } else {
            throw new MatchError(option);
        }
        return list;
    }

    public List<Line> writeActionCall(String signalArg, Option<String> valueArgOpt, StateMachineSymbol.Action sym) {
        String functionName = this.getActionFunctionName(sym);
        String args = this.writeArgsWithValueOpt(signalArg, valueArgOpt, sym.node()._2().data().typeName());
        return this.lines(new StringBuilder(9).append("this->").append(functionName).append("(").append(args).append(");").toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> String writeArgsWithValueOpt(String signalArg, Option<String> valueArgOpt, Option<T> typeOpt) {
        String string2;
        Option<String> option;
        Tuple2<Option<String>, Option<T>> tuple2 = Tuple2$.MODULE$.apply(valueArgOpt, typeOpt);
        if (tuple2 != null && (option = tuple2._1()) instanceof Some) {
            String valueArg = (String)((Some)option).value();
            if (tuple2._2() instanceof Some) {
                string2 = new StringBuilder(2).append(signalArg).append(", ").append(valueArg).toString();
                return string2;
            }
        }
        string2 = signalArg;
        return string2;
    }

    public List<Line> writeEnterCall(String signalArg, Option<String> valueArgOpt, StateMachineSymbol sym) {
        Option option;
        String functionName = this.getEnterFunctionName(sym);
        StateMachineSymbol stateMachineSymbol = sym;
        if (stateMachineSymbol instanceof StateMachineSymbol.Choice) {
            Tuple3<List<String>, AstNode<Ast.DefChoice>, List<String>> tuple3;
            StateMachineSymbol.Choice choice = StateMachineSymbol$Choice$.MODULE$.unapply((StateMachineSymbol.Choice)stateMachineSymbol);
            Tuple3<List<String>, AstNode<Ast.DefChoice>, List<String>> aNode = tuple3 = choice._1();
            StateMachineTypedElement.Choice te = StateMachineTypedElement$Choice$.MODULE$.apply(aNode);
            option = (Option)this.sma().typeOptionMap().apply(te);
        } else {
            option = None$.MODULE$;
        }
        None$ typeOpt = option;
        String args = this.writeArgsWithValueOpt(signalArg, valueArgOpt, typeOpt);
        return this.lines(new StringBuilder(9).append("this->").append(functionName).append("(").append(args).append(");").toString());
    }

    public String writeGuardCall(String signalArg, Option<String> valueArgOpt, StateMachineSymbol.Guard sym) {
        String functionName = this.getGuardFunctionName(sym);
        String args = this.writeArgsWithValueOpt(signalArg, valueArgOpt, sym.node()._2().data().typeName());
        return new StringBuilder(8).append("this->").append(functionName).append("(").append(args).append(")").toString();
    }

    public List<Line> writeGuardedTransition(StateMachineSymbol.Signal signal, Transition.Guarded gt) {
        List list;
        String signalArg = this.writeSignalName(signal);
        Option<String> valueArgOpt = signal.node()._2().data().typeName().map((Function1<AstNode, String> & Serializable)_$7 -> this.valueParamName());
        List transitionLines = this.writeTransition(signalArg, valueArgOpt, gt.transition());
        Option<StateMachineSymbol.Guard> option = gt.guardOpt();
        if (option instanceof Some) {
            StateMachineSymbol.Guard guard = (StateMachineSymbol.Guard)((Some)option).value();
            String guardCall = this.writeGuardCall(signalArg, valueArgOpt, guard);
            list = this.wrapInIf(guardCall, transitionLines);
        } else if (None$.MODULE$.equals(option)) {
            list = transitionLines;
        } else {
            throw new MatchError(option);
        }
        return list;
    }

    public String writeSignalName(StateMachineSymbol.Signal signal) {
        return new StringBuilder(8).append("Signal::").append(this.writeSmSymbolName(signal)).toString();
    }

    public String writeSmSymbolName(StateMachineSymbol state) {
        return CppWriterState$.MODULE$.identFromQualifiedSmSymbolName(this.sma(), state);
    }

    public String writeStateName(StateMachineSymbol.State state) {
        return new StringBuilder(7).append("State::").append(this.writeSmSymbolName(state)).toString();
    }

    public List<Line> writeStateUpdate(StateMachineSymbol.State sym) {
        String stateName = this.writeSmSymbolName(sym);
        return this.lines(new StringBuilder(24).append("this->m_state = State::").append(stateName).append(";").toString());
    }

    public List<Line> writeTransition(String signalArg, Option<String> valueArgOpt, Transition transition) {
        List list;
        Line actionComment = this.line("// Do the actions for the transition");
        Object actionLines = transition.getActions().flatMap((Function1<StateMachineSymbol.Action, IterableOnce> & Serializable)sym -> this.writeActionCall(signalArg, valueArgOpt, (StateMachineSymbol.Action)sym));
        Line entryComment = this.line("// Enter the target");
        Option<StateOrChoice> option = transition.getTargetOpt();
        if (option instanceof Some) {
            StateOrChoice target = (StateOrChoice)((Some)option).value();
            list = this.writeEnterCall(signalArg, valueArgOpt, target.getSymbol());
        } else if (None$.MODULE$.equals(option)) {
            list = package$.MODULE$.Nil();
        } else {
            throw new MatchError(option);
        }
        Nil$ entryLines = list;
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{Line$.MODULE$.addPrefixLine(actionComment, (List<Line>)actionLines), Line$.MODULE$.addPrefixLine(entryComment, entryLines)}));
    }
}

