#
# This file is part of Invenio.
# Copyright (C) 2016-2018 CERN.
#
# Invenio is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""Create github tables."""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql
from sqlalchemy_utils import ChoiceType, JSONType, UUIDType

# revision identifiers, used by Alembic.
revision = "b0eaee37b545"
down_revision = "5a5428312b2b"
branch_labels = ()
# Depends on invenio-webhooks table creation for FK reference
depends_on = "a095bd179f5c"


def upgrade():
    """Upgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "github_repositories",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", UUIDType(), nullable=False),
        sa.Column("github_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=True),
        sa.Column("hook", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["accounts_user.id"],
            name=op.f("fk_github_repositories_user_id_accounts_user"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_github_repositories")),
    )
    op.create_index(
        op.f("ix_github_repositories_github_id"),
        "github_repositories",
        ["github_id"],
        unique=True,
    )
    op.create_index(
        op.f("ix_github_repositories_name"),
        "github_repositories",
        ["name"],
        unique=True,
    )
    op.create_table(
        "github_releases",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.Column("id", UUIDType(), nullable=False),
        sa.Column("release_id", sa.Integer(), nullable=True),
        sa.Column("tag", sa.String(length=255), nullable=True),
        sa.Column(
            "errors",
            JSONType().with_variant(
                postgresql.JSON(none_as_null=True, astext_type=sa.Text()), "postgresql"
            ),
            nullable=True,
        ),
        sa.Column("repository_id", UUIDType(), nullable=True),
        sa.Column("event_id", UUIDType(), nullable=True),
        sa.Column("record_id", UUIDType(), nullable=True),
        sa.Column("status", sa.CHAR(length=1), nullable=False),
        sa.ForeignKeyConstraint(
            ["event_id"],
            ["webhooks_events.id"],
            name=op.f("fk_github_releases_event_id_webhooks_events"),
        ),
        sa.ForeignKeyConstraint(
            ["repository_id"],
            ["github_repositories.id"],
            name=op.f("fk_github_releases_repository_id_github_repositories"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_github_releases")),
        sa.UniqueConstraint("release_id", name=op.f("uq_github_releases_release_id")),
    )
    op.create_index(
        op.f("ix_github_releases_record_id"),
        "github_releases",
        ["record_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    """Downgrade database."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_github_releases_record_id"), table_name="github_releases")
    op.drop_table("github_releases")
    op.drop_index(op.f("ix_github_repositories_name"), table_name="github_repositories")
    op.drop_index(
        op.f("ix_github_repositories_github_id"), table_name="github_repositories"
    )
    op.drop_table("github_repositories")
    # ### end Alembic commands ###
