import Boost.Python
from _typeshed import Incomplete
from jiminy_py.core.eigenpy.eigenpy_pywrap import AngleAxis as AngleAxis, Quaternion as Quaternion
from typing import Any, ClassVar

ACCELERATION: KinematicLevel
ARG0: ArgumentPosition
ARG1: ArgumentPosition
ARG2: ArgumentPosition
ARG3: ArgumentPosition
ARG4: ArgumentPosition
BODY: FrameType
COLLISION: GeometryType
FIXED_JOINT: FrameType
JOINT: FrameType
LOCAL: ReferenceFrame
LOCAL_WORLD_ALIGNED: ReferenceFrame
OP_FRAME: FrameType
PINOCCHIO_MAJOR_VERSION: int
PINOCCHIO_MINOR_VERSION: int
PINOCCHIO_PATCH_VERSION: int
POSITION: KinematicLevel
SENSOR: FrameType
VELOCITY: KinematicLevel
VISUAL: GeometryType
WITH_CPPAD: bool
WITH_HPP_FCL: bool
WITH_OPENMP: bool
WITH_URDFDOM: bool
WORLD: ReferenceFrame
__raw_version__: str
__version__: str

class ArgumentPosition(Boost.Python.enum):
    ARG0: ClassVar[ArgumentPosition] = ...
    ARG1: ClassVar[ArgumentPosition] = ...
    ARG2: ClassVar[ArgumentPosition] = ...
    ARG3: ClassVar[ArgumentPosition] = ...
    ARG4: ClassVar[ArgumentPosition] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class CollisionPair(Boost.Python.instance):
    first: Incomplete
    second: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class Data(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    Ag: Incomplete
    B: Incomplete
    C: Incomplete
    D: Incomplete
    Fcrb: Incomplete
    Ig: Incomplete
    Ivx: Incomplete
    J: Incomplete
    Jcom: Incomplete
    M: Incomplete
    Minv: Incomplete
    U: Incomplete
    Ycrb: Incomplete
    a: Incomplete
    a_gf: Incomplete
    acom: Incomplete
    com: Incomplete
    dAg: Incomplete
    dJ: Incomplete
    ddq: Incomplete
    ddq_dq: Incomplete
    ddq_dv: Incomplete
    dhg: Incomplete
    dq_after: Incomplete
    dtau_dq: Incomplete
    dtau_dv: Incomplete
    f: Incomplete
    g: Incomplete
    h: Incomplete
    hg: Incomplete
    iMf: Incomplete
    impulse_c: Incomplete
    jointTorqueRegressor: Incomplete
    kinetic_energy: Incomplete
    lambda_c: Incomplete
    lastChild: Incomplete
    liMi: Incomplete
    mass: Incomplete
    nle: Incomplete
    nvSubtree: Incomplete
    nvSubtree_fromRow: Incomplete
    oMf: Incomplete
    oMi: Incomplete
    oa: Incomplete
    oa_gf: Incomplete
    of: Incomplete
    ov: Incomplete
    parents_fromRow: Incomplete
    potential_energy: Incomplete
    staticRegressor: Incomplete
    tau: Incomplete
    v: Incomplete
    vcom: Incomplete
    vxI: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs): ...
    @classmethod
    def loadFromString(cls, *args, **kwargs): ...
    @classmethod
    def loadFromText(cls, *args, **kwargs): ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs): ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs): ...
    @classmethod
    def saveToString(cls, *args, **kwargs): ...
    @classmethod
    def saveToText(cls, *args, **kwargs): ...
    @classmethod
    def saveToXML(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class Force(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    angular: Incomplete
    linear: Incomplete
    vector: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Random(cls, *args, **kwargs): ...
    @classmethod
    def Zero(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def isApprox(cls, *args, **kwargs): ...
    @classmethod
    def isZero(cls, *args, **kwargs): ...
    @classmethod
    def se3Action(cls, *args, **kwargs): ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs): ...
    @classmethod
    def setRandom(cls, *args, **kwargs): ...
    @classmethod
    def setZero(cls, *args, **kwargs): ...
    @classmethod
    def __add__(cls, other): ...
    @classmethod
    def __array__(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __iadd__(cls, other): ...
    @classmethod
    def __isub__(cls, other): ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __neg__(cls): ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __rmul__(cls, other): ...
    @classmethod
    def __sub__(cls, other): ...
    @classmethod
    def __truediv__(cls, other): ...
    @property
    def np(self): ...

class Frame(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    inertia: Incomplete
    name: Incomplete
    parent: Incomplete
    placement: Incomplete
    previousFrame: Incomplete
    type: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class FrameType(Boost.Python.enum):
    BODY: ClassVar[FrameType] = ...
    FIXED_JOINT: ClassVar[FrameType] = ...
    JOINT: ClassVar[FrameType] = ...
    OP_FRAME: ClassVar[FrameType] = ...
    SENSOR: ClassVar[FrameType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class GeometryData(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def activateCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def deactivateAllCollisionPairs(cls, *args, **kwargs): ...
    @classmethod
    def deactivateCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def fillInnerOuterObjectMaps(cls, *args, **kwargs): ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs): ...
    @classmethod
    def loadFromString(cls, *args, **kwargs): ...
    @classmethod
    def loadFromText(cls, *args, **kwargs): ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs): ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs): ...
    @classmethod
    def saveToString(cls, *args, **kwargs): ...
    @classmethod
    def saveToText(cls, *args, **kwargs): ...
    @classmethod
    def saveToXML(cls, *args, **kwargs): ...
    @classmethod
    def setActiveCollisionPairs(cls, *args, **kwargs): ...
    @classmethod
    def setGeometryCollisionStatus(cls, *args, **kwargs): ...
    @classmethod
    def setSecurityMargins(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def activeCollisionPairs(self): ...
    @property
    def collisionRequests(self): ...
    @property
    def collisionResults(self): ...
    @property
    def distanceRequests(self): ...
    @property
    def distanceResults(self): ...
    @property
    def oMg(self): ...
    @property
    def radius(self): ...

class GeometryModel(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addAllCollisionPairs(cls, *args, **kwargs): ...
    @classmethod
    def addCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def addGeometryObject(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def createData(cls, *args, **kwargs): ...
    @classmethod
    def existCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def existGeometryName(cls, *args, **kwargs): ...
    @classmethod
    def findCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def getGeometryId(cls, *args, **kwargs): ...
    @classmethod
    def removeAllCollisionPairs(cls, *args, **kwargs): ...
    @classmethod
    def removeCollisionPair(cls, *args, **kwargs): ...
    @classmethod
    def removeGeometryObject(cls, *args, **kwargs): ...
    @classmethod
    def setCollisionPairs(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def collisionPairs(self): ...
    @property
    def geometryObjects(self): ...
    @property
    def ngeoms(self): ...

class GeometryNoMaterial(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class GeometryObject(Boost.Python.instance):
    disableCollision: Incomplete
    geometry: Incomplete
    meshColor: Incomplete
    meshMaterial: Incomplete
    meshPath: Incomplete
    meshScale: Incomplete
    meshTexturePath: Incomplete
    name: Incomplete
    overrideMaterial: Incomplete
    parentFrame: Incomplete
    parentJoint: Incomplete
    placement: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def CreateCapsule(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...

class GeometryPhongMaterial(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    meshEmissionColor: Incomplete
    meshShininess: Incomplete
    meshSpecularColor: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls): ...

class GeometryType(Boost.Python.enum):
    COLLISION: ClassVar[GeometryType] = ...
    VISUAL: ClassVar[GeometryType] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class Inertia(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    inertia: Incomplete
    lever: Incomplete
    mass: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def FromBox(cls, *args, **kwargs): ...
    @classmethod
    def FromCylinder(cls, *args, **kwargs): ...
    @classmethod
    def FromDynamicParameters(cls, *args, **kwargs): ...
    @classmethod
    def FromEllipsoid(cls, *args, **kwargs): ...
    @classmethod
    def FromSphere(cls, *args, **kwargs): ...
    @classmethod
    def Identity(cls, *args, **kwargs): ...
    @classmethod
    def Random(cls, *args, **kwargs): ...
    @classmethod
    def Zero(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def isApprox(cls, *args, **kwargs): ...
    @classmethod
    def isZero(cls, *args, **kwargs): ...
    @classmethod
    def ivx(cls, *args, **kwargs): ...
    @classmethod
    def matrix(cls, *args, **kwargs): ...
    @classmethod
    def se3Action(cls, *args, **kwargs): ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs): ...
    @classmethod
    def setIdentity(cls, *args, **kwargs): ...
    @classmethod
    def setRandom(cls, *args, **kwargs): ...
    @classmethod
    def setZero(cls, *args, **kwargs): ...
    @classmethod
    def toDynamicParameters(cls, *args, **kwargs): ...
    @classmethod
    def variation(cls, *args, **kwargs): ...
    @classmethod
    def vtiv(cls, *args, **kwargs): ...
    @classmethod
    def vxi(cls, *args, **kwargs): ...
    @classmethod
    def vxiv(cls, *args, **kwargs): ...
    @classmethod
    def __add__(cls, other): ...
    @classmethod
    def __array__(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def np(self): ...

class JointDataComposite(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def StU(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def iMlast(self): ...
    @property
    def joints(self): ...
    @property
    def pjMi(self): ...
    @property
    def v(self): ...

class JointDataFreeFlyer(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataMimic_JointDataRX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataMimic_JointDataRY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataMimic_JointDataRZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataPX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataPY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataPZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataPlanar(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def StU(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataPrismaticUnaligned(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRUBX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRUBY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRUBZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRY(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRZ(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRevoluteUnaligned(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataRevoluteUnboundedUnalignedTpl(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataSpherical(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataSphericalZYX(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def StU(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointDataTranslation(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def Dinv(self): ...
    @property
    def M(self): ...
    @property
    def S(self): ...
    @property
    def U(self): ...
    @property
    def UDinv(self): ...
    @property
    def c(self): ...
    @property
    def v(self): ...

class JointModel(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasConfigurationLimit(cls, *args, **kwargs): ...
    @classmethod
    def hasConfigurationLimitInTangent(cls, *args, **kwargs): ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelComposite(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addJoint(cls, *args, **kwargs): ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def jointPlacements(self): ...
    @property
    def joints(self): ...
    @property
    def njoints(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelFreeFlyer(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelMimic_JointModelRX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelMimic_JointModelRY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelMimic_JointModelRZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelPX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelPY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelPZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelPlanar(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelPrismaticUnaligned(Boost.Python.instance):
    axis: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRUBX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRUBY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRUBZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRY(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRZ(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRevoluteUnaligned(Boost.Python.instance):
    axis: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelRevoluteUnboundedUnaligned(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelSpherical(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelSphericalZYX(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class JointModelTranslation(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def hasSameIndexes(cls, *args, **kwargs): ...
    @classmethod
    def setIndexes(cls, *args, **kwargs): ...
    @classmethod
    def shortname(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def hasConfigurationLimit(self): ...
    @property
    def hasConfigurationLimitInTangent(self): ...
    @property
    def id(self): ...
    @property
    def idx_q(self): ...
    @property
    def idx_v(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class KinematicLevel(Boost.Python.enum):
    ACCELERATION: ClassVar[KinematicLevel] = ...
    POSITION: ClassVar[KinematicLevel] = ...
    VELOCITY: ClassVar[KinematicLevel] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class LieGroup(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def dDifference(cls, *args, **kwargs): ...
    @classmethod
    def dIntegrate(cls, *args, **kwargs): ...
    @classmethod
    def dIntegrateTransport(cls, *args, **kwargs): ...
    @classmethod
    def dIntegrate_dq(cls, *args, **kwargs): ...
    @classmethod
    def dIntegrate_dv(cls, *args, **kwargs): ...
    @classmethod
    def difference(cls, *args, **kwargs): ...
    @classmethod
    def distance(cls, *args, **kwargs): ...
    @classmethod
    def integrate(cls, *args, **kwargs): ...
    @classmethod
    def interpolate(cls, *args, **kwargs): ...
    @classmethod
    def normalize(cls, *args, **kwargs): ...
    @classmethod
    def random(cls, *args, **kwargs): ...
    @classmethod
    def randomConfiguration(cls, *args, **kwargs): ...
    @classmethod
    def squaredDistance(cls, *args, **kwargs): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __imul__(cls, other): ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def name(self): ...
    @property
    def neutral(self): ...
    @property
    def nq(self): ...
    @property
    def nv(self): ...

class Model(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    damping: Incomplete
    effortLimit: Incomplete
    frames: Incomplete
    friction: Incomplete
    gravity: Incomplete
    lowerPositionLimit: Incomplete
    name: Incomplete
    referenceConfigurations: Incomplete
    rotorGearRatio: Incomplete
    rotorInertia: Incomplete
    subtrees: Incomplete
    supports: Incomplete
    upperPositionLimit: Incomplete
    velocityLimit: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def addBodyFrame(cls, *args, **kwargs): ...
    @classmethod
    def addFrame(cls, *args, **kwargs): ...
    @classmethod
    def addJoint(cls, *args, **kwargs): ...
    @classmethod
    def addJointFrame(cls, *args, **kwargs): ...
    @classmethod
    def appendBodyToJoint(cls, *args, **kwargs): ...
    @classmethod
    def check(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def createData(cls, *args, **kwargs): ...
    @classmethod
    def existBodyName(cls, *args, **kwargs): ...
    @classmethod
    def existFrame(cls, *args, **kwargs): ...
    @classmethod
    def existJointName(cls, *args, **kwargs): ...
    @classmethod
    def getBodyId(cls, *args, **kwargs): ...
    @classmethod
    def getFrameId(cls, *args, **kwargs): ...
    @classmethod
    def getJointId(cls, *args, **kwargs): ...
    @classmethod
    def hasConfigurationLimit(cls, *args, **kwargs): ...
    @classmethod
    def hasConfigurationLimitInTangent(cls, *args, **kwargs): ...
    @classmethod
    def loadFromBinary(cls, *args, **kwargs): ...
    @classmethod
    def loadFromString(cls, *args, **kwargs): ...
    @classmethod
    def loadFromText(cls, *args, **kwargs): ...
    @classmethod
    def loadFromXML(cls, *args, **kwargs): ...
    @classmethod
    def saveToBinary(cls, *args, **kwargs): ...
    @classmethod
    def saveToString(cls, *args, **kwargs): ...
    @classmethod
    def saveToText(cls, *args, **kwargs): ...
    @classmethod
    def saveToXML(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def idx_qs(self): ...
    @property
    def idx_vs(self): ...
    @property
    def inertias(self): ...
    @property
    def jointPlacements(self): ...
    @property
    def joints(self): ...
    @property
    def names(self): ...
    @property
    def nbodies(self): ...
    @property
    def nframes(self): ...
    @property
    def njoints(self): ...
    @property
    def nq(self): ...
    @property
    def nqs(self): ...
    @property
    def nv(self): ...
    @property
    def nvs(self): ...
    @property
    def parents(self): ...

class Motion(Boost.Python.instance):
    __safe_for_unpickling__: ClassVar[bool] = ...
    angular: Incomplete
    linear: Incomplete
    vector: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Random(cls, *args, **kwargs): ...
    @classmethod
    def Zero(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def cross(cls, *args, **kwargs): ...
    @classmethod
    def isApprox(cls, *args, **kwargs): ...
    @classmethod
    def isZero(cls, *args, **kwargs): ...
    @classmethod
    def se3Action(cls, *args, **kwargs): ...
    @classmethod
    def se3ActionInverse(cls, *args, **kwargs): ...
    @classmethod
    def setRandom(cls, *args, **kwargs): ...
    @classmethod
    def setZero(cls, *args, **kwargs): ...
    @classmethod
    def __add__(cls, other): ...
    @classmethod
    def __array__(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __iadd__(cls, other): ...
    @classmethod
    def __isub__(cls, other): ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __neg__(cls): ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __rmul__(cls, other): ...
    @classmethod
    def __sub__(cls, other): ...
    @classmethod
    def __truediv__(cls, other): ...
    @classmethod
    def __xor__(cls, other): ...
    @property
    def action(self): ...
    @property
    def dualAction(self): ...
    @property
    def homogeneous(self): ...
    @property
    def np(self): ...

class ReferenceFrame(Boost.Python.enum):
    LOCAL: ClassVar[ReferenceFrame] = ...
    LOCAL_WORLD_ALIGNED: ClassVar[ReferenceFrame] = ...
    WORLD: ClassVar[ReferenceFrame] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...

class SE3(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    rotation: Incomplete
    translation: Incomplete
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def Identity(cls, *args, **kwargs): ...
    @classmethod
    def Interpolate(cls, *args, **kwargs): ...
    @classmethod
    def Random(cls, *args, **kwargs): ...
    @classmethod
    def act(cls, *args, **kwargs): ...
    @classmethod
    def actInv(cls, *args, **kwargs): ...
    @classmethod
    def copy(cls, *args, **kwargs): ...
    @classmethod
    def inverse(cls, *args, **kwargs): ...
    @classmethod
    def isApprox(cls, *args, **kwargs): ...
    @classmethod
    def isIdentity(cls, *args, **kwargs): ...
    @classmethod
    def setIdentity(cls, *args, **kwargs): ...
    @classmethod
    def setRandom(cls, *args, **kwargs): ...
    @classmethod
    def toActionMatrix(cls, *args, **kwargs): ...
    @classmethod
    def toActionMatrixInverse(cls, *args, **kwargs): ...
    @classmethod
    def toDualActionMatrix(cls, *args, **kwargs): ...
    @classmethod
    def __array__(cls, *args, **kwargs): ...
    @classmethod
    def __copy__(cls): ...
    @classmethod
    def __deepcopy__(cls): ...
    @classmethod
    def __eq__(cls, other: object) -> bool: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __invert__(cls): ...
    @classmethod
    def __mul__(cls, other): ...
    @classmethod
    def __ne__(cls, other: object) -> bool: ...
    @classmethod
    def __reduce__(cls): ...
    @property
    def action(self): ...
    @property
    def actionInverse(self): ...
    @property
    def dualAction(self): ...
    @property
    def homogeneous(self): ...
    @property
    def np(self): ...

class StdMap_String_VectorXd(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Bool(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_CollisionPair(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Double(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Force(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Frame(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_GeometryModel(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_GeometryObject(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Index(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_IndexVector(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Inertia(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Int(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_JointModelVector(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Matrix6x(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Motion(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_SE3(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_StdString(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class StdVec_Vector3(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs): ...
    @classmethod
    def extend(cls, *args, **kwargs): ...
    @classmethod
    def tolist(cls, *args, **kwargs): ...
    @classmethod
    def __contains__(cls, other) -> bool: ...
    @classmethod
    def __delitem__(cls, other) -> None: ...
    @classmethod
    def __getinitargs__(cls): ...
    @classmethod
    def __getitem__(cls, index): ...
    @classmethod
    def __iter__(cls): ...
    @classmethod
    def __len__(cls) -> int: ...
    @classmethod
    def __reduce__(cls): ...
    @classmethod
    def __setitem__(cls, index, object) -> None: ...

class map_indexing_suite_StdMap_String_VectorXd_entry(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def data(cls, *args, **kwargs): ...
    @classmethod
    def key(cls, *args, **kwargs): ...
    @classmethod
    def __reduce__(cls): ...

def Hlog3(*args, **kwargs): ...
def Jexp3(*args, **kwargs): ...
def Jexp6(*args, **kwargs): ...
def Jlog3(*args, **kwargs): ...
def Jlog6(*args, **kwargs): ...
def SE3ToXYZQUAT(*args, **kwargs): ...
def SE3ToXYZQUATtuple(*args, **kwargs): ...
def XYZQUATToSE3(*args, **kwargs): ...
def aba(*args, **kwargs): ...
def appendModel(*args, **kwargs): ...
def bodyRegressor(v, a) -> Any: ...
def buildGeomFromUrdf(*args, **kwargs): ...
def buildGeomFromUrdfString(*args, **kwargs): ...
def buildModelFromUrdf(*args, **kwargs): ...
def buildModelFromXML(*args, **kwargs): ...
def buildReducedModel(*args, **kwargs): ...
def buildSampleGeometryModelHumanoid(*args, **kwargs): ...
def buildSampleGeometryModelManipulator(*args, **kwargs): ...
def buildSampleModelHumanoid(*args, **kwargs): ...
def buildSampleModelHumanoidRandom(*args, **kwargs): ...
def buildSampleModelManipulator(*args, **kwargs): ...
def ccrba(*args, **kwargs): ...
def centerOfMass(*args, **kwargs): ...
def checkVersionAtLeast(*args, **kwargs): ...
def computeABADerivatives(*args, **kwargs): ...
def computeAllTerms(*args, **kwargs): ...
def computeBodyRadius(*args, **kwargs): ...
def computeCentroidalDynamicsDerivatives(*args, **kwargs): ...
def computeCentroidalMap(*args, **kwargs): ...
def computeCentroidalMapTimeVariation(*args, **kwargs): ...
def computeCentroidalMomentum(*args, **kwargs): ...
def computeCentroidalMomentumTimeVariation(*args, **kwargs): ...
def computeCollision(*args, **kwargs): ...
def computeCollisions(*args, **kwargs): ...
def computeCoriolisMatrix(*args, **kwargs): ...
def computeDistance(*args, **kwargs): ...
def computeDistances(*args, **kwargs): ...
def computeForwardKinematicsDerivatives(*args, **kwargs): ...
def computeFrameJacobian(*args, **kwargs): ...
def computeFrameKinematicRegressor(*args, **kwargs): ...
def computeGeneralizedGravity(*args, **kwargs): ...
def computeGeneralizedGravityDerivatives(*args, **kwargs): ...
def computeJointJacobian(*args, **kwargs): ...
def computeJointJacobians(*args, **kwargs): ...
def computeJointJacobiansTimeVariation(*args, **kwargs): ...
def computeJointKinematicRegressor(*args, **kwargs): ...
def computeJointTorqueRegressor(*args, **kwargs): ...
def computeKKTContactDynamicMatrixInverse(*args, **kwargs): ...
def computeKineticEnergy(*args, **kwargs): ...
def computeMinverse(*args, **kwargs): ...
def computePotentialEnergy(*args, **kwargs): ...
def computeRNEADerivatives(*args, **kwargs): ...
def computeStaticRegressor(*args, **kwargs): ...
def computeStaticTorque(*args, **kwargs): ...
def computeStaticTorqueDerivatives(*args, **kwargs): ...
def computeSubtreeMasses(*args, **kwargs): ...
def computeSupportedForceByFrame(*args, **kwargs): ...
def computeSupportedInertiaByFrame(*args, **kwargs): ...
def computeTotalMass(*args, **kwargs): ...
def crba(*args, **kwargs): ...
def dDifference(*args, **kwargs): ...
def dIntegrate(*args, **kwargs): ...
def dIntegrateTransport(*args, **kwargs): ...
def dccrba(*args, **kwargs): ...
def difference(*args, **kwargs): ...
def distance(*args, **kwargs): ...
def exp3(*args, **kwargs): ...
def exp6(*args, **kwargs): ...
def forwardDynamics(*args, **kwargs): ...
def forwardKinematics(*args, **kwargs): ...
def frameBodyRegressor(*args, **kwargs): ...
def frameJacobianTimeVariation(*args, **kwargs): ...
def framesForwardKinematics(*args, **kwargs): ...
def getAcceleration(*args, **kwargs): ...
def getCenterOfMassVelocityDerivatives(*args, **kwargs): ...
def getCentroidalDynamicsDerivatives(*args, **kwargs): ...
def getClassicalAcceleration(*args, **kwargs): ...
def getCoriolisMatrix(*args, **kwargs): ...
def getFrameAcceleration(*args, **kwargs): ...
def getFrameAccelerationDerivatives(*args, **kwargs): ...
def getFrameClassicalAcceleration(*args, **kwargs): ...
def getFrameJacobian(*args, **kwargs): ...
def getFrameJacobianTimeVariation(*args, **kwargs): ...
def getFrameVelocity(*args, **kwargs): ...
def getFrameVelocityDerivatives(*args, **kwargs): ...
def getJacobianSubtreeCenterOfMass(*args, **kwargs): ...
def getJointAccelerationDerivatives(*args, **kwargs): ...
def getJointJacobian(*args, **kwargs): ...
def getJointJacobianTimeVariation(*args, **kwargs): ...
def getJointVelocityDerivatives(*args, **kwargs): ...
def getKKTContactDynamicMatrixInverse(*args, **kwargs): ...
def getVelocity(*args, **kwargs): ...
def impulseDynamics(*args, **kwargs): ...
def integrate(*args, **kwargs): ...
def interpolate(*args, **kwargs): ...
def isNormalized(*args, **kwargs): ...
def isSameConfiguration(*args, **kwargs): ...
def jacobianCenterOfMass(*args, **kwargs): ...
def jacobianSubtreeCenterOfMass(*args, **kwargs): ...
def jacobianSubtreeCoMJacobian(*args, **kwargs): ...
def jointBodyRegressor(*args, **kwargs): ...
def loadReferenceConfigurations(*args, **kwargs): ...
def loadReferenceConfigurationsFromXML(*args, **kwargs): ...
def loadRotorParameters(*args, **kwargs): ...
def log3(*args, **kwargs): ...
def log6(*args, **kwargs): ...
def neutral(*args, **kwargs): ...
def nonLinearEffects(*args, **kwargs): ...
def normalize(*args, **kwargs): ...
def printVersion(*args, **kwargs): ...
def randomConfiguration(*args, **kwargs): ...
def removeCollisionPairs(*args, **kwargs): ...
def removeCollisionPairsFromXML(*args, **kwargs): ...
def rnea(*args, **kwargs): ...
def seed(*args, **kwargs): ...
def sharedMemory(*args, **kwargs): ...
def skew(*args, **kwargs): ...
def skewSquare(*args, **kwargs): ...
def squaredDistance(*args, **kwargs): ...
def unSkew(*args, **kwargs): ...
def updateFramePlacement(*args, **kwargs): ...
def updateFramePlacements(*args, **kwargs): ...
def updateGeometryPlacements(*args, **kwargs): ...
def updateGlobalPlacements(*args, **kwargs): ...
