# -*- coding: utf-8 -*-
"""Exam Project Valle Ilenia.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1iennHVJtTxqwp2ZTuwd4EuyFkdaygmmx
"""

#STEP 1
#Use the noun given from the teacher and find adjectives which are often used to describe the given word 
#Example of a given word: "house"

import json,requests
from pprint import pprint

keyword = input('write the noun given from the teacher ')
print(keyword)

url= 'https://api.datamuse.com/words?rel_jjb=' + keyword  
print(url)

response1 = requests.get(url)   
#Print(response.text)  

adjectives = json.loads(response1.text)
pprint(adjectives)
       
#Use the noun given from the teacher so as to find words with are strongly associated with the given noun

url='https://api.datamuse.com/words?rel_trg=' + keyword
print(url)

response2 = requests.get(url)   
#Print(response2.text) 

othercollocations = json.loads(response2.text)
pprint(othercollocations)

#STEP 2

#The teacher gives a number of 'banned' words which cannot be used. The words change according to the topic of the text and belong to the collocations obtained in step 2
#Example of banned words: big,beautyful,empty

input_string = input("Enter the words given from the teacher separated by comma ")
banned_words_list  = input_string.split(",")
print("These words cannot be used in the text: " )
print(banned_words_list)

#STEP 3

#Install a language package

!pip install gingerit

#STEP 4

#Now the student is asked to write a text of at least 50 words by continuing a given sentence, including at least 5 collocations found in STEP 1 
#but excluding the banned words which are in STEP 2
#The number of words can change according to the aim of the task.

#Sentence given from the teacher. Example: Jane and Jack were walking in the forest when they suddenly saw a huge house.

sentence_completition = input('Copy the sentence given from the teacher ')
print('This is the beginning of your story:', sentence_completition)

#The input is the student's text. It is the continuation of the given sentence. It must contain at least five words obtained from step 1 and 1. It cannot contain the banned words. 

#Example of a text with banned words: 
#From the outside it looked likt the residence off a quiin. It had an spacious garden autsaid with an victorian foutain. Jane and Jason tryed to opened the door and managed to enter. Inside the haus were lovely. It was complitely furnished and reallly spacious. Suddenly, they heared an voice. They ran out and goed back to town. Banned word empty

#Example of a text: 
#From the outside it looked likt the residence off a quiin. It had an spacious garden autsaid with an victorian foutain. Jane and Jason tryed to opened the door and managed to enter. Inside the haus were lovely. It was complitely furnished and reallly spacious. Suddenly, they heared an voice. They ran out and goed back to town.


contains_banned_words = True
while contains_banned_words:
  text = input('Write a text of at least 50 words using at least five words obtained in step 1 and 2 but without using the banned words ')
  print(text)
  if not any(word in text for word in banned_words_list):
    contains_banned_words = False
  else:
    print("Check your text and eliminate banned words")


from gingerit.gingerit import GingerIt
result = GingerIt().parse(text)
result
len(result['corrections'])
for i in range(len(result['corrections'])):
  print(result['corrections'][i])
print("Original Text: ", result['text'])
print("Corrected Text: ", result['result'])

#STEP 5
!pip install gTTS

#STEP 6
#Copy the corrected text and then have it read with British accent.

from gtts import gTTS
import IPython.display as ipd 

usertext = input('Copy the Corrected Text')
tts1 = gTTS(text=usertext , lang= 'en', tld= 'co.uk' )
tts1.save('corrected_text_britishenglish.mp3')

ipd.display(ipd.Audio('corrected_text_britishenglish.mp3',autoplay=True))