
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "rtg"

@_ods_cext.register_operation(_Dialect)
class ArrayCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.array_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, elements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def elements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_create(result, elements, *, loc=None, ip=None) -> _ods_ir.Value:
  return ArrayCreateOp(result=result, elements=elements, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ArrayExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.array_extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, array, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(array)
    operands.append(index)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def array(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_extract(array, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return ArrayExtractOp(array=array, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ArrayInjectOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.array_inject"

  _ODS_REGIONS = (0, True)

  def __init__(self, array, index, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(array)
    operands.append(index)
    operands.append(value)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def array(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def value(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_inject(array, index, value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ArrayInjectOp(array=array, index=index, value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ArraySizeOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.array_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, array, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(array)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def array(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_size(array, *, loc=None, ip=None) -> _ods_ir.Value:
  return ArraySizeOp(array=array, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagConvertToSetOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_convert_to_set"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bag_convert_to_set(input, *, loc=None, ip=None) -> _ods_ir.Value:
  return BagConvertToSetOp(input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, bag, elements, multiples, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    operands.extend(_get_op_results_or_values(multiples))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(bag)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def elements(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 0)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def multiples(self):
    start, elements_per_group = _ods_equally_sized_accessor(self.operation.operands, 0, 2, 0, 1)
    return self.operation.operands[start:start + elements_per_group]

  @builtins.property
  def bag(self):
    return self.operation.results[0]

def bag_create(bag, elements, multiples, *, loc=None, ip=None) -> _ods_ir.Value:
  return BagCreateOp(bag=bag, elements=elements, multiples=multiples, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagDifferenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_difference"

  _ODS_REGIONS = (0, True)

  def __init__(self, original, diff, *, inf=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(original)
    operands.append(diff)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(inf): attributes["inf"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def original(self):
    return self.operation.operands[0]

  @builtins.property
  def diff(self):
    return self.operation.operands[1]

  @builtins.property
  def inf(self):
    return "inf" in self.operation.attributes

  @inf.setter
  def inf(self, value):
    if bool(value):
      self.operation.attributes["inf"] = _ods_ir.UnitAttr.get()
    elif "inf" in self.operation.attributes:
      del self.operation.attributes["inf"]

  @inf.deleter
  def inf(self):
    del self.operation.attributes["inf"]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bag_difference(original, diff, *, inf=None, loc=None, ip=None) -> _ods_ir.Value:
  return BagDifferenceOp(original=original, diff=diff, inf=inf, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagSelectRandomOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_select_random"

  _ODS_REGIONS = (0, True)

  def __init__(self, bag, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(bag)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def bag(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def bag_select_random(bag, *, loc=None, ip=None) -> _ods_ir.Value:
  return BagSelectRandomOp(bag=bag, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagUnionOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_union"

  _ODS_REGIONS = (0, True)

  def __init__(self, bags, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(bags))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def bags(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bag_union(bags, *, loc=None, ip=None) -> _ods_ir.Value:
  return BagUnionOp(bags=bags, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BagUniqueSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.bag_unique_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, bag, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(bag)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def bag(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bag_unique_size(bag, *, loc=None, ip=None) -> _ods_ir.Value:
  return BagUniqueSizeOp(bag=bag, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CommentOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.comment"

  _ODS_REGIONS = (0, True)

  def __init__(self, comment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["comment"] = (comment if (
    isinstance(comment, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(comment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def comment(self):
    return self.operation.attributes["comment"]

  @comment.setter
  def comment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["comment"] = value

def comment(comment, *, loc=None, ip=None) -> _ods_ir.Operation:
  return CommentOp(comment=comment, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypedAttrInterface')) else
      _ods_ir.AttrBuilder.get('TypedAttrInterface')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constant(value, *, loc=None, ip=None) -> _ods_ir.Value:
  return ConstantOp(value=value, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ContextSwitchOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.context_switch"

  _ODS_REGIONS = (0, True)

  def __init__(self, from_, to, sequence, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(sequence)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["from"] = (from_ if (
    isinstance(from_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ContextResourceAttrInterface')) else
      _ods_ir.AttrBuilder.get('ContextResourceAttrInterface')(from_, context=_ods_context))
    attributes["to"] = (to if (
    isinstance(to, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ContextResourceAttrInterface')) else
      _ods_ir.AttrBuilder.get('ContextResourceAttrInterface')(to, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequence(self):
    return self.operation.operands[0]

  @builtins.property
  def from_(self):
    return self.operation.attributes["from"]

  @from_.setter
  def from_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["from"] = value

  @builtins.property
  def to(self):
    return self.operation.attributes["to"]

  @to.setter
  def to(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["to"] = value

def context_switch(from_, to, sequence, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ContextSwitchOp(from_=from_, to=to, sequence=sequence, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class EmbedSequenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.embed_sequence"

  _ODS_REGIONS = (0, True)

  def __init__(self, sequence, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(sequence)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequence(self):
    return self.operation.operands[0]

def embed_sequence(sequence, *, loc=None, ip=None) -> _ods_ir.Operation:
  return EmbedSequenceOp(sequence=sequence, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class FixedRegisterOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.fixed_reg"

  _ODS_REGIONS = (0, True)

  def __init__(self, reg, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reg"] = (reg if (
    isinstance(reg, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('RegisterAttrInterface')) else
      _ods_ir.AttrBuilder.get('RegisterAttrInterface')(reg, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def reg(self):
    return self.operation.attributes["reg"]

  @reg.setter
  def reg(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reg"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def fixed_reg(reg, *, loc=None, ip=None) -> _ods_ir.Value:
  return FixedRegisterOp(reg=reg, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class GetSequenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.get_sequence"

  _ODS_REGIONS = (0, True)

  def __init__(self, ref, sequence, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sequence"] = (sequence if (
    isinstance(sequence, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sequence, context=_ods_context))
    results.append(ref)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequence(self):
    return self.operation.attributes["sequence"]

  @sequence.setter
  def sequence(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sequence"] = value

  @builtins.property
  def ref(self):
    return self.operation.results[0]

def get_sequence(ref, sequence, *, loc=None, ip=None) -> _ods_ir.Value:
  return GetSequenceOp(ref=ref, sequence=sequence, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IntToImmediateOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.isa.int_to_immediate"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def isa_int_to_immediate(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return IntToImmediateOp(result=result, input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class InterleaveSequencesOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.interleave_sequences"

  _ODS_REGIONS = (0, True)

  def __init__(self, sequences, *, batchSize=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sequences))
    _ods_context = _ods_get_default_loc_context(loc)
    if batchSize is not None: attributes["batchSize"] = (batchSize if (
        isinstance(batchSize, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(batchSize, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequences(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def batchSize(self):
    return self.operation.attributes["batchSize"]

  @batchSize.setter
  def batchSize(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["batchSize"] = value

  @builtins.property
  def interleavedSequence(self):
    return self.operation.results[0]

def interleave_sequences(sequences, *, batch_size=None, loc=None, ip=None) -> _ods_ir.Value:
  return InterleaveSequencesOp(sequences=sequences, batchSize=batch_size, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LabelDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.label_decl"

  _ODS_REGIONS = (0, True)

  def __init__(self, formatString, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["formatString"] = (formatString if (
    isinstance(formatString, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(formatString, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def formatString(self):
    return self.operation.attributes["formatString"]

  @formatString.setter
  def formatString(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["formatString"] = value

  @builtins.property
  def label(self):
    return self.operation.results[0]

def label_decl(format_string, args, *, loc=None, ip=None) -> _ods_ir.Value:
  return LabelDeclOp(formatString=format_string, args=args, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LabelOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.label"

  _ODS_REGIONS = (0, True)

  def __init__(self, visibility, label, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(label)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["visibility"] = (visibility if (
    isinstance(visibility, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('LabelVisibilityAttr')) else
      _ods_ir.AttrBuilder.get('LabelVisibilityAttr')(visibility, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def label(self):
    return self.operation.operands[0]

  @builtins.property
  def visibility(self):
    return self.operation.attributes["visibility"]

  @visibility.setter
  def visibility(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["visibility"] = value

def label(visibility, label, *, loc=None, ip=None) -> _ods_ir.Operation:
  return LabelOp(visibility=visibility, label=label, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class LabelUniqueDeclOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.label_unique_decl"

  _ODS_REGIONS = (0, True)

  def __init__(self, formatString, args, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(args))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["formatString"] = (formatString if (
    isinstance(formatString, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(formatString, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def args(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def formatString(self):
    return self.operation.attributes["formatString"]

  @formatString.setter
  def formatString(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["formatString"] = value

  @builtins.property
  def label(self):
    return self.operation.results[0]

def label_unique_decl(format_string, args, *, loc=None, ip=None) -> _ods_ir.Value:
  return LabelUniqueDeclOp(formatString=format_string, args=args, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemoryAllocOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.isa.memory_alloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, memoryBlock, size, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(memoryBlock)
    operands.append(size)
    operands.append(alignment)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def memoryBlock(self):
    return self.operation.operands[0]

  @builtins.property
  def size(self):
    return self.operation.operands[1]

  @builtins.property
  def alignment(self):
    return self.operation.operands[2]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def isa_memory_alloc(memory_block, size, alignment, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemoryAllocOp(memoryBlock=memory_block, size=size, alignment=alignment, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemoryBaseAddressOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.isa.memory_base_address"

  _ODS_REGIONS = (0, True)

  def __init__(self, memory, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(memory)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def memory(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def isa_memory_base_address(memory, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemoryBaseAddressOp(memory=memory, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemoryBlockDeclareOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.isa.memory_block_declare"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, baseAddress, endAddress, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["baseAddress"] = (baseAddress if (
    isinstance(baseAddress, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('APIntAttr')) else
      _ods_ir.AttrBuilder.get('APIntAttr')(baseAddress, context=_ods_context))
    attributes["endAddress"] = (endAddress if (
    isinstance(endAddress, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('APIntAttr')) else
      _ods_ir.AttrBuilder.get('APIntAttr')(endAddress, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def baseAddress(self):
    return self.operation.attributes["baseAddress"]

  @baseAddress.setter
  def baseAddress(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["baseAddress"] = value

  @builtins.property
  def endAddress(self):
    return self.operation.attributes["endAddress"]

  @endAddress.setter
  def endAddress(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["endAddress"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def isa_memory_block_declare(result, base_address, end_address, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemoryBlockDeclareOp(result=result, baseAddress=base_address, endAddress=end_address, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MemorySizeOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.isa.memory_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, memory, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(memory)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def memory(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def isa_memory_size(memory, *, loc=None, ip=None) -> _ods_ir.Value:
  return MemorySizeOp(memory=memory, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OnContextOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.on_context"

  _ODS_REGIONS = (0, True)

  def __init__(self, context_, sequence, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(context_)
    operands.append(sequence)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def context_(self):
    return self.operation.operands[0]

  @builtins.property
  def sequence(self):
    return self.operation.operands[1]

def on_context(context_, sequence, *, loc=None, ip=None) -> _ods_ir.Operation:
  return OnContextOp(context_=context_, sequence=sequence, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class RandomNumberInRangeOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.random_number_in_range"

  _ODS_REGIONS = (0, True)

  def __init__(self, lowerBound, upperBound, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(lowerBound)
    operands.append(upperBound)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lowerBound(self):
    return self.operation.operands[0]

  @builtins.property
  def upperBound(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def random_number_in_range(lower_bound, upper_bound, *, loc=None, ip=None) -> _ods_ir.Value:
  return RandomNumberInRangeOp(lowerBound=lower_bound, upperBound=upper_bound, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RandomizeSequenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.randomize_sequence"

  _ODS_REGIONS = (0, True)

  def __init__(self, sequence, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(sequence)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequence(self):
    return self.operation.operands[0]

  @builtins.property
  def randomizedSequence(self):
    return self.operation.results[0]

def randomize_sequence(sequence, *, loc=None, ip=None) -> _ods_ir.Value:
  return RandomizeSequenceOp(sequence=sequence, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SequenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.sequence"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, sequenceType, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["sequenceType"] = (sequenceType if (
    isinstance(sequenceType, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_463')) else
      _ods_ir.AttrBuilder.get('anonymous_463')(sequenceType, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def sequenceType(self):
    return self.operation.attributes["sequenceType"]

  @sequenceType.setter
  def sequenceType(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sequenceType"] = value

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def sequence(sym_name, sequence_type, *, loc=None, ip=None) -> _ods_ir.Operation:
  return SequenceOp(sym_name=sym_name, sequenceType=sequence_type, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SetCartesianProductOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_cartesian_product"

  _ODS_REGIONS = (0, True)

  def __init__(self, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def set_cartesian_product(inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetCartesianProductOp(inputs=inputs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetConvertToBagOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_convert_to_bag"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(input)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def set_convert_to_bag(input, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetConvertToBagOp(input=input, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, set, elements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(set)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def elements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def set(self):
    return self.operation.results[0]

def set_create(set, elements, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetCreateOp(set=set, elements=elements, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetDifferenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_difference"

  _ODS_REGIONS = (0, True)

  def __init__(self, original, diff, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(original)
    operands.append(diff)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def original(self):
    return self.operation.operands[0]

  @builtins.property
  def diff(self):
    return self.operation.operands[1]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def set_difference(original, diff, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetDifferenceOp(original=original, diff=diff, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetSelectRandomOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_select_random"

  _ODS_REGIONS = (0, True)

  def __init__(self, set, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(set)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def set(self):
    return self.operation.operands[0]

  @builtins.property
  def output(self):
    return self.operation.results[0]

def set_select_random(set, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetSelectRandomOp(set=set, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetSizeOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_size"

  _ODS_REGIONS = (0, True)

  def __init__(self, set, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(set)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def set(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def set_size(set, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetSizeOp(set=set, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SetUnionOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.set_union"

  _ODS_REGIONS = (0, True)

  def __init__(self, sets, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(sets))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sets(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def set_union(sets, *, loc=None, ip=None) -> _ods_ir.Value:
  return SetUnionOp(sets=sets, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SubstituteSequenceOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.substitute_sequence"

  _ODS_REGIONS = (0, True)

  def __init__(self, sequence, replacements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(sequence)
    operands.extend(_get_op_results_or_values(replacements))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sequence(self):
    return self.operation.operands[0]

  @builtins.property
  def replacements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def substitute_sequence(sequence, replacements, *, loc=None, ip=None) -> _ods_ir.Value:
  return SubstituteSequenceOp(sequence=sequence, replacements=replacements, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TargetOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.target"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, target, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["target"] = (target if (
    isinstance(target, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_506')) else
      _ods_ir.AttrBuilder.get('anonymous_506')(target, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def target(self):
    return self.operation.attributes["target"]

  @target.setter
  def target(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["target"] = value

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def target(sym_name, target, *, loc=None, ip=None) -> _ods_ir.Operation:
  return TargetOp(sym_name=sym_name, target=target, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TestOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.test"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, target, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["target"] = (target if (
    isinstance(target, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_506')) else
      _ods_ir.AttrBuilder.get('anonymous_506')(target, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def target(self):
    return self.operation.attributes["target"]

  @target.setter
  def target(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["target"] = value

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def test(sym_name, target, *, loc=None, ip=None) -> _ods_ir.Operation:
  return TestOp(sym_name=sym_name, target=target, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TupleCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.tuple_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, elements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(elements))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def elements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def tuple_create(elements, *, loc=None, ip=None) -> _ods_ir.Value:
  return TupleCreateOp(elements=elements, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TupleExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.tuple_extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, tuple, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(tuple)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["index"] = (index if (
    isinstance(index, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexAttr')) else
      _ods_ir.AttrBuilder.get('IndexAttr')(index, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def tuple(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.attributes["index"]

  @index.setter
  def index(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["index"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def tuple_extract(tuple, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return TupleExtractOp(tuple=tuple, index=index, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class VirtualRegisterOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.virtual_reg"

  _ODS_REGIONS = (0, True)

  def __init__(self, allowedRegs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["allowedRegs"] = (allowedRegs if (
    isinstance(allowedRegs, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(allowedRegs, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def allowedRegs(self):
    return self.operation.attributes["allowedRegs"]

  @allowedRegs.setter
  def allowedRegs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["allowedRegs"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def virtual_reg(allowed_regs, *, loc=None, ip=None) -> _ods_ir.Value:
  return VirtualRegisterOp(allowedRegs=allowed_regs, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class YieldOp(_ods_ir.OpView):
  OPERATION_NAME = "rtg.yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def yield_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return YieldOp(operands_=operands_, loc=loc, ip=ip)
