# generated by datamodel-codegen:
#   filename:  alerts/api/createAlertAction.json
#   timestamp: 2023-01-16T09:36:03+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ...entity.events import webhook
from ...type import basic, entityReference
from .. import alertAction, emailAlertConfig


class CreateAlertAction(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[basic.EntityName] = Field(
        None, description='Name that uniquely identifies this Alert.'
    )
    displayName: Optional[str] = Field(None, description='Display name for this Alert.')
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Alert, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Alert.'
    )
    enabled: Optional[bool] = Field(True, description='Is the alert enabled.')
    alertActionType: alertAction.AlertActionType
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default 10s).'
    )
    readTimeout: Optional[int] = Field(
        12, description='Read timeout in seconds. (Default 12s).'
    )
    alertActionConfig: Union[
        webhook.Webhook,
        emailAlertConfig.EmailAlertConfig,
        alertAction.ActivityFeedAlertActionConfig,
    ]
