# generated by datamodel-codegen:
#   filename:  alerts/alerts.json
#   timestamp: 2023-01-16T09:36:03+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic, entityHistory, entityReference
from . import alertFilterRules, triggerConfig


class Rules(BaseModel):
    __root__: List[alertFilterRules.AlertFilterRule] = Field(
        ..., description='A set of filter rules associated with the Alert.'
    )


class Alerts(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this Alert.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Alert.'
    )
    fullyQualifiedName: Optional[basic.EntityName] = Field(
        None, description='Name that uniquely identifies a Alert.'
    )
    displayName: Optional[str] = Field(None, description='Display name for this Alert.')
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Alert, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Alert.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Alert.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the Alert in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the Alert.'
    )
    triggerConfig: triggerConfig.TriggerConfigModel
    filteringRules: Optional[Rules] = Field(
        None,
        description='Set of rules that the Alert Contains to allow conditional control for alerting.',
    )
    alertActions: Optional[entityReference.EntityReferenceList] = None
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
