# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/openMetadataConnection.json
#   timestamp: 2023-01-16T09:36:03+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .....security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
    openMetadataJWTClientConfig,
)
from .....security.credentials import awsCredentials
from .....security.secrets import secretsManagerProvider
from .....security.ssl import verifySSLConfig
from .....type import basic
from .. import connectionBasicType


class AuthProvider(Enum):
    no_auth = 'no-auth'
    azure = 'azure'
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    custom_oidc = 'custom-oidc'
    openmetadata = 'openmetadata'


class ElasticsSearch(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of sink component ex: metadata')
    config: Optional[basic.ComponentConfig] = None


class OpenmetadataType(Enum):
    OpenMetadata = 'OpenMetadata'


class OpenMetadataConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    clusterName: Optional[str] = Field(
        'openmetadata',
        description='Cluster name to differentiate OpenMetadata Server instance',
    )
    type: Optional[OpenmetadataType] = Field(
        OpenmetadataType.OpenMetadata, description='Service Type'
    )
    hostPort: str = Field(
        ...,
        description='OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api',
    )
    authProvider: Optional[AuthProvider] = Field(
        AuthProvider.no_auth,
        description='OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadata server.',
    )
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    securityConfig: Optional[
        Union[
            googleSSOClientConfig.GoogleSSOClientConfig,
            oktaSSOClientConfig.OktaSSOClientConfig,
            auth0SSOClientConfig.Auth0SSOClientConfig,
            azureSSOClientConfig.AzureSSOClientConfig,
            customOidcSSOClientConfig.CustomOIDCSSOClientConfig,
            openMetadataJWTClientConfig.OpenMetadataJWTClientConfig,
        ]
    ] = Field(None, description='OpenMetadata Client security configuration.')
    secretsManagerProvider: Optional[
        secretsManagerProvider.SecretsManagerProvider
    ] = secretsManagerProvider.SecretsManagerProvider.noop
    secretsManagerCredentials: Optional[awsCredentials.AWSCredentials] = Field(
        None, description='OpenMetadata Secrets Manager Client credentials'
    )
    apiVersion: Optional[str] = Field(
        'v1', description='OpenMetadata server API version to use.'
    )
    includeTopics: Optional[bool] = Field(
        True, description='Include Topics for Indexing'
    )
    includeTables: Optional[bool] = Field(
        True, description='Include Tables for Indexing'
    )
    includeDashboards: Optional[bool] = Field(
        True, description='Include Dashboards for Indexing'
    )
    includePipelines: Optional[bool] = Field(
        True, description='Include Pipelines for Indexing'
    )
    includeMlModels: Optional[bool] = Field(
        True, description='Include MlModels for Indexing'
    )
    includeUsers: Optional[bool] = Field(True, description='Include Users for Indexing')
    includeTeams: Optional[bool] = Field(True, description='Include Teams for Indexing')
    includeGlossaryTerms: Optional[bool] = Field(
        True, description='Include Glossary Terms for Indexing'
    )
    includeTags: Optional[bool] = Field(True, description='Include Tags for Indexing')
    includePolicy: Optional[bool] = Field(True, description='Include Tags for Policy')
    includeMessagingServices: Optional[bool] = Field(
        True, description='Include Messaging Services for Indexing'
    )
    enableVersionValidation: Optional[bool] = Field(
        True, description='Validate Openmetadata Server & Client Version.'
    )
    includeDatabaseServices: Optional[bool] = Field(
        True, description='Include Database Services for Indexing'
    )
    includePipelineServices: Optional[bool] = Field(
        True, description='Include Pipeline Services for Indexing'
    )
    limitRecords: Optional[int] = Field(
        '1000', description='Limit the number of records for Indexing.'
    )
    forceEntityOverwriting: Optional[bool] = Field(
        False, description='Force the overwriting of any entity during the ingestion.'
    )
    elasticsSearch: Optional[ElasticsSearch] = Field(
        None,
        description='Configuration for Sink Component in the OpenMetadata Ingestion Framework.',
    )
    supportsDataInsightExtraction: Optional[
        connectionBasicType.SupportsDataInsightExtraction
    ] = None
    supportsElasticSearchReindexingExtraction: Optional[
        connectionBasicType.SupportsElasticSearchReindexingExtraction
    ] = None
