# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class EmploymentStatus(str, enum.Enum):
    UNEMPLOYED = "UNEMPLOYED"
    EMPLOYED = "EMPLOYED"
    SELF_EMPLOYED = "SELF_EMPLOYED"
    STUDENT = "STUDENT"
    FULL_TIME = "FULL_TIME"
    PART_TIME = "PART_TIME"
    SOLE_PROPRIETOR = "SOLE_PROPRIETOR"
    PENSIONER = "PENSIONER"
    COMPANY_OWNER = "COMPANY_OWNER"

    def visit(
        self,
        unemployed: typing.Callable[[], T_Result],
        employed: typing.Callable[[], T_Result],
        self_employed: typing.Callable[[], T_Result],
        student: typing.Callable[[], T_Result],
        full_time: typing.Callable[[], T_Result],
        part_time: typing.Callable[[], T_Result],
        sole_proprietor: typing.Callable[[], T_Result],
        pensioner: typing.Callable[[], T_Result],
        company_owner: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is EmploymentStatus.UNEMPLOYED:
            return unemployed()
        if self is EmploymentStatus.EMPLOYED:
            return employed()
        if self is EmploymentStatus.SELF_EMPLOYED:
            return self_employed()
        if self is EmploymentStatus.STUDENT:
            return student()
        if self is EmploymentStatus.FULL_TIME:
            return full_time()
        if self is EmploymentStatus.PART_TIME:
            return part_time()
        if self is EmploymentStatus.SOLE_PROPRIETOR:
            return sole_proprietor()
        if self is EmploymentStatus.PENSIONER:
            return pensioner()
        if self is EmploymentStatus.COMPANY_OWNER:
            return company_owner()
