import { CfnElement } from './cfn-element';
import { Construct } from './construct';
export interface CfnOutputProps {
    /**
     * A String type that describes the output value.
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     */
    readonly description?: string;
    /**
     * The value of the property returned by the aws cloudformation describe-stacks command.
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     */
    readonly value: string;
    /**
     * The name used to export the value of this output across stacks.
     *
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     *
     * @default - the output is not exported
     */
    readonly exportName?: string;
    /**
     * A condition to associate with this output value. If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     */
    readonly condition?: CfnCondition;
}
export declare class CfnOutput extends CfnElement {
    private readonly _description?;
    private readonly _condition?;
    private readonly _value?;
    private readonly _export?;
    /**
     * Creates an CfnOutput value for this stack.
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     */
    constructor(scope: Construct, id: string, props: CfnOutputProps);
}
import { CfnCondition } from './cfn-condition';
