"use strict";
const cxapi = require("@aws-cdk/cx-api");
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'addFileAsset correctly sets metadata and creates S3 parameters'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        stack.addFileAsset({
            fileName: 'file-name',
            packaging: lib_1.FileAssetPackaging.ZIP_DIRECTORY,
            sourceHash: 'source-hash'
        });
        // THEN
        const assetMetadata = stack.node.metadata.find(({ type }) => type === cxapi.ASSET_METADATA);
        test.equal(assetMetadata && assetMetadata.data.path, 'file-name');
        test.equal(assetMetadata && assetMetadata.data.id, 'source-hash');
        test.equal(assetMetadata && assetMetadata.data.packaging, lib_1.FileAssetPackaging.ZIP_DIRECTORY);
        test.equal(assetMetadata && assetMetadata.data.sourceHash, 'source-hash');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                AssetParameterssourcehashS3BucketE6E91E3E: {
                    Type: 'String',
                    Description: 'S3 bucket for asset "source-hash"'
                },
                AssetParameterssourcehashS3VersionKeyAC4157C3: {
                    Type: 'String',
                    Description: 'S3 key for asset version "source-hash"'
                },
                AssetParameterssourcehashArtifactHashADBAE418: {
                    Type: 'String',
                    Description: 'Artifact hash for asset "source-hash"'
                }
            }
        });
        test.done();
    },
    'addDockerImageAsset correctly sets metadata and creates an ECR parameter'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        // WHEN
        stack.addDockerImageAsset({
            sourceHash: 'source-hash',
            directoryName: 'directory-name',
            repositoryName: 'repository-name'
        });
        // THEN
        const assetMetadata = stack.node.metadata.find(({ type }) => type === cxapi.ASSET_METADATA);
        test.equal(assetMetadata && assetMetadata.data.packaging, 'container-image');
        test.equal(assetMetadata && assetMetadata.data.path, 'directory-name');
        test.equal(assetMetadata && assetMetadata.data.sourceHash, 'source-hash');
        test.equal(assetMetadata && assetMetadata.data.repositoryName, 'repository-name');
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: {
                AssetParameterssourcehashImageName3B572B12: {
                    Type: 'String',
                    Description: 'ECR repository name and tag for asset "source-hash"'
                }
            }
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5hc3NldHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LmFzc2V0cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEseUNBQXlDO0FBRXpDLGdDQUFtRDtBQUNuRCxpQ0FBMEM7QUFFMUMsaUJBQVM7SUFDUCxnRUFBZ0UsQ0FBQyxJQUFVO1FBQ3pFLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssRUFBRSxDQUFDO1FBRTFCLE9BQU87UUFDUCxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQ2pCLFFBQVEsRUFBRSxXQUFXO1lBQ3JCLFNBQVMsRUFBRSx3QkFBa0IsQ0FBQyxhQUFhO1lBQzNDLFVBQVUsRUFBRSxhQUFhO1NBQzFCLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxNQUFNLGFBQWEsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQyxJQUFJLEtBQUssS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBRTVGLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ2xFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLHdCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQzVGLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBRTFFLElBQUksQ0FBQyxTQUFTLENBQUMsdUJBQWdCLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDdEMsVUFBVSxFQUFFO2dCQUNWLHlDQUF5QyxFQUFFO29CQUN6QyxJQUFJLEVBQUUsUUFBUTtvQkFDZCxXQUFXLEVBQUUsbUNBQW1DO2lCQUNqRDtnQkFDRCw2Q0FBNkMsRUFBRTtvQkFDN0MsSUFBSSxFQUFFLFFBQVE7b0JBQ2QsV0FBVyxFQUFFLHdDQUF3QztpQkFDdEQ7Z0JBQ0QsNkNBQTZDLEVBQUU7b0JBQzdDLElBQUksRUFBRSxRQUFRO29CQUNkLFdBQVcsRUFBRSx1Q0FBdUM7aUJBQ3JEO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFFZCxDQUFDO0lBRUQsMEVBQTBFLENBQUMsSUFBVTtRQUNuRixRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFLLEVBQUUsQ0FBQztRQUUxQixPQUFPO1FBQ1AsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1lBQ3hCLFVBQVUsRUFBRSxhQUFhO1lBQ3pCLGFBQWEsRUFBRSxnQkFBZ0I7WUFDL0IsY0FBYyxFQUFFLGlCQUFpQjtTQUNsQyxDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsRUFBRSxFQUFFLENBQUMsSUFBSSxLQUFLLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUU1RixJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsSUFBSSxhQUFhLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBQzdFLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxJQUFJLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsYUFBYSxDQUFDLENBQUM7UUFDMUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUksYUFBYSxDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztRQUVsRixJQUFJLENBQUMsU0FBUyxDQUFDLHVCQUFnQixDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3RDLFVBQVUsRUFBRTtnQkFDViwwQ0FBMEMsRUFBRTtvQkFDMUMsSUFBSSxFQUFFLFFBQVE7b0JBQ2QsV0FBVyxFQUFFLHFEQUFxRDtpQkFDbkU7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3hhcGkgZnJvbSAnQGF3cy1jZGsvY3gtYXBpJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBGaWxlQXNzZXRQYWNrYWdpbmcsIFN0YWNrIH0gZnJvbSAnLi4vbGliJztcbmltcG9ydCB7IHRvQ2xvdWRGb3JtYXRpb24gfSBmcm9tICcuL3V0aWwnO1xuXG5leHBvcnQgPSB7XG4gICdhZGRGaWxlQXNzZXQgY29ycmVjdGx5IHNldHMgbWV0YWRhdGEgYW5kIGNyZWF0ZXMgUzMgcGFyYW1ldGVycycodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBzdGFjay5hZGRGaWxlQXNzZXQoe1xuICAgICAgZmlsZU5hbWU6ICdmaWxlLW5hbWUnLFxuICAgICAgcGFja2FnaW5nOiBGaWxlQXNzZXRQYWNrYWdpbmcuWklQX0RJUkVDVE9SWSxcbiAgICAgIHNvdXJjZUhhc2g6ICdzb3VyY2UtaGFzaCdcbiAgICB9KTtcblxuICAgIC8vIFRIRU5cbiAgICBjb25zdCBhc3NldE1ldGFkYXRhID0gc3RhY2subm9kZS5tZXRhZGF0YS5maW5kKCh7IHR5cGUgfSkgPT4gdHlwZSA9PT0gY3hhcGkuQVNTRVRfTUVUQURBVEEpO1xuXG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5wYXRoLCAnZmlsZS1uYW1lJyk7XG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5pZCwgJ3NvdXJjZS1oYXNoJyk7XG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5wYWNrYWdpbmcsIEZpbGVBc3NldFBhY2thZ2luZy5aSVBfRElSRUNUT1JZKTtcbiAgICB0ZXN0LmVxdWFsKGFzc2V0TWV0YWRhdGEgJiYgYXNzZXRNZXRhZGF0YS5kYXRhLnNvdXJjZUhhc2gsICdzb3VyY2UtaGFzaCcpO1xuXG4gICAgdGVzdC5kZWVwRXF1YWwodG9DbG91ZEZvcm1hdGlvbihzdGFjayksIHtcbiAgICAgIFBhcmFtZXRlcnM6IHtcbiAgICAgICAgQXNzZXRQYXJhbWV0ZXJzc291cmNlaGFzaFMzQnVja2V0RTZFOTFFM0U6IHtcbiAgICAgICAgICBUeXBlOiAnU3RyaW5nJyxcbiAgICAgICAgICBEZXNjcmlwdGlvbjogJ1MzIGJ1Y2tldCBmb3IgYXNzZXQgXCJzb3VyY2UtaGFzaFwiJ1xuICAgICAgICB9LFxuICAgICAgICBBc3NldFBhcmFtZXRlcnNzb3VyY2VoYXNoUzNWZXJzaW9uS2V5QUM0MTU3QzM6IHtcbiAgICAgICAgICBUeXBlOiAnU3RyaW5nJyxcbiAgICAgICAgICBEZXNjcmlwdGlvbjogJ1MzIGtleSBmb3IgYXNzZXQgdmVyc2lvbiBcInNvdXJjZS1oYXNoXCInXG4gICAgICAgIH0sXG4gICAgICAgIEFzc2V0UGFyYW1ldGVyc3NvdXJjZWhhc2hBcnRpZmFjdEhhc2hBREJBRTQxODoge1xuICAgICAgICAgIFR5cGU6ICdTdHJpbmcnLFxuICAgICAgICAgIERlc2NyaXB0aW9uOiAnQXJ0aWZhY3QgaGFzaCBmb3IgYXNzZXQgXCJzb3VyY2UtaGFzaFwiJ1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcblxuICB9LFxuXG4gICdhZGREb2NrZXJJbWFnZUFzc2V0IGNvcnJlY3RseSBzZXRzIG1ldGFkYXRhIGFuZCBjcmVhdGVzIGFuIEVDUiBwYXJhbWV0ZXInKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgc3RhY2suYWRkRG9ja2VySW1hZ2VBc3NldCh7XG4gICAgICBzb3VyY2VIYXNoOiAnc291cmNlLWhhc2gnLFxuICAgICAgZGlyZWN0b3J5TmFtZTogJ2RpcmVjdG9yeS1uYW1lJyxcbiAgICAgIHJlcG9zaXRvcnlOYW1lOiAncmVwb3NpdG9yeS1uYW1lJ1xuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGNvbnN0IGFzc2V0TWV0YWRhdGEgPSBzdGFjay5ub2RlLm1ldGFkYXRhLmZpbmQoKHsgdHlwZSB9KSA9PiB0eXBlID09PSBjeGFwaS5BU1NFVF9NRVRBREFUQSk7XG5cbiAgICB0ZXN0LmVxdWFsKGFzc2V0TWV0YWRhdGEgJiYgYXNzZXRNZXRhZGF0YS5kYXRhLnBhY2thZ2luZywgJ2NvbnRhaW5lci1pbWFnZScpO1xuICAgIHRlc3QuZXF1YWwoYXNzZXRNZXRhZGF0YSAmJiBhc3NldE1ldGFkYXRhLmRhdGEucGF0aCwgJ2RpcmVjdG9yeS1uYW1lJyk7XG4gICAgdGVzdC5lcXVhbChhc3NldE1ldGFkYXRhICYmIGFzc2V0TWV0YWRhdGEuZGF0YS5zb3VyY2VIYXNoLCAnc291cmNlLWhhc2gnKTtcbiAgICB0ZXN0LmVxdWFsKGFzc2V0TWV0YWRhdGEgJiYgYXNzZXRNZXRhZGF0YS5kYXRhLnJlcG9zaXRvcnlOYW1lLCAncmVwb3NpdG9yeS1uYW1lJyk7XG5cbiAgICB0ZXN0LmRlZXBFcXVhbCh0b0Nsb3VkRm9ybWF0aW9uKHN0YWNrKSwge1xuICAgICAgUGFyYW1ldGVyczoge1xuICAgICAgICBBc3NldFBhcmFtZXRlcnNzb3VyY2VoYXNoSW1hZ2VOYW1lM0I1NzJCMTI6IHtcbiAgICAgICAgICBUeXBlOiAnU3RyaW5nJyxcbiAgICAgICAgICBEZXNjcmlwdGlvbjogJ0VDUiByZXBvc2l0b3J5IG5hbWUgYW5kIHRhZyBmb3IgYXNzZXQgXCJzb3VyY2UtaGFzaFwiJ1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcbn07XG4iXX0=