"""
################# WARNING #####################################################
This file is only to be used during a run of tests/regenerate_test_bobfiles.sh.
It should not be ran during normal testing.
###############################################################################
"""

from time import sleep

import pytest
from fixtures.mocked_panda import (
    BOBFILE_DIR,
    TEST_PREFIX,
    ResponseHandler,
    create_subprocess_ioc_and_responses,
)


@pytest.fixture
def mocked_panda_generate_new_bobfiles(
    standard_responses,
    caplog,
    caplog_workaround,
    table_field_info,
    table_fields,
):
    response_handler = ResponseHandler(standard_responses)

    yield from create_subprocess_ioc_and_responses(
        response_handler,
        BOBFILE_DIR,
        TEST_PREFIX,
        caplog,
        caplog_workaround,
        table_field_info,
        table_fields,
        clear_bobfiles=True,
    )


def test_regenerate_test_bobfiles(mocked_panda_generate_new_bobfiles):
    """
    Regenerates test-bobfiles. This isn't really a test.
    Test bobfiles are generated by the mocked panda fixture
    and unfortunately the option to call fixtures directly
    has been removed. This means that to automatically regenerate test-bobfiles
    we need to run this in pytest.
    """
    sleep(1)
