/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AiServicesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#custom_subdomain_name AiServices#custom_subdomain_name}
    */
    readonly customSubdomainName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#fqdns AiServices#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#id AiServices#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#local_authentication_enabled AiServices#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#location AiServices#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#name AiServices#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#outbound_network_access_restricted AiServices#outbound_network_access_restricted}
    */
    readonly outboundNetworkAccessRestricted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#public_network_access AiServices#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#resource_group_name AiServices#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#sku_name AiServices#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#tags AiServices#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * customer_managed_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#customer_managed_key AiServices#customer_managed_key}
    */
    readonly customerManagedKey?: AiServicesCustomerManagedKey;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#identity AiServices#identity}
    */
    readonly identity?: AiServicesIdentity;
    /**
    * network_acls block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#network_acls AiServices#network_acls}
    */
    readonly networkAcls?: AiServicesNetworkAcls;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#storage AiServices#storage}
    */
    readonly storage?: AiServicesStorage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#timeouts AiServices#timeouts}
    */
    readonly timeouts?: AiServicesTimeouts;
}
export interface AiServicesCustomerManagedKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#identity_client_id AiServices#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#key_vault_key_id AiServices#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#managed_hsm_key_id AiServices#managed_hsm_key_id}
    */
    readonly managedHsmKeyId?: string;
}
export declare function aiServicesCustomerManagedKeyToTerraform(struct?: AiServicesCustomerManagedKeyOutputReference | AiServicesCustomerManagedKey): any;
export declare function aiServicesCustomerManagedKeyToHclTerraform(struct?: AiServicesCustomerManagedKeyOutputReference | AiServicesCustomerManagedKey): any;
export declare class AiServicesCustomerManagedKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiServicesCustomerManagedKey | undefined;
    set internalValue(value: AiServicesCustomerManagedKey | undefined);
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
    private _managedHsmKeyId?;
    get managedHsmKeyId(): string;
    set managedHsmKeyId(value: string);
    resetManagedHsmKeyId(): void;
    get managedHsmKeyIdInput(): string | undefined;
}
export interface AiServicesIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#identity_ids AiServices#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#type AiServices#type}
    */
    readonly type: string;
}
export declare function aiServicesIdentityToTerraform(struct?: AiServicesIdentityOutputReference | AiServicesIdentity): any;
export declare function aiServicesIdentityToHclTerraform(struct?: AiServicesIdentityOutputReference | AiServicesIdentity): any;
export declare class AiServicesIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiServicesIdentity | undefined;
    set internalValue(value: AiServicesIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AiServicesNetworkAclsVirtualNetworkRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#ignore_missing_vnet_service_endpoint AiServices#ignore_missing_vnet_service_endpoint}
    */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#subnet_id AiServices#subnet_id}
    */
    readonly subnetId: string;
}
export declare function aiServicesNetworkAclsVirtualNetworkRulesToTerraform(struct?: AiServicesNetworkAclsVirtualNetworkRules | cdktf.IResolvable): any;
export declare function aiServicesNetworkAclsVirtualNetworkRulesToHclTerraform(struct?: AiServicesNetworkAclsVirtualNetworkRules | cdktf.IResolvable): any;
export declare class AiServicesNetworkAclsVirtualNetworkRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AiServicesNetworkAclsVirtualNetworkRules | cdktf.IResolvable | undefined;
    set internalValue(value: AiServicesNetworkAclsVirtualNetworkRules | cdktf.IResolvable | undefined);
    private _ignoreMissingVnetServiceEndpoint?;
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    resetIgnoreMissingVnetServiceEndpoint(): void;
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class AiServicesNetworkAclsVirtualNetworkRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AiServicesNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AiServicesNetworkAclsVirtualNetworkRulesOutputReference;
}
export interface AiServicesNetworkAcls {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#default_action AiServices#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#ip_rules AiServices#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * virtual_network_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#virtual_network_rules AiServices#virtual_network_rules}
    */
    readonly virtualNetworkRules?: AiServicesNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable;
}
export declare function aiServicesNetworkAclsToTerraform(struct?: AiServicesNetworkAclsOutputReference | AiServicesNetworkAcls): any;
export declare function aiServicesNetworkAclsToHclTerraform(struct?: AiServicesNetworkAclsOutputReference | AiServicesNetworkAcls): any;
export declare class AiServicesNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiServicesNetworkAcls | undefined;
    set internalValue(value: AiServicesNetworkAcls | undefined);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkRules;
    get virtualNetworkRules(): AiServicesNetworkAclsVirtualNetworkRulesList;
    putVirtualNetworkRules(value: AiServicesNetworkAclsVirtualNetworkRules[] | cdktf.IResolvable): void;
    resetVirtualNetworkRules(): void;
    get virtualNetworkRulesInput(): cdktf.IResolvable | AiServicesNetworkAclsVirtualNetworkRules[] | undefined;
}
export interface AiServicesStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#identity_client_id AiServices#identity_client_id}
    */
    readonly identityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#storage_account_id AiServices#storage_account_id}
    */
    readonly storageAccountId: string;
}
export declare function aiServicesStorageToTerraform(struct?: AiServicesStorage | cdktf.IResolvable): any;
export declare function aiServicesStorageToHclTerraform(struct?: AiServicesStorage | cdktf.IResolvable): any;
export declare class AiServicesStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AiServicesStorage | cdktf.IResolvable | undefined;
    set internalValue(value: AiServicesStorage | cdktf.IResolvable | undefined);
    private _identityClientId?;
    get identityClientId(): string;
    set identityClientId(value: string);
    resetIdentityClientId(): void;
    get identityClientIdInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
}
export declare class AiServicesStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AiServicesStorage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AiServicesStorageOutputReference;
}
export interface AiServicesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#create AiServices#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#delete AiServices#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#read AiServices#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#update AiServices#update}
    */
    readonly update?: string;
}
export declare function aiServicesTimeoutsToTerraform(struct?: AiServicesTimeouts | cdktf.IResolvable): any;
export declare function aiServicesTimeoutsToHclTerraform(struct?: AiServicesTimeouts | cdktf.IResolvable): any;
export declare class AiServicesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiServicesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AiServicesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services azurerm_ai_services}
*/
export declare class AiServices extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_ai_services";
    /**
    * Generates CDKTF code for importing a AiServices resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AiServices to import
    * @param importFromId The id of the existing AiServices that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AiServices to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/ai_services azurerm_ai_services} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AiServicesConfig
    */
    constructor(scope: Construct, id: string, config: AiServicesConfig);
    private _customSubdomainName?;
    get customSubdomainName(): string;
    set customSubdomainName(value: string);
    resetCustomSubdomainName(): void;
    get customSubdomainNameInput(): string | undefined;
    get endpoint(): string;
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outboundNetworkAccessRestricted?;
    get outboundNetworkAccessRestricted(): boolean | cdktf.IResolvable;
    set outboundNetworkAccessRestricted(value: boolean | cdktf.IResolvable);
    resetOutboundNetworkAccessRestricted(): void;
    get outboundNetworkAccessRestrictedInput(): boolean | cdktf.IResolvable | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customerManagedKey;
    get customerManagedKey(): AiServicesCustomerManagedKeyOutputReference;
    putCustomerManagedKey(value: AiServicesCustomerManagedKey): void;
    resetCustomerManagedKey(): void;
    get customerManagedKeyInput(): AiServicesCustomerManagedKey | undefined;
    private _identity;
    get identity(): AiServicesIdentityOutputReference;
    putIdentity(value: AiServicesIdentity): void;
    resetIdentity(): void;
    get identityInput(): AiServicesIdentity | undefined;
    private _networkAcls;
    get networkAcls(): AiServicesNetworkAclsOutputReference;
    putNetworkAcls(value: AiServicesNetworkAcls): void;
    resetNetworkAcls(): void;
    get networkAclsInput(): AiServicesNetworkAcls | undefined;
    private _storage;
    get storage(): AiServicesStorageList;
    putStorage(value: AiServicesStorage[] | cdktf.IResolvable): void;
    resetStorage(): void;
    get storageInput(): cdktf.IResolvable | AiServicesStorage[] | undefined;
    private _timeouts;
    get timeouts(): AiServicesTimeoutsOutputReference;
    putTimeouts(value: AiServicesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AiServicesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
