/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceCertificateOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#auto_renew AppServiceCertificateOrder#auto_renew}
    */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#csr AppServiceCertificateOrder#csr}
    */
    readonly csr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#distinguished_name AppServiceCertificateOrder#distinguished_name}
    */
    readonly distinguishedName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#id AppServiceCertificateOrder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#key_size AppServiceCertificateOrder#key_size}
    */
    readonly keySize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#location AppServiceCertificateOrder#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#name AppServiceCertificateOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#product_type AppServiceCertificateOrder#product_type}
    */
    readonly productType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#resource_group_name AppServiceCertificateOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#tags AppServiceCertificateOrder#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#validity_in_years AppServiceCertificateOrder#validity_in_years}
    */
    readonly validityInYears?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#timeouts AppServiceCertificateOrder#timeouts}
    */
    readonly timeouts?: AppServiceCertificateOrderTimeouts;
}
export interface AppServiceCertificateOrderCertificates {
}
export declare function appServiceCertificateOrderCertificatesToTerraform(struct?: AppServiceCertificateOrderCertificates): any;
export declare function appServiceCertificateOrderCertificatesToHclTerraform(struct?: AppServiceCertificateOrderCertificates): any;
export declare class AppServiceCertificateOrderCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppServiceCertificateOrderCertificates | undefined;
    set internalValue(value: AppServiceCertificateOrderCertificates | undefined);
    get certificateName(): string;
    get keyVaultId(): string;
    get keyVaultSecretName(): string;
    get provisioningState(): string;
}
export declare class AppServiceCertificateOrderCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppServiceCertificateOrderCertificatesOutputReference;
}
export interface AppServiceCertificateOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#create AppServiceCertificateOrder#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#delete AppServiceCertificateOrder#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#read AppServiceCertificateOrder#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#update AppServiceCertificateOrder#update}
    */
    readonly update?: string;
}
export declare function appServiceCertificateOrderTimeoutsToTerraform(struct?: AppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare function appServiceCertificateOrderTimeoutsToHclTerraform(struct?: AppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare class AppServiceCertificateOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceCertificateOrderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceCertificateOrderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order azurerm_app_service_certificate_order}
*/
export declare class AppServiceCertificateOrder extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_certificate_order";
    /**
    * Generates CDKTF code for importing a AppServiceCertificateOrder resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceCertificateOrder to import
    * @param importFromId The id of the existing AppServiceCertificateOrder that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceCertificateOrder to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/app_service_certificate_order azurerm_app_service_certificate_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceCertificateOrderConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceCertificateOrderConfig);
    get appServiceCertificateNotRenewableReasons(): string[];
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    resetAutoRenew(): void;
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _certificates;
    get certificates(): AppServiceCertificateOrderCertificatesList;
    private _csr?;
    get csr(): string;
    set csr(value: string);
    resetCsr(): void;
    get csrInput(): string | undefined;
    private _distinguishedName?;
    get distinguishedName(): string;
    set distinguishedName(value: string);
    resetDistinguishedName(): void;
    get distinguishedNameInput(): string | undefined;
    get domainVerificationToken(): string;
    get expirationTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get intermediateThumbprint(): string;
    get isPrivateKeyExternal(): cdktf.IResolvable;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _productType?;
    get productType(): string;
    set productType(value: string);
    resetProductType(): void;
    get productTypeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get rootThumbprint(): string;
    get signedCertificateThumbprint(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _validityInYears?;
    get validityInYears(): number;
    set validityInYears(value: number);
    resetValidityInYears(): void;
    get validityInYearsInput(): number | undefined;
    private _timeouts;
    get timeouts(): AppServiceCertificateOrderTimeoutsOutputReference;
    putTimeouts(value: AppServiceCertificateOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceCertificateOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
