/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationSourceControlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#automatic_sync AutomationSourceControl#automatic_sync}
    */
    readonly automaticSync?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#automation_account_id AutomationSourceControl#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#branch AutomationSourceControl#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#description AutomationSourceControl#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#folder_path AutomationSourceControl#folder_path}
    */
    readonly folderPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#id AutomationSourceControl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#name AutomationSourceControl#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#publish_runbook_enabled AutomationSourceControl#publish_runbook_enabled}
    */
    readonly publishRunbookEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#repository_url AutomationSourceControl#repository_url}
    */
    readonly repositoryUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#source_control_type AutomationSourceControl#source_control_type}
    */
    readonly sourceControlType: string;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#security AutomationSourceControl#security}
    */
    readonly security: AutomationSourceControlSecurity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#timeouts AutomationSourceControl#timeouts}
    */
    readonly timeouts?: AutomationSourceControlTimeouts;
}
export interface AutomationSourceControlSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#refresh_token AutomationSourceControl#refresh_token}
    */
    readonly refreshToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#token AutomationSourceControl#token}
    */
    readonly token: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#token_type AutomationSourceControl#token_type}
    */
    readonly tokenType: string;
}
export declare function automationSourceControlSecurityToTerraform(struct?: AutomationSourceControlSecurityOutputReference | AutomationSourceControlSecurity): any;
export declare function automationSourceControlSecurityToHclTerraform(struct?: AutomationSourceControlSecurityOutputReference | AutomationSourceControlSecurity): any;
export declare class AutomationSourceControlSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSourceControlSecurity | undefined;
    set internalValue(value: AutomationSourceControlSecurity | undefined);
    private _refreshToken?;
    get refreshToken(): string;
    set refreshToken(value: string);
    resetRefreshToken(): void;
    get refreshTokenInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    get tokenInput(): string | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    get tokenTypeInput(): string | undefined;
}
export interface AutomationSourceControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#create AutomationSourceControl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#delete AutomationSourceControl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#read AutomationSourceControl#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#update AutomationSourceControl#update}
    */
    readonly update?: string;
}
export declare function automationSourceControlTimeoutsToTerraform(struct?: AutomationSourceControlTimeouts | cdktf.IResolvable): any;
export declare function automationSourceControlTimeoutsToHclTerraform(struct?: AutomationSourceControlTimeouts | cdktf.IResolvable): any;
export declare class AutomationSourceControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationSourceControlTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationSourceControlTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control azurerm_automation_source_control}
*/
export declare class AutomationSourceControl extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_source_control";
    /**
    * Generates CDKTF code for importing a AutomationSourceControl resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationSourceControl to import
    * @param importFromId The id of the existing AutomationSourceControl that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationSourceControl to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/automation_source_control azurerm_automation_source_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationSourceControlConfig
    */
    constructor(scope: Construct, id: string, config: AutomationSourceControlConfig);
    private _automaticSync?;
    get automaticSync(): boolean | cdktf.IResolvable;
    set automaticSync(value: boolean | cdktf.IResolvable);
    resetAutomaticSync(): void;
    get automaticSyncInput(): boolean | cdktf.IResolvable | undefined;
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folderPath?;
    get folderPath(): string;
    set folderPath(value: string);
    get folderPathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publishRunbookEnabled?;
    get publishRunbookEnabled(): boolean | cdktf.IResolvable;
    set publishRunbookEnabled(value: boolean | cdktf.IResolvable);
    resetPublishRunbookEnabled(): void;
    get publishRunbookEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _repositoryUrl?;
    get repositoryUrl(): string;
    set repositoryUrl(value: string);
    get repositoryUrlInput(): string | undefined;
    private _sourceControlType?;
    get sourceControlType(): string;
    set sourceControlType(value: string);
    get sourceControlTypeInput(): string | undefined;
    private _security;
    get security(): AutomationSourceControlSecurityOutputReference;
    putSecurity(value: AutomationSourceControlSecurity): void;
    get securityInput(): AutomationSourceControlSecurity | undefined;
    private _timeouts;
    get timeouts(): AutomationSourceControlTimeoutsOutputReference;
    putTimeouts(value: AutomationSourceControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationSourceControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
