/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#developer_app_insights_api_key BotWebApp#developer_app_insights_api_key}
    */
    readonly developerAppInsightsApiKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#developer_app_insights_application_id BotWebApp#developer_app_insights_application_id}
    */
    readonly developerAppInsightsApplicationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#developer_app_insights_key BotWebApp#developer_app_insights_key}
    */
    readonly developerAppInsightsKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#display_name BotWebApp#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#endpoint BotWebApp#endpoint}
    */
    readonly endpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#id BotWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#location BotWebApp#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#luis_app_ids BotWebApp#luis_app_ids}
    */
    readonly luisAppIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#luis_key BotWebApp#luis_key}
    */
    readonly luisKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#microsoft_app_id BotWebApp#microsoft_app_id}
    */
    readonly microsoftAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#name BotWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#resource_group_name BotWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#sku BotWebApp#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#tags BotWebApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#timeouts BotWebApp#timeouts}
    */
    readonly timeouts?: BotWebAppTimeouts;
}
export interface BotWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#create BotWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#delete BotWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#read BotWebApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#update BotWebApp#update}
    */
    readonly update?: string;
}
export declare function botWebAppTimeoutsToTerraform(struct?: BotWebAppTimeouts | cdktf.IResolvable): any;
export declare function botWebAppTimeoutsToHclTerraform(struct?: BotWebAppTimeouts | cdktf.IResolvable): any;
export declare class BotWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BotWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app azurerm_bot_web_app}
*/
export declare class BotWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_web_app";
    /**
    * Generates CDKTF code for importing a BotWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BotWebApp to import
    * @param importFromId The id of the existing BotWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BotWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/bot_web_app azurerm_bot_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotWebAppConfig
    */
    constructor(scope: Construct, id: string, config: BotWebAppConfig);
    private _developerAppInsightsApiKey?;
    get developerAppInsightsApiKey(): string;
    set developerAppInsightsApiKey(value: string);
    resetDeveloperAppInsightsApiKey(): void;
    get developerAppInsightsApiKeyInput(): string | undefined;
    private _developerAppInsightsApplicationId?;
    get developerAppInsightsApplicationId(): string;
    set developerAppInsightsApplicationId(value: string);
    resetDeveloperAppInsightsApplicationId(): void;
    get developerAppInsightsApplicationIdInput(): string | undefined;
    private _developerAppInsightsKey?;
    get developerAppInsightsKey(): string;
    set developerAppInsightsKey(value: string);
    resetDeveloperAppInsightsKey(): void;
    get developerAppInsightsKeyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _endpoint?;
    get endpoint(): string;
    set endpoint(value: string);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _luisAppIds?;
    get luisAppIds(): string[];
    set luisAppIds(value: string[]);
    resetLuisAppIds(): void;
    get luisAppIdsInput(): string[] | undefined;
    private _luisKey?;
    get luisKey(): string;
    set luisKey(value: string);
    resetLuisKey(): void;
    get luisKeyInput(): string | undefined;
    private _microsoftAppId?;
    get microsoftAppId(): string;
    set microsoftAppId(value: string);
    get microsoftAppIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): BotWebAppTimeoutsOutputReference;
    putTimeouts(value: BotWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BotWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
