/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CognitiveAccountRaiPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#base_policy_name CognitiveAccountRaiPolicy#base_policy_name}
    */
    readonly basePolicyName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#cognitive_account_id CognitiveAccountRaiPolicy#cognitive_account_id}
    */
    readonly cognitiveAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#id CognitiveAccountRaiPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#mode CognitiveAccountRaiPolicy#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#name CognitiveAccountRaiPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#tags CognitiveAccountRaiPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * content_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#content_filter CognitiveAccountRaiPolicy#content_filter}
    */
    readonly contentFilter: CognitiveAccountRaiPolicyContentFilter[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#timeouts CognitiveAccountRaiPolicy#timeouts}
    */
    readonly timeouts?: CognitiveAccountRaiPolicyTimeouts;
}
export interface CognitiveAccountRaiPolicyContentFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#block_enabled CognitiveAccountRaiPolicy#block_enabled}
    */
    readonly blockEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#filter_enabled CognitiveAccountRaiPolicy#filter_enabled}
    */
    readonly filterEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#name CognitiveAccountRaiPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#severity_threshold CognitiveAccountRaiPolicy#severity_threshold}
    */
    readonly severityThreshold: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#source CognitiveAccountRaiPolicy#source}
    */
    readonly source: string;
}
export declare function cognitiveAccountRaiPolicyContentFilterToTerraform(struct?: CognitiveAccountRaiPolicyContentFilter | cdktf.IResolvable): any;
export declare function cognitiveAccountRaiPolicyContentFilterToHclTerraform(struct?: CognitiveAccountRaiPolicyContentFilter | cdktf.IResolvable): any;
export declare class CognitiveAccountRaiPolicyContentFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CognitiveAccountRaiPolicyContentFilter | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountRaiPolicyContentFilter | cdktf.IResolvable | undefined);
    private _blockEnabled?;
    get blockEnabled(): boolean | cdktf.IResolvable;
    set blockEnabled(value: boolean | cdktf.IResolvable);
    get blockEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filterEnabled?;
    get filterEnabled(): boolean | cdktf.IResolvable;
    set filterEnabled(value: boolean | cdktf.IResolvable);
    get filterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _severityThreshold?;
    get severityThreshold(): string;
    set severityThreshold(value: string);
    get severityThresholdInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export declare class CognitiveAccountRaiPolicyContentFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CognitiveAccountRaiPolicyContentFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CognitiveAccountRaiPolicyContentFilterOutputReference;
}
export interface CognitiveAccountRaiPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#create CognitiveAccountRaiPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#delete CognitiveAccountRaiPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#read CognitiveAccountRaiPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#update CognitiveAccountRaiPolicy#update}
    */
    readonly update?: string;
}
export declare function cognitiveAccountRaiPolicyTimeoutsToTerraform(struct?: CognitiveAccountRaiPolicyTimeouts | cdktf.IResolvable): any;
export declare function cognitiveAccountRaiPolicyTimeoutsToHclTerraform(struct?: CognitiveAccountRaiPolicyTimeouts | cdktf.IResolvable): any;
export declare class CognitiveAccountRaiPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CognitiveAccountRaiPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CognitiveAccountRaiPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy azurerm_cognitive_account_rai_policy}
*/
export declare class CognitiveAccountRaiPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cognitive_account_rai_policy";
    /**
    * Generates CDKTF code for importing a CognitiveAccountRaiPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CognitiveAccountRaiPolicy to import
    * @param importFromId The id of the existing CognitiveAccountRaiPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CognitiveAccountRaiPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/cognitive_account_rai_policy azurerm_cognitive_account_rai_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CognitiveAccountRaiPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CognitiveAccountRaiPolicyConfig);
    private _basePolicyName?;
    get basePolicyName(): string;
    set basePolicyName(value: string);
    get basePolicyNameInput(): string | undefined;
    private _cognitiveAccountId?;
    get cognitiveAccountId(): string;
    set cognitiveAccountId(value: string);
    get cognitiveAccountIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _contentFilter;
    get contentFilter(): CognitiveAccountRaiPolicyContentFilterList;
    putContentFilter(value: CognitiveAccountRaiPolicyContentFilter[] | cdktf.IResolvable): void;
    get contentFilterInput(): cdktf.IResolvable | CognitiveAccountRaiPolicyContentFilter[] | undefined;
    private _timeouts;
    get timeouts(): CognitiveAccountRaiPolicyTimeoutsOutputReference;
    putTimeouts(value: CognitiveAccountRaiPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CognitiveAccountRaiPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
