/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CommunicationServiceEmailDomainAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#communication_service_id CommunicationServiceEmailDomainAssociation#communication_service_id}
    */
    readonly communicationServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#email_service_domain_id CommunicationServiceEmailDomainAssociation#email_service_domain_id}
    */
    readonly emailServiceDomainId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#id CommunicationServiceEmailDomainAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#timeouts CommunicationServiceEmailDomainAssociation#timeouts}
    */
    readonly timeouts?: CommunicationServiceEmailDomainAssociationTimeouts;
}
export interface CommunicationServiceEmailDomainAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#create CommunicationServiceEmailDomainAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#delete CommunicationServiceEmailDomainAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#read CommunicationServiceEmailDomainAssociation#read}
    */
    readonly read?: string;
}
export declare function communicationServiceEmailDomainAssociationTimeoutsToTerraform(struct?: CommunicationServiceEmailDomainAssociationTimeouts | cdktf.IResolvable): any;
export declare function communicationServiceEmailDomainAssociationTimeoutsToHclTerraform(struct?: CommunicationServiceEmailDomainAssociationTimeouts | cdktf.IResolvable): any;
export declare class CommunicationServiceEmailDomainAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CommunicationServiceEmailDomainAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CommunicationServiceEmailDomainAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association azurerm_communication_service_email_domain_association}
*/
export declare class CommunicationServiceEmailDomainAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_communication_service_email_domain_association";
    /**
    * Generates CDKTF code for importing a CommunicationServiceEmailDomainAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CommunicationServiceEmailDomainAssociation to import
    * @param importFromId The id of the existing CommunicationServiceEmailDomainAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CommunicationServiceEmailDomainAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/communication_service_email_domain_association azurerm_communication_service_email_domain_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CommunicationServiceEmailDomainAssociationConfig
    */
    constructor(scope: Construct, id: string, config: CommunicationServiceEmailDomainAssociationConfig);
    private _communicationServiceId?;
    get communicationServiceId(): string;
    set communicationServiceId(value: string);
    get communicationServiceIdInput(): string | undefined;
    private _emailServiceDomainId?;
    get emailServiceDomainId(): string;
    set emailServiceDomainId(value: string);
    get emailServiceDomainIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): CommunicationServiceEmailDomainAssociationTimeoutsOutputReference;
    putTimeouts(value: CommunicationServiceEmailDomainAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CommunicationServiceEmailDomainAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
