/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApplicationGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#id DataAzurermApplicationGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#name DataAzurermApplicationGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#resource_group_name DataAzurermApplicationGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#timeouts DataAzurermApplicationGateway#timeouts}
    */
    readonly timeouts?: DataAzurermApplicationGatewayTimeouts;
}
export interface DataAzurermApplicationGatewayAuthenticationCertificate {
}
export declare function dataAzurermApplicationGatewayAuthenticationCertificateToTerraform(struct?: DataAzurermApplicationGatewayAuthenticationCertificate): any;
export declare function dataAzurermApplicationGatewayAuthenticationCertificateToHclTerraform(struct?: DataAzurermApplicationGatewayAuthenticationCertificate): any;
export declare class DataAzurermApplicationGatewayAuthenticationCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayAuthenticationCertificate | undefined;
    set internalValue(value: DataAzurermApplicationGatewayAuthenticationCertificate | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayAuthenticationCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayAuthenticationCertificateOutputReference;
}
export interface DataAzurermApplicationGatewayAutoscaleConfiguration {
}
export declare function dataAzurermApplicationGatewayAutoscaleConfigurationToTerraform(struct?: DataAzurermApplicationGatewayAutoscaleConfiguration): any;
export declare function dataAzurermApplicationGatewayAutoscaleConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayAutoscaleConfiguration): any;
export declare class DataAzurermApplicationGatewayAutoscaleConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayAutoscaleConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayAutoscaleConfiguration | undefined);
    get maxCapacity(): number;
    get minCapacity(): number;
}
export declare class DataAzurermApplicationGatewayAutoscaleConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayAutoscaleConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayBackendAddressPool {
}
export declare function dataAzurermApplicationGatewayBackendAddressPoolToTerraform(struct?: DataAzurermApplicationGatewayBackendAddressPool): any;
export declare function dataAzurermApplicationGatewayBackendAddressPoolToHclTerraform(struct?: DataAzurermApplicationGatewayBackendAddressPool): any;
export declare class DataAzurermApplicationGatewayBackendAddressPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayBackendAddressPool | undefined;
    set internalValue(value: DataAzurermApplicationGatewayBackendAddressPool | undefined);
    get fqdns(): string[];
    get id(): string;
    get ipAddresses(): string[];
    get name(): string;
}
export declare class DataAzurermApplicationGatewayBackendAddressPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayBackendAddressPoolOutputReference;
}
export interface DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificate {
}
export declare function dataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateToTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificate): any;
export declare function dataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateToHclTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificate): any;
export declare class DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificate | undefined;
    set internalValue(value: DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificate | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateOutputReference;
}
export interface DataAzurermApplicationGatewayBackendHttpSettingsConnectionDraining {
}
export declare function dataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingToTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettingsConnectionDraining): any;
export declare function dataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingToHclTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettingsConnectionDraining): any;
export declare class DataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayBackendHttpSettingsConnectionDraining | undefined;
    set internalValue(value: DataAzurermApplicationGatewayBackendHttpSettingsConnectionDraining | undefined);
    get drainTimeoutSec(): number;
    get enabled(): cdktf.IResolvable;
}
export declare class DataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingOutputReference;
}
export interface DataAzurermApplicationGatewayBackendHttpSettings {
}
export declare function dataAzurermApplicationGatewayBackendHttpSettingsToTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettings): any;
export declare function dataAzurermApplicationGatewayBackendHttpSettingsToHclTerraform(struct?: DataAzurermApplicationGatewayBackendHttpSettings): any;
export declare class DataAzurermApplicationGatewayBackendHttpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayBackendHttpSettings | undefined;
    set internalValue(value: DataAzurermApplicationGatewayBackendHttpSettings | undefined);
    get affinityCookieName(): string;
    private _authenticationCertificate;
    get authenticationCertificate(): DataAzurermApplicationGatewayBackendHttpSettingsAuthenticationCertificateList;
    private _connectionDraining;
    get connectionDraining(): DataAzurermApplicationGatewayBackendHttpSettingsConnectionDrainingList;
    get cookieBasedAffinity(): string;
    get hostName(): string;
    get id(): string;
    get name(): string;
    get path(): string;
    get pickHostNameFromBackendAddress(): cdktf.IResolvable;
    get port(): number;
    get probeId(): string;
    get probeName(): string;
    get protocol(): string;
    get requestTimeout(): number;
    get trustedRootCertificateNames(): string[];
}
export declare class DataAzurermApplicationGatewayBackendHttpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayBackendHttpSettingsOutputReference;
}
export interface DataAzurermApplicationGatewayCustomErrorConfiguration {
}
export declare function dataAzurermApplicationGatewayCustomErrorConfigurationToTerraform(struct?: DataAzurermApplicationGatewayCustomErrorConfiguration): any;
export declare function dataAzurermApplicationGatewayCustomErrorConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayCustomErrorConfiguration): any;
export declare class DataAzurermApplicationGatewayCustomErrorConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayCustomErrorConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayCustomErrorConfiguration | undefined);
    get customErrorPageUrl(): string;
    get id(): string;
    get statusCode(): string;
}
export declare class DataAzurermApplicationGatewayCustomErrorConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayCustomErrorConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayFrontendIpConfiguration {
}
export declare function dataAzurermApplicationGatewayFrontendIpConfigurationToTerraform(struct?: DataAzurermApplicationGatewayFrontendIpConfiguration): any;
export declare function dataAzurermApplicationGatewayFrontendIpConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayFrontendIpConfiguration): any;
export declare class DataAzurermApplicationGatewayFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayFrontendIpConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayFrontendIpConfiguration | undefined);
    get id(): string;
    get name(): string;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateLinkConfigurationId(): string;
    get privateLinkConfigurationName(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermApplicationGatewayFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayFrontendIpConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayFrontendPort {
}
export declare function dataAzurermApplicationGatewayFrontendPortToTerraform(struct?: DataAzurermApplicationGatewayFrontendPort): any;
export declare function dataAzurermApplicationGatewayFrontendPortToHclTerraform(struct?: DataAzurermApplicationGatewayFrontendPort): any;
export declare class DataAzurermApplicationGatewayFrontendPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayFrontendPort | undefined;
    set internalValue(value: DataAzurermApplicationGatewayFrontendPort | undefined);
    get id(): string;
    get name(): string;
    get port(): number;
}
export declare class DataAzurermApplicationGatewayFrontendPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayFrontendPortOutputReference;
}
export interface DataAzurermApplicationGatewayGatewayIpConfiguration {
}
export declare function dataAzurermApplicationGatewayGatewayIpConfigurationToTerraform(struct?: DataAzurermApplicationGatewayGatewayIpConfiguration): any;
export declare function dataAzurermApplicationGatewayGatewayIpConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayGatewayIpConfiguration): any;
export declare class DataAzurermApplicationGatewayGatewayIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayGatewayIpConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayGatewayIpConfiguration | undefined);
    get id(): string;
    get name(): string;
    get subnetId(): string;
}
export declare class DataAzurermApplicationGatewayGatewayIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayGatewayIpConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayGlobal {
}
export declare function dataAzurermApplicationGatewayGlobalToTerraform(struct?: DataAzurermApplicationGatewayGlobal): any;
export declare function dataAzurermApplicationGatewayGlobalToHclTerraform(struct?: DataAzurermApplicationGatewayGlobal): any;
export declare class DataAzurermApplicationGatewayGlobalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayGlobal | undefined;
    set internalValue(value: DataAzurermApplicationGatewayGlobal | undefined);
    get requestBufferingEnabled(): cdktf.IResolvable;
    get responseBufferingEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermApplicationGatewayGlobalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayGlobalOutputReference;
}
export interface DataAzurermApplicationGatewayHttpListenerCustomErrorConfiguration {
}
export declare function dataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationToTerraform(struct?: DataAzurermApplicationGatewayHttpListenerCustomErrorConfiguration): any;
export declare function dataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayHttpListenerCustomErrorConfiguration): any;
export declare class DataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayHttpListenerCustomErrorConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayHttpListenerCustomErrorConfiguration | undefined);
    get customErrorPageUrl(): string;
    get id(): string;
    get statusCode(): string;
}
export declare class DataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayHttpListener {
}
export declare function dataAzurermApplicationGatewayHttpListenerToTerraform(struct?: DataAzurermApplicationGatewayHttpListener): any;
export declare function dataAzurermApplicationGatewayHttpListenerToHclTerraform(struct?: DataAzurermApplicationGatewayHttpListener): any;
export declare class DataAzurermApplicationGatewayHttpListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayHttpListener | undefined;
    set internalValue(value: DataAzurermApplicationGatewayHttpListener | undefined);
    private _customErrorConfiguration;
    get customErrorConfiguration(): DataAzurermApplicationGatewayHttpListenerCustomErrorConfigurationList;
    get firewallPolicyId(): string;
    get frontendIpConfigurationId(): string;
    get frontendIpConfigurationName(): string;
    get frontendPortId(): string;
    get frontendPortName(): string;
    get hostName(): string;
    get hostNames(): string[];
    get id(): string;
    get name(): string;
    get protocol(): string;
    get requireSni(): cdktf.IResolvable;
    get sslCertificateId(): string;
    get sslCertificateName(): string;
    get sslProfileId(): string;
    get sslProfileName(): string;
}
export declare class DataAzurermApplicationGatewayHttpListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayHttpListenerOutputReference;
}
export interface DataAzurermApplicationGatewayIdentity {
}
export declare function dataAzurermApplicationGatewayIdentityToTerraform(struct?: DataAzurermApplicationGatewayIdentity): any;
export declare function dataAzurermApplicationGatewayIdentityToHclTerraform(struct?: DataAzurermApplicationGatewayIdentity): any;
export declare class DataAzurermApplicationGatewayIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayIdentity | undefined;
    set internalValue(value: DataAzurermApplicationGatewayIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermApplicationGatewayIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayIdentityOutputReference;
}
export interface DataAzurermApplicationGatewayPrivateEndpointConnection {
}
export declare function dataAzurermApplicationGatewayPrivateEndpointConnectionToTerraform(struct?: DataAzurermApplicationGatewayPrivateEndpointConnection): any;
export declare function dataAzurermApplicationGatewayPrivateEndpointConnectionToHclTerraform(struct?: DataAzurermApplicationGatewayPrivateEndpointConnection): any;
export declare class DataAzurermApplicationGatewayPrivateEndpointConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayPrivateEndpointConnection | undefined;
    set internalValue(value: DataAzurermApplicationGatewayPrivateEndpointConnection | undefined);
    get id(): string;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayPrivateEndpointConnectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayPrivateEndpointConnectionOutputReference;
}
export interface DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfiguration {
}
export declare function dataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationToTerraform(struct?: DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfiguration): any;
export declare function dataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfiguration): any;
export declare class DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfiguration | undefined);
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get subnetId(): string;
}
export declare class DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayPrivateLinkConfiguration {
}
export declare function dataAzurermApplicationGatewayPrivateLinkConfigurationToTerraform(struct?: DataAzurermApplicationGatewayPrivateLinkConfiguration): any;
export declare function dataAzurermApplicationGatewayPrivateLinkConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayPrivateLinkConfiguration): any;
export declare class DataAzurermApplicationGatewayPrivateLinkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayPrivateLinkConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayPrivateLinkConfiguration | undefined);
    get id(): string;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermApplicationGatewayPrivateLinkConfigurationIpConfigurationList;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayPrivateLinkConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayPrivateLinkConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayProbeMatch {
}
export declare function dataAzurermApplicationGatewayProbeMatchToTerraform(struct?: DataAzurermApplicationGatewayProbeMatch): any;
export declare function dataAzurermApplicationGatewayProbeMatchToHclTerraform(struct?: DataAzurermApplicationGatewayProbeMatch): any;
export declare class DataAzurermApplicationGatewayProbeMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayProbeMatch | undefined;
    set internalValue(value: DataAzurermApplicationGatewayProbeMatch | undefined);
    get body(): string;
    get statusCode(): string[];
}
export declare class DataAzurermApplicationGatewayProbeMatchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayProbeMatchOutputReference;
}
export interface DataAzurermApplicationGatewayProbe {
}
export declare function dataAzurermApplicationGatewayProbeToTerraform(struct?: DataAzurermApplicationGatewayProbe): any;
export declare function dataAzurermApplicationGatewayProbeToHclTerraform(struct?: DataAzurermApplicationGatewayProbe): any;
export declare class DataAzurermApplicationGatewayProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayProbe | undefined;
    set internalValue(value: DataAzurermApplicationGatewayProbe | undefined);
    get host(): string;
    get id(): string;
    get interval(): number;
    private _match;
    get match(): DataAzurermApplicationGatewayProbeMatchList;
    get minimumServers(): number;
    get name(): string;
    get path(): string;
    get pickHostNameFromBackendHttpSettings(): cdktf.IResolvable;
    get port(): number;
    get protocol(): string;
    get timeout(): number;
    get unhealthyThreshold(): number;
}
export declare class DataAzurermApplicationGatewayProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayProbeOutputReference;
}
export interface DataAzurermApplicationGatewayRedirectConfiguration {
}
export declare function dataAzurermApplicationGatewayRedirectConfigurationToTerraform(struct?: DataAzurermApplicationGatewayRedirectConfiguration): any;
export declare function dataAzurermApplicationGatewayRedirectConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayRedirectConfiguration): any;
export declare class DataAzurermApplicationGatewayRedirectConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRedirectConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRedirectConfiguration | undefined);
    get id(): string;
    get includePath(): cdktf.IResolvable;
    get includeQueryString(): cdktf.IResolvable;
    get name(): string;
    get redirectType(): string;
    get targetListenerId(): string;
    get targetListenerName(): string;
    get targetUrl(): string;
}
export declare class DataAzurermApplicationGatewayRedirectConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRedirectConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayRequestRoutingRule {
}
export declare function dataAzurermApplicationGatewayRequestRoutingRuleToTerraform(struct?: DataAzurermApplicationGatewayRequestRoutingRule): any;
export declare function dataAzurermApplicationGatewayRequestRoutingRuleToHclTerraform(struct?: DataAzurermApplicationGatewayRequestRoutingRule): any;
export declare class DataAzurermApplicationGatewayRequestRoutingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRequestRoutingRule | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRequestRoutingRule | undefined);
    get backendAddressPoolId(): string;
    get backendAddressPoolName(): string;
    get backendHttpSettingsId(): string;
    get backendHttpSettingsName(): string;
    get httpListenerId(): string;
    get httpListenerName(): string;
    get id(): string;
    get name(): string;
    get priority(): number;
    get redirectConfigurationId(): string;
    get redirectConfigurationName(): string;
    get rewriteRuleSetId(): string;
    get rewriteRuleSetName(): string;
    get ruleType(): string;
    get urlPathMapId(): string;
    get urlPathMapName(): string;
}
export declare class DataAzurermApplicationGatewayRequestRoutingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRequestRoutingRuleOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleCondition {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleCondition): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleCondition): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleCondition | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleCondition | undefined);
    get ignoreCase(): cdktf.IResolvable;
    get negate(): cdktf.IResolvable;
    get pattern(): string;
    get variable(): string;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfiguration | undefined);
    get headerName(): string;
    get headerValue(): string;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfiguration | undefined);
    get headerName(): string;
    get headerValue(): string;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrl {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrl): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrl): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrl | undefined);
    get components(): string;
    get path(): string;
    get queryString(): string;
    get reroute(): cdktf.IResolvable;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSetRewriteRule {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRule): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetRewriteRuleToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSetRewriteRule): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRule | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSetRewriteRule | undefined);
    private _condition;
    get condition(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleConditionList;
    get name(): string;
    private _requestHeaderConfiguration;
    get requestHeaderConfiguration(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleRequestHeaderConfigurationList;
    private _responseHeaderConfiguration;
    get responseHeaderConfiguration(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleResponseHeaderConfigurationList;
    get ruleSequence(): number;
    private _url;
    get url(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleUrlList;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleOutputReference;
}
export interface DataAzurermApplicationGatewayRewriteRuleSet {
}
export declare function dataAzurermApplicationGatewayRewriteRuleSetToTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSet): any;
export declare function dataAzurermApplicationGatewayRewriteRuleSetToHclTerraform(struct?: DataAzurermApplicationGatewayRewriteRuleSet): any;
export declare class DataAzurermApplicationGatewayRewriteRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayRewriteRuleSet | undefined;
    set internalValue(value: DataAzurermApplicationGatewayRewriteRuleSet | undefined);
    get id(): string;
    get name(): string;
    private _rewriteRule;
    get rewriteRule(): DataAzurermApplicationGatewayRewriteRuleSetRewriteRuleList;
}
export declare class DataAzurermApplicationGatewayRewriteRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayRewriteRuleSetOutputReference;
}
export interface DataAzurermApplicationGatewaySku {
}
export declare function dataAzurermApplicationGatewaySkuToTerraform(struct?: DataAzurermApplicationGatewaySku): any;
export declare function dataAzurermApplicationGatewaySkuToHclTerraform(struct?: DataAzurermApplicationGatewaySku): any;
export declare class DataAzurermApplicationGatewaySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewaySku | undefined;
    set internalValue(value: DataAzurermApplicationGatewaySku | undefined);
    get capacity(): number;
    get name(): string;
    get tier(): string;
}
export declare class DataAzurermApplicationGatewaySkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewaySkuOutputReference;
}
export interface DataAzurermApplicationGatewaySslCertificate {
}
export declare function dataAzurermApplicationGatewaySslCertificateToTerraform(struct?: DataAzurermApplicationGatewaySslCertificate): any;
export declare function dataAzurermApplicationGatewaySslCertificateToHclTerraform(struct?: DataAzurermApplicationGatewaySslCertificate): any;
export declare class DataAzurermApplicationGatewaySslCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewaySslCertificate | undefined;
    set internalValue(value: DataAzurermApplicationGatewaySslCertificate | undefined);
    get id(): string;
    get keyVaultSecretId(): string;
    get name(): string;
    get publicCertData(): string;
}
export declare class DataAzurermApplicationGatewaySslCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewaySslCertificateOutputReference;
}
export interface DataAzurermApplicationGatewaySslPolicy {
}
export declare function dataAzurermApplicationGatewaySslPolicyToTerraform(struct?: DataAzurermApplicationGatewaySslPolicy): any;
export declare function dataAzurermApplicationGatewaySslPolicyToHclTerraform(struct?: DataAzurermApplicationGatewaySslPolicy): any;
export declare class DataAzurermApplicationGatewaySslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewaySslPolicy | undefined;
    set internalValue(value: DataAzurermApplicationGatewaySslPolicy | undefined);
    get cipherSuites(): string[];
    get disabledProtocols(): string[];
    get minProtocolVersion(): string;
    get policyName(): string;
    get policyType(): string;
}
export declare class DataAzurermApplicationGatewaySslPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewaySslPolicyOutputReference;
}
export interface DataAzurermApplicationGatewaySslProfileSslPolicy {
}
export declare function dataAzurermApplicationGatewaySslProfileSslPolicyToTerraform(struct?: DataAzurermApplicationGatewaySslProfileSslPolicy): any;
export declare function dataAzurermApplicationGatewaySslProfileSslPolicyToHclTerraform(struct?: DataAzurermApplicationGatewaySslProfileSslPolicy): any;
export declare class DataAzurermApplicationGatewaySslProfileSslPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewaySslProfileSslPolicy | undefined;
    set internalValue(value: DataAzurermApplicationGatewaySslProfileSslPolicy | undefined);
    get cipherSuites(): string[];
    get disabledProtocols(): string[];
    get minProtocolVersion(): string;
    get policyName(): string;
    get policyType(): string;
}
export declare class DataAzurermApplicationGatewaySslProfileSslPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewaySslProfileSslPolicyOutputReference;
}
export interface DataAzurermApplicationGatewaySslProfile {
}
export declare function dataAzurermApplicationGatewaySslProfileToTerraform(struct?: DataAzurermApplicationGatewaySslProfile): any;
export declare function dataAzurermApplicationGatewaySslProfileToHclTerraform(struct?: DataAzurermApplicationGatewaySslProfile): any;
export declare class DataAzurermApplicationGatewaySslProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewaySslProfile | undefined;
    set internalValue(value: DataAzurermApplicationGatewaySslProfile | undefined);
    get id(): string;
    get name(): string;
    private _sslPolicy;
    get sslPolicy(): DataAzurermApplicationGatewaySslProfileSslPolicyList;
    get trustedClientCertificateNames(): string[];
    get verifyClientCertificateIssuerDn(): cdktf.IResolvable;
    get verifyClientCertificateRevocation(): string;
}
export declare class DataAzurermApplicationGatewaySslProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewaySslProfileOutputReference;
}
export interface DataAzurermApplicationGatewayTrustedClientCertificate {
}
export declare function dataAzurermApplicationGatewayTrustedClientCertificateToTerraform(struct?: DataAzurermApplicationGatewayTrustedClientCertificate): any;
export declare function dataAzurermApplicationGatewayTrustedClientCertificateToHclTerraform(struct?: DataAzurermApplicationGatewayTrustedClientCertificate): any;
export declare class DataAzurermApplicationGatewayTrustedClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayTrustedClientCertificate | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTrustedClientCertificate | undefined);
    get data(): string;
    get id(): string;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayTrustedClientCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayTrustedClientCertificateOutputReference;
}
export interface DataAzurermApplicationGatewayTrustedRootCertificate {
}
export declare function dataAzurermApplicationGatewayTrustedRootCertificateToTerraform(struct?: DataAzurermApplicationGatewayTrustedRootCertificate): any;
export declare function dataAzurermApplicationGatewayTrustedRootCertificateToHclTerraform(struct?: DataAzurermApplicationGatewayTrustedRootCertificate): any;
export declare class DataAzurermApplicationGatewayTrustedRootCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayTrustedRootCertificate | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTrustedRootCertificate | undefined);
    get id(): string;
    get keyVaultSecretId(): string;
    get name(): string;
}
export declare class DataAzurermApplicationGatewayTrustedRootCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayTrustedRootCertificateOutputReference;
}
export interface DataAzurermApplicationGatewayUrlPathMapPathRule {
}
export declare function dataAzurermApplicationGatewayUrlPathMapPathRuleToTerraform(struct?: DataAzurermApplicationGatewayUrlPathMapPathRule): any;
export declare function dataAzurermApplicationGatewayUrlPathMapPathRuleToHclTerraform(struct?: DataAzurermApplicationGatewayUrlPathMapPathRule): any;
export declare class DataAzurermApplicationGatewayUrlPathMapPathRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayUrlPathMapPathRule | undefined;
    set internalValue(value: DataAzurermApplicationGatewayUrlPathMapPathRule | undefined);
    get backendAddressPoolId(): string;
    get backendAddressPoolName(): string;
    get backendHttpSettingsId(): string;
    get backendHttpSettingsName(): string;
    get firewallPolicyId(): string;
    get id(): string;
    get name(): string;
    get paths(): string[];
    get redirectConfigurationId(): string;
    get redirectConfigurationName(): string;
    get rewriteRuleSetId(): string;
    get rewriteRuleSetName(): string;
}
export declare class DataAzurermApplicationGatewayUrlPathMapPathRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayUrlPathMapPathRuleOutputReference;
}
export interface DataAzurermApplicationGatewayUrlPathMap {
}
export declare function dataAzurermApplicationGatewayUrlPathMapToTerraform(struct?: DataAzurermApplicationGatewayUrlPathMap): any;
export declare function dataAzurermApplicationGatewayUrlPathMapToHclTerraform(struct?: DataAzurermApplicationGatewayUrlPathMap): any;
export declare class DataAzurermApplicationGatewayUrlPathMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayUrlPathMap | undefined;
    set internalValue(value: DataAzurermApplicationGatewayUrlPathMap | undefined);
    get defaultBackendAddressPoolId(): string;
    get defaultBackendAddressPoolName(): string;
    get defaultBackendHttpSettingsId(): string;
    get defaultBackendHttpSettingsName(): string;
    get defaultRedirectConfigurationId(): string;
    get defaultRedirectConfigurationName(): string;
    get defaultRewriteRuleSetId(): string;
    get defaultRewriteRuleSetName(): string;
    get id(): string;
    get name(): string;
    private _pathRule;
    get pathRule(): DataAzurermApplicationGatewayUrlPathMapPathRuleList;
}
export declare class DataAzurermApplicationGatewayUrlPathMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayUrlPathMapOutputReference;
}
export interface DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroup {
}
export declare function dataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupToTerraform(struct?: DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroup): any;
export declare function dataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupToHclTerraform(struct?: DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroup): any;
export declare class DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroup | undefined;
    set internalValue(value: DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroup | undefined);
    get ruleGroupName(): string;
    get rules(): number[];
}
export declare class DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupOutputReference;
}
export interface DataAzurermApplicationGatewayWafConfigurationExclusion {
}
export declare function dataAzurermApplicationGatewayWafConfigurationExclusionToTerraform(struct?: DataAzurermApplicationGatewayWafConfigurationExclusion): any;
export declare function dataAzurermApplicationGatewayWafConfigurationExclusionToHclTerraform(struct?: DataAzurermApplicationGatewayWafConfigurationExclusion): any;
export declare class DataAzurermApplicationGatewayWafConfigurationExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayWafConfigurationExclusion | undefined;
    set internalValue(value: DataAzurermApplicationGatewayWafConfigurationExclusion | undefined);
    get matchVariable(): string;
    get selector(): string;
    get selectorMatchOperator(): string;
}
export declare class DataAzurermApplicationGatewayWafConfigurationExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayWafConfigurationExclusionOutputReference;
}
export interface DataAzurermApplicationGatewayWafConfiguration {
}
export declare function dataAzurermApplicationGatewayWafConfigurationToTerraform(struct?: DataAzurermApplicationGatewayWafConfiguration): any;
export declare function dataAzurermApplicationGatewayWafConfigurationToHclTerraform(struct?: DataAzurermApplicationGatewayWafConfiguration): any;
export declare class DataAzurermApplicationGatewayWafConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApplicationGatewayWafConfiguration | undefined;
    set internalValue(value: DataAzurermApplicationGatewayWafConfiguration | undefined);
    private _disabledRuleGroup;
    get disabledRuleGroup(): DataAzurermApplicationGatewayWafConfigurationDisabledRuleGroupList;
    get enabled(): cdktf.IResolvable;
    private _exclusion;
    get exclusion(): DataAzurermApplicationGatewayWafConfigurationExclusionList;
    get fileUploadLimitMb(): number;
    get firewallMode(): string;
    get maxRequestBodySizeKb(): number;
    get requestBodyCheck(): cdktf.IResolvable;
    get ruleSetType(): string;
    get ruleSetVersion(): string;
}
export declare class DataAzurermApplicationGatewayWafConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApplicationGatewayWafConfigurationOutputReference;
}
export interface DataAzurermApplicationGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#read DataAzurermApplicationGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApplicationGatewayTimeoutsToTerraform(struct?: DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApplicationGatewayTimeoutsToHclTerraform(struct?: DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApplicationGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApplicationGatewayTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway azurerm_application_gateway}
*/
export declare class DataAzurermApplicationGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_application_gateway";
    /**
    * Generates CDKTF code for importing a DataAzurermApplicationGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApplicationGateway to import
    * @param importFromId The id of the existing DataAzurermApplicationGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApplicationGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/application_gateway azurerm_application_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApplicationGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationGatewayConfig);
    private _authenticationCertificate;
    get authenticationCertificate(): DataAzurermApplicationGatewayAuthenticationCertificateList;
    private _autoscaleConfiguration;
    get autoscaleConfiguration(): DataAzurermApplicationGatewayAutoscaleConfigurationList;
    private _backendAddressPool;
    get backendAddressPool(): DataAzurermApplicationGatewayBackendAddressPoolList;
    private _backendHttpSettings;
    get backendHttpSettings(): DataAzurermApplicationGatewayBackendHttpSettingsList;
    private _customErrorConfiguration;
    get customErrorConfiguration(): DataAzurermApplicationGatewayCustomErrorConfigurationList;
    get fipsEnabled(): cdktf.IResolvable;
    get firewallPolicyId(): string;
    get forceFirewallPolicyAssociation(): cdktf.IResolvable;
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): DataAzurermApplicationGatewayFrontendIpConfigurationList;
    private _frontendPort;
    get frontendPort(): DataAzurermApplicationGatewayFrontendPortList;
    private _gatewayIpConfiguration;
    get gatewayIpConfiguration(): DataAzurermApplicationGatewayGatewayIpConfigurationList;
    private _global;
    get global(): DataAzurermApplicationGatewayGlobalList;
    get http2Enabled(): cdktf.IResolvable;
    private _httpListener;
    get httpListener(): DataAzurermApplicationGatewayHttpListenerList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermApplicationGatewayIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpointConnection;
    get privateEndpointConnection(): DataAzurermApplicationGatewayPrivateEndpointConnectionList;
    private _privateLinkConfiguration;
    get privateLinkConfiguration(): DataAzurermApplicationGatewayPrivateLinkConfigurationList;
    private _probe;
    get probe(): DataAzurermApplicationGatewayProbeList;
    private _redirectConfiguration;
    get redirectConfiguration(): DataAzurermApplicationGatewayRedirectConfigurationList;
    private _requestRoutingRule;
    get requestRoutingRule(): DataAzurermApplicationGatewayRequestRoutingRuleList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rewriteRuleSet;
    get rewriteRuleSet(): DataAzurermApplicationGatewayRewriteRuleSetList;
    private _sku;
    get sku(): DataAzurermApplicationGatewaySkuList;
    private _sslCertificate;
    get sslCertificate(): DataAzurermApplicationGatewaySslCertificateList;
    private _sslPolicy;
    get sslPolicy(): DataAzurermApplicationGatewaySslPolicyList;
    private _sslProfile;
    get sslProfile(): DataAzurermApplicationGatewaySslProfileList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _trustedClientCertificate;
    get trustedClientCertificate(): DataAzurermApplicationGatewayTrustedClientCertificateList;
    private _trustedRootCertificate;
    get trustedRootCertificate(): DataAzurermApplicationGatewayTrustedRootCertificateList;
    private _urlPathMap;
    get urlPathMap(): DataAzurermApplicationGatewayUrlPathMapList;
    private _wafConfiguration;
    get wafConfiguration(): DataAzurermApplicationGatewayWafConfigurationList;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermApplicationGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApplicationGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApplicationGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
