/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#dns_proxy_enabled DataAzurermFirewall#dns_proxy_enabled}
    */
    readonly dnsProxyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#id DataAzurermFirewall#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#name DataAzurermFirewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#resource_group_name DataAzurermFirewall#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#timeouts DataAzurermFirewall#timeouts}
    */
    readonly timeouts?: DataAzurermFirewallTimeouts;
}
export interface DataAzurermFirewallIpConfiguration {
}
export declare function dataAzurermFirewallIpConfigurationToTerraform(struct?: DataAzurermFirewallIpConfiguration): any;
export declare function dataAzurermFirewallIpConfigurationToHclTerraform(struct?: DataAzurermFirewallIpConfiguration): any;
export declare class DataAzurermFirewallIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallIpConfiguration | undefined;
    set internalValue(value: DataAzurermFirewallIpConfiguration | undefined);
    get name(): string;
    get privateIpAddress(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermFirewallIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallIpConfigurationOutputReference;
}
export interface DataAzurermFirewallManagementIpConfiguration {
}
export declare function dataAzurermFirewallManagementIpConfigurationToTerraform(struct?: DataAzurermFirewallManagementIpConfiguration): any;
export declare function dataAzurermFirewallManagementIpConfigurationToHclTerraform(struct?: DataAzurermFirewallManagementIpConfiguration): any;
export declare class DataAzurermFirewallManagementIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallManagementIpConfiguration | undefined;
    set internalValue(value: DataAzurermFirewallManagementIpConfiguration | undefined);
    get name(): string;
    get privateIpAddress(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermFirewallManagementIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallManagementIpConfigurationOutputReference;
}
export interface DataAzurermFirewallVirtualHub {
}
export declare function dataAzurermFirewallVirtualHubToTerraform(struct?: DataAzurermFirewallVirtualHub): any;
export declare function dataAzurermFirewallVirtualHubToHclTerraform(struct?: DataAzurermFirewallVirtualHub): any;
export declare class DataAzurermFirewallVirtualHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermFirewallVirtualHub | undefined;
    set internalValue(value: DataAzurermFirewallVirtualHub | undefined);
    get privateIpAddress(): string;
    get publicIpAddresses(): string[];
    get publicIpCount(): number;
    get virtualHubId(): string;
}
export declare class DataAzurermFirewallVirtualHubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermFirewallVirtualHubOutputReference;
}
export interface DataAzurermFirewallTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#read DataAzurermFirewall#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFirewallTimeoutsToTerraform(struct?: DataAzurermFirewallTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermFirewallTimeoutsToHclTerraform(struct?: DataAzurermFirewallTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermFirewallTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermFirewallTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall azurerm_firewall}
*/
export declare class DataAzurermFirewall extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_firewall";
    /**
    * Generates CDKTF code for importing a DataAzurermFirewall resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermFirewall to import
    * @param importFromId The id of the existing DataAzurermFirewall that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermFirewall to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/firewall azurerm_firewall} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFirewallConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallConfig);
    private _dnsProxyEnabled?;
    get dnsProxyEnabled(): boolean | cdktf.IResolvable;
    set dnsProxyEnabled(value: boolean | cdktf.IResolvable);
    resetDnsProxyEnabled(): void;
    get dnsProxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get dnsServers(): string[];
    get firewallPolicyId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermFirewallIpConfigurationList;
    get location(): string;
    private _managementIpConfiguration;
    get managementIpConfiguration(): DataAzurermFirewallManagementIpConfigurationList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get skuTier(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get threatIntelMode(): string;
    private _virtualHub;
    get virtualHub(): DataAzurermFirewallVirtualHubList;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermFirewallTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFirewallTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermFirewallTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
