/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkSiteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#id DataAzurermMobileNetworkSite#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#mobile_network_id DataAzurermMobileNetworkSite#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#name DataAzurermMobileNetworkSite#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#timeouts DataAzurermMobileNetworkSite#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkSiteTimeouts;
}
export interface DataAzurermMobileNetworkSiteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#read DataAzurermMobileNetworkSite#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkSiteTimeoutsToTerraform(struct?: DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkSiteTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkSiteTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site azurerm_mobile_network_site}
*/
export declare class DataAzurermMobileNetworkSite extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_site";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkSite resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkSite to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkSite that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkSite to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/mobile_network_site azurerm_mobile_network_site} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkSiteConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkSiteConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkFunctionIds(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkSiteTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkSiteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkSiteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
