/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNginxCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#id DataAzurermNginxCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#name DataAzurermNginxCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#nginx_deployment_id DataAzurermNginxCertificate#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#timeouts DataAzurermNginxCertificate#timeouts}
    */
    readonly timeouts?: DataAzurermNginxCertificateTimeouts;
}
export interface DataAzurermNginxCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#read DataAzurermNginxCertificate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNginxCertificateTimeoutsToTerraform(struct?: DataAzurermNginxCertificateTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNginxCertificateTimeoutsToHclTerraform(struct?: DataAzurermNginxCertificateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNginxCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNginxCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNginxCertificateTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate azurerm_nginx_certificate}
*/
export declare class DataAzurermNginxCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_nginx_certificate";
    /**
    * Generates CDKTF code for importing a DataAzurermNginxCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNginxCertificate to import
    * @param importFromId The id of the existing DataAzurermNginxCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNginxCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/nginx_certificate azurerm_nginx_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNginxCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNginxCertificateConfig);
    get certificateVirtualPath(): string;
    get errorCode(): string;
    get errorMessage(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyVaultSecretCreationDate(): string;
    get keyVaultSecretId(): string;
    get keyVaultSecretVersion(): string;
    get keyVirtualPath(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    get sha1Thumbprint(): string;
    private _timeouts;
    get timeouts(): DataAzurermNginxCertificateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNginxCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNginxCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
