/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleDbSystemShapesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes#id DataAzurermOracleDbSystemShapes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes#location DataAzurermOracleDbSystemShapes#location}
    */
    readonly location: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes#timeouts DataAzurermOracleDbSystemShapes#timeouts}
    */
    readonly timeouts?: DataAzurermOracleDbSystemShapesTimeouts;
}
export interface DataAzurermOracleDbSystemShapesDbSystemShapes {
}
export declare function dataAzurermOracleDbSystemShapesDbSystemShapesToTerraform(struct?: DataAzurermOracleDbSystemShapesDbSystemShapes): any;
export declare function dataAzurermOracleDbSystemShapesDbSystemShapesToHclTerraform(struct?: DataAzurermOracleDbSystemShapesDbSystemShapes): any;
export declare class DataAzurermOracleDbSystemShapesDbSystemShapesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleDbSystemShapesDbSystemShapes | undefined;
    set internalValue(value: DataAzurermOracleDbSystemShapesDbSystemShapes | undefined);
    get availableCoreCount(): number;
    get availableCoreCountPerNode(): number;
    get availableDataStorageInTbs(): number;
    get availableDataStoragePerServerInTbs(): number;
    get availableDbNodePerNodeInGbs(): number;
    get availableDbNodeStorageInGbs(): number;
    get availableMemoryInGbs(): number;
    get availableMemoryPerNodeInGbs(): number;
    get coreCountIncrement(): number;
    get maximumNodeCount(): number;
    get maximumStorageCount(): number;
    get minimumCoreCount(): number;
    get minimumCoreCountPerNode(): number;
    get minimumDataStorageInTbs(): number;
    get minimumDbNodeStoragePerNodeInGbs(): number;
    get minimumMemoryPerNodeInGbs(): number;
    get minimumNodeCount(): number;
    get minimumStorageCount(): number;
    get runtimeMinimumCoreCount(): number;
    get shapeFamily(): string;
}
export declare class DataAzurermOracleDbSystemShapesDbSystemShapesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleDbSystemShapesDbSystemShapesOutputReference;
}
export interface DataAzurermOracleDbSystemShapesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes#read DataAzurermOracleDbSystemShapes#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleDbSystemShapesTimeoutsToTerraform(struct?: DataAzurermOracleDbSystemShapesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleDbSystemShapesTimeoutsToHclTerraform(struct?: DataAzurermOracleDbSystemShapesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleDbSystemShapesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleDbSystemShapesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleDbSystemShapesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes azurerm_oracle_db_system_shapes}
*/
export declare class DataAzurermOracleDbSystemShapes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_db_system_shapes";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleDbSystemShapes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleDbSystemShapes to import
    * @param importFromId The id of the existing DataAzurermOracleDbSystemShapes that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleDbSystemShapes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/oracle_db_system_shapes azurerm_oracle_db_system_shapes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleDbSystemShapesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleDbSystemShapesConfig);
    private _dbSystemShapes;
    get dbSystemShapes(): DataAzurermOracleDbSystemShapesDbSystemShapesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermOracleDbSystemShapesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleDbSystemShapesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleDbSystemShapesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
