/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRoleManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#id DataAzurermRoleManagementPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the Azure Role to which this policy is assigned
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#role_definition_id DataAzurermRoleManagementPolicy#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * The scope of the role to which this policy will apply
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#scope DataAzurermRoleManagementPolicy#scope}
    */
    readonly scope: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#timeouts DataAzurermRoleManagementPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermRoleManagementPolicyTimeouts;
}
export interface DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApprover {
}
export declare function dataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverToTerraform(struct?: DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApprover): any;
export declare function dataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverToHclTerraform(struct?: DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApprover): any;
export declare class DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApprover | undefined);
    get objectId(): string;
    get type(): string;
}
export declare class DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverOutputReference;
}
export interface DataAzurermRoleManagementPolicyActivationRulesApprovalStage {
}
export declare function dataAzurermRoleManagementPolicyActivationRulesApprovalStageToTerraform(struct?: DataAzurermRoleManagementPolicyActivationRulesApprovalStage): any;
export declare function dataAzurermRoleManagementPolicyActivationRulesApprovalStageToHclTerraform(struct?: DataAzurermRoleManagementPolicyActivationRulesApprovalStage): any;
export declare class DataAzurermRoleManagementPolicyActivationRulesApprovalStageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyActivationRulesApprovalStage | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyActivationRulesApprovalStage | undefined);
    private _primaryApprover;
    get primaryApprover(): DataAzurermRoleManagementPolicyActivationRulesApprovalStagePrimaryApproverList;
}
export declare class DataAzurermRoleManagementPolicyActivationRulesApprovalStageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyActivationRulesApprovalStageOutputReference;
}
export interface DataAzurermRoleManagementPolicyActivationRules {
}
export declare function dataAzurermRoleManagementPolicyActivationRulesToTerraform(struct?: DataAzurermRoleManagementPolicyActivationRules): any;
export declare function dataAzurermRoleManagementPolicyActivationRulesToHclTerraform(struct?: DataAzurermRoleManagementPolicyActivationRules): any;
export declare class DataAzurermRoleManagementPolicyActivationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyActivationRules | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyActivationRules | undefined);
    private _approvalStage;
    get approvalStage(): DataAzurermRoleManagementPolicyActivationRulesApprovalStageList;
    get maximumDuration(): string;
    get requireApproval(): cdktf.IResolvable;
    get requireJustification(): cdktf.IResolvable;
    get requireMultifactorAuthentication(): cdktf.IResolvable;
    get requireTicketInfo(): cdktf.IResolvable;
    get requiredConditionalAccessAuthenticationContext(): string;
}
export declare class DataAzurermRoleManagementPolicyActivationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyActivationRulesOutputReference;
}
export interface DataAzurermRoleManagementPolicyActiveAssignmentRules {
}
export declare function dataAzurermRoleManagementPolicyActiveAssignmentRulesToTerraform(struct?: DataAzurermRoleManagementPolicyActiveAssignmentRules): any;
export declare function dataAzurermRoleManagementPolicyActiveAssignmentRulesToHclTerraform(struct?: DataAzurermRoleManagementPolicyActiveAssignmentRules): any;
export declare class DataAzurermRoleManagementPolicyActiveAssignmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyActiveAssignmentRules | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyActiveAssignmentRules | undefined);
    get expirationRequired(): cdktf.IResolvable;
    get expireAfter(): string;
    get requireJustification(): cdktf.IResolvable;
    get requireMultifactorAuthentication(): cdktf.IResolvable;
    get requireTicketInfo(): cdktf.IResolvable;
}
export declare class DataAzurermRoleManagementPolicyActiveAssignmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyActiveAssignmentRulesOutputReference;
}
export interface DataAzurermRoleManagementPolicyEligibleAssignmentRules {
}
export declare function dataAzurermRoleManagementPolicyEligibleAssignmentRulesToTerraform(struct?: DataAzurermRoleManagementPolicyEligibleAssignmentRules): any;
export declare function dataAzurermRoleManagementPolicyEligibleAssignmentRulesToHclTerraform(struct?: DataAzurermRoleManagementPolicyEligibleAssignmentRules): any;
export declare class DataAzurermRoleManagementPolicyEligibleAssignmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyEligibleAssignmentRules | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyEligibleAssignmentRules | undefined);
    get expirationRequired(): cdktf.IResolvable;
    get expireAfter(): string;
}
export declare class DataAzurermRoleManagementPolicyEligibleAssignmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyEligibleAssignmentRulesOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesActiveAssignments {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignments): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignments): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignments | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesActiveAssignments | undefined);
    private _adminNotifications;
    get adminNotifications(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAdminNotificationsList;
    private _approverNotifications;
    get approverNotifications(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsApproverNotificationsList;
    private _assigneeNotifications;
    get assigneeNotifications(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsAssigneeNotificationsList;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleActivations {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivations): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivations): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivations | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleActivations | undefined);
    private _adminNotifications;
    get adminNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAdminNotificationsList;
    private _approverNotifications;
    get approverNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsApproverNotificationsList;
    private _assigneeNotifications;
    get assigneeNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsAssigneeNotificationsList;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotifications | undefined);
    get additionalRecipients(): string[];
    get defaultRecipients(): cdktf.IResolvable;
    get notificationLevel(): string;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignments {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignments): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignments): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignments | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignments | undefined);
    private _adminNotifications;
    get adminNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAdminNotificationsList;
    private _approverNotifications;
    get approverNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsApproverNotificationsList;
    private _assigneeNotifications;
    get assigneeNotifications(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsAssigneeNotificationsList;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsOutputReference;
}
export interface DataAzurermRoleManagementPolicyNotificationRules {
}
export declare function dataAzurermRoleManagementPolicyNotificationRulesToTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRules): any;
export declare function dataAzurermRoleManagementPolicyNotificationRulesToHclTerraform(struct?: DataAzurermRoleManagementPolicyNotificationRules): any;
export declare class DataAzurermRoleManagementPolicyNotificationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleManagementPolicyNotificationRules | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyNotificationRules | undefined);
    private _activeAssignments;
    get activeAssignments(): DataAzurermRoleManagementPolicyNotificationRulesActiveAssignmentsList;
    private _eligibleActivations;
    get eligibleActivations(): DataAzurermRoleManagementPolicyNotificationRulesEligibleActivationsList;
    private _eligibleAssignments;
    get eligibleAssignments(): DataAzurermRoleManagementPolicyNotificationRulesEligibleAssignmentsList;
}
export declare class DataAzurermRoleManagementPolicyNotificationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleManagementPolicyNotificationRulesOutputReference;
}
export interface DataAzurermRoleManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#read DataAzurermRoleManagementPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRoleManagementPolicyTimeoutsToTerraform(struct?: DataAzurermRoleManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermRoleManagementPolicyTimeoutsToHclTerraform(struct?: DataAzurermRoleManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRoleManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermRoleManagementPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermRoleManagementPolicyTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy azurerm_role_management_policy}
*/
export declare class DataAzurermRoleManagementPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_role_management_policy";
    /**
    * Generates CDKTF code for importing a DataAzurermRoleManagementPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermRoleManagementPolicy to import
    * @param importFromId The id of the existing DataAzurermRoleManagementPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermRoleManagementPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/role_management_policy azurerm_role_management_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRoleManagementPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermRoleManagementPolicyConfig);
    private _activationRules;
    get activationRules(): DataAzurermRoleManagementPolicyActivationRulesList;
    private _activeAssignmentRules;
    get activeAssignmentRules(): DataAzurermRoleManagementPolicyActiveAssignmentRulesList;
    get description(): string;
    private _eligibleAssignmentRules;
    get eligibleAssignmentRules(): DataAzurermRoleManagementPolicyEligibleAssignmentRulesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _notificationRules;
    get notificationRules(): DataAzurermRoleManagementPolicyNotificationRulesList;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermRoleManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRoleManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermRoleManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
