/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#id DataAzurermVirtualNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#name DataAzurermVirtualNetworkPeering#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#virtual_network_id DataAzurermVirtualNetworkPeering#virtual_network_id}
    */
    readonly virtualNetworkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#timeouts DataAzurermVirtualNetworkPeering#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualNetworkPeeringTimeouts;
}
export interface DataAzurermVirtualNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#read DataAzurermVirtualNetworkPeering#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkPeeringTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualNetworkPeeringTimeoutsToHclTerraform(struct?: DataAzurermVirtualNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering azurerm_virtual_network_peering}
*/
export declare class DataAzurermVirtualNetworkPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_network_peering";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualNetworkPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualNetworkPeering to import
    * @param importFromId The id of the existing DataAzurermVirtualNetworkPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualNetworkPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/data-sources/virtual_network_peering azurerm_virtual_network_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkPeeringConfig);
    get allowForwardedTraffic(): cdktf.IResolvable;
    get allowGatewayTransit(): cdktf.IResolvable;
    get allowVirtualNetworkAccess(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get onlyIpv6PeeringEnabled(): cdktf.IResolvable;
    get peerCompleteVirtualNetworksEnabled(): cdktf.IResolvable;
    get remoteVirtualNetworkId(): string;
    get useRemoteGateways(): cdktf.IResolvable;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
