/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryIntegrationRuntimeAzureSsisConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#credential_name DataFactoryIntegrationRuntimeAzureSsis#credential_name}
    */
    readonly credentialName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#data_factory_id DataFactoryIntegrationRuntimeAzureSsis#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#description DataFactoryIntegrationRuntimeAzureSsis#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#edition DataFactoryIntegrationRuntimeAzureSsis#edition}
    */
    readonly edition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#id DataFactoryIntegrationRuntimeAzureSsis#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#license_type DataFactoryIntegrationRuntimeAzureSsis#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#location DataFactoryIntegrationRuntimeAzureSsis#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#max_parallel_executions_per_node DataFactoryIntegrationRuntimeAzureSsis#max_parallel_executions_per_node}
    */
    readonly maxParallelExecutionsPerNode?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#node_size DataFactoryIntegrationRuntimeAzureSsis#node_size}
    */
    readonly nodeSize: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#number_of_nodes DataFactoryIntegrationRuntimeAzureSsis#number_of_nodes}
    */
    readonly numberOfNodes?: number;
    /**
    * catalog_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#catalog_info DataFactoryIntegrationRuntimeAzureSsis#catalog_info}
    */
    readonly catalogInfo?: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo;
    /**
    * copy_compute_scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#copy_compute_scale DataFactoryIntegrationRuntimeAzureSsis#copy_compute_scale}
    */
    readonly copyComputeScale?: DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale;
    /**
    * custom_setup_script block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#custom_setup_script DataFactoryIntegrationRuntimeAzureSsis#custom_setup_script}
    */
    readonly customSetupScript?: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript;
    /**
    * express_custom_setup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#express_custom_setup DataFactoryIntegrationRuntimeAzureSsis#express_custom_setup}
    */
    readonly expressCustomSetup?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup;
    /**
    * express_vnet_integration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#express_vnet_integration DataFactoryIntegrationRuntimeAzureSsis#express_vnet_integration}
    */
    readonly expressVnetIntegration?: DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration;
    /**
    * package_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#package_store DataFactoryIntegrationRuntimeAzureSsis#package_store}
    */
    readonly packageStore?: DataFactoryIntegrationRuntimeAzureSsisPackageStore[] | cdktf.IResolvable;
    /**
    * pipeline_external_compute_scale block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#pipeline_external_compute_scale DataFactoryIntegrationRuntimeAzureSsis#pipeline_external_compute_scale}
    */
    readonly pipelineExternalComputeScale?: DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale;
    /**
    * proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#proxy DataFactoryIntegrationRuntimeAzureSsis#proxy}
    */
    readonly proxy?: DataFactoryIntegrationRuntimeAzureSsisProxy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#timeouts DataFactoryIntegrationRuntimeAzureSsis#timeouts}
    */
    readonly timeouts?: DataFactoryIntegrationRuntimeAzureSsisTimeouts;
    /**
    * vnet_integration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#vnet_integration DataFactoryIntegrationRuntimeAzureSsis#vnet_integration}
    */
    readonly vnetIntegration?: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration;
}
export interface DataFactoryIntegrationRuntimeAzureSsisCatalogInfo {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#administrator_login DataFactoryIntegrationRuntimeAzureSsis#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#administrator_password DataFactoryIntegrationRuntimeAzureSsis#administrator_password}
    */
    readonly administratorPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#dual_standby_pair_name DataFactoryIntegrationRuntimeAzureSsis#dual_standby_pair_name}
    */
    readonly dualStandbyPairName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#elastic_pool_name DataFactoryIntegrationRuntimeAzureSsis#elastic_pool_name}
    */
    readonly elasticPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#pricing_tier DataFactoryIntegrationRuntimeAzureSsis#pricing_tier}
    */
    readonly pricingTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#server_endpoint DataFactoryIntegrationRuntimeAzureSsis#server_endpoint}
    */
    readonly serverEndpoint: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisCatalogInfoToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference | DataFactoryIntegrationRuntimeAzureSsisCatalogInfo): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisCatalogInfoToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference | DataFactoryIntegrationRuntimeAzureSsisCatalogInfo): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    get administratorPassword(): string;
    set administratorPassword(value: string);
    resetAdministratorPassword(): void;
    get administratorPasswordInput(): string | undefined;
    private _dualStandbyPairName?;
    get dualStandbyPairName(): string;
    set dualStandbyPairName(value: string);
    resetDualStandbyPairName(): void;
    get dualStandbyPairNameInput(): string | undefined;
    private _elasticPoolName?;
    get elasticPoolName(): string;
    set elasticPoolName(value: string);
    resetElasticPoolName(): void;
    get elasticPoolNameInput(): string | undefined;
    private _pricingTier?;
    get pricingTier(): string;
    set pricingTier(value: string);
    resetPricingTier(): void;
    get pricingTierInput(): string | undefined;
    private _serverEndpoint?;
    get serverEndpoint(): string;
    set serverEndpoint(value: string);
    get serverEndpointInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#data_integration_unit DataFactoryIntegrationRuntimeAzureSsis#data_integration_unit}
    */
    readonly dataIntegrationUnit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#time_to_live DataFactoryIntegrationRuntimeAzureSsis#time_to_live}
    */
    readonly timeToLive?: number;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleOutputReference | DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleOutputReference | DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale | undefined);
    private _dataIntegrationUnit?;
    get dataIntegrationUnit(): number;
    set dataIntegrationUnit(value: number);
    resetDataIntegrationUnit(): void;
    get dataIntegrationUnitInput(): number | undefined;
    private _timeToLive?;
    get timeToLive(): number;
    set timeToLive(value: number);
    resetTimeToLive(): void;
    get timeToLiveInput(): number | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#blob_container_uri DataFactoryIntegrationRuntimeAzureSsis#blob_container_uri}
    */
    readonly blobContainerUri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#sas_token DataFactoryIntegrationRuntimeAzureSsis#sas_token}
    */
    readonly sasToken: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference | DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference | DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined);
    private _blobContainerUri?;
    get blobContainerUri(): string;
    set blobContainerUri(value: string);
    get blobContainerUriInput(): string | undefined;
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    get sasTokenInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#parameters DataFactoryIntegrationRuntimeAzureSsis#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#secret_name DataFactoryIntegrationRuntimeAzureSsis#secret_name}
    */
    readonly secretName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#secret_version DataFactoryIntegrationRuntimeAzureSsis#secret_version}
    */
    readonly secretVersion?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    resetSecretVersion(): void;
    get secretVersionInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#password DataFactoryIntegrationRuntimeAzureSsis#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#target_name DataFactoryIntegrationRuntimeAzureSsis#target_name}
    */
    readonly targetName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#user_name DataFactoryIntegrationRuntimeAzureSsis#user_name}
    */
    readonly userName: string;
    /**
    * key_vault_password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#key_vault_password DataFactoryIntegrationRuntimeAzureSsis#key_vault_password}
    */
    readonly keyVaultPassword?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey | cdktf.IResolvable): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey | cdktf.IResolvable): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey | cdktf.IResolvable | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    get userNameInput(): string | undefined;
    private _keyVaultPassword;
    get keyVaultPassword(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPasswordOutputReference;
    putKeyVaultPassword(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword): void;
    resetKeyVaultPassword(): void;
    get keyVaultPasswordInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyKeyVaultPassword | undefined;
}
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyOutputReference;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#parameters DataFactoryIntegrationRuntimeAzureSsis#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#secret_name DataFactoryIntegrationRuntimeAzureSsis#secret_name}
    */
    readonly secretName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#secret_version DataFactoryIntegrationRuntimeAzureSsis#secret_version}
    */
    readonly secretVersion?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    resetSecretVersion(): void;
    get secretVersionInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#license DataFactoryIntegrationRuntimeAzureSsis#license}
    */
    readonly license?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}
    */
    readonly name: string;
    /**
    * key_vault_license block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#key_vault_license DataFactoryIntegrationRuntimeAzureSsis#key_vault_license}
    */
    readonly keyVaultLicense?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent | cdktf.IResolvable): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent | cdktf.IResolvable): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent | cdktf.IResolvable | undefined);
    private _license?;
    get license(): string;
    set license(value: string);
    resetLicense(): void;
    get licenseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _keyVaultLicense;
    get keyVaultLicense(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicenseOutputReference;
    putKeyVaultLicense(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense): void;
    resetKeyVaultLicense(): void;
    get keyVaultLicenseInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentKeyVaultLicense | undefined;
}
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentOutputReference;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#environment DataFactoryIntegrationRuntimeAzureSsis#environment}
    */
    readonly environment?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#powershell_version DataFactoryIntegrationRuntimeAzureSsis#powershell_version}
    */
    readonly powershellVersion?: string;
    /**
    * command_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#command_key DataFactoryIntegrationRuntimeAzureSsis#command_key}
    */
    readonly commandKey?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[] | cdktf.IResolvable;
    /**
    * component block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#component DataFactoryIntegrationRuntimeAzureSsis#component}
    */
    readonly component?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[] | cdktf.IResolvable;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined);
    private _environment?;
    get environment(): {
        [key: string]: string;
    };
    set environment(value: {
        [key: string]: string;
    });
    resetEnvironment(): void;
    get environmentInput(): {
        [key: string]: string;
    } | undefined;
    private _powershellVersion?;
    get powershellVersion(): string;
    set powershellVersion(value: string);
    resetPowershellVersion(): void;
    get powershellVersionInput(): string | undefined;
    private _commandKey;
    get commandKey(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKeyList;
    putCommandKey(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[] | cdktf.IResolvable): void;
    resetCommandKey(): void;
    get commandKeyInput(): cdktf.IResolvable | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupCommandKey[] | undefined;
    private _component;
    get component(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponentList;
    putComponent(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[] | cdktf.IResolvable): void;
    resetComponent(): void;
    get componentInput(): cdktf.IResolvable | DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupComponent[] | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#subnet_id DataFactoryIntegrationRuntimeAzureSsis#subnet_id}
    */
    readonly subnetId: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisPackageStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#linked_service_name DataFactoryIntegrationRuntimeAzureSsis#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#name DataFactoryIntegrationRuntimeAzureSsis#name}
    */
    readonly name: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisPackageStoreToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisPackageStore | cdktf.IResolvable): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisPackageStoreToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisPackageStore | cdktf.IResolvable): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisPackageStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisPackageStore | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisPackageStore | cdktf.IResolvable | undefined);
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class DataFactoryIntegrationRuntimeAzureSsisPackageStoreList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryIntegrationRuntimeAzureSsisPackageStore[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryIntegrationRuntimeAzureSsisPackageStoreOutputReference;
}
export interface DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#number_of_external_nodes DataFactoryIntegrationRuntimeAzureSsis#number_of_external_nodes}
    */
    readonly numberOfExternalNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#number_of_pipeline_nodes DataFactoryIntegrationRuntimeAzureSsis#number_of_pipeline_nodes}
    */
    readonly numberOfPipelineNodes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#time_to_live DataFactoryIntegrationRuntimeAzureSsis#time_to_live}
    */
    readonly timeToLive?: number;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleOutputReference | DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleOutputReference | DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale | undefined);
    private _numberOfExternalNodes?;
    get numberOfExternalNodes(): number;
    set numberOfExternalNodes(value: number);
    resetNumberOfExternalNodes(): void;
    get numberOfExternalNodesInput(): number | undefined;
    private _numberOfPipelineNodes?;
    get numberOfPipelineNodes(): number;
    set numberOfPipelineNodes(value: number);
    resetNumberOfPipelineNodes(): void;
    get numberOfPipelineNodesInput(): number | undefined;
    private _timeToLive?;
    get timeToLive(): number;
    set timeToLive(value: number);
    resetTimeToLive(): void;
    get timeToLiveInput(): number | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisProxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#path DataFactoryIntegrationRuntimeAzureSsis#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#self_hosted_integration_runtime_name DataFactoryIntegrationRuntimeAzureSsis#self_hosted_integration_runtime_name}
    */
    readonly selfHostedIntegrationRuntimeName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#staging_storage_linked_service_name DataFactoryIntegrationRuntimeAzureSsis#staging_storage_linked_service_name}
    */
    readonly stagingStorageLinkedServiceName: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisProxyToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference | DataFactoryIntegrationRuntimeAzureSsisProxy): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisProxyToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference | DataFactoryIntegrationRuntimeAzureSsisProxy): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisProxy | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisProxy | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _selfHostedIntegrationRuntimeName?;
    get selfHostedIntegrationRuntimeName(): string;
    set selfHostedIntegrationRuntimeName(value: string);
    get selfHostedIntegrationRuntimeNameInput(): string | undefined;
    private _stagingStorageLinkedServiceName?;
    get stagingStorageLinkedServiceName(): string;
    set stagingStorageLinkedServiceName(value: string);
    get stagingStorageLinkedServiceNameInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#create DataFactoryIntegrationRuntimeAzureSsis#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#delete DataFactoryIntegrationRuntimeAzureSsis#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#read DataFactoryIntegrationRuntimeAzureSsis#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#update DataFactoryIntegrationRuntimeAzureSsis#update}
    */
    readonly update?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisTimeoutsToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisTimeoutsToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataFactoryIntegrationRuntimeAzureSsisVnetIntegration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#public_ips DataFactoryIntegrationRuntimeAzureSsis#public_ips}
    */
    readonly publicIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#subnet_id DataFactoryIntegrationRuntimeAzureSsis#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#subnet_name DataFactoryIntegrationRuntimeAzureSsis#subnet_name}
    */
    readonly subnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#vnet_id DataFactoryIntegrationRuntimeAzureSsis#vnet_id}
    */
    readonly vnetId?: string;
}
export declare function dataFactoryIntegrationRuntimeAzureSsisVnetIntegrationToTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeAzureSsisVnetIntegration): any;
export declare function dataFactoryIntegrationRuntimeAzureSsisVnetIntegrationToHclTerraform(struct?: DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeAzureSsisVnetIntegration): any;
export declare class DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined;
    set internalValue(value: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined);
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    resetPublicIps(): void;
    get publicIpsInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _subnetName?;
    get subnetName(): string;
    set subnetName(value: string);
    resetSubnetName(): void;
    get subnetNameInput(): string | undefined;
    private _vnetId?;
    get vnetId(): string;
    set vnetId(value: string);
    resetVnetId(): void;
    get vnetIdInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis azurerm_data_factory_integration_runtime_azure_ssis}
*/
export declare class DataFactoryIntegrationRuntimeAzureSsis extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_integration_runtime_azure_ssis";
    /**
    * Generates CDKTF code for importing a DataFactoryIntegrationRuntimeAzureSsis resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryIntegrationRuntimeAzureSsis to import
    * @param importFromId The id of the existing DataFactoryIntegrationRuntimeAzureSsis that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryIntegrationRuntimeAzureSsis to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/data_factory_integration_runtime_azure_ssis azurerm_data_factory_integration_runtime_azure_ssis} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryIntegrationRuntimeAzureSsisConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryIntegrationRuntimeAzureSsisConfig);
    private _credentialName?;
    get credentialName(): string;
    set credentialName(value: string);
    resetCredentialName(): void;
    get credentialNameInput(): string | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    resetEdition(): void;
    get editionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxParallelExecutionsPerNode?;
    get maxParallelExecutionsPerNode(): number;
    set maxParallelExecutionsPerNode(value: number);
    resetMaxParallelExecutionsPerNode(): void;
    get maxParallelExecutionsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeSize?;
    get nodeSize(): string;
    set nodeSize(value: string);
    get nodeSizeInput(): string | undefined;
    private _numberOfNodes?;
    get numberOfNodes(): number;
    set numberOfNodes(value: number);
    resetNumberOfNodes(): void;
    get numberOfNodesInput(): number | undefined;
    private _catalogInfo;
    get catalogInfo(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfoOutputReference;
    putCatalogInfo(value: DataFactoryIntegrationRuntimeAzureSsisCatalogInfo): void;
    resetCatalogInfo(): void;
    get catalogInfoInput(): DataFactoryIntegrationRuntimeAzureSsisCatalogInfo | undefined;
    private _copyComputeScale;
    get copyComputeScale(): DataFactoryIntegrationRuntimeAzureSsisCopyComputeScaleOutputReference;
    putCopyComputeScale(value: DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale): void;
    resetCopyComputeScale(): void;
    get copyComputeScaleInput(): DataFactoryIntegrationRuntimeAzureSsisCopyComputeScale | undefined;
    private _customSetupScript;
    get customSetupScript(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScriptOutputReference;
    putCustomSetupScript(value: DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript): void;
    resetCustomSetupScript(): void;
    get customSetupScriptInput(): DataFactoryIntegrationRuntimeAzureSsisCustomSetupScript | undefined;
    private _expressCustomSetup;
    get expressCustomSetup(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetupOutputReference;
    putExpressCustomSetup(value: DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup): void;
    resetExpressCustomSetup(): void;
    get expressCustomSetupInput(): DataFactoryIntegrationRuntimeAzureSsisExpressCustomSetup | undefined;
    private _expressVnetIntegration;
    get expressVnetIntegration(): DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegrationOutputReference;
    putExpressVnetIntegration(value: DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration): void;
    resetExpressVnetIntegration(): void;
    get expressVnetIntegrationInput(): DataFactoryIntegrationRuntimeAzureSsisExpressVnetIntegration | undefined;
    private _packageStore;
    get packageStore(): DataFactoryIntegrationRuntimeAzureSsisPackageStoreList;
    putPackageStore(value: DataFactoryIntegrationRuntimeAzureSsisPackageStore[] | cdktf.IResolvable): void;
    resetPackageStore(): void;
    get packageStoreInput(): cdktf.IResolvable | DataFactoryIntegrationRuntimeAzureSsisPackageStore[] | undefined;
    private _pipelineExternalComputeScale;
    get pipelineExternalComputeScale(): DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScaleOutputReference;
    putPipelineExternalComputeScale(value: DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale): void;
    resetPipelineExternalComputeScale(): void;
    get pipelineExternalComputeScaleInput(): DataFactoryIntegrationRuntimeAzureSsisPipelineExternalComputeScale | undefined;
    private _proxy;
    get proxy(): DataFactoryIntegrationRuntimeAzureSsisProxyOutputReference;
    putProxy(value: DataFactoryIntegrationRuntimeAzureSsisProxy): void;
    resetProxy(): void;
    get proxyInput(): DataFactoryIntegrationRuntimeAzureSsisProxy | undefined;
    private _timeouts;
    get timeouts(): DataFactoryIntegrationRuntimeAzureSsisTimeoutsOutputReference;
    putTimeouts(value: DataFactoryIntegrationRuntimeAzureSsisTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryIntegrationRuntimeAzureSsisTimeouts | undefined;
    private _vnetIntegration;
    get vnetIntegration(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegrationOutputReference;
    putVnetIntegration(value: DataFactoryIntegrationRuntimeAzureSsisVnetIntegration): void;
    resetVnetIntegration(): void;
    get vnetIntegrationInput(): DataFactoryIntegrationRuntimeAzureSsisVnetIntegration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
