/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EmailCommunicationServiceDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#domain_management EmailCommunicationServiceDomain#domain_management}
    */
    readonly domainManagement: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#email_service_id EmailCommunicationServiceDomain#email_service_id}
    */
    readonly emailServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#id EmailCommunicationServiceDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#name EmailCommunicationServiceDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#tags EmailCommunicationServiceDomain#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#user_engagement_tracking_enabled EmailCommunicationServiceDomain#user_engagement_tracking_enabled}
    */
    readonly userEngagementTrackingEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#timeouts EmailCommunicationServiceDomain#timeouts}
    */
    readonly timeouts?: EmailCommunicationServiceDomainTimeouts;
}
export interface EmailCommunicationServiceDomainVerificationRecordsDkim {
}
export declare function emailCommunicationServiceDomainVerificationRecordsDkimToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDkim): any;
export declare function emailCommunicationServiceDomainVerificationRecordsDkimToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDkim): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsDkimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecordsDkim | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecordsDkim | undefined);
    get name(): string;
    get ttl(): number;
    get type(): string;
    get value(): string;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsDkimList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsDkimOutputReference;
}
export interface EmailCommunicationServiceDomainVerificationRecordsDkim2 {
}
export declare function emailCommunicationServiceDomainVerificationRecordsDkim2ToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDkim2): any;
export declare function emailCommunicationServiceDomainVerificationRecordsDkim2ToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDkim2): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsDkim2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecordsDkim2 | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecordsDkim2 | undefined);
    get name(): string;
    get ttl(): number;
    get type(): string;
    get value(): string;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsDkim2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsDkim2OutputReference;
}
export interface EmailCommunicationServiceDomainVerificationRecordsDmarc {
}
export declare function emailCommunicationServiceDomainVerificationRecordsDmarcToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDmarc): any;
export declare function emailCommunicationServiceDomainVerificationRecordsDmarcToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDmarc): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsDmarcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecordsDmarc | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecordsDmarc | undefined);
    get name(): string;
    get ttl(): number;
    get type(): string;
    get value(): string;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsDmarcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsDmarcOutputReference;
}
export interface EmailCommunicationServiceDomainVerificationRecordsDomain {
}
export declare function emailCommunicationServiceDomainVerificationRecordsDomainToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDomain): any;
export declare function emailCommunicationServiceDomainVerificationRecordsDomainToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsDomain): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecordsDomain | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecordsDomain | undefined);
    get name(): string;
    get ttl(): number;
    get type(): string;
    get value(): string;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsDomainOutputReference;
}
export interface EmailCommunicationServiceDomainVerificationRecordsSpf {
}
export declare function emailCommunicationServiceDomainVerificationRecordsSpfToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsSpf): any;
export declare function emailCommunicationServiceDomainVerificationRecordsSpfToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecordsSpf): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsSpfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecordsSpf | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecordsSpf | undefined);
    get name(): string;
    get ttl(): number;
    get type(): string;
    get value(): string;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsSpfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsSpfOutputReference;
}
export interface EmailCommunicationServiceDomainVerificationRecords {
}
export declare function emailCommunicationServiceDomainVerificationRecordsToTerraform(struct?: EmailCommunicationServiceDomainVerificationRecords): any;
export declare function emailCommunicationServiceDomainVerificationRecordsToHclTerraform(struct?: EmailCommunicationServiceDomainVerificationRecords): any;
export declare class EmailCommunicationServiceDomainVerificationRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EmailCommunicationServiceDomainVerificationRecords | undefined;
    set internalValue(value: EmailCommunicationServiceDomainVerificationRecords | undefined);
    private _dkim;
    get dkim(): EmailCommunicationServiceDomainVerificationRecordsDkimList;
    private _dkim2;
    get dkim2(): EmailCommunicationServiceDomainVerificationRecordsDkim2List;
    private _dmarc;
    get dmarc(): EmailCommunicationServiceDomainVerificationRecordsDmarcList;
    private _domain;
    get domain(): EmailCommunicationServiceDomainVerificationRecordsDomainList;
    private _spf;
    get spf(): EmailCommunicationServiceDomainVerificationRecordsSpfList;
}
export declare class EmailCommunicationServiceDomainVerificationRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EmailCommunicationServiceDomainVerificationRecordsOutputReference;
}
export interface EmailCommunicationServiceDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#create EmailCommunicationServiceDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#delete EmailCommunicationServiceDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#read EmailCommunicationServiceDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#update EmailCommunicationServiceDomain#update}
    */
    readonly update?: string;
}
export declare function emailCommunicationServiceDomainTimeoutsToTerraform(struct?: EmailCommunicationServiceDomainTimeouts | cdktf.IResolvable): any;
export declare function emailCommunicationServiceDomainTimeoutsToHclTerraform(struct?: EmailCommunicationServiceDomainTimeouts | cdktf.IResolvable): any;
export declare class EmailCommunicationServiceDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EmailCommunicationServiceDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EmailCommunicationServiceDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain azurerm_email_communication_service_domain}
*/
export declare class EmailCommunicationServiceDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_email_communication_service_domain";
    /**
    * Generates CDKTF code for importing a EmailCommunicationServiceDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EmailCommunicationServiceDomain to import
    * @param importFromId The id of the existing EmailCommunicationServiceDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EmailCommunicationServiceDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/email_communication_service_domain azurerm_email_communication_service_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EmailCommunicationServiceDomainConfig
    */
    constructor(scope: Construct, id: string, config: EmailCommunicationServiceDomainConfig);
    private _domainManagement?;
    get domainManagement(): string;
    set domainManagement(value: string);
    get domainManagementInput(): string | undefined;
    private _emailServiceId?;
    get emailServiceId(): string;
    set emailServiceId(value: string);
    get emailServiceIdInput(): string | undefined;
    get fromSenderDomain(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mailFromSenderDomain(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userEngagementTrackingEnabled?;
    get userEngagementTrackingEnabled(): boolean | cdktf.IResolvable;
    set userEngagementTrackingEnabled(value: boolean | cdktf.IResolvable);
    resetUserEngagementTrackingEnabled(): void;
    get userEngagementTrackingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _verificationRecords;
    get verificationRecords(): EmailCommunicationServiceDomainVerificationRecordsList;
    private _timeouts;
    get timeouts(): EmailCommunicationServiceDomainTimeoutsOutputReference;
    putTimeouts(value: EmailCommunicationServiceDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EmailCommunicationServiceDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
