/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#dns_proxy_enabled Firewall#dns_proxy_enabled}
    */
    readonly dnsProxyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#dns_servers Firewall#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#firewall_policy_id Firewall#firewall_policy_id}
    */
    readonly firewallPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#id Firewall#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#location Firewall#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#name Firewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#private_ip_ranges Firewall#private_ip_ranges}
    */
    readonly privateIpRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#resource_group_name Firewall#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#sku_name Firewall#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#sku_tier Firewall#sku_tier}
    */
    readonly skuTier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#tags Firewall#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#threat_intel_mode Firewall#threat_intel_mode}
    */
    readonly threatIntelMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#zones Firewall#zones}
    */
    readonly zones?: string[];
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#ip_configuration Firewall#ip_configuration}
    */
    readonly ipConfiguration?: FirewallIpConfiguration[] | cdktf.IResolvable;
    /**
    * management_ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#management_ip_configuration Firewall#management_ip_configuration}
    */
    readonly managementIpConfiguration?: FirewallManagementIpConfiguration;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#timeouts Firewall#timeouts}
    */
    readonly timeouts?: FirewallTimeouts;
    /**
    * virtual_hub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#virtual_hub Firewall#virtual_hub}
    */
    readonly virtualHub?: FirewallVirtualHub;
}
export interface FirewallIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#name Firewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#public_ip_address_id Firewall#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#subnet_id Firewall#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function firewallIpConfigurationToTerraform(struct?: FirewallIpConfiguration | cdktf.IResolvable): any;
export declare function firewallIpConfigurationToHclTerraform(struct?: FirewallIpConfiguration | cdktf.IResolvable): any;
export declare class FirewallIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallIpConfiguration | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export declare class FirewallIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallIpConfigurationOutputReference;
}
export interface FirewallManagementIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#name Firewall#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#public_ip_address_id Firewall#public_ip_address_id}
    */
    readonly publicIpAddressId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#subnet_id Firewall#subnet_id}
    */
    readonly subnetId: string;
}
export declare function firewallManagementIpConfigurationToTerraform(struct?: FirewallManagementIpConfigurationOutputReference | FirewallManagementIpConfiguration): any;
export declare function firewallManagementIpConfigurationToHclTerraform(struct?: FirewallManagementIpConfigurationOutputReference | FirewallManagementIpConfiguration): any;
export declare class FirewallManagementIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallManagementIpConfiguration | undefined;
    set internalValue(value: FirewallManagementIpConfiguration | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface FirewallTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#create Firewall#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#delete Firewall#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#read Firewall#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#update Firewall#update}
    */
    readonly update?: string;
}
export declare function firewallTimeoutsToTerraform(struct?: FirewallTimeouts | cdktf.IResolvable): any;
export declare function firewallTimeoutsToHclTerraform(struct?: FirewallTimeouts | cdktf.IResolvable): any;
export declare class FirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface FirewallVirtualHub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#public_ip_count Firewall#public_ip_count}
    */
    readonly publicIpCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#virtual_hub_id Firewall#virtual_hub_id}
    */
    readonly virtualHubId: string;
}
export declare function firewallVirtualHubToTerraform(struct?: FirewallVirtualHubOutputReference | FirewallVirtualHub): any;
export declare function firewallVirtualHubToHclTerraform(struct?: FirewallVirtualHubOutputReference | FirewallVirtualHub): any;
export declare class FirewallVirtualHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallVirtualHub | undefined;
    set internalValue(value: FirewallVirtualHub | undefined);
    get privateIpAddress(): string;
    get publicIpAddresses(): string[];
    private _publicIpCount?;
    get publicIpCount(): number;
    set publicIpCount(value: number);
    resetPublicIpCount(): void;
    get publicIpCountInput(): number | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall azurerm_firewall}
*/
export declare class Firewall extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall";
    /**
    * Generates CDKTF code for importing a Firewall resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Firewall to import
    * @param importFromId The id of the existing Firewall that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Firewall to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/firewall azurerm_firewall} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallConfig
    */
    constructor(scope: Construct, id: string, config: FirewallConfig);
    private _dnsProxyEnabled?;
    get dnsProxyEnabled(): boolean | cdktf.IResolvable;
    set dnsProxyEnabled(value: boolean | cdktf.IResolvable);
    resetDnsProxyEnabled(): void;
    get dnsProxyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _firewallPolicyId?;
    get firewallPolicyId(): string;
    set firewallPolicyId(value: string);
    resetFirewallPolicyId(): void;
    get firewallPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateIpRanges?;
    get privateIpRanges(): string[];
    set privateIpRanges(value: string[]);
    resetPrivateIpRanges(): void;
    get privateIpRangesInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _skuTier?;
    get skuTier(): string;
    set skuTier(value: string);
    get skuTierInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _threatIntelMode?;
    get threatIntelMode(): string;
    set threatIntelMode(value: string);
    resetThreatIntelMode(): void;
    get threatIntelModeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _ipConfiguration;
    get ipConfiguration(): FirewallIpConfigurationList;
    putIpConfiguration(value: FirewallIpConfiguration[] | cdktf.IResolvable): void;
    resetIpConfiguration(): void;
    get ipConfigurationInput(): cdktf.IResolvable | FirewallIpConfiguration[] | undefined;
    private _managementIpConfiguration;
    get managementIpConfiguration(): FirewallManagementIpConfigurationOutputReference;
    putManagementIpConfiguration(value: FirewallManagementIpConfiguration): void;
    resetManagementIpConfiguration(): void;
    get managementIpConfigurationInput(): FirewallManagementIpConfiguration | undefined;
    private _timeouts;
    get timeouts(): FirewallTimeoutsOutputReference;
    putTimeouts(value: FirewallTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirewallTimeouts | undefined;
    private _virtualHub;
    get virtualHub(): FirewallVirtualHubOutputReference;
    putVirtualHub(value: FirewallVirtualHub): void;
    resetVirtualHub(): void;
    get virtualHubInput(): FirewallVirtualHub | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
