/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GalleryApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#description GalleryApplication#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#end_of_life_date GalleryApplication#end_of_life_date}
    */
    readonly endOfLifeDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#eula GalleryApplication#eula}
    */
    readonly eula?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#gallery_id GalleryApplication#gallery_id}
    */
    readonly galleryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#id GalleryApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#location GalleryApplication#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#name GalleryApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#privacy_statement_uri GalleryApplication#privacy_statement_uri}
    */
    readonly privacyStatementUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#release_note_uri GalleryApplication#release_note_uri}
    */
    readonly releaseNoteUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#supported_os_type GalleryApplication#supported_os_type}
    */
    readonly supportedOsType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#tags GalleryApplication#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#timeouts GalleryApplication#timeouts}
    */
    readonly timeouts?: GalleryApplicationTimeouts;
}
export interface GalleryApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#create GalleryApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#delete GalleryApplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#read GalleryApplication#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#update GalleryApplication#update}
    */
    readonly update?: string;
}
export declare function galleryApplicationTimeoutsToTerraform(struct?: GalleryApplicationTimeouts | cdktf.IResolvable): any;
export declare function galleryApplicationTimeoutsToHclTerraform(struct?: GalleryApplicationTimeouts | cdktf.IResolvable): any;
export declare class GalleryApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GalleryApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GalleryApplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application azurerm_gallery_application}
*/
export declare class GalleryApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_gallery_application";
    /**
    * Generates CDKTF code for importing a GalleryApplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GalleryApplication to import
    * @param importFromId The id of the existing GalleryApplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GalleryApplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/gallery_application azurerm_gallery_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GalleryApplicationConfig
    */
    constructor(scope: Construct, id: string, config: GalleryApplicationConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _endOfLifeDate?;
    get endOfLifeDate(): string;
    set endOfLifeDate(value: string);
    resetEndOfLifeDate(): void;
    get endOfLifeDateInput(): string | undefined;
    private _eula?;
    get eula(): string;
    set eula(value: string);
    resetEula(): void;
    get eulaInput(): string | undefined;
    private _galleryId?;
    get galleryId(): string;
    set galleryId(value: string);
    get galleryIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privacyStatementUri?;
    get privacyStatementUri(): string;
    set privacyStatementUri(value: string);
    resetPrivacyStatementUri(): void;
    get privacyStatementUriInput(): string | undefined;
    private _releaseNoteUri?;
    get releaseNoteUri(): string;
    set releaseNoteUri(value: string);
    resetReleaseNoteUri(): void;
    get releaseNoteUriInput(): string | undefined;
    private _supportedOsType?;
    get supportedOsType(): string;
    set supportedOsType(value: string);
    get supportedOsTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): GalleryApplicationTimeoutsOutputReference;
    putTimeouts(value: GalleryApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GalleryApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
