/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HpcCacheAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#hpc_cache_id HpcCacheAccessPolicy#hpc_cache_id}
    */
    readonly hpcCacheId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#id HpcCacheAccessPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#name HpcCacheAccessPolicy#name}
    */
    readonly name: string;
    /**
    * access_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#access_rule HpcCacheAccessPolicy#access_rule}
    */
    readonly accessRule: HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#timeouts HpcCacheAccessPolicy#timeouts}
    */
    readonly timeouts?: HpcCacheAccessPolicyTimeouts;
}
export interface HpcCacheAccessPolicyAccessRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#access HpcCacheAccessPolicy#access}
    */
    readonly access: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#anonymous_gid HpcCacheAccessPolicy#anonymous_gid}
    */
    readonly anonymousGid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#anonymous_uid HpcCacheAccessPolicy#anonymous_uid}
    */
    readonly anonymousUid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#filter HpcCacheAccessPolicy#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#root_squash_enabled HpcCacheAccessPolicy#root_squash_enabled}
    */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#scope HpcCacheAccessPolicy#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#submount_access_enabled HpcCacheAccessPolicy#submount_access_enabled}
    */
    readonly submountAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#suid_enabled HpcCacheAccessPolicy#suid_enabled}
    */
    readonly suidEnabled?: boolean | cdktf.IResolvable;
}
export declare function hpcCacheAccessPolicyAccessRuleToTerraform(struct?: HpcCacheAccessPolicyAccessRule | cdktf.IResolvable): any;
export declare function hpcCacheAccessPolicyAccessRuleToHclTerraform(struct?: HpcCacheAccessPolicyAccessRule | cdktf.IResolvable): any;
export declare class HpcCacheAccessPolicyAccessRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): HpcCacheAccessPolicyAccessRule | cdktf.IResolvable | undefined;
    set internalValue(value: HpcCacheAccessPolicyAccessRule | cdktf.IResolvable | undefined);
    private _access?;
    get access(): string;
    set access(value: string);
    get accessInput(): string | undefined;
    private _anonymousGid?;
    get anonymousGid(): number;
    set anonymousGid(value: number);
    resetAnonymousGid(): void;
    get anonymousGidInput(): number | undefined;
    private _anonymousUid?;
    get anonymousUid(): number;
    set anonymousUid(value: number);
    resetAnonymousUid(): void;
    get anonymousUidInput(): number | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _rootSquashEnabled?;
    get rootSquashEnabled(): boolean | cdktf.IResolvable;
    set rootSquashEnabled(value: boolean | cdktf.IResolvable);
    resetRootSquashEnabled(): void;
    get rootSquashEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _submountAccessEnabled?;
    get submountAccessEnabled(): boolean | cdktf.IResolvable;
    set submountAccessEnabled(value: boolean | cdktf.IResolvable);
    resetSubmountAccessEnabled(): void;
    get submountAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _suidEnabled?;
    get suidEnabled(): boolean | cdktf.IResolvable;
    set suidEnabled(value: boolean | cdktf.IResolvable);
    resetSuidEnabled(): void;
    get suidEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class HpcCacheAccessPolicyAccessRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): HpcCacheAccessPolicyAccessRuleOutputReference;
}
export interface HpcCacheAccessPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#create HpcCacheAccessPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#delete HpcCacheAccessPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#read HpcCacheAccessPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#update HpcCacheAccessPolicy#update}
    */
    readonly update?: string;
}
export declare function hpcCacheAccessPolicyTimeoutsToTerraform(struct?: HpcCacheAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare function hpcCacheAccessPolicyTimeoutsToHclTerraform(struct?: HpcCacheAccessPolicyTimeouts | cdktf.IResolvable): any;
export declare class HpcCacheAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): HpcCacheAccessPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: HpcCacheAccessPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy azurerm_hpc_cache_access_policy}
*/
export declare class HpcCacheAccessPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_hpc_cache_access_policy";
    /**
    * Generates CDKTF code for importing a HpcCacheAccessPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HpcCacheAccessPolicy to import
    * @param importFromId The id of the existing HpcCacheAccessPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HpcCacheAccessPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/hpc_cache_access_policy azurerm_hpc_cache_access_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HpcCacheAccessPolicyConfig
    */
    constructor(scope: Construct, id: string, config: HpcCacheAccessPolicyConfig);
    private _hpcCacheId?;
    get hpcCacheId(): string;
    set hpcCacheId(value: string);
    get hpcCacheIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _accessRule;
    get accessRule(): HpcCacheAccessPolicyAccessRuleList;
    putAccessRule(value: HpcCacheAccessPolicyAccessRule[] | cdktf.IResolvable): void;
    get accessRuleInput(): cdktf.IResolvable | HpcCacheAccessPolicyAccessRule[] | undefined;
    private _timeouts;
    get timeouts(): HpcCacheAccessPolicyTimeoutsOutputReference;
    putTimeouts(value: HpcCacheAccessPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | HpcCacheAccessPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
