/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesFleetUpdateStrategyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#id KubernetesFleetUpdateStrategy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#kubernetes_fleet_manager_id KubernetesFleetUpdateStrategy#kubernetes_fleet_manager_id}
    */
    readonly kubernetesFleetManagerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#name KubernetesFleetUpdateStrategy#name}
    */
    readonly name: string;
    /**
    * stage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#stage KubernetesFleetUpdateStrategy#stage}
    */
    readonly stage: KubernetesFleetUpdateStrategyStage[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#timeouts KubernetesFleetUpdateStrategy#timeouts}
    */
    readonly timeouts?: KubernetesFleetUpdateStrategyTimeouts;
}
export interface KubernetesFleetUpdateStrategyStageGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#name KubernetesFleetUpdateStrategy#name}
    */
    readonly name: string;
}
export declare function kubernetesFleetUpdateStrategyStageGroupToTerraform(struct?: KubernetesFleetUpdateStrategyStageGroup | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateStrategyStageGroupToHclTerraform(struct?: KubernetesFleetUpdateStrategyStageGroup | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateStrategyStageGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFleetUpdateStrategyStageGroup | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateStrategyStageGroup | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class KubernetesFleetUpdateStrategyStageGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFleetUpdateStrategyStageGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFleetUpdateStrategyStageGroupOutputReference;
}
export interface KubernetesFleetUpdateStrategyStage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#after_stage_wait_in_seconds KubernetesFleetUpdateStrategy#after_stage_wait_in_seconds}
    */
    readonly afterStageWaitInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#name KubernetesFleetUpdateStrategy#name}
    */
    readonly name: string;
    /**
    * group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#group KubernetesFleetUpdateStrategy#group}
    */
    readonly group: KubernetesFleetUpdateStrategyStageGroup[] | cdktf.IResolvable;
}
export declare function kubernetesFleetUpdateStrategyStageToTerraform(struct?: KubernetesFleetUpdateStrategyStage | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateStrategyStageToHclTerraform(struct?: KubernetesFleetUpdateStrategyStage | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateStrategyStageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFleetUpdateStrategyStage | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateStrategyStage | cdktf.IResolvable | undefined);
    private _afterStageWaitInSeconds?;
    get afterStageWaitInSeconds(): number;
    set afterStageWaitInSeconds(value: number);
    resetAfterStageWaitInSeconds(): void;
    get afterStageWaitInSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _group;
    get group(): KubernetesFleetUpdateStrategyStageGroupList;
    putGroup(value: KubernetesFleetUpdateStrategyStageGroup[] | cdktf.IResolvable): void;
    get groupInput(): cdktf.IResolvable | KubernetesFleetUpdateStrategyStageGroup[] | undefined;
}
export declare class KubernetesFleetUpdateStrategyStageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFleetUpdateStrategyStage[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFleetUpdateStrategyStageOutputReference;
}
export interface KubernetesFleetUpdateStrategyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#create KubernetesFleetUpdateStrategy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#delete KubernetesFleetUpdateStrategy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#read KubernetesFleetUpdateStrategy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#update KubernetesFleetUpdateStrategy#update}
    */
    readonly update?: string;
}
export declare function kubernetesFleetUpdateStrategyTimeoutsToTerraform(struct?: KubernetesFleetUpdateStrategyTimeouts | cdktf.IResolvable): any;
export declare function kubernetesFleetUpdateStrategyTimeoutsToHclTerraform(struct?: KubernetesFleetUpdateStrategyTimeouts | cdktf.IResolvable): any;
export declare class KubernetesFleetUpdateStrategyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetUpdateStrategyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetUpdateStrategyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy azurerm_kubernetes_fleet_update_strategy}
*/
export declare class KubernetesFleetUpdateStrategy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_fleet_update_strategy";
    /**
    * Generates CDKTF code for importing a KubernetesFleetUpdateStrategy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesFleetUpdateStrategy to import
    * @param importFromId The id of the existing KubernetesFleetUpdateStrategy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesFleetUpdateStrategy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/kubernetes_fleet_update_strategy azurerm_kubernetes_fleet_update_strategy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesFleetUpdateStrategyConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesFleetUpdateStrategyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesFleetManagerId?;
    get kubernetesFleetManagerId(): string;
    set kubernetesFleetManagerId(value: string);
    get kubernetesFleetManagerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _stage;
    get stage(): KubernetesFleetUpdateStrategyStageList;
    putStage(value: KubernetesFleetUpdateStrategyStage[] | cdktf.IResolvable): void;
    get stageInput(): cdktf.IResolvable | KubernetesFleetUpdateStrategyStage[] | undefined;
    private _timeouts;
    get timeouts(): KubernetesFleetUpdateStrategyTimeoutsOutputReference;
    putTimeouts(value: KubernetesFleetUpdateStrategyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesFleetUpdateStrategyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
