/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkSimPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#default_slice_id MobileNetworkSimPolicy#default_slice_id}
    */
    readonly defaultSliceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#id MobileNetworkSimPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#location MobileNetworkSimPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#mobile_network_id MobileNetworkSimPolicy#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#name MobileNetworkSimPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#rat_frequency_selection_priority_index MobileNetworkSimPolicy#rat_frequency_selection_priority_index}
    */
    readonly ratFrequencySelectionPriorityIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#registration_timer_in_seconds MobileNetworkSimPolicy#registration_timer_in_seconds}
    */
    readonly registrationTimerInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#tags MobileNetworkSimPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * slice block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#slice MobileNetworkSimPolicy#slice}
    */
    readonly slice: MobileNetworkSimPolicySlice[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#timeouts MobileNetworkSimPolicy#timeouts}
    */
    readonly timeouts?: MobileNetworkSimPolicyTimeouts;
    /**
    * user_equipment_aggregate_maximum_bit_rate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#user_equipment_aggregate_maximum_bit_rate MobileNetworkSimPolicy#user_equipment_aggregate_maximum_bit_rate}
    */
    readonly userEquipmentAggregateMaximumBitRate: MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate;
}
export interface MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#downlink MobileNetworkSimPolicy#downlink}
    */
    readonly downlink: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#uplink MobileNetworkSimPolicy#uplink}
    */
    readonly uplink: string;
}
export declare function mobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateToTerraform(struct?: MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference | MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate): any;
export declare function mobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateToHclTerraform(struct?: MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference | MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate): any;
export declare class MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate | undefined;
    set internalValue(value: MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate | undefined);
    private _downlink?;
    get downlink(): string;
    set downlink(value: string);
    get downlinkInput(): string | undefined;
    private _uplink?;
    get uplink(): string;
    set uplink(value: string);
    get uplinkInput(): string | undefined;
}
export interface MobileNetworkSimPolicySliceDataNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#additional_allowed_session_types MobileNetworkSimPolicy#additional_allowed_session_types}
    */
    readonly additionalAllowedSessionTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#allocation_and_retention_priority_level MobileNetworkSimPolicy#allocation_and_retention_priority_level}
    */
    readonly allocationAndRetentionPriorityLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#allowed_services_ids MobileNetworkSimPolicy#allowed_services_ids}
    */
    readonly allowedServicesIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#data_network_id MobileNetworkSimPolicy#data_network_id}
    */
    readonly dataNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#default_session_type MobileNetworkSimPolicy#default_session_type}
    */
    readonly defaultSessionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#max_buffered_packets MobileNetworkSimPolicy#max_buffered_packets}
    */
    readonly maxBufferedPackets?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#preemption_capability MobileNetworkSimPolicy#preemption_capability}
    */
    readonly preemptionCapability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#preemption_vulnerability MobileNetworkSimPolicy#preemption_vulnerability}
    */
    readonly preemptionVulnerability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#qos_indicator MobileNetworkSimPolicy#qos_indicator}
    */
    readonly qosIndicator: number;
    /**
    * session_aggregate_maximum_bit_rate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#session_aggregate_maximum_bit_rate MobileNetworkSimPolicy#session_aggregate_maximum_bit_rate}
    */
    readonly sessionAggregateMaximumBitRate: MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate;
}
export declare function mobileNetworkSimPolicySliceDataNetworkToTerraform(struct?: MobileNetworkSimPolicySliceDataNetwork | cdktf.IResolvable): any;
export declare function mobileNetworkSimPolicySliceDataNetworkToHclTerraform(struct?: MobileNetworkSimPolicySliceDataNetwork | cdktf.IResolvable): any;
export declare class MobileNetworkSimPolicySliceDataNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MobileNetworkSimPolicySliceDataNetwork | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSimPolicySliceDataNetwork | cdktf.IResolvable | undefined);
    private _additionalAllowedSessionTypes?;
    get additionalAllowedSessionTypes(): string[];
    set additionalAllowedSessionTypes(value: string[]);
    resetAdditionalAllowedSessionTypes(): void;
    get additionalAllowedSessionTypesInput(): string[] | undefined;
    private _allocationAndRetentionPriorityLevel?;
    get allocationAndRetentionPriorityLevel(): number;
    set allocationAndRetentionPriorityLevel(value: number);
    resetAllocationAndRetentionPriorityLevel(): void;
    get allocationAndRetentionPriorityLevelInput(): number | undefined;
    private _allowedServicesIds?;
    get allowedServicesIds(): string[];
    set allowedServicesIds(value: string[]);
    get allowedServicesIdsInput(): string[] | undefined;
    private _dataNetworkId?;
    get dataNetworkId(): string;
    set dataNetworkId(value: string);
    get dataNetworkIdInput(): string | undefined;
    private _defaultSessionType?;
    get defaultSessionType(): string;
    set defaultSessionType(value: string);
    resetDefaultSessionType(): void;
    get defaultSessionTypeInput(): string | undefined;
    private _maxBufferedPackets?;
    get maxBufferedPackets(): number;
    set maxBufferedPackets(value: number);
    resetMaxBufferedPackets(): void;
    get maxBufferedPacketsInput(): number | undefined;
    private _preemptionCapability?;
    get preemptionCapability(): string;
    set preemptionCapability(value: string);
    resetPreemptionCapability(): void;
    get preemptionCapabilityInput(): string | undefined;
    private _preemptionVulnerability?;
    get preemptionVulnerability(): string;
    set preemptionVulnerability(value: string);
    resetPreemptionVulnerability(): void;
    get preemptionVulnerabilityInput(): string | undefined;
    private _qosIndicator?;
    get qosIndicator(): number;
    set qosIndicator(value: number);
    get qosIndicatorInput(): number | undefined;
    private _sessionAggregateMaximumBitRate;
    get sessionAggregateMaximumBitRate(): MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateOutputReference;
    putSessionAggregateMaximumBitRate(value: MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate): void;
    get sessionAggregateMaximumBitRateInput(): MobileNetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRate | undefined;
}
export declare class MobileNetworkSimPolicySliceDataNetworkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MobileNetworkSimPolicySliceDataNetwork[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MobileNetworkSimPolicySliceDataNetworkOutputReference;
}
export interface MobileNetworkSimPolicySlice {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#default_data_network_id MobileNetworkSimPolicy#default_data_network_id}
    */
    readonly defaultDataNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#slice_id MobileNetworkSimPolicy#slice_id}
    */
    readonly sliceId: string;
    /**
    * data_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#data_network MobileNetworkSimPolicy#data_network}
    */
    readonly dataNetwork: MobileNetworkSimPolicySliceDataNetwork[] | cdktf.IResolvable;
}
export declare function mobileNetworkSimPolicySliceToTerraform(struct?: MobileNetworkSimPolicySlice | cdktf.IResolvable): any;
export declare function mobileNetworkSimPolicySliceToHclTerraform(struct?: MobileNetworkSimPolicySlice | cdktf.IResolvable): any;
export declare class MobileNetworkSimPolicySliceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MobileNetworkSimPolicySlice | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSimPolicySlice | cdktf.IResolvable | undefined);
    private _defaultDataNetworkId?;
    get defaultDataNetworkId(): string;
    set defaultDataNetworkId(value: string);
    get defaultDataNetworkIdInput(): string | undefined;
    private _sliceId?;
    get sliceId(): string;
    set sliceId(value: string);
    get sliceIdInput(): string | undefined;
    private _dataNetwork;
    get dataNetwork(): MobileNetworkSimPolicySliceDataNetworkList;
    putDataNetwork(value: MobileNetworkSimPolicySliceDataNetwork[] | cdktf.IResolvable): void;
    get dataNetworkInput(): cdktf.IResolvable | MobileNetworkSimPolicySliceDataNetwork[] | undefined;
}
export declare class MobileNetworkSimPolicySliceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MobileNetworkSimPolicySlice[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MobileNetworkSimPolicySliceOutputReference;
}
export interface MobileNetworkSimPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#create MobileNetworkSimPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#delete MobileNetworkSimPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#read MobileNetworkSimPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#update MobileNetworkSimPolicy#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkSimPolicyTimeoutsToTerraform(struct?: MobileNetworkSimPolicyTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkSimPolicyTimeoutsToHclTerraform(struct?: MobileNetworkSimPolicyTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkSimPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSimPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkSimPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#downlink MobileNetworkSimPolicy#downlink}
    */
    readonly downlink: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#uplink MobileNetworkSimPolicy#uplink}
    */
    readonly uplink: string;
}
export declare function mobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateToTerraform(struct?: MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference | MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate): any;
export declare function mobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateToHclTerraform(struct?: MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference | MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate): any;
export declare class MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate | undefined;
    set internalValue(value: MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate | undefined);
    private _downlink?;
    get downlink(): string;
    set downlink(value: string);
    get downlinkInput(): string | undefined;
    private _uplink?;
    get uplink(): string;
    set uplink(value: string);
    get uplinkInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy azurerm_mobile_network_sim_policy}
*/
export declare class MobileNetworkSimPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_sim_policy";
    /**
    * Generates CDKTF code for importing a MobileNetworkSimPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkSimPolicy to import
    * @param importFromId The id of the existing MobileNetworkSimPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkSimPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mobile_network_sim_policy azurerm_mobile_network_sim_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkSimPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkSimPolicyConfig);
    private _defaultSliceId?;
    get defaultSliceId(): string;
    set defaultSliceId(value: string);
    get defaultSliceIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ratFrequencySelectionPriorityIndex?;
    get ratFrequencySelectionPriorityIndex(): number;
    set ratFrequencySelectionPriorityIndex(value: number);
    resetRatFrequencySelectionPriorityIndex(): void;
    get ratFrequencySelectionPriorityIndexInput(): number | undefined;
    private _registrationTimerInSeconds?;
    get registrationTimerInSeconds(): number;
    set registrationTimerInSeconds(value: number);
    resetRegistrationTimerInSeconds(): void;
    get registrationTimerInSecondsInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _slice;
    get slice(): MobileNetworkSimPolicySliceList;
    putSlice(value: MobileNetworkSimPolicySlice[] | cdktf.IResolvable): void;
    get sliceInput(): cdktf.IResolvable | MobileNetworkSimPolicySlice[] | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkSimPolicyTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkSimPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkSimPolicyTimeouts | undefined;
    private _userEquipmentAggregateMaximumBitRate;
    get userEquipmentAggregateMaximumBitRate(): MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRateOutputReference;
    putUserEquipmentAggregateMaximumBitRate(value: MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate): void;
    get userEquipmentAggregateMaximumBitRateInput(): MobileNetworkSimPolicyUserEquipmentAggregateMaximumBitRate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
