/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorDataCollectionRuleAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#data_collection_endpoint_id MonitorDataCollectionRuleAssociation#data_collection_endpoint_id}
    */
    readonly dataCollectionEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#data_collection_rule_id MonitorDataCollectionRuleAssociation#data_collection_rule_id}
    */
    readonly dataCollectionRuleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#description MonitorDataCollectionRuleAssociation#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#id MonitorDataCollectionRuleAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#name MonitorDataCollectionRuleAssociation#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#target_resource_id MonitorDataCollectionRuleAssociation#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#timeouts MonitorDataCollectionRuleAssociation#timeouts}
    */
    readonly timeouts?: MonitorDataCollectionRuleAssociationTimeouts;
}
export interface MonitorDataCollectionRuleAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#create MonitorDataCollectionRuleAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#delete MonitorDataCollectionRuleAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#read MonitorDataCollectionRuleAssociation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#update MonitorDataCollectionRuleAssociation#update}
    */
    readonly update?: string;
}
export declare function monitorDataCollectionRuleAssociationTimeoutsToTerraform(struct?: MonitorDataCollectionRuleAssociationTimeouts | cdktf.IResolvable): any;
export declare function monitorDataCollectionRuleAssociationTimeoutsToHclTerraform(struct?: MonitorDataCollectionRuleAssociationTimeouts | cdktf.IResolvable): any;
export declare class MonitorDataCollectionRuleAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorDataCollectionRuleAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorDataCollectionRuleAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association azurerm_monitor_data_collection_rule_association}
*/
export declare class MonitorDataCollectionRuleAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_rule_association";
    /**
    * Generates CDKTF code for importing a MonitorDataCollectionRuleAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorDataCollectionRuleAssociation to import
    * @param importFromId The id of the existing MonitorDataCollectionRuleAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorDataCollectionRuleAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/monitor_data_collection_rule_association azurerm_monitor_data_collection_rule_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorDataCollectionRuleAssociationConfig
    */
    constructor(scope: Construct, id: string, config: MonitorDataCollectionRuleAssociationConfig);
    private _dataCollectionEndpointId?;
    get dataCollectionEndpointId(): string;
    set dataCollectionEndpointId(value: string);
    resetDataCollectionEndpointId(): void;
    get dataCollectionEndpointIdInput(): string | undefined;
    private _dataCollectionRuleId?;
    get dataCollectionRuleId(): string;
    set dataCollectionRuleId(value: string);
    resetDataCollectionRuleId(): void;
    get dataCollectionRuleIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): MonitorDataCollectionRuleAssociationTimeoutsOutputReference;
    putTimeouts(value: MonitorDataCollectionRuleAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorDataCollectionRuleAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
