/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#baseline_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_name}
    */
    readonly baselineName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#database_name MssqlDatabaseVulnerabilityAssessmentRuleBaseline#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#rule_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#rule_id}
    */
    readonly ruleId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#server_vulnerability_assessment_id MssqlDatabaseVulnerabilityAssessmentRuleBaseline#server_vulnerability_assessment_id}
    */
    readonly serverVulnerabilityAssessmentId: string;
    /**
    * baseline_result block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#baseline_result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#baseline_result}
    */
    readonly baselineResult: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#timeouts MssqlDatabaseVulnerabilityAssessmentRuleBaseline#timeouts}
    */
    readonly timeouts?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts;
}
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#result MssqlDatabaseVulnerabilityAssessmentRuleBaseline#result}
    */
    readonly result: string[];
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult | cdktf.IResolvable): any;
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultToHclTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult | cdktf.IResolvable): any;
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult | cdktf.IResolvable | undefined);
    private _result?;
    get result(): string[];
    set result(value: string[]);
    get resultInput(): string[] | undefined;
}
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultOutputReference;
}
export interface MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#create MssqlDatabaseVulnerabilityAssessmentRuleBaseline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#delete MssqlDatabaseVulnerabilityAssessmentRuleBaseline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#read MssqlDatabaseVulnerabilityAssessmentRuleBaseline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#update MssqlDatabaseVulnerabilityAssessmentRuleBaseline#update}
    */
    readonly update?: string;
}
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsToTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | cdktf.IResolvable): any;
export declare function mssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsToHclTerraform(struct?: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | cdktf.IResolvable): any;
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline}
*/
export declare class MssqlDatabaseVulnerabilityAssessmentRuleBaseline extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_database_vulnerability_assessment_rule_baseline";
    /**
    * Generates CDKTF code for importing a MssqlDatabaseVulnerabilityAssessmentRuleBaseline resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlDatabaseVulnerabilityAssessmentRuleBaseline to import
    * @param importFromId The id of the existing MssqlDatabaseVulnerabilityAssessmentRuleBaseline that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlDatabaseVulnerabilityAssessmentRuleBaseline to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_database_vulnerability_assessment_rule_baseline azurerm_mssql_database_vulnerability_assessment_rule_baseline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig
    */
    constructor(scope: Construct, id: string, config: MssqlDatabaseVulnerabilityAssessmentRuleBaselineConfig);
    private _baselineName?;
    get baselineName(): string;
    set baselineName(value: string);
    resetBaselineName(): void;
    get baselineNameInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ruleId?;
    get ruleId(): string;
    set ruleId(value: string);
    get ruleIdInput(): string | undefined;
    private _serverVulnerabilityAssessmentId?;
    get serverVulnerabilityAssessmentId(): string;
    set serverVulnerabilityAssessmentId(value: string);
    get serverVulnerabilityAssessmentIdInput(): string | undefined;
    private _baselineResult;
    get baselineResult(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResultList;
    putBaselineResult(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | cdktf.IResolvable): void;
    get baselineResultInput(): cdktf.IResolvable | MssqlDatabaseVulnerabilityAssessmentRuleBaselineBaselineResult[] | undefined;
    private _timeouts;
    get timeouts(): MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeoutsOutputReference;
    putTimeouts(value: MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlDatabaseVulnerabilityAssessmentRuleBaselineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
