/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlServerDnsAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#id MssqlServerDnsAlias#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#mssql_server_id MssqlServerDnsAlias#mssql_server_id}
    */
    readonly mssqlServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#name MssqlServerDnsAlias#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#timeouts MssqlServerDnsAlias#timeouts}
    */
    readonly timeouts?: MssqlServerDnsAliasTimeouts;
}
export interface MssqlServerDnsAliasTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#create MssqlServerDnsAlias#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#delete MssqlServerDnsAlias#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#read MssqlServerDnsAlias#read}
    */
    readonly read?: string;
}
export declare function mssqlServerDnsAliasTimeoutsToTerraform(struct?: MssqlServerDnsAliasTimeouts | cdktf.IResolvable): any;
export declare function mssqlServerDnsAliasTimeoutsToHclTerraform(struct?: MssqlServerDnsAliasTimeouts | cdktf.IResolvable): any;
export declare class MssqlServerDnsAliasTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlServerDnsAliasTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlServerDnsAliasTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias azurerm_mssql_server_dns_alias}
*/
export declare class MssqlServerDnsAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_server_dns_alias";
    /**
    * Generates CDKTF code for importing a MssqlServerDnsAlias resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlServerDnsAlias to import
    * @param importFromId The id of the existing MssqlServerDnsAlias that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlServerDnsAlias to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/mssql_server_dns_alias azurerm_mssql_server_dns_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlServerDnsAliasConfig
    */
    constructor(scope: Construct, id: string, config: MssqlServerDnsAliasConfig);
    get dnsRecord(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mssqlServerId?;
    get mssqlServerId(): string;
    set mssqlServerId(value: string);
    get mssqlServerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlServerDnsAliasTimeoutsOutputReference;
    putTimeouts(value: MssqlServerDnsAliasTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlServerDnsAliasTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
